/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.generictable;

import de.esg.commonclient.GlobalObjects;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import webetk.javaclient.generictable.DirectRenderer;
import webetk.javaclient.generictable.DreieckCellRenderer;
import webetk.javaclient.generictable.DreieckLabel;
import webetk.javaclient.generictable.ETKDefaultTableCellRenderer;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.HeaderRenderer;
import webetk.javaclient.generictable.IconCellRenderer;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.WebETKTheme;

public class GenericTable
extends JTable {
    private static final long serialVersionUID = 8319529926399767093L;
    private static Logger log = Logger.getLogger(GenericTable.class);
    private JScrollPane enclosingScrollPane = null;
    private int minWidth = -1;
    private int resizeMode = 1;
    private Dimension preferredSize = null;
    private static int defaultHSpacing = 2;
    private int hSpacing = defaultHSpacing;
    private TableModel model;
    private TableConfiguration configuration;
    public static final int FIT_TO_SCROLLPANE = 1;
    public static final int DONT_STRETCH = 2;
    protected static int defaultResizingMode = 2;
    private TableCellRenderer defRendererCentered;
    private TableCellRenderer defRendererLeft;
    private TableCellRenderer defRendererRight;
    private TableCellRenderer defRendererIcon;
    private TableCellRenderer defRendererDreieck;
    private ArrayList<EventRestriction> listenerlist = new ArrayList();

    public GenericTable(GenericTableModel model) {
        this.model = model;
        this.configuration = model.getConfiguration();
        this.createTable();
    }

    public GenericTable(TableModel model, TableConfiguration configuration) {
        this.model = model;
        this.configuration = configuration;
        this.createTable();
    }

    public GenericTable getTable() {
        return this;
    }

    public JScrollPane getScrollPane() {
        return this.enclosingScrollPane;
    }

    protected void createTable() {
        this.setResizeMode(defaultResizingMode);
        this.getTableHeader().setReorderingAllowed(false);
        if (this.defRendererCentered == null) {
            this.defRendererCentered = new ETKDefaultTableCellRenderer();
            ((ETKDefaultTableCellRenderer)this.defRendererCentered).setHorizontalAlignment(0);
            ((ETKDefaultTableCellRenderer)this.defRendererCentered).setHorizontalSpacing(this.hSpacing);
            this.defRendererLeft = new ETKDefaultTableCellRenderer();
            ((ETKDefaultTableCellRenderer)this.defRendererLeft).setHorizontalAlignment(2);
            ((ETKDefaultTableCellRenderer)this.defRendererLeft).setHorizontalSpacing(this.hSpacing);
            this.defRendererRight = new ETKDefaultTableCellRenderer();
            ((ETKDefaultTableCellRenderer)this.defRendererRight).setHorizontalAlignment(4);
            ((ETKDefaultTableCellRenderer)this.defRendererRight).setHorizontalSpacing(this.hSpacing);
            this.defRendererIcon = new IconCellRenderer();
            ((IconCellRenderer)this.defRendererIcon).setHorizontalSpacing(this.hSpacing);
            this.defRendererDreieck = new DreieckCellRenderer();
            ((DreieckCellRenderer)this.defRendererDreieck).setHorizontalAlignment(0);
            ((DreieckCellRenderer)this.defRendererDreieck).setHorizontalSpacing(this.hSpacing);
        }
        this.enclosingScrollPane = new JScrollPane(this);
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(this.model);
        DirectRenderer directRenderer = new DirectRenderer();
        int rowHeight = 0;
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            Object renderer;
            block17: {
                JLabel newRenderer;
                Class<?> columnClass;
                block18: {
                    renderer = this.configuration.getRenderer(k);
                    if (renderer != null) break block17;
                    columnClass = this.configuration.getColumnClass(k);
                    if (columnClass != String.class) break block18;
                    switch (this.configuration.getAlignment(k)) {
                        case 0: {
                            renderer = this.defRendererCentered;
                            break block17;
                        }
                        case 2: {
                            renderer = this.defRendererLeft;
                            break block17;
                        }
                        case 4: {
                            renderer = this.defRendererRight;
                            break block17;
                        }
                        default: {
                            throw new IllegalStateException("Alignment must be CENTER, LEFT or RIGHT. value=" + this.configuration.getAlignment(k));
                        }
                    }
                }
                if (columnClass == Icon.class) {
                    if (this.configuration.getTooltip(k) == null) {
                        renderer = this.defRendererIcon;
                    } else {
                        newRenderer = new IconCellRenderer();
                        newRenderer.setToolTipText(this.configuration.getTooltip(k));
                        renderer = newRenderer;
                        log.debug((Object)("**** Tooltip = " + this.configuration.getTooltip(k)));
                    }
                } else if (columnClass == DreieckLabel.class) {
                    if (this.configuration.getTooltip(k) == null) {
                        renderer = this.defRendererDreieck;
                    } else {
                        newRenderer = new DreieckCellRenderer();
                        newRenderer.setToolTipText(this.configuration.getTooltip(k));
                        renderer = newRenderer;
                        log.debug((Object)("**** Tooltip (DreieckCellRenderer) = " + this.configuration.getTooltip(k)));
                    }
                } else {
                    renderer = directRenderer;
                }
            }
            Object prototype = this.configuration.getPrototype(k);
            Component c = renderer.getTableCellRendererComponent(this, prototype, false, false, 1, k);
            Dimension prefSize = c.getPreferredSize();
            TableCellEditor editor = this.configuration.getEditor(k);
            rowHeight = Math.max(rowHeight, prefSize.height);
            HeaderRenderer hrenderer = new HeaderRenderer(this.configuration.getHeaderTooltip(k), this.configuration.getHeaderButtonLeft(k), this.configuration.getHeaderButtonRight(k));
            TableColumn column = new TableColumn(k, prefSize.width + 0, (TableCellRenderer)renderer, editor);
            column.setHeaderRenderer(hrenderer);
            c = hrenderer.getTableCellRendererComponent(this, this.model.getColumnName(k), false, false, 1, k);
            Dimension prefSize2 = c.getPreferredSize();
            if (prefSize2.width > prefSize.width) {
                prefSize = prefSize2;
            }
            column.setMinWidth(prefSize.width + 0);
            column.setPreferredWidth(prefSize.width + 0);
            column.setWidth(prefSize.width + 0);
            boolean isResizeable = this.configuration.isResizeable(k);
            if (!isResizeable) {
                column.setMaxWidth(prefSize.width + 0);
            }
            column.setResizable(isResizeable);
            this.addColumn(column);
        }
        this.setRowHeight(rowHeight);
        this.calcMinSizeNow();
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setPreferredScrollableViewportSize(new Dimension(40, 20));
        this.setAllowSizingSmallerThanMinimumWidth(true);
        this.addMouseListener(new MouseAdapter(){
            int rowDown = -1;
            int colDown = -1;

            @Override
            public void mousePressed(MouseEvent e) {
                this.rowDown = GenericTable.this.rowAtPoint(e.getPoint());
                this.colDown = GenericTable.this.columnAtPoint(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int rowUp = GenericTable.this.rowAtPoint(e.getPoint());
                int colUp = GenericTable.this.columnAtPoint(e.getPoint());
                if (rowUp == this.rowDown && colUp == this.colDown) {
                    GenericTableMouseEvent te = GenericTable.this.createEvent(e);
                    if (e.isPopupTrigger()) {
                        GenericTable.this.firePopupMouseEvent(te);
                    } else {
                        GenericTable.this.fireClickedMouseEvent(te);
                    }
                }
            }
        });
    }

    protected GenericTableMouseEvent createEvent(MouseEvent e) {
        int row = this.rowAtPoint(e.getPoint());
        int column = this.columnAtPoint(e.getPoint());
        if (row > -1 && column > -1) {
            GenericTableMouseEvent evt = new GenericTableMouseEvent(e, row, column);
            return evt;
        }
        return null;
    }

    public void setAllowSizingSmallerThanMinimumWidth(boolean allowMinimizing) {
        if (allowMinimizing) {
            this.setPreferredScrollableViewportSize(new Dimension(150, 40));
        } else {
            this.setPreferredScrollableViewportSize(new Dimension(this.getMinWidth(), 40));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(GenericTableMouseEventListener listener) {
        ArrayList<EventRestriction> arrayList = this.listenerlist;
        synchronized (arrayList) {
            this.listenerlist.add(new EventRestriction(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(GenericTableMouseEventListener listener, int column) {
        ArrayList<EventRestriction> arrayList = this.listenerlist;
        synchronized (arrayList) {
            this.listenerlist.add(new EventRestriction(listener, column));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireClickedMouseEvent(GenericTableMouseEvent evt) {
        if (evt == null) {
            return;
        }
        ArrayList<EventRestriction> arrayList = this.listenerlist;
        synchronized (arrayList) {
            int n = this.listenerlist.size();
            for (int i = 0; i < n; ++i) {
                EventRestriction res = this.listenerlist.get(i);
                res.fireClickedIfNotRestricted(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePopupMouseEvent(GenericTableMouseEvent evt) {
        if (evt == null) {
            return;
        }
        ArrayList<EventRestriction> arrayList = this.listenerlist;
        synchronized (arrayList) {
            int n = this.listenerlist.size();
            for (int i = 0; i < n; ++i) {
                EventRestriction res = this.listenerlist.get(i);
                res.firePopupIfNotRestricted(evt);
            }
        }
    }

    public static int getDefaultResizingMode() {
        return defaultResizingMode;
    }

    public static void setDefaultResizingMode(int defaultResizingMode) {
        GenericTable.defaultResizingMode = defaultResizingMode;
    }

    public static int getDefaultHorizontalSpacing() {
        return defaultHSpacing;
    }

    public static void setDefaultHorizontalSpacing(int defaultHSpacing) {
        GenericTable.defaultHSpacing = defaultHSpacing;
    }

    public int getHorizontalSpacing() {
        return this.hSpacing;
    }

    public void setHorizontalSpacing(int hSpacing) {
        this.hSpacing = hSpacing;
    }

    public int calcRowHeights() {
        int height = 0;
        int maxHeightHeader = 0;
        for (int j = 0; j < this.getModel().getColumnCount(); ++j) {
            TableColumn column = this.getTable().getColumnModel().getColumn(j);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (this.getValueAt(0, j) == null) continue;
            Component component = renderer.getTableCellRendererComponent(this, this.getValueAt(0, j), false, false, 0, j);
            maxHeightHeader = Math.max(component.getPreferredSize().height, maxHeightHeader);
        }
        if (maxHeightHeader == 0) {
            String language = GlobalObjects.getInstance().getLanguage();
            maxHeightHeader = WebETKTheme.testeExotensprache(language.substring(0, 2)) ? 19 : 17;
        }
        height += ++maxHeightHeader;
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            int maxHeight = 0;
            for (int j = 0; j < this.getModel().getColumnCount(); ++j) {
                TableCellRenderer renderer = this.getCellRenderer(i, j);
                Component component = renderer.getTableCellRendererComponent(this, this.getValueAt(i, j), false, false, i, j);
                maxHeight = Math.max(component.getPreferredSize().height, maxHeight);
            }
            maxHeight = Math.max(maxHeight, this.getRowHeight());
            this.setRowHeight(i, maxHeight);
            height += maxHeight;
        }
        return height;
    }

    public void setEnclosingScrollPane(JScrollPane p) {
        this.enclosingScrollPane = p;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.enclosingScrollPane == null) {
            throw new IllegalStateException("ResizingTable: enclosingScrollPane must be set. Consult the documentation of ResizingTable");
        }
        if (this.resizeMode == 1) {
            if (this.enclosingScrollPane.getWidth() >= this.minWidth) {
                this.setAutoResizeMode(4);
                return true;
            }
            this.setAutoResizeMode(0);
            return false;
        }
        if (this.resizeMode == 2) {
            this.setAutoResizeMode(0);
            return false;
        }
        throw new IllegalStateException("invalid resizeMode");
    }

    public void calcMinSizeNow() {
        this.minWidth = this.getColumnModel().getTotalColumnWidth();
        log.debug((Object)("calcMinSizeNow: minWidth=" + this.minWidth));
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    public void setResizeMode(int resizeMode) {
        this.resizeMode = resizeMode;
    }

    @Override
    public void setPreferredSize(Dimension dim) {
        this.preferredSize = dim;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        return super.getPreferredScrollableViewportSize();
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        return this.getToolTipText(ev.getPoint());
    }

    @Override
    public Point getToolTipLocation(MouseEvent ev) {
        String text = this.getToolTipText(ev.getPoint());
        if (text == null) {
            return null;
        }
        int indUmbruch = text.indexOf("<p>");
        int anzRows = 2;
        while (indUmbruch > -1) {
            indUmbruch = text.indexOf("<p>", indUmbruch + 1);
            ++anzRows;
        }
        int tipHeight = anzRows * this.rowHeight;
        JScrollPane sp = this.getScrollPane();
        JViewport vp = sp.getViewport();
        Point viewPos = vp.getViewPosition();
        Dimension dimSp = sp.getSize();
        if (ev.getPoint().y - viewPos.y + tipHeight < dimSp.height) {
            return null;
        }
        return new Point(ev.getPoint().x + 16, dimSp.height + viewPos.y - tipHeight);
    }

    private String getToolTipText(Point mousePos) {
        int row = this.rowAtPoint(mousePos);
        int column = this.columnAtPoint(mousePos);
        if (this.model instanceof GenericTableModel) {
            return ((GenericTableModel)this.model).getToolTipText(row, column);
        }
        return null;
    }

    public boolean getHasButtons() {
        return this.configuration.getHasButtons();
    }

    public void setHasButtons(boolean bHasButons) {
        this.configuration.setHasButtons(bHasButons);
    }

    public void changeHeaderText(int nColumn, String sHeaderText) {
        JTableHeader th = this.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        TableColumn tc = tcm.getColumn(nColumn);
        tc.setHeaderValue(sHeaderText);
        th.repaint();
    }

    private static class EventRestriction {
        int column = -1;
        GenericTableMouseEventListener listener;

        public EventRestriction(GenericTableMouseEventListener listener) {
            this.listener = listener;
        }

        public EventRestriction(GenericTableMouseEventListener listener, int column) {
            this.column = column;
            this.listener = listener;
        }

        public void fireClickedIfNotRestricted(GenericTableMouseEvent evt) {
            if (this.column == -1 || evt.getColumn() == this.column) {
                if (evt.getClickCount() == 1) {
                    this.listener.clickedOnCell(evt);
                }
                if (evt.getClickCount() == 2) {
                    this.listener.clickedOnCellDouble(evt);
                }
            }
        }

        public void firePopupIfNotRestricted(GenericTableMouseEvent evt) {
            if (this.column == -1 || evt.getColumn() == this.column) {
                this.listener.popupOnCell(evt);
            }
        }
    }
}

