/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.generictable;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import webetk.javaclient.generictable.DreieckTextAndTooltip;
import webetk.javaclient.generictable.ETKDefaultTableCellRenderer;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.IconAndTooltip;
import webetk.javaclient.generictable.TableConfiguration;

public class GenericTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList<GenericRow> rows;
    private TableConfiguration configuration;

    public GenericTableModel(TableConfiguration configuration) {
        this.configuration = configuration;
        this.rows = new ArrayList();
    }

    public void addRow(GenericRow row) {
        this.rows.add(row);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void insertRow(int insertIndex, GenericRow row) {
        this.rows.add(insertIndex, row);
        this.fireTableRowsInserted(insertIndex, insertIndex);
    }

    public void removeRow(int rowIndex) {
        this.rows.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public void removeAllRows() {
        this.rows = new ArrayList();
        this.fireTableDataChanged();
    }

    public GenericRow getRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.rows.size()) {
            throw new IllegalArgumentException("Illegal rowIndex in getRow. index=" + rowIndex);
        }
        return this.rows.get(rowIndex);
    }

    @Override
    public int getColumnCount() {
        return this.configuration.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rows.size() <= rowIndex) {
            if (this.configuration.getUsePrototypeIcons() && this.configuration.getColumnClass(columnIndex) == Icon.class) {
                return (Icon)this.configuration.getPrototype(columnIndex);
            }
            return null;
        }
        if (this.configuration.getUsePrototypeIcons() && this.configuration.getColumnClass(columnIndex) == Icon.class && this.rows.get(rowIndex).get(columnIndex) == null) {
            return (Icon)this.configuration.getPrototype(columnIndex);
        }
        return this.rows.get(rowIndex).get(columnIndex);
    }

    public String getToolTipText(int rowIndex, int columnIndex) {
        if (this.rows.size() <= rowIndex) {
            if (this.configuration.getUsePrototypeIcons()) {
                return this.configuration.getTooltip(columnIndex);
            }
            return null;
        }
        GenericRow row = this.rows.get(rowIndex);
        Object obj = row.get(columnIndex);
        if (obj instanceof IconAndTooltip) {
            IconAndTooltip iat = (IconAndTooltip)obj;
            return iat.getTooltip();
        }
        if (obj instanceof DreieckTextAndTooltip) {
            DreieckTextAndTooltip oTat = (DreieckTextAndTooltip)obj;
            return oTat.getTooltip();
        }
        if (obj instanceof ETKDefaultTableCellRenderer) {
            ETKDefaultTableCellRenderer renderer = (ETKDefaultTableCellRenderer)obj;
            return renderer.getToolTipText();
        }
        if (obj instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)obj;
            return renderer.getToolTipText();
        }
        if (obj instanceof Icon) {
            return this.configuration.getTooltip(columnIndex);
        }
        if (row.getTooltip(columnIndex) != null) {
            return row.getTooltip(columnIndex);
        }
        if (this.configuration.getUsePrototypeIcons()) {
            return this.configuration.getTooltip(columnIndex);
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return this.configuration.getColumnName(column);
    }

    public TableConfiguration getConfiguration() {
        return this.configuration;
    }
}

