/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.generictable;

import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import webetk.javaclient.generictable.GenericTable;

public class HeaderRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    String tooltipHeaderText;
    private int spacing = 10;
    private JPanel panelButtons;
    private JButtonEx buttonLeft;
    private JButtonEx buttonRight;

    public HeaderRenderer(String tooltipText) {
        this.setHorizontalAlignment(0);
        this.tooltipHeaderText = tooltipText;
    }

    public HeaderRenderer(String tooltipText, JButtonEx buttonLeft, JButtonEx buttonRight) {
        this.setHorizontalAlignment(0);
        this.tooltipHeaderText = tooltipText;
        this.buttonLeft = buttonLeft;
        this.buttonRight = buttonRight;
        this.panelButtons = new JPanel();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setToolTipText(this.tooltipHeaderText);
        if (table instanceof GenericTable && this.getText().length() > 0) {
            GenericTable genTable = (GenericTable)table;
            if (this.buttonLeft != null || this.buttonRight != null || genTable.getHasButtons()) {
                JPanel panel = new JPanel();
                FlowLayout bl = new FlowLayout();
                bl.setHgap(2);
                bl.setVgap(1);
                this.panelButtons.setLayout(bl);
                panel.setLayout(new BorderLayout());
                if (this.buttonLeft != null) {
                    this.panelButtons.add(this.buttonLeft);
                }
                if (this.buttonRight != null) {
                    this.panelButtons.add(this.buttonRight);
                }
                panel.add((Component)this.panelButtons, "North");
                panel.add((Component)this, "South");
                panel.setToolTipText(this.tooltipHeaderText);
                return panel;
            }
        }
        return this;
    }

    protected Component getComponent(Point pt) {
        if (this.panelButtons != null && this.panelButtons.contains(pt)) {
            pt.x += this.panelButtons.getX();
            pt.y += this.panelButtons.getY();
            if (this.buttonLeft != null && pt.x >= this.buttonLeft.getX() && pt.y >= this.buttonLeft.getY() && pt.x <= this.buttonLeft.getX() + this.buttonLeft.getWidth() && pt.y <= this.buttonLeft.getY() + this.buttonLeft.getHeight()) {
                return this.buttonLeft;
            }
            if (this.buttonRight != null && pt.x >= this.buttonRight.getX() && pt.y >= this.buttonRight.getY() && pt.x <= this.buttonRight.getX() + this.buttonRight.getWidth() && pt.y <= this.buttonRight.getY() + this.buttonRight.getHeight()) {
                return this.buttonRight;
            }
            return null;
        }
        return this;
    }

    public boolean handleClick(JTable table, MouseEvent ev) {
        JTableHeader th = table.getTableHeader();
        int col = th.columnAtPoint(ev.getPoint());
        Rectangle r = th.getHeaderRect(col);
        Point p2 = new Point(ev.getPoint().x - r.x, ev.getPoint().y - r.y);
        Component comp = this.getComponent(p2);
        if (comp != null && comp instanceof HeaderRenderer) {
            return false;
        }
        if (comp != null && comp instanceof JButtonEx) {
            JButtonEx button = (JButtonEx)comp;
            button.doClick();
            return true;
        }
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width += 2 * this.spacing;
        return d;
    }

    public void setHorizontalSpacing(int amount) {
        this.spacing = amount;
    }

    public int getHorizontalSpacing() {
        return this.spacing;
    }
}

