/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.generictable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.IconAndTooltip;

public class IconCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private int horizontalSpacing = 10;

    public IconCellRenderer() {
        this.setHorizontalAlignment(0);
    }

    public IconCellRenderer(Icon icon, String tooltip) {
        this.setHorizontalAlignment(0);
        this.setIcon(icon);
        this.setToolTipText(tooltip);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setIcon(null);
        } else if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else if (value instanceof IconAndTooltip) {
            IconAndTooltip oIconAndTooltip = (IconAndTooltip)value;
            this.setIcon(oIconAndTooltip.getIcon());
            this.setToolTipText(oIconAndTooltip.getTooltip());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width += 2 * this.horizontalSpacing;
        return d;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int pHorizontalSpacing) {
        this.horizontalSpacing = pHorizontalSpacing;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableModel model = table.getModel();
        if (!isSelected) {
            this.setBackground(Color.white);
        }
        if (model instanceof GenericTableModel) {
            AbstractRow abstractrow;
            Color color;
            GenericRow modelrow;
            GenericTableModel genmodel = (GenericTableModel)model;
            if (row >= 0 && row < genmodel.getRowCount() && (modelrow = genmodel.getRow(row)) instanceof AbstractRow && (color = (abstractrow = (AbstractRow)modelrow).getBackColor()) != null) {
                this.setBackground(color);
            }
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

