/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.infotool;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import webetk.app.infotool.InfoObject;
import webetk.app.infotool.InfoObjectText;
import webetk.app.settings.EinstellungenBasis;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.infotool.TippsTricksDruckansicht;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class TippsTricksDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int MODUS_UNDEF = -1;
    public static final int MODUS_1 = 1;
    public static final int MODUS_2 = 2;
    public static final int MODUS_3 = 3;
    private static Logger log = Logger.getLogger(TippsTricksDlg.class);
    private JPanel mPanAnzeige = null;
    private JPanel mPanButton = null;
    private JCheckBox mCBTippsAnzeigen = new JCheckBox();
    private JButtonEx mButtonPrint = new JButtonEx();
    private JButtonEx mButtonPrev = new JButtonEx();
    private JButtonEx mButtonNext = new JButtonEx();
    private JButtonEx mButtonSchliessen = new JButtonEx();
    private List<InfoObject> maTippsTricks = null;
    private int mnAktIndex = -1;
    private int mnModus = -1;
    private boolean mbBeendenDialog = false;
    private boolean mbAnzeigenTippsInit = true;

    public TippsTricksDlg(JFrame oFrame, List<InfoObject> aTippsTricks, int nStartIndex, int nModus) {
        super((Frame)oFrame, true);
        ArrayList arrayList = this.maTippsTricks = aTippsTricks != null ? aTippsTricks : new ArrayList();
        if (nStartIndex != -1) {
            this.mnAktIndex = nStartIndex - 1;
        }
        this.mnModus = nModus;
        this.setTitle(Resource.getInstance().getTippsTricks());
        this.setSize(900, 480);
        this.setLocation(70, 70);
        this.initComponents();
        this.anpassenControls();
        if (this.maTippsTricks.size() == 0) {
            this.dispose();
            return;
        }
        this.checkAndReactNoData();
        if (this.mbBeendenDialog) {
            return;
        }
        this.anpassenButtons();
        this.anzeigen();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.mbBeendenDialog) {
            this.dispose();
            return;
        }
        super.setVisible(visible);
    }

    void initComponents() {
        JPanel panel = new JPanel();
        int[] w = new int[]{5, 0, 5};
        int[] h = new int[]{5, 0, 10, 0, 5};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(2, 1);
        l.setRowWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(l);
        panel.add((Component)this.createAnzeigeBereich(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonBereich(), c.rc(4, 2, "lrtb"));
        this.getContentPane().add(panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TippsTricksDlg.this.schliessen();
            }
        });
    }

    protected JPanel createAnzeigeBereich() {
        this.mPanAnzeige = new JPanel();
        this.mPanAnzeige.setBorder(UIHelper.getStandardBorder());
        return this.mPanAnzeige;
    }

    protected JPanel createButtonBereich() {
        boolean bDisplayTipps;
        this.mPanButton = new JPanel();
        int[] w = new int[]{0, 5, 0, 5, -7, 5, -5, 5, -5};
        int[] h = new int[]{0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(4, 1);
        l.setColumnWeight(8, 1);
        this.mPanButton.setLayout(l);
        this.mCBTippsAnzeigen.setText(Resource.getInstance().getTippsTricksAnzeigenErsteZeile() + " " + Resource.getInstance().getTippsTricksAnzeigenZweiteZeile());
        this.mbAnzeigenTippsInit = bDisplayTipps = GlobalObjects.getInstance().getSessionInfo().getSettings().displayTippsTricks();
        this.mCBTippsAnzeigen.setSelected(bDisplayTipps);
        this.mButtonPrint.setIcon(new ImageIcon(ImageCache.getInstance().getImage("drucken.gif")));
        this.mButtonPrint.setText(Resource.getInstance().getDrucken());
        this.mButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TippsTricksDlg.this.printTipp();
            }
        });
        this.mButtonPrev.setText(Resource.getInstance().getVorherigerTipp());
        this.mButtonPrev.setIcon(ImageCache.getInstance().getIcon("scrollhome.gif"));
        this.mButtonPrev.setHorizontalTextPosition(4);
        this.mButtonPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TippsTricksDlg.this.vorherigerTipp();
            }
        });
        this.mButtonNext.setText(Resource.getInstance().getNaechsterTipp());
        this.mButtonNext.setIcon(ImageCache.getInstance().getIcon("scrollend.gif"));
        this.mButtonNext.setHorizontalTextPosition(2);
        this.mButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TippsTricksDlg.this.naechsterTipp();
            }
        });
        this.mButtonSchliessen.setText(Resource.getInstance().getSchlieszen());
        this.mButtonSchliessen.setIcon(ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonSchliessen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TippsTricksDlg.this.schliessen();
            }
        });
        this.mPanButton.add((Component)this.mCBTippsAnzeigen, c.rc(1, 1, "lrtb"));
        this.mPanButton.add((Component)this.mButtonPrint, c.rc(1, 3, "ltb"));
        this.mPanButton.add((Component)this.mButtonPrev, c.rc(1, 5, "lrtb"));
        this.mPanButton.add((Component)this.mButtonNext, c.rc(1, 7, "lrtb"));
        this.mPanButton.add((Component)this.mButtonSchliessen, c.rc(1, 9, "lrtb"));
        return this.mPanButton;
    }

    private void anpassenControls() {
        this.mCBTippsAnzeigen.setVisible(false);
        this.mButtonPrev.setVisible(false);
        this.mButtonNext.setVisible(false);
        this.mButtonSchliessen.setVisible(false);
        if (this.mnModus == 1) {
            this.mCBTippsAnzeigen.setVisible(true);
            this.mButtonNext.setVisible(true);
            this.mButtonSchliessen.setVisible(true);
        }
        if (this.mnModus == 2) {
            this.mButtonNext.setVisible(true);
            this.mButtonSchliessen.setVisible(true);
        }
        if (this.mnModus == 3) {
            this.mCBTippsAnzeigen.setVisible(true);
            this.mButtonPrev.setVisible(true);
            this.mButtonNext.setVisible(true);
            this.mButtonSchliessen.setVisible(true);
        }
    }

    private void anpassenButtons() {
        boolean bEnablePrev = this.evalAktIndex(false, true);
        this.mButtonPrev.setEnabled(bEnablePrev);
        boolean bEnableNext = this.evalAktIndex(true, true);
        this.mButtonNext.setEnabled(bEnableNext);
        if (this.mnModus == 2) {
            this.mButtonSchliessen.setEnabled(!bEnableNext);
        }
    }

    protected void printTipp() {
        InfoObject oAktObject = this.getObjectAtAktIndex();
        if (oAktObject != null && oAktObject instanceof InfoObjectText) {
            this.mButtonPrint.setCursor(Cursor.getPredefinedCursor(3));
            TippsTricksDruckansicht.print((InfoObjectText)this.getObjectAtAktIndex());
            this.mButtonPrint.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void vorherigerTipp() {
        this.evalAktIndex(false, false);
        this.anzeigen();
    }

    private void naechsterTipp() {
        this.evalAktIndex(true, false);
        this.anzeigen();
    }

    private void schliessen() {
        this.updateEinstellungen();
        this.saveGelesenNichtGelesen();
        this.dispose();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean evalAktIndex(boolean bNext, boolean bTest) {
        int nAktIndexTest;
        block10: {
            boolean bIndexGefunden;
            block9: {
                nAktIndexTest = this.mnAktIndex;
                switch (this.mnModus) {
                    case 1: {
                        bIndexGefunden = false;
                        if (bNext) {
                            break;
                        }
                        for (int i = nAktIndexTest - 1; i >= 0; --i) {
                            InfoObject oObj = (InfoObject)this.maTippsTricks.toArray()[i];
                            if (oObj.isGelesen()) continue;
                            nAktIndexTest = i;
                            bIndexGefunden = true;
                            break block9;
                        }
                        break block9;
                    }
                    case 2: 
                    case 3: {
                        nAktIndexTest = bNext ? this.mnAktIndex + 1 : this.mnAktIndex - 1;
                        break block10;
                    }
                    default: {
                        log.error((Object)(this.mnModus + " ist kein g\u00fcltiger Dialog-Modus"));
                        break block10;
                    }
                }
                for (int i = nAktIndexTest + 1; i < this.maTippsTricks.size(); ++i) {
                    InfoObject oObj = (InfoObject)this.maTippsTricks.toArray()[i];
                    if (oObj.isGelesen()) continue;
                    nAktIndexTest = i;
                    bIndexGefunden = true;
                    break;
                }
            }
            if (!bIndexGefunden) {
                nAktIndexTest = bNext ? this.maTippsTricks.size() : -1;
            }
        }
        if (!bTest) {
            this.mnAktIndex = nAktIndexTest;
        }
        return nAktIndexTest >= 0 && nAktIndexTest < this.maTippsTricks.size();
    }

    private void anzeigen() {
        InfoObject oAktObject = this.getObjectAtAktIndex();
        if (oAktObject == null) {
            return;
        }
        if ((oAktObject = this.ladenInfoObject(oAktObject)) == null) {
            return;
        }
        if (oAktObject instanceof InfoObjectText) {
            this.anzeigenInfoObjectText(oAktObject);
        }
        this.anpassenButtons();
        oAktObject.isGelesen(true);
    }

    private void anzeigenInfoObjectText(Object oAktObject) {
        if (oAktObject == null || this.mPanAnzeige == null) {
            return;
        }
        InfoObjectText oObject = (InfoObjectText)oAktObject;
        this.mPanAnzeige.removeAll();
        int[] w = new int[]{5, 0, 5};
        int[] h = new int[]{5, 0, 5, 0, 5};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 2);
        l.setRowWeight(4, 2);
        this.mPanAnzeige.setLayout(l);
        JTextArea taNrUeberschrift = new JTextArea();
        taNrUeberschrift.setBorder(UIHelper.getStandardBorder());
        taNrUeberschrift.setEditable(false);
        taNrUeberschrift.setLineWrap(true);
        taNrUeberschrift.setWrapStyleWord(true);
        taNrUeberschrift.setText("#" + oObject.getNummer() + "  " + oObject.getUeberschrift());
        if (oObject.isWichtig()) {
            taNrUeberschrift.setBackground(Color.RED);
        }
        this.mPanAnzeige.add((Component)taNrUeberschrift, c.rc(2, 2, "lrtb"));
        JTextArea taText = new JTextArea();
        taNrUeberschrift.setBorder(UIHelper.getStandardBorder());
        taText.setEditable(false);
        taText.setLineWrap(true);
        taText.setWrapStyleWord(true);
        taText.setText(oObject.getText());
        taText.setCaretPosition(0);
        JScrollPane sc = new JScrollPane(taText);
        sc.setBorder(UIHelper.getStandardBorder());
        this.mPanAnzeige.add((Component)sc, c.rc(4, 2, "lrtb"));
        this.validate();
    }

    private InfoObject getObjectAtAktIndex() {
        if (this.maTippsTricks == null || this.maTippsTricks.size() == 0) {
            return null;
        }
        if (this.mnAktIndex == -1 || this.mnAktIndex >= this.maTippsTricks.size()) {
            return null;
        }
        return (InfoObject)this.maTippsTricks.toArray()[this.mnAktIndex];
    }

    private void checkAndReactNoData() {
        this.mbBeendenDialog = false;
        if (!this.mbAnzeigenTippsInit && this.mnModus == 1) {
            this.mbBeendenDialog = true;
            return;
        }
        boolean bVorhanden = this.evalAktIndex(true, false);
        if (bVorhanden) {
            return;
        }
        int nReturn = JOptionPane.showConfirmDialog(MainView.getInstance(), Resource.getInstance().getTippsTricksFrage1(), Resource.getInstance().getTippsTricks(), 0);
        if (nReturn == 1) {
            this.mCBTippsAnzeigen.setSelected(false);
            this.updateEinstellungen();
            this.mbBeendenDialog = true;
        } else {
            for (int i = 0; i < this.maTippsTricks.size(); ++i) {
                InfoObject oObj = (InfoObject)this.maTippsTricks.toArray()[i];
                oObj.isGelesen(false);
            }
            this.mnAktIndex = 0;
        }
    }

    private InfoObject ladenInfoObject(InfoObject oAktObject) {
        if (oAktObject == null) {
            return null;
        }
        if (oAktObject.isGeladen()) {
            return oAktObject;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTipps = new TrfHashMap(null);
        trfTipps.setValue("info", oAktObject);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTipps, Command.GET_TIPP_TRICK);
            oAktObject = (InfoObject)trfTipps.getValue("info");
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return oAktObject;
        }
        if (trfTipps.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTipps.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTipps.getError().getMessage(), Resource.getInstance().getTippsTricks(), 0);
            return oAktObject;
        }
        ArrayList<InfoObject> cHelp = new ArrayList<InfoObject>();
        for (InfoObject oObj : this.maTippsTricks) {
            if (oObj.getId().equals(oAktObject.getId())) {
                cHelp.add(oAktObject);
                continue;
            }
            cHelp.add(oObj);
        }
        this.maTippsTricks.clear();
        this.maTippsTricks = cHelp;
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return oAktObject;
    }

    private void updateEinstellungen() {
        boolean bShowTipps = this.mCBTippsAnzeigen.isSelected();
        if (bShowTipps == this.mbAnzeigenTippsInit) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfEinstellungen = new TrfHashMap(null);
        EinstellungenBasis oEinstellungen = GlobalObjects.getInstance().getSessionInfo().getSettings();
        oEinstellungen.displayTrippsTricks(bShowTipps);
        trfEinstellungen.setValue("einstellungen", oEinstellungen);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfEinstellungen, Command.SAVE_SETTINGS);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfEinstellungen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfEinstellungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfEinstellungen.getError().getMessage(), Resource.getInstance().getTippsTricks(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void saveGelesenNichtGelesen() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTipps = new TrfHashMap(null);
        trfTipps.setValue("tipps", this.maTippsTricks);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTipps, Command.SAVE_TIPPS_GELESEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTipps.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTipps.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTipps.getError().getMessage(), Resource.getInstance().getTippsTricks(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public List<InfoObject> getExitData() {
        return this.maTippsTricks;
    }
}

