/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.lookandfeel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import webetk.javaclient.lookandfeel.UIHelper;

public class ETKScrollBarUI
extends BasicScrollBarUI {
    static Paint scrollbarBackgroundPaint;

    public static ComponentUI createUI(JComponent arg0) {
        return new ETKScrollBarUI();
    }

    public Paint getPaint() {
        if (scrollbarBackgroundPaint != null) {
            return scrollbarBackgroundPaint;
        }
        BufferedImage bi = new BufferedImage(2, 2, 1);
        bi.setRGB(0, 0, UIHelper.getBackground().getRGB());
        bi.setRGB(1, 1, UIHelper.getBackground().getRGB());
        bi.setRGB(0, 1, MetalLookAndFeel.getControlHighlight().getRGB());
        bi.setRGB(1, 0, MetalLookAndFeel.getControlHighlight().getRGB());
        scrollbarBackgroundPaint = new TexturePaint(bi, new Rectangle2D.Float(0.0f, 0.0f, 2.0f, 2.0f));
        return scrollbarBackgroundPaint;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Graphics2D g2d = (Graphics2D)g;
        Color col = g.getColor();
        g2d.setPaint(this.getPaint());
        g2d.fill(trackBounds);
        g.setColor(col);
        if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(g);
        } else if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(g);
        }
    }
}

