/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.score;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.extras.login.DlgLoginController;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoBrandAuthorizationException;
import webetk.NoDataFoundException;
import webetk.app.settings.EinstellungenBasis;
import webetk.app.teileliste.As2ServerScore;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.app.teileliste.Teil;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.communication.transferables.TrfHashMap;
import webetk.etkclientws.IScoreService;
import webetk.etkscore.EtkScoreFiliale;
import webetk.etkscore.EtkScoreTeileliste;
import webetk.etkscore.EtkScoreTeilelisteAb12;
import webetk.etkscore.EtkScoreTeilelisteJob;
import webetk.etkscore.EtkScoreTeilelisteJobAb12;
import webetk.etkscore.EtkScoreTeilelisteSrp;
import webetk.etkscore.EtkScoreTeilelisteSrpAb12;
import webetk.etkscore.EtkScoreTeilelisteTeil;
import webetk.etkscore.EtkScoreTeilelisteTeilAb12;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.javaclient.dialog.administration.firmeneinstellungen.DlgFirmeneinstellungenController;
import webetk.javaclient.dialog.extras.einstellungen.DlgEinstellungenController;
import webetk.javaclient.dialog.extras.login.DlgLoginView;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoKleinController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.framework.MainViewController;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.workflow.MainWorkflowsteuerung;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class ScoreService
implements IScoreService {
    private static Logger log = Logger.getLogger(ScoreService.class);
    private static final String ETK_SCHNITTSTELLEN_VERSION = "2.0";

    public void closeETK() {
        log.debug((Object)"closeETK");
        System.exit(0);
    }

    public String exchangeVersion(String scoreVersion) {
        return ETK_SCHNITTSTELLEN_VERSION;
    }

    public EtkScoreTeileliste editTeileliste(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, String listeID, EtkScoreTeileliste liste) {
        this.editTeileliste(nutzerID, passwort, filialID, sprache, vin, vbg, kundennummer, listeID, liste, null);
        return liste;
    }

    public EtkScoreTeilelisteAb12 editTeilelisteAb12(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, String listeID, EtkScoreTeilelisteAb12 liste) {
        this.editTeileliste(nutzerID, passwort, filialID, sprache, vin, vbg, kundennummer, listeID, null, liste);
        return liste;
    }

    private void editTeileliste(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, String listeID, EtkScoreTeileliste liste, EtkScoreTeilelisteAb12 listeAb12) {
        log.debug((Object)("Parameter nutzerID " + nutzerID + ", passwort " + passwort + ", filialID " + filialID + ", Sprache " + sprache + ", vin " + vin + ", kundennummer " + kundennummer + ", teilelistenID " + listeID));
        MainViewController mvci = ScoreService.getMainViewControllerInstance(nutzerID, passwort, filialID, sprache);
        if (mvci == null) {
            log.error((Object)"Error: Could not get MainViewController instance!");
            return;
        }
        GlobalObjects.getInstance().getEtkData().setScoreFunction("Score_Teileliste");
        GlobalObjects.getInstance().getEtkData().setScoreFgstnr(vin);
        GlobalObjects.getInstance().getEtkData().setScoreAusstattungen(vbg);
        try {
            ScoreService.doFIByFahrgesellnummer(mvci, vin, vbg);
        }
        catch (NoDataFoundException ex) {
            JOptionPane.showMessageDialog(mvci.getMainViewInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getFahrzeugidentifikation(), 1);
            return;
        }
        catch (NoBrandAuthorizationException ex) {
            JOptionPane.showMessageDialog(mvci.getMainViewInstance(), Resource.getInstance().getKeineMarkenberechtigung(), Resource.getInstance().getFahrzeugidentifikation(), 1);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(mvci.getMainViewInstance(), ex.getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 1);
            return;
        }
        String aktFilialId = GlobalObjects.getInstance().getSessionInfo().getFilialeId();
        Scoreliste objScoreliste = new Scoreliste("", sprache, nutzerID, aktFilialId);
        GlobalObjects.getInstance().getEtkData().setScoreListe(objScoreliste);
        JavaFzgIdInfo oFzgIdInfo = GlobalObjects.getInstance().getFzgIdInfo();
        objScoreliste.setMarke(oFzgIdInfo.getMarke());
        objScoreliste.setDurchlaufId(listeID);
        if (kundennummer == null) {
            log.warn((Object)"Kundennummer null - ignoriert");
        } else if (kundennummer.length() > 7) {
            log.warn((Object)"Kundennummer laenger als 7 Zeichen - ignoriert");
        } else {
            try {
                Long lKundennummer = new Long(kundennummer);
                objScoreliste.setKundenNrLokal(lKundennummer);
            }
            catch (Exception ex) {
                log.warn((Object)"Kundennummer nicht numerisch - ignoriert");
            }
        }
        if (liste != null) {
            ScoreService.createEtklistenPos(objScoreliste, liste, mvci);
        } else if (listeAb12 != null) {
            ScoreService.createEtklistenPos(objScoreliste, listeAb12, mvci);
        }
        objScoreliste = DlgTeilelisteController.createScoreListe(objScoreliste);
        String sEtkId = objScoreliste.getID();
        GlobalObjects.getInstance().getEtkData().setScoreListenID(sEtkId);
        MainWorkflowsteuerung oMainWfSteuerungInstance = MainWorkflowsteuerung.getInstance();
        WorkflowStateData oWsd = new WorkflowStateData();
        oMainWfSteuerungInstance.startWorkflow("WfTeilesucheFzg", oWsd);
        this.showMainView(mvci);
        boolean bLoadTcFlags = listeAb12 != null;
        objScoreliste = DlgTeilelisteController.loadScoreliste(sEtkId, nutzerID, aktFilialId, bLoadTcFlags);
        if (liste != null) {
            ScoreService.createScorelistenPos(objScoreliste, liste);
        } else if (listeAb12 != null) {
            ScoreService.createScorelistenPos(objScoreliste, listeAb12);
        }
        DlgTeilelisteController.deleteScoreListe(sEtkId, nutzerID, aktFilialId);
        if (log.isDebugEnabled()) {
            this.logListeninhalt(liste, listeAb12);
        }
    }

    private void logListeninhalt(EtkScoreTeileliste liste, EtkScoreTeilelisteAb12 listeAb12) {
        block7: {
            block6: {
                log.debug((Object)"returning EtkScoreTeileliste:");
                if (liste == null) break block6;
                for (EtkScoreTeilelisteJob job : liste.getJobs()) {
                    log.debug((Object)("\tId: " + job.getId() + " Bezeichung: " + job.getBezeichung() + " lock: " + job.isLock()));
                    for (EtkScoreTeilelisteSrp srp : job.getSrps()) {
                        log.debug((Object)("\t\tId: " + srp.getId() + " Bez: " + srp.getBezeichung() + " Paketquelle: " + srp.getPaketquelle() + " lock: " + srp.isLock()));
                        for (EtkScoreTeilelisteTeil teil : srp.getTeile()) {
                            log.debug((Object)("\t\t\t Bez: " + teil.getBezeichnung() + " Aenderung: " + teil.getAenderung() + " Menge: " + teil.getMenge() + " Preis: " + teil.getPreis() + " Sachnr: " + teil.getSachnummer() + " lock: " + teil.isLock() + " lokalTeil: " + teil.isLokalteil() + " pruefen: " + teil.isPruefen()));
                        }
                    }
                }
                break block7;
            }
            if (listeAb12 == null) break block7;
            for (EtkScoreTeilelisteJobAb12 job : listeAb12.getJobs()) {
                log.debug((Object)("\tId: " + job.getId() + " Bezeichung: " + job.getBezeichung() + " lock: " + job.isLock()));
                for (EtkScoreTeilelisteSrpAb12 srp : job.getSrps()) {
                    log.debug((Object)("\t\tId: " + srp.getId() + " Bez: " + srp.getBezeichung() + " Paketquelle: " + srp.getPaketquelle() + " lock: " + srp.isLock()));
                    for (EtkScoreTeilelisteTeilAb12 teil : srp.getTeile()) {
                        log.debug((Object)("\t\t\t Bez: " + teil.getBezeichnung() + " Aenderung: " + teil.getAenderung() + " Menge: " + teil.getMenge() + " Preis: " + teil.getPreis() + " Sachnr: " + teil.getSachnummer() + " lock: " + teil.isLock() + " lokalTeil: " + teil.isLokalteil() + " pruefen: " + teil.isPruefen() + " tckennzeichen: " + teil.isTckennzeichen()));
                    }
                }
            }
        }
    }

    public EtkScoreFiliale[] ermittleFilialen() {
        int nFilialCount = 0;
        log.debug((Object)"ermittleFilialen start");
        EtkScoreFiliale[] aFilialen = new EtkScoreFiliale[]{};
        String nutzerID = "score";
        MainViewController mvci = ScoreService.getMainViewControllerInstance(nutzerID);
        if (mvci == null) {
            log.error((Object)"Error: Could not get MainViewController instance!");
            return aFilialen;
        }
        TrfHashMap oFilialen = DlgFirmeneinstellungenController.loadFilialen();
        if (oFilialen != null) {
            String sBezeichnung;
            int ii = 1;
            while ((sBezeichnung = (String)oFilialen.getValue(ii + "benennung")) != null) {
                ++nFilialCount;
                ++ii;
            }
            aFilialen = new EtkScoreFiliale[nFilialCount];
            for (ii = 1; ii <= nFilialCount; ++ii) {
                sBezeichnung = (String)oFilialen.getValue(ii + "benennung");
                EtkScoreFiliale filiale = new EtkScoreFiliale();
                filiale.setBezeichnung(sBezeichnung);
                String sId = (String)oFilialen.getValue(ii + "filialid");
                filiale.setId(sId);
                aFilialen[ii - 1] = filiale;
            }
        }
        log.debug((Object)"Filialen: ");
        for (EtkScoreFiliale filiale : aFilialen) {
            log.debug((Object)("\tId: " + filiale.getId() + " Bez: " + filiale.getBezeichnung()));
        }
        return aFilialen;
    }

    public boolean isAlive() {
        log.debug((Object)"isAlive dto.");
        return true;
    }

    public void showTeileinformation(String nutzerID, String passwort, String filialID, String sprache, String sachnummer) {
        log.debug((Object)("nutzerID: " + nutzerID + " passwort: " + passwort + " filialID: " + filialID + " sprache: " + sprache + " sachnummer: " + sachnummer));
        MainViewController mvci = ScoreService.getMainViewControllerInstance(nutzerID, passwort, filialID, sprache);
        GlobalObjects.getInstance().getEtkData().setScoreFunction("Score_Teileinfo");
        GlobalObjects.getInstance().getEtkData().setScoreFgstnr(null);
        GlobalObjects.getInstance().getEtkData().setScoreAusstattungen(null);
        if (mvci == null) {
            log.error((Object)"Error: Could not get MainViewController instance!");
            return;
        }
        if (sachnummer != null && sachnummer.length() == 11) {
            sachnummer = sachnummer.substring(4, 11);
        }
        new DlgTeileinfoKleinController((Frame)mvci.getMainViewInstance(), sachnummer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showTeilesuche(String nutzerID, String passwort, String filialID, String sprache, String teilenummer, String vin, EtkScoreVerbauung[] vbg) {
        String sachnummer;
        MainViewController mvci;
        block9: {
            log.debug((Object)("nutzerID: " + nutzerID + " passwort: " + passwort + " filialID: " + filialID + " sprache: " + sprache + " teilenummer: " + teilenummer + " vin: " + vin));
            for (EtkScoreVerbauung verbauung : vbg) {
                log.debug((Object)("art: " + verbauung.getArt() + " code: " + verbauung.getCode()));
            }
            mvci = ScoreService.getMainViewControllerInstance(nutzerID, passwort, filialID, sprache);
            GlobalObjects.getInstance().getEtkData().setScoreFunction("Score_Teilesuche");
            GlobalObjects.getInstance().getEtkData().setScoreFgstnr(vin);
            GlobalObjects.getInstance().getEtkData().setScoreAusstattungen(vbg);
            if (mvci == null) {
                log.error((Object)"Error: Could not get MainViewController instance!");
                return;
            }
            log.debug((Object)("Parameter nutzerID " + nutzerID + ", passwort " + passwort + ", filialID " + filialID + ", Sprache " + sprache + ", Sachnummer " + teilenummer + ", vin " + vin));
            sachnummer = null;
            if (teilenummer == null || teilenummer.length() != 11) {
                if (teilenummer != null && teilenummer.length() == 7) {
                    sachnummer = teilenummer;
                    break block9;
                } else {
                    JOptionPane.showMessageDialog(mvci.getMainViewInstance(), "Ung\u00fcltiges Teilenummernformat!\nEs m\u00fcssen genau 11 Zeichen \u00fcbergeben werden!\n\n\u00dcbergebene Teilenummer war '" + teilenummer + "'", "", 1);
                    log.error((Object)("Ung\u00fcltiges Teilenummernformat! Es m\u00fcssen genau 11 Zeichen \u00fcbergeben werden! \u00dcbergebene Teilenummer war " + teilenummer));
                    return;
                }
            }
            sachnummer = teilenummer.substring(4, 11);
        }
        try {
            ScoreService.doFIByFahrgesellnummer(mvci, vin, vbg);
            MainWorkflowsteuerung oMainWfSteuerungInstance = MainWorkflowsteuerung.getInstance();
            WorkflowStateData oWsd = new WorkflowStateData();
            oWsd.setWert("sachnummer", sachnummer);
            oMainWfSteuerungInstance.startWorkflow("WfTeilesucheFzg", oWsd);
        }
        catch (NoDataFoundException e) {
            JOptionPane.showMessageDialog(mvci.getMainViewInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getFahrzeugidentifikation(), 1);
            return;
        }
        catch (NoBrandAuthorizationException e) {
            JOptionPane.showMessageDialog(mvci.getMainViewInstance(), Resource.getInstance().getKeineMarkenberechtigung(), Resource.getInstance().getFahrzeugidentifikation(), 1);
            return;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(mvci.getMainViewInstance(), e.getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 1);
            return;
        }
        this.showMainView(mvci);
    }

    protected void showMainView(MainViewController mvci) {
        log.debug((Object)"MainViewController");
        ShowMainViewThread showMainViewThread = new ShowMainViewThread(mvci);
        showMainViewThread.start();
        try {
            showMainViewThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static MainViewController getMainViewControllerInstance(String nutzerID, String passwort, String filialID, String sprache) {
        log.debug((Object)("nutzerID: " + nutzerID + " passwort: " + passwort + " filialID: " + filialID + " sprache: " + sprache));
        MainViewController mainViewController = MainViewController.getInstance();
        if (!mainViewController.isInitialized()) {
            mainViewController.initFromScore(nutzerID);
        }
        String firmaID = GlobalObjects.getInstance().getFirmaId();
        DlgLoginController loginController = new DlgLoginController();
        loginController.init(new DlgLoginView(), nutzerID, mainViewController.getMainViewInstance());
        if (!loginController.performLogin(firmaID, filialID, nutzerID, passwort)) {
            return null;
        }
        ScoreService.setLanguage(sprache);
        mainViewController.getMainViewInstance().initMenus();
        return mainViewController;
    }

    protected static MainViewController getMainViewControllerInstance(String nutzerID) {
        MainViewController mainViewController = MainViewController.getInstance();
        if (!mainViewController.isInitialized()) {
            mainViewController.initFromScore(nutzerID);
        }
        return mainViewController;
    }

    protected static void setLanguage(String sprache) {
        log.debug((Object)("Sprache setzen: " + sprache));
        String etkSprache = ScoreService.changeScoreSpracheToEtkSprache(sprache);
        Resource.setLanguage(etkSprache);
        WebETKTheme.changeFont(etkSprache.substring(0, 2));
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        EinstellungenBasis settings = oLoginInfo.getSettings();
        settings.setSprache(etkSprache.substring(0, 2));
        if (etkSprache.length() == 4) {
            settings.setSpracheRegion(etkSprache.substring(2, 4));
        } else {
            settings.setSpracheRegion("  ");
        }
        DlgEinstellungenController.setEinstellungenInServerSessionInfo(settings);
    }

    protected static String changeScoreSpracheToEtkSprache(String scoreSprache) {
        log.debug((Object)("scoreSprache: " + scoreSprache));
        if (scoreSprache.indexOf("_") > -1) {
            scoreSprache = scoreSprache.substring(0, 2) + scoreSprache.substring(3, 5);
        }
        if (scoreSprache.indexOf("-") > -1) {
            scoreSprache = scoreSprache.substring(0, 2) + scoreSprache.substring(3, 5);
        }
        if (Resource.canSetLanguage(scoreSprache)) {
            return scoreSprache;
        }
        if (Resource.canSetLanguage(scoreSprache = scoreSprache.substring(0, 2))) {
            return scoreSprache;
        }
        scoreSprache = "en";
        log.debug((Object)("umgewandelt in: " + scoreSprache));
        return scoreSprache;
    }

    public static boolean doFIByFahrgesellnummer(MainViewController mvci, String sFgstnr, EtkScoreVerbauung[] vbg) throws NoDataFoundException, Exception {
        log.debug((Object)"Performing FI by Fahrgestellnummer ");
        String sNetz = GlobalObjects.getInstance().getNetz();
        if (sNetz == null) {
            log.error((Object)Resource.getInstance().getNoCommunicationError());
            mvci.getMainViewInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(mvci.getMainViewInstance(), Resource.getInstance().getNoCommunicationError(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return false;
        }
        if (vbg != null) {
            for (EtkScoreVerbauung verbauung : vbg) {
                log.debug((Object)("art: " + verbauung.getArt() + " code: " + verbauung.getCode()));
            }
        }
        if (sFgstnr == null || sFgstnr.length() != 7) {
            throw new Exception("Ung\u00fcltiges Fahrgestellnummernformat!\nEs m\u00fcssen die letzen 7 Zeichen der VIN \u00fcbergeben werden!\n\n\u00dcbergebene Fahrgestellnummer war '" + sFgstnr + "'");
        }
        if (mvci != null) {
            mvci.getMainViewInstance().setCursor(Cursor.getPredefinedCursor(3));
        }
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        trfFI.setIgdom(true);
        trfFI.setValue("isvollstaendigefi", "true");
        trfFI.setValue("fgstnr", sFgstnr);
        boolean bAusstattungsinfoScoreVorhanden = vbg != null && vbg.length > 0;
        boolean bIGDOMVerwenden = false;
        boolean bVINSpecVerwenden = false;
        boolean bIGDOMAngeschlossen = GlobalObjects.getInstance().getSessionInfo().getIGDOMAngeschlossen();
        bIGDOMVerwenden = !bAusstattungsinfoScoreVorhanden && bIGDOMAngeschlossen;
        boolean bVINSpecAngeschlossen = GlobalObjects.getInstance().getSessionInfo().getVINSpecAngeschlossen();
        bVINSpecVerwenden = !bAusstattungsinfoScoreVorhanden && !bIGDOMAngeschlossen && bVINSpecAngeschlossen;
        ArrayList<EtkScoreVerbauung> ispaAusstattung = new ArrayList<EtkScoreVerbauung>();
        ispaAusstattung.addAll(Arrays.asList(vbg));
        trfFI.setValue("score_ausstattungsinfo", ispaAusstattung);
        trfFI.setValue("igdom_schnittstelle_kontaktieren", bIGDOMVerwenden ? "true" : "false");
        trfFI.setValue("vinspec_schnittstelle_kontaktieren", bVINSpecVerwenden ? "true" : "false");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_FGSTNR);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            mvci.getMainViewInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFI.getError() != null) {
            if (trfFI.getError() instanceof NoDataFoundException) {
                mvci.getMainViewInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw (NoDataFoundException)trfFI.getError();
            }
            if (trfFI.getError() instanceof NoBrandAuthorizationException) {
                mvci.getMainViewInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw (NoBrandAuthorizationException)trfFI.getError();
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            mvci.getMainViewInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(mvci.getMainViewInstance(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            throw trfFI.getError();
        }
        JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfFI.getValue("fzgsucheinfo_java");
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        GlobalObjects.getInstance().setFzgIdInfo(oFzgIdInfo);
        GlobalObjects.getInstance().getEtkData().setScoreMarke(oFzgIdInfo.getMarke());
        GlobalObjects.getInstance().getEtkData().setScoreProduktart(oFzgIdInfo.getProduktart());
        GlobalObjects.getInstance().getEtkData().setScoreKatalogumfang(oFzgIdInfo.getKatalogumfang());
        if (mvci != null) {
            mvci.getMainViewInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        log.debug((Object)"return: true");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void createEtklistenPos(Scoreliste etk, EtkScoreTeileliste score, MainViewController mvci) {
        int nPos = 0;
        Vector<ScorelisteJob> etkJobs = new Vector<ScorelisteJob>();
        EtkScoreTeilelisteJob[] scoreJobs = score.getJobs();
        int jj = 0;
        block0: while (true) {
            if (jj >= scoreJobs.length) {
                etk.setJobs(etkJobs);
                return;
            }
            ScorelisteJob etkJob = new ScorelisteJob();
            etkJob.setId(scoreJobs[jj].getId());
            etkJob.setBezeichnung(scoreJobs[jj].getBezeichung());
            etkJob.setLock(scoreJobs[jj].isLock());
            Vector<ScorelisteSrp> etkSrps = new Vector<ScorelisteSrp>();
            EtkScoreTeilelisteSrp[] scoreSrps = scoreJobs[jj].getSrps();
            int ss = 0;
            while (true) {
                EtkScoreTeilelisteTeil[] scoreTeile;
                Vector<Teil> etkTeile;
                ScorelisteSrp etkSrp;
                if (ss < scoreSrps.length) {
                    etkSrp = new ScorelisteSrp();
                    etkSrp.setId(scoreSrps[ss].getId());
                    etkSrp.setBezeichnung(scoreSrps[ss].getBezeichung());
                    etkSrp.setLock(scoreSrps[ss].isLock());
                    etkSrp.setQuelle(scoreSrps[ss].getPaketquelle());
                    etkTeile = new Vector<Teil>();
                    scoreTeile = scoreSrps[ss].getTeile();
                } else {
                    etkJob.setSrps(etkSrps);
                    etkJobs.add(etkJob);
                    ++jj;
                    continue block0;
                }
                for (int tt = 0; tt < scoreTeile.length; ++tt) {
                    boolean bLokalteil;
                    String uglokalteil;
                    String hglokalteil;
                    String sachnummer;
                    block19: {
                        String hgug;
                        String teilenummer = scoreTeile[tt].getSachnummer();
                        sachnummer = null;
                        hglokalteil = null;
                        uglokalteil = null;
                        bLokalteil = scoreTeile[tt].isLokalteil();
                        if (!bLokalteil) {
                            if (teilenummer == null || teilenummer.length() != 11) {
                                if (teilenummer != null && teilenummer.length() == 7) {
                                    sachnummer = teilenummer;
                                    break block19;
                                } else {
                                    JOptionPane.showMessageDialog(mvci.getMainViewInstance(), "Ung\u00fcltiges Teilenummernformat!\nEs m\u00fcssen genau 11 Zeichen \u00fcbergeben werden!\n\n\u00dcbergebene Teilenummer war '" + teilenummer + "'", "", 1);
                                    log.error((Object)("Ung\u00fcltiges Teilenummernformat! Es m\u00fcssen genau 11 Zeichen \u00fcbergeben werden! \u00dcbergebene Teilenummer war " + teilenummer));
                                    continue;
                                }
                            }
                            sachnummer = teilenummer.substring(4, 11);
                            hgug = teilenummer.substring(0, teilenummer.length() - 7);
                            hglokalteil = hgug.substring(0, 2);
                            uglokalteil = hgug.substring(2, hgug.length());
                        } else {
                            if (teilenummer == null || teilenummer.length() > 11 || teilenummer.length() < 1) {
                                JOptionPane.showMessageDialog(mvci.getMainViewInstance(), "Ung\u00fcltiges Sachnummernformat!\nEs d\u00fcrfen maximal 11 Zeichen \u00fcbergeben werden!\n\n\u00dcbergebene Teilenummer war '" + teilenummer + "'", "", 1);
                                log.error((Object)("Ung\u00fcltiges Sachnummernformat! Es d\u00fcrfen maximal 11 Zeichen \u00fcbergeben werden! \u00dcbergebene Teilenummer war " + teilenummer));
                                continue;
                            }
                            if (teilenummer.length() <= 7) {
                                sachnummer = teilenummer;
                            } else {
                                sachnummer = teilenummer.substring(teilenummer.length() - 7, teilenummer.length());
                                hgug = teilenummer.substring(0, teilenummer.length() - 7);
                                if (hgug.length() <= 2) {
                                    hglokalteil = hgug;
                                } else {
                                    hglokalteil = hgug.substring(0, 2);
                                    uglokalteil = hgug.substring(2, hgug.length());
                                }
                            }
                        }
                    }
                    Teil etkTeil = new Teil(sachnummer);
                    if (hglokalteil != null) {
                        etkTeil.setHG(hglokalteil);
                    }
                    if (uglokalteil != null) {
                        etkTeil.setUG(uglokalteil);
                    }
                    etkTeil.setScoreAenderung(1);
                    etkTeil.setJobId(etkJob.getId());
                    etkTeil.setSrpId(etkSrp.getId());
                    etkTeil.setBenennung(scoreTeile[tt].getBezeichnung());
                    etkTeil.setMenge(Double.toString(scoreTeile[tt].getMenge()));
                    etkTeil.setPreis(scoreTeile[tt].getPreis());
                    etkTeil.setLokalteil(bLokalteil);
                    etkTeil.setScorePruefen(scoreTeile[tt].isPruefen());
                    etkTeil.setScoreLock(scoreTeile[tt].isLock());
                    etkTeil.setPos(++nPos);
                    etkTeile.add(etkTeil);
                }
                if (etkTeile.size() < 1) {
                    ++nPos;
                }
                etkSrp.setTeile(etkTeile);
                etkSrps.add(etkSrp);
                ++ss;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void createEtklistenPos(Scoreliste etk, EtkScoreTeilelisteAb12 score, MainViewController mvci) {
        int nPos = 0;
        Vector<ScorelisteJob> etkJobs = new Vector<ScorelisteJob>();
        EtkScoreTeilelisteJobAb12[] scoreJobs = score.getJobs();
        int jj = 0;
        block0: while (true) {
            if (jj >= scoreJobs.length) {
                etk.setJobs(etkJobs);
                return;
            }
            ScorelisteJob etkJob = new ScorelisteJob();
            etkJob.setId(scoreJobs[jj].getId());
            etkJob.setBezeichnung(scoreJobs[jj].getBezeichung());
            etkJob.setLock(scoreJobs[jj].isLock());
            Vector<ScorelisteSrp> etkSrps = new Vector<ScorelisteSrp>();
            EtkScoreTeilelisteSrpAb12[] scoreSrps = scoreJobs[jj].getSrps();
            int ss = 0;
            while (true) {
                EtkScoreTeilelisteTeilAb12[] scoreTeile;
                Vector<Teil> etkTeile;
                ScorelisteSrp etkSrp;
                if (ss < scoreSrps.length) {
                    etkSrp = new ScorelisteSrp();
                    etkSrp.setId(scoreSrps[ss].getId());
                    etkSrp.setBezeichnung(scoreSrps[ss].getBezeichung());
                    etkSrp.setLock(scoreSrps[ss].isLock());
                    etkSrp.setQuelle(scoreSrps[ss].getPaketquelle());
                    etkTeile = new Vector<Teil>();
                    scoreTeile = scoreSrps[ss].getTeile();
                } else {
                    etkJob.setSrps(etkSrps);
                    etkJobs.add(etkJob);
                    ++jj;
                    continue block0;
                }
                for (int tt = 0; tt < scoreTeile.length; ++tt) {
                    boolean bLokalteil;
                    String uglokalteil;
                    String hglokalteil;
                    String sachnummer;
                    block19: {
                        String hgug;
                        String teilenummer = scoreTeile[tt].getSachnummer();
                        sachnummer = null;
                        hglokalteil = null;
                        uglokalteil = null;
                        bLokalteil = scoreTeile[tt].isLokalteil();
                        if (!bLokalteil) {
                            if (teilenummer == null || teilenummer.length() != 11) {
                                if (teilenummer != null && teilenummer.length() == 7) {
                                    sachnummer = teilenummer;
                                    break block19;
                                } else {
                                    JOptionPane.showMessageDialog(mvci.getMainViewInstance(), "Ung\u00fcltiges Teilenummernformat!\nEs m\u00fcssen genau 11 Zeichen \u00fcbergeben werden!\n\n\u00dcbergebene Teilenummer war '" + teilenummer + "'", "", 1);
                                    log.error((Object)("Ung\u00fcltiges Teilenummernformat! Es m\u00fcssen genau 11 Zeichen \u00fcbergeben werden! \u00dcbergebene Teilenummer war " + teilenummer));
                                    continue;
                                }
                            }
                            sachnummer = teilenummer.substring(4, 11);
                            hgug = teilenummer.substring(0, teilenummer.length() - 7);
                            hglokalteil = hgug.substring(0, 2);
                            uglokalteil = hgug.substring(2, hgug.length());
                        } else {
                            if (teilenummer == null || teilenummer.length() > 11 || teilenummer.length() < 1) {
                                JOptionPane.showMessageDialog(mvci.getMainViewInstance(), "Ung\u00fcltiges Sachnummernformat!\nEs d\u00fcrfen maximal 11 Zeichen \u00fcbergeben werden!\n\n\u00dcbergebene Teilenummer war '" + teilenummer + "'", "", 1);
                                log.error((Object)("Ung\u00fcltiges Sachnummernformat! Es d\u00fcrfen maximal 11 Zeichen \u00fcbergeben werden! \u00dcbergebene Teilenummer war " + teilenummer));
                                continue;
                            }
                            if (teilenummer.length() <= 7) {
                                sachnummer = teilenummer;
                            } else {
                                sachnummer = teilenummer.substring(teilenummer.length() - 7, teilenummer.length());
                                hgug = teilenummer.substring(0, teilenummer.length() - 7);
                                if (hgug.length() <= 2) {
                                    hglokalteil = hgug;
                                } else {
                                    hglokalteil = hgug.substring(0, 2);
                                    uglokalteil = hgug.substring(2, hgug.length());
                                }
                            }
                        }
                    }
                    Teil etkTeil = new Teil(sachnummer);
                    if (hglokalteil != null) {
                        etkTeil.setHG(hglokalteil);
                    }
                    if (uglokalteil != null) {
                        etkTeil.setUG(uglokalteil);
                    }
                    etkTeil.setScoreAenderung(1);
                    etkTeil.setJobId(etkJob.getId());
                    etkTeil.setSrpId(etkSrp.getId());
                    etkTeil.setBenennung(scoreTeile[tt].getBezeichnung());
                    etkTeil.setMenge(Double.toString(scoreTeile[tt].getMenge()));
                    etkTeil.setPreis(scoreTeile[tt].getPreis());
                    etkTeil.setLokalteil(bLokalteil);
                    etkTeil.setScorePruefen(scoreTeile[tt].isPruefen());
                    etkTeil.setScoreLock(scoreTeile[tt].isLock());
                    etkTeil.setPos(++nPos);
                    etkTeile.add(etkTeil);
                }
                if (etkTeile.size() < 1) {
                    ++nPos;
                }
                etkSrp.setTeile(etkTeile);
                etkSrps.add(etkSrp);
                ++ss;
            }
            break;
        }
    }

    protected static void createScorelistenPos(Scoreliste etk, EtkScoreTeileliste score) {
        As2ServerScore.createScorelistenPos(etk, score);
    }

    protected static void createScorelistenPos(Scoreliste etk, EtkScoreTeilelisteAb12 score) {
        int jj = -1;
        Collection<ScorelisteJob> etkJobs = etk.getJobs();
        EtkScoreTeilelisteJobAb12[] scoreJobs = new EtkScoreTeilelisteJobAb12[etkJobs.size()];
        Iterator<ScorelisteJob> iterJobs = etkJobs.iterator();
        while (iterJobs.hasNext()) {
            ++jj;
            ScorelisteJob etkJob = iterJobs.next();
            EtkScoreTeilelisteJobAb12 scoreJob = new EtkScoreTeilelisteJobAb12();
            scoreJob.setId(etkJob.getId());
            scoreJob.setBezeichung(etkJob.getBezeichnung());
            scoreJob.setLock(etkJob.isLock());
            scoreJobs[jj] = scoreJob;
            int ss = -1;
            Collection<ScorelisteSrp> etkSrps = etkJob.getSrps();
            EtkScoreTeilelisteSrpAb12[] scoreSrps = new EtkScoreTeilelisteSrpAb12[etkSrps.size()];
            Iterator<ScorelisteSrp> iterSrps = etkSrps.iterator();
            while (iterSrps.hasNext()) {
                ++ss;
                ScorelisteSrp etkSrp = iterSrps.next();
                EtkScoreTeilelisteSrpAb12 scoreSrp = new EtkScoreTeilelisteSrpAb12();
                scoreSrp.setId(etkSrp.getId());
                scoreSrp.setBezeichung(etkSrp.getBezeichnung());
                scoreSrp.setLock(etkSrp.isLock());
                scoreSrp.setPaketquelle(etkSrp.getQuelle());
                scoreSrps[ss] = scoreSrp;
                int tt = -1;
                Collection<Teil> etkTeile = etkSrp.getTeile();
                EtkScoreTeilelisteTeilAb12[] scoreTeile = new EtkScoreTeilelisteTeilAb12[etkTeile.size()];
                Iterator<Teil> iterTeile = etkTeile.iterator();
                while (iterTeile.hasNext()) {
                    ++tt;
                    Teil etkTeil = iterTeile.next();
                    EtkScoreTeilelisteTeilAb12 scoreTeil = new EtkScoreTeilelisteTeilAb12();
                    scoreTeil.setSachnummer(etkTeil.getTeilenummer());
                    scoreTeil.setBezeichnung(etkTeil.getBenennung());
                    scoreTeil.setMenge(Double.parseDouble(etkTeil.getMenge()));
                    scoreTeil.setPreis(etkTeil.getPreis());
                    scoreTeil.setLokalteil(etkTeil.getLokalteil());
                    scoreTeil.setAenderung(Integer.toString(etkTeil.getScoreAenderung()));
                    scoreTeil.setPruefen(etkTeil.isScorePruefen());
                    scoreTeil.setLock(etkTeil.isScoreLock());
                    scoreTeil.setTckennzeichen(etkTeil.isTcKennzeichen());
                    scoreTeile[tt] = scoreTeil;
                }
                scoreSrps[ss].setTeile(scoreTeile);
            }
            scoreJobs[jj].setSrps(scoreSrps);
        }
        score.setJobs(scoreJobs);
    }

    protected static class ShowMainViewThread
    extends Thread {
        private MainViewController mvci;

        public ShowMainViewThread(MainViewController mvci) {
            log.debug((Object)"ShowMainViewThread()instanciated");
            this.mvci = mvci;
        }

        @Override
        public void run() {
            log.debug((Object)"MainViewInstance().setVisible(true)");
            this.mvci.getMainViewInstance().setVisible(true);
            while (!this.mvci.getMainViewInstance().isHidden()) {
                try {
                    ShowMainViewThread.sleep(1011L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

