/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.utils;

import java.awt.Cursor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import webetk.DMSException;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.teileliste.Teil;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DmsUtils {
    public static boolean showMsgTxt(String sDmsMsgTxt, Integer nStatus) {
        return DmsUtils.showMsgTxt(sDmsMsgTxt, nStatus, null);
    }

    public static boolean showMsgTxt(String sDmsMsgTxt, Integer nStatus, String sErfolgsMsg) {
        int nMessageType = 1;
        if (nStatus != null && nStatus != 0) {
            nMessageType = 0;
        }
        if (sDmsMsgTxt != null && sDmsMsgTxt.length() > 0) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sDmsMsgTxt, Resource.getInstance().getDmsMeldung(), nMessageType);
            return nMessageType == 1;
        }
        if (nStatus != null && nStatus != 0) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getDmsFehlerText(nStatus), Resource.getInstance().getDmsMeldung(), 0);
            return false;
        }
        if (sErfolgsMsg != null && sErfolgsMsg.length() > 0) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sErfolgsMsg, Resource.getInstance().getDmsMeldung(), 1);
        }
        return true;
    }

    public static boolean showMsgTxt(String sDmsMsgTxt, int[] aRetCodes, Teil[] aTeile, Konfiguration oKonfig, String sErfolgsMsg) {
        if (sDmsMsgTxt != null && sDmsMsgTxt.length() > 0) {
            String sRetCodes = DmsUtils.checkRetcodes(aRetCodes, aTeile, oKonfig);
            boolean bFehler = sRetCodes.length() > 0;
            int nMessageType = 0;
            if (!bFehler) {
                nMessageType = 1;
            }
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sDmsMsgTxt, Resource.getInstance().getDmsMeldung(), nMessageType);
            return !bFehler;
        }
        String sRetCodes = DmsUtils.checkRetcodes(aRetCodes, aTeile, oKonfig);
        if (sRetCodes.length() > 0) {
            Object[] aMsgZeilen = StringUtils.convMultilineToArray(sRetCodes);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), aMsgZeilen, Resource.getInstance().getDmsMeldung(), 0);
            return false;
        }
        if (sErfolgsMsg != null && sErfolgsMsg.length() > 0) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sErfolgsMsg, Resource.getInstance().getDmsMeldung(), 1);
        }
        return true;
    }

    protected static String checkRetcodes(int[] aRetCodes, Teil[] aTeile, Konfiguration oKonfig) {
        String sRetCodes = "";
        for (int ii = 0; ii < aRetCodes.length; ++ii) {
            Teil oTeil;
            if (aRetCodes[ii] == 0) continue;
            if (oKonfig.getAbwicklung().equals("S") && (oTeil = aTeile[ii]) != null) {
                sRetCodes = sRetCodes + oTeil.getTeilenummerGespreizt() + ": ";
            }
            sRetCodes = sRetCodes + Resource.getInstance().getDmsFehlerText(aRetCodes[ii]) + "\n";
        }
        return sRetCodes;
    }

    public static boolean showMsgTxt(String sDmsMsgTxt, Exception ex) {
        int nMessageType = 1;
        if (ex != null) {
            nMessageType = 0;
        }
        if (sDmsMsgTxt != null && sDmsMsgTxt.length() > 0) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sDmsMsgTxt, Resource.getInstance().getDmsMeldung(), nMessageType);
            return nMessageType == 1;
        }
        if (ex != null) {
            if (ex instanceof DMSException) {
                StringBuffer sMsg = new StringBuffer(Resource.getInstance().getFehlerDmsAbgleich() + ".\n");
                DMSException exDms = (DMSException)ex;
                Collection aTeilenummern = exDms.getTeilenummern();
                Collection aPos = exDms.getPositionen();
                Collection aRetcodes = exDms.getRetCodes();
                if (aTeilenummern != null && aRetcodes != null) {
                    sMsg.append(Resource.getInstance().getMsgPosOhneDatenabgleich() + "\n");
                    Iterator iTeilenummern = aTeilenummern.iterator();
                    Iterator iPos = aPos.iterator();
                    Iterator iRetcodes = aRetcodes.iterator();
                    while (iTeilenummern.hasNext() && iRetcodes.hasNext()) {
                        String sTeilenummer = (String)iTeilenummern.next();
                        String sPos = ((Integer)iPos.next()).toString();
                        int nStatus = (Integer)iRetcodes.next();
                        sMsg.append(sPos + ":    " + sTeilenummer + ":    " + Resource.getInstance().getDmsFehlerText(nStatus) + "\n");
                    }
                } else {
                    int nStatus = Integer.parseInt(ex.getMessage());
                    sMsg.append(Resource.getInstance().getDmsFehlerText(nStatus));
                }
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), sMsg.toString(), Resource.getInstance().getDmsMeldung(), 0);
                return true;
            }
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        return true;
    }

    public static boolean showMsgTxt(Collection<String> cMsgTxts, Collection<Integer> cRetCodes, Collection<Teil> cTeile) {
        Iterator<String> iterMsgTxts = cMsgTxts.iterator();
        Iterator<Teil> iterTeile = cTeile.iterator();
        Iterator<Integer> iterRetCodes = cRetCodes.iterator();
        StringBuffer sDmsMsg = new StringBuffer("");
        int nMsgType = 1;
        Vector<Teil> aTeileErfolg = new Vector<Teil>();
        while (iterMsgTxts.hasNext() && iterMsgTxts.hasNext() && iterTeile.hasNext()) {
            boolean bBreak = false;
            int nStatus = iterRetCodes.next();
            String sMsgTxt = iterMsgTxts.next();
            Teil oTeil = iterTeile.next();
            if (sMsgTxt != null && sMsgTxt.length() > 0) {
                sDmsMsg.append(oTeil.getTeilenummerGespreizt() + ":    " + sMsgTxt + "\n");
            } else if (nStatus == 0) {
                sDmsMsg.append(oTeil.getTeilenummerGespreizt() + ":    " + Resource.getInstance().getErfolgStammsatzanlage() + "\n");
            } else if (nStatus > 0) {
                sDmsMsg.append(oTeil.getTeilenummerGespreizt() + ":    " + Resource.getInstance().getDmsFehlerText(nStatus) + "\n");
            }
            if (nStatus == 0) {
                aTeileErfolg.add(oTeil);
                continue;
            }
            if (nStatus > 0) {
                nMsgType = 0;
                continue;
            }
            nMsgType = 0;
            if (sMsgTxt != null && sMsgTxt.equals("Produktklasse")) {
                sMsgTxt = Resource.getInstance().getFehlerProduktklasse() + " " + Resource.getInstance().getStammsatzanlageNichtMoeglich();
            } else if (sMsgTxt != null && sMsgTxt.equals("Teileart")) {
                sMsgTxt = Resource.getInstance().getFehlerTeileart() + " " + Resource.getInstance().getStammsatzanlageNichtMoeglich();
            } else if (sMsgTxt != null && sMsgTxt.equals("RabattSchluessel")) {
                sMsgTxt = Resource.getInstance().getFehlerRabattschluesselTeil() + " " + Resource.getInstance().getStammsatzanlageNichtMoeglich();
            } else {
                sMsgTxt = Resource.getInstance().getSonstigerFehler() + ": " + sMsgTxt;
                bBreak = true;
            }
            sDmsMsg.append(oTeil.getTeilenummerGespreizt() + ":    " + sMsgTxt + "\n");
            if (!bBreak) continue;
            break;
        }
        if (sDmsMsg.length() > 0) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sDmsMsg.toString(), Resource.getInstance().getTeilelisteBearbeiten(), nMsgType);
        }
        if (aTeileErfolg.size() == 0) {
            return false;
        }
        cTeile.clear();
        for (Teil oTeil : aTeileErfolg) {
            cTeile.add(oTeil);
        }
        return true;
    }

    protected static boolean getAbwicklungSatzweise(TrfHashMap oKonfig) {
        Object oAbwicklungSatzweise = oKonfig.getValue("abwicklung");
        return oAbwicklungSatzweise == null || ((String)oAbwicklungSatzweise).equals("S");
    }
}

