/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import java.awt.Cursor;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.fuellmengen.FMZeilen;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.fzgid.DlgFzgIdController;
import webetk.javaclient.dialog.zusatzinfo.fuellmengen.DlgFuellmengenController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.javaclient.workflow.Workflowsteuerung;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class WfFuellmengen
extends Workflowsteuerung {
    private static Logger log = Logger.getLogger(WfFuellmengen.class);

    @Override
    public AbstractDialogViewController getStartDialog() {
        return null;
    }

    @Override
    protected void finalizeDialog(WorkflowStateData exitData) {
    }

    @Override
    protected AbstractDialogViewController calcNextDialog(int nState, WorkflowStateData oWFStateData) {
        if (nState == 0) {
            JavaFzgIdInfo oFzgIdInfo = GlobalObjects.getInstance().getFzgIdInfo();
            if (oFzgIdInfo == null) {
                oWFStateData.setWert("isvollstaendigefi", "true");
                oWFStateData.setWert("modus", "FI_Fuellmengen");
                return new DlgFzgIdController();
            }
            if (oFzgIdInfo.getProduktart().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMotorradIdentifiziertFuellmengen(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                return null;
            }
            if (!oFzgIdInfo.isCompletelyIdentified()) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFahrzeugidentifikationNichtAusreichend(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                oWFStateData.setWert("isvollstaendigefi", "true");
                oWFStateData.setWert("isupdate", "true");
                oWFStateData.setWert("modus", "FI_Fuellmengen");
                return new DlgFzgIdController();
            }
            FMZeilen fmZeilen = this.loadFuellmengen();
            if (fmZeilen == null) {
                return null;
            }
            oWFStateData.setWert("fuellmengen", fmZeilen);
            return new DlgFuellmengenController();
        }
        log.debug((Object)"No further dialog in F\u00fcllmengen workflow.");
        return null;
    }

    public FMZeilen loadFuellmengen() {
        log.debug((Object)"Performing Load F\u00fcllmengen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFuellmengen = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFuellmengen, Command.LOAD_FUELLMENGEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFuellmengenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfFuellmengen.getError() != null) {
            if (trfFuellmengen.getError() instanceof NoDataFoundException) {
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFuellmengen.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getFuellmengen(), 0);
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFuellmengen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFuellmengen.getError().getMessage(), Resource.getInstance().getFuellmengen(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return (FMZeilen)trfFuellmengen.getValue("fuellmengen");
    }
}

