/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.FGs;
import webetk.app.SearchBTETeile;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.fzgid.BedZusatzInfo;
import webetk.app.fzgid.ZusatzInfo;
import webetk.app.fzgid.ZusatzInfoMarke;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfImage;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.fix.Constants;
import webetk.javaclient.dialog.bte.BTEController;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.fzgid.DlgFzgIdController;
import webetk.javaclient.dialog.fzgid.DlgZusatzInfoController;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheBTController;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheFGController;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheHGController;
import webetk.javaclient.dialog.spezifteilesuche.bedingungsauswertung.BedingungsauswertungController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.score.ScoreService;
import webetk.javaclient.workflow.MainWorkflowsteuerung;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.javaclient.workflow.Workflowsteuerung;
import webetk.resources.Resource;

public class WfTeilesucheFzgGrafisch
extends Workflowsteuerung {
    private static Logger log = Logger.getLogger(WfTeilesucheFzgGrafisch.class);
    public static final int STEP_FAHRZEUGIDENTIFIKATION = 0;
    public static final int STEP_AUSWAHL_HG_GRAFIK = 1;
    public static final int STEP_AUSWAHL_FG_GRAFIK = 2;
    public static final int STEP_AUSWAHL_BT_GRAFIK = 3;
    public static final int STEP_BEDINGUNGSAUSWERTUNG = 4;
    public static final int STEP_ANZEIGE_BILDTAFEL = 5;
    public static final int STEP_ANZEIGE_TEILELISTE = 6;
    private static final int STEP_ZUSATZINFO = 7;
    public static final int THIS_BT = 0;
    public static final int NEXT_BT = 1;
    public static final int PREV_BT = 2;
    private String msMarke = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msHG = null;
    private String msFGSuche = "false";
    private Collection<String> mcHGs = null;
    private List<SearchBTETeile.PartOrBTE> moBtGrafiken = null;
    private Collection<String> mcFGs = null;
    private Collection<SearchBTETeile.PartOrBTE> mcBildtafeln_bed_aend = new Vector<SearchBTETeile.PartOrBTE>();
    private int mnBtGrafikenCount = 0;
    private CurrentBTE moBildtafelSel = null;
    private boolean mbBedFilter = true;
    private CurrentBTE moCurrentBte = null;
    private String msHasNextBT = null;
    private String msHasPrevBT = null;
    private WorkflowStateData moWsd = null;
    private int mnIndexPrevHG = -1;
    private int mnIndexNextHG = -1;
    private int mnIndexHGToSearch = -1;
    private int mnIndexPrevFG = -1;
    private int mnIndexNextFG = -1;
    private int mnIndexFGToSearch = -1;
    private String msExitAction = "";
    private Collection<SearchBTETeile.PartOrBTE> mcBildtafeln = new Vector<SearchBTETeile.PartOrBTE>();
    private TrfHashMap moTeilelistenIDs = null;
    private ZusatzInfo moZusatzInfo;

    @Override
    public AbstractDialogViewController getStartDialog() {
        return new DlgFzgIdController();
    }

    @Override
    protected void finalizeDialog(WorkflowStateData exitData) {
        if (exitData == null) {
            log.error((Object)"No valid data found");
            return;
        }
        this.msExitAction = (String)exitData.getWert("exitaction");
        this.moZusatzInfo = (ZusatzInfo)exitData.getWert("zusatz_info");
        this.msMarke = (String)exitData.getWert("marke");
        this.msProduktart = (String)exitData.getWert("produktart");
        this.msKatalogumfang = (String)exitData.getWert("katalogumfang");
        String sBedFilter = (String)exitData.getWert("bed_filter");
        if (sBedFilter != null) {
            boolean bl = this.mbBedFilter = sBedFilter.equals("true");
        }
        if (this.msExitAction != null && this.msExitAction.equals("zurueck_zu_bt_ergebnisse") && exitData.getWert("bildtafeln_bed_aend") != null) {
            this.mcBildtafeln_bed_aend = (Vector)exitData.getWert("bildtafeln_bed_aend");
        }
        if (this.msExitAction != null && this.msExitAction.equals("anzfg_graf")) {
            this.msHG = (String)exitData.getWert("hg");
            this.mcHGs = (Collection)exitData.getWert("hgfg");
        }
        if (this.msExitAction != null && this.msExitAction.equals("anzbildtafeln_graf")) {
            this.msHG = (String)exitData.getWert("hg");
            this.msFGSuche = (String)exitData.getWert("fgsuche");
            this.mcHGs = (Collection)exitData.getWert("hgfg");
            this.mcFGs = (Collection)exitData.getWert("fgs");
        }
        if (this.msExitAction != null && this.msExitAction.equals("anzeige_teileliste")) {
            this.moWsd = (WorkflowStateData)exitData.getWert("wsd");
        }
        if (this.msExitAction != null && this.msExitAction.equals("weiterbildtafeln")) {
            this.mcBildtafeln = (Collection)exitData.getWert("bildtafeln");
            String sBtNummer = (String)exitData.getWert("btnummer");
            this.setBteMenge(this.mcBildtafeln);
            this.setCurrentBte(sBtNummer);
            this.moBildtafelSel = this.moCurrentBte;
            this.aktualisiereBTE();
        }
        if (this.msExitAction == null) {
            return;
        }
        if (this.msExitAction.equals("anzeigen_bt")) {
            this.aktualisiereBTE();
        } else if (this.msExitAction.equals("this_bt")) {
            this.moTeilelistenIDs = (TrfHashMap)exitData.getWert("teilelisten");
            this.selectBTE(0);
        } else if (this.msExitAction.equals("next_bt")) {
            this.moTeilelistenIDs = (TrfHashMap)exitData.getWert("teilelisten");
            this.selectBTE(1);
        } else if (this.msExitAction.equals("prev_bt")) {
            this.moTeilelistenIDs = (TrfHashMap)exitData.getWert("teilelisten");
            this.selectBTE(2);
        } else if (this.msExitAction.equals("search_hg_at_index")) {
            String sIndexHGToSearch = (String)exitData.getWert("index");
            this.mnIndexHGToSearch = sIndexHGToSearch == null ? -1 : Integer.parseInt(sIndexHGToSearch);
            String dummy = (String)this.mcHGs.toArray()[this.mnIndexHGToSearch];
            this.msHG = dummy.length() == 4 ? dummy.substring(0, 2) : dummy;
        } else if (this.msExitAction.equals("search_fg_at_index")) {
            String sIndexFGToSearch = (String)exitData.getWert("index");
            this.mnIndexFGToSearch = sIndexFGToSearch == null ? -1 : Integer.parseInt(sIndexFGToSearch);
            String selFG = (String)this.mcFGs.toArray()[this.mnIndexFGToSearch];
            Vector<String> cHGs = new Vector<String>();
            for (String hg : this.mcHGs) {
                if (hg.contains(this.msHG)) {
                    cHGs.add(this.msHG + selFG);
                    continue;
                }
                cHGs.add(hg);
            }
            this.mcHGs = cHGs;
        }
    }

    @Override
    protected AbstractDialogViewController calcNextDialog(int nState, WorkflowStateData oWFStateData) {
        if (!this.mcBildtafeln_bed_aend.isEmpty() && this.msExitAction != null && this.msExitAction.equals("zurueck_zu_bt_ergebnisse")) {
            oWFStateData.setWert("bildtafeln_bed_aend", this.mcBildtafeln_bed_aend);
        }
        oWFStateData.setWert("modus", "Fahrzeugteile");
        oWFStateData.setWert("bed_filter", this.mbBedFilter ? "true" : "false");
        if (nState == 0 && GlobalObjects.isScore() && GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() == null) {
            String sScoreFgstnr = GlobalObjects.getInstance().getEtkData().getScoreFgstnr();
            EtkScoreVerbauung[] aScoreAusstattung = GlobalObjects.getInstance().getEtkData().getScoreAusstattungen();
            try {
                ScoreService.doFIByFahrgesellnummer(null, sScoreFgstnr, aScoreAusstattung);
            }
            catch (Exception e) {
                log.error((Object)("Das Fahrzeug mit Fgstnr " + sScoreFgstnr + " konnte nicht identifiziert werden"));
                log.error((Object)e.getMessage());
            }
        }
        if (this.msExitAction != null && this.msExitAction.equals("zurueckzubildtafel")) {
            nState = 5;
        }
        if (this.msExitAction != null && this.msExitAction.equals("anzbildtafeln_graf")) {
            nState = 3;
        }
        if (nState == 7) {
            nState = 1;
        } else if (this.msExitAction != null && this.msExitAction.equals("fzgermitteln")) {
            boolean bHatZusatzInfo = false;
            if (this.moZusatzInfo instanceof BedZusatzInfo) {
                BedZusatzInfo oBedZusatzInfo = (BedZusatzInfo)this.moZusatzInfo;
                bHatZusatzInfo = oBedZusatzInfo.hatInfotexte();
            } else if (this.moZusatzInfo instanceof ZusatzInfoMarke) {
                ZusatzInfoMarke oZusatzInfoMarke = (ZusatzInfoMarke)this.moZusatzInfo;
                bHatZusatzInfo = oZusatzInfoMarke.hatZusatzInfos();
            }
            if (this.moZusatzInfo == null || !bHatZusatzInfo) {
                nState = 1;
            } else {
                this.setZustand(7);
                oWFStateData.setWert("zusatz_info", this.moZusatzInfo);
                return new DlgZusatzInfoController();
            }
        }
        if (this.msExitAction != null && this.msExitAction.equals("anzfg_graf")) {
            nState = 2;
        }
        if (this.msExitAction != null && this.msExitAction.equals("search_hg_at_index")) {
            TrfHashMap fgGrafiken = this.ladeFunktionsgruppenGrafiken();
            this.msFGSuche = "false";
            if (fgGrafiken != null) {
                String message;
                String sFg;
                oWFStateData.setWert("FG_OBJECT", fgGrafiken.getValue("FGOBJECT"));
                this.mcFGs = new Vector<String>();
                int i = 0;
                while ((sFg = (String)fgGrafiken.getValue(i + "fg")) != null && !sFg.equals("")) {
                    this.mcFGs.add(sFg);
                    this.msFGSuche = "true";
                    ++i;
                }
                String sFG = (String)fgGrafiken.getValue("0fg");
                if (sFG != null && sFG.length() > 0) {
                    message = "Function groups found!";
                    if (this.mcHGs.contains(this.msHG)) {
                        Iterator<String> iter = this.mcHGs.iterator();
                        Vector<String> cNewHGs = new Vector<String>();
                        while (iter.hasNext()) {
                            String sHG = iter.next();
                            if (this.msHG.equals(sHG)) {
                                cNewHGs.add(sHG + sFG);
                                continue;
                            }
                            cNewHGs.add(sHG);
                        }
                        this.mcHGs.clear();
                        this.mcHGs.addAll(cNewHGs);
                    }
                    log.info((Object)"Function groups found!");
                } else {
                    message = "No function groups found...";
                    log.info((Object)"No function groups found...");
                }
            }
            nState = 3;
        }
        if (this.msExitAction != null && this.msExitAction.equals("search_fg_at_index")) {
            nState = 3;
        }
        if (this.msExitAction != null && this.msExitAction.equals("weiterbildtafeln")) {
            boolean bAllConditionsEvaluated = true;
            boolean bSuchwegVerk = GlobalObjects.getInstance().getSessionInfo().getSuchwegVerkuerzen();
            if (!bSuchwegVerk) {
                bAllConditionsEvaluated = this.moCurrentBte.getBedingungen().alleWerteGesetzt();
            }
            nState = !bSuchwegVerk && !bAllConditionsEvaluated ? 4 : 5;
        }
        if (this.msExitAction != null && this.msExitAction.equals("anzeigen_bt")) {
            nState = 5;
        }
        if (this.msExitAction != null && this.msExitAction.equals("zurueckzubildtafel")) {
            nState = 5;
        }
        if (this.msExitAction != null && this.msExitAction.equals("anzfg_graf")) {
            nState = 2;
        }
        if (this.msExitAction != null && (this.msExitAction.equals("next_bt") || this.msExitAction.equals("prev_bt"))) {
            boolean bAllConditionsEvaluated = true;
            boolean bSuchwegVerk = GlobalObjects.getInstance().getSessionInfo().getSuchwegVerkuerzen();
            if (!bSuchwegVerk) {
                bAllConditionsEvaluated = this.moCurrentBte.getBedingungen().alleWerteGesetzt();
            }
            nState = !bSuchwegVerk && !bAllConditionsEvaluated ? 4 : 5;
        }
        if (this.msExitAction != null && this.msExitAction.equals("zurueck_zu_bt_ergebnisse")) {
            nState = 3;
        }
        if (this.msExitAction != null && this.msExitAction.equals("zurueck_zu_fi")) {
            nState = 0;
        }
        if (this.msExitAction != null && this.msExitAction.equals("anzeige_teileliste")) {
            nState = 6;
        }
        if (nState == 0) {
            boolean bZurueckZurFI = MainWorkflowsteuerung.getInstance().zurueckZurFI();
            MainWorkflowsteuerung.getInstance().zurueckZurFI(false);
            if (!this.msExitAction.equals("zurueck_zu_fi") && !bZurueckZurFI) {
                JavaFzgIdInfo oFzgIdInfo;
                if (GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() != null) {
                    return this.calcNextDialog(1, oWFStateData);
                }
                if (GlobalObjects.getInstance().getEtkData().getAssSucheInfo() != null && (oFzgIdInfo = GlobalObjects.getInstance().getFzgIdInfo()) != null) {
                    String sFzgVIN = oFzgIdInfo.getFahrgestellNr();
                    boolean bIsVinFISuccessful = sFzgVIN != null && sFzgVIN.length() == 7 ? DlgFzgIdController.doFIByFahrgestellnummer(sFzgVIN) : false;
                    boolean bIsModellFISuccessful = false;
                    if (!bIsVinFISuccessful) {
                        try {
                            bIsModellFISuccessful = DlgFzgIdController.doFIByTypAttribute(oFzgIdInfo);
                        }
                        catch (Exception exc) {
                            bIsModellFISuccessful = false;
                        }
                    }
                    if (bIsVinFISuccessful || bIsModellFISuccessful) {
                        return this.calcNextDialog(1, oWFStateData);
                    }
                }
            }
            this.setZustand(3);
            oWFStateData.setWert("isvollstaendigefi", "false");
            oWFStateData.setWert("modus", "FI_Teilesuche");
            log.debug((Object)"Starting spezifische Teilesuche Fahrzeugteile dialog.");
            return this.getStartDialog();
        }
        if (nState == 1) {
            this.setZustand(++nState);
            log.debug((Object)"Starting grafische Teilesuche Fahrzeugteile dialog.");
            return new GrafischeSucheHGController();
        }
        if (nState == 2) {
            oWFStateData.setWert("produktart", this.msProduktart);
            oWFStateData.setWert("marke", this.msMarke);
            oWFStateData.setWert("katalogumfang", this.msKatalogumfang);
            oWFStateData.setWert("hg", this.msHG);
            this.setZustand(++nState);
            log.debug((Object)"Starting grafische Teilesuche Fahrzeugteile dialog.");
            return new GrafischeSucheFGController();
        }
        if (nState == 3) {
            if (this.msExitAction != null && this.msExitAction.equals("zurueck_zu_bt_ergebnisse")) {
                log.debug((Object)"Starting grafische Teilesuche Fahrzeugteile BT-Dialog.");
                oWFStateData.setWert("daten", this.moBtGrafiken);
                if (!this.mcBildtafeln_bed_aend.isEmpty() && this.msExitAction != null && this.msExitAction.equals("zurueck_zu_bt_ergebnisse")) {
                    Vector<SearchBTETeile.PartOrBTE> vBtGrafiken = new Vector<SearchBTETeile.PartOrBTE>(this.mcBildtafeln_bed_aend);
                    oWFStateData.setWert("daten", vBtGrafiken);
                }
                oWFStateData.setWert("bildtafel_sel", this.moBildtafelSel);
                oWFStateData.setWert("index_prev_hg", Integer.toString(this.mnIndexPrevHG));
                oWFStateData.setWert("index_next_hg", Integer.toString(this.mnIndexNextHG));
                oWFStateData.setWert("index_prev_fg", Integer.toString(this.mnIndexPrevFG));
                oWFStateData.setWert("index_next_fg", Integer.toString(this.mnIndexNextFG));
                return new GrafischeSucheBTController();
            }
            this.mnBtGrafikenCount = this.ladeBTGrafiken();
            if (this.mnBtGrafikenCount == 1) {
                this.setBteMenge(this.moBtGrafiken);
                this.selectBTE(1);
                boolean bAllConditionsEvaluated = true;
                boolean bSuchwegVerk = GlobalObjects.getInstance().getSessionInfo().getSuchwegVerkuerzen();
                if (!bSuchwegVerk) {
                    bAllConditionsEvaluated = this.moCurrentBte.getBedingungen().alleWerteGesetzt();
                }
                nState = !bSuchwegVerk && !bAllConditionsEvaluated ? 4 : 5;
            } else {
                log.debug((Object)"Starting grafische Teilesuche Fahrzeugteile BT-Dialog.");
                oWFStateData.setWert("daten", this.moBtGrafiken);
                oWFStateData.setWert("index_prev_hg", Integer.toString(this.mnIndexPrevHG));
                oWFStateData.setWert("index_next_hg", Integer.toString(this.mnIndexNextHG));
                oWFStateData.setWert("index_prev_fg", Integer.toString(this.mnIndexPrevFG));
                oWFStateData.setWert("index_next_fg", Integer.toString(this.mnIndexNextFG));
                return new GrafischeSucheBTController();
            }
        }
        if (nState == 4) {
            oWFStateData.setWert("currentbte", this.moCurrentBte);
            return new BedingungsauswertungController();
        }
        if (nState == 5) {
            oWFStateData.setWert("modus", "Fahrzeugteile");
            oWFStateData.setWert("currentbte", this.moCurrentBte);
            oWFStateData.setWert("teilelisten", this.moTeilelistenIDs);
            oWFStateData.setWert("hasnextbt", this.msHasNextBT);
            oWFStateData.setWert("hasprevbt", this.msHasPrevBT);
            oWFStateData.setWert("zurueck_zu_ergebnisse_tnrbt_visile", "false");
            oWFStateData.setWert("zurueck_zu_ergebnisse_tnrbt_sensitiv", "false");
            oWFStateData.setWert("zurueck_zu_ergebnisse_bt_visible", "true");
            String sZurueckZuBtErgebnisse = this.mcBildtafeln != null && this.mcBildtafeln.size() > 1 ? "true" : "false";
            oWFStateData.setWert("zurueck_zu_ergebnisse_bt_sensitiv", sZurueckZuBtErgebnisse);
            oWFStateData.setWert("aufruf_aus_workflow", "true");
            oWFStateData.setWert("index_prev_hg", Integer.toString(this.mnIndexPrevHG));
            oWFStateData.setWert("index_next_hg", Integer.toString(this.mnIndexNextHG));
            oWFStateData.setWert("index_prev_fg", Integer.toString(this.mnIndexPrevFG));
            oWFStateData.setWert("index_next_fg", Integer.toString(this.mnIndexNextFG));
            return new BTEController();
        }
        if (nState == 6) {
            log.debug((Object)"Starting Teileliste dialog.");
            if (this.moWsd == null) {
                log.error((Object)"no valid WorkflowStatInfo available!");
                return null;
            }
            String sTeilelisteID = (String)this.moWsd.getWert("ID");
            oWFStateData.setWert("ID", (String)this.moWsd.getWert("ID"));
            oWFStateData.setWert("DMS", (String)this.moWsd.getWert("DMS"));
            oWFStateData.setWert("zurueck_zu_bt_erlauben", "true");
            oWFStateData.setWert("aufruf_aus_workflow", "true");
            if (Constants.Bestellliste.isBestellliste(sTeilelisteID)) {
                return new DlgBestelllisteController();
            }
            return new DlgTeilelisteController();
        }
        log.debug((Object)"No further dialog in Teilesuche Fahreugtzeile workflow.");
        return null;
    }

    int ladeBTGrafiken() {
        log.debug((Object)"Performing Load BT-Grafiken");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trf = new TrfHashMap(null);
        trf.setValue("marke", this.msMarke);
        trf.setValue("produktart", this.msProduktart);
        trf.setValue("katalogumfang", this.msKatalogumfang);
        trf.setValue("hg", this.msHG);
        trf.setValue("hgfg", this.mcHGs);
        trf.setValue("isfzg", "true");
        trf.setValue("fgsuche", this.msFGSuche);
        trf.setValue("fgs", this.mcFGs);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_TEILESUCHE_GRAF_BT);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheFzgGrafisch: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return -1;
        }
        if (trf.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getTeilesuche(), 0);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sCount = (String)trf.getValue("count");
        String sIndexNextHG = (String)trf.getValue("index_next_hg");
        this.mnIndexNextHG = sIndexNextHG == null ? -1 : Integer.parseInt(sIndexNextHG);
        String sIndexPrevHG = (String)trf.getValue("index_prev_hg");
        this.mnIndexPrevHG = sIndexPrevHG == null ? -1 : Integer.parseInt(sIndexPrevHG);
        String sIndexNextFG = "-1";
        String sIndexPrevFG = "-1";
        if (!this.mcHGs.contains(this.msHG)) {
            sIndexNextFG = (String)trf.getValue("index_next_fg");
            sIndexPrevFG = (String)trf.getValue("index_prev_fg");
        }
        this.mnIndexNextFG = sIndexNextFG == null ? -1 : Integer.parseInt(sIndexNextFG);
        this.mnIndexPrevFG = sIndexPrevFG == null ? -1 : Integer.parseInt(sIndexPrevFG);
        this.moBtGrafiken = (List)trf.getValue("btes");
        JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trf.getValue("fzgsucheinfo_java");
        if (oFzgSucheInfo != null) {
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        }
        return Integer.parseInt(sCount);
    }

    protected TrfHashMap ladeFunktionsgruppenGrafiken() {
        log.debug((Object)"Performing Teilesuche Acc Grafisch: Hauptgruppen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFgGrafiken = new TrfHashMap(null);
        trfFgGrafiken.setValue("isfzg", "true");
        trfFgGrafiken.setValue("marke", this.msMarke);
        trfFgGrafiken.setValue("produktart", this.msProduktart);
        trfFgGrafiken.setValue("katalogumfang", this.msKatalogumfang);
        trfFgGrafiken.setValue("hg", this.msHG);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFgGrafiken, Command.LOAD_TEILESUCHE_GRAF_FG);
        }
        catch (CommunicationException ex) {
            log.error((Object)("GrafischeSucheHGController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        FGs fGs = (FGs)trfFgGrafiken.getValue("FGOBJECT");
        if (fGs != null) {
            for (int i = 0; i < fGs.getFGs().size(); ++i) {
                trfFgGrafiken.setValue(i + "fg", fGs.getFGs().get(i));
                trfFgGrafiken.setValue(i + "benennung", fGs.getFGBen().get(i));
                trfFgGrafiken.setValue(i + "bild", fGs.getFGGraf().get(i));
            }
        }
        boolean bHasFgs = trfFgGrafiken.getValue("0bild") != null;
        if (trfFgGrafiken.getError() != null) {
            if (trfFgGrafiken.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Funktionsgruppen gefunden!", (Throwable)trfFgGrafiken.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getTeilesucheZubehoerAccessoires(), 0);
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFgGrafiken.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFgGrafiken.getError().getMessage(), Resource.getInstance().getTeilesucheZubehoerAccessoires(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (bHasFgs) {
            return trfFgGrafiken;
        }
        return null;
    }

    public void setBteMenge(Collection<SearchBTETeile.PartOrBTE> cBTEs) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTransferable = new TrfHashMap(null);
        ArrayList<String> cSelBTENummern = new ArrayList<String>();
        ArrayList<String> cSelBTETypen = new ArrayList<String>();
        for (SearchBTETeile.PartOrBTE oBte : cBTEs) {
            String sBTENummer = oBte.getIdNummer();
            cSelBTENummern.add(sBTENummer);
            cSelBTETypen.add("FZG");
        }
        oTransferable.setValue("bildtafeln_list_of_string", cSelBTENummern);
        oTransferable.setValue("btearten", cSelBTETypen);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.SET_BTE_MENGE);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void selectBTE(int nWhat) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTransferable = new TrfHashMap(null);
        try {
            switch (nWhat) {
                case 0: {
                    GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_THIS_BTE);
                    break;
                }
                case 1: {
                    GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_NEXT_BTE);
                    break;
                }
                case 2: {
                    GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_PREV_BTE);
                }
            }
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return;
        }
        this.moCurrentBte = (CurrentBTE)oTransferable.getValue("currentbte");
        this.msHasNextBT = (String)oTransferable.getValue("hasnextbt");
        this.msHasPrevBT = (String)oTransferable.getValue("hasprevbt");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setCurrentBte(String sBtNummer) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTransferable = new TrfHashMap(null);
        oTransferable.setValue("btnummer", sBtNummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_SET_CURRENT_BTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheFzg: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return;
        }
        this.moCurrentBte = (CurrentBTE)oTransferable.getValue("currentbte");
        this.msHasNextBT = (String)oTransferable.getValue("hasnextbt");
        this.msHasPrevBT = (String)oTransferable.getValue("hasprevbt");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void aktualisiereBTE() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTransferable = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_LOAD_BTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheFzg: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return;
        }
        this.moCurrentBte = (CurrentBTE)oTransferable.getValue("currentbte");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public byte[] ladeGrafik(String sGrafikId, String sTimestamp, String sFormat) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfImage oTransferable = new TrfImage(null);
        oTransferable.setImageID(sGrafikId);
        oTransferable.setTimestamp(sTimestamp);
        oTransferable.setFormFactor(sFormat);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.GET_IMAGE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheAcc: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheZubehoerAccessoires(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return oTransferable.toByteArray();
    }
}

