/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.SearchBTETeile;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.fzgid.BedZusatzInfo;
import webetk.app.fzgid.ZusatzInfo;
import webetk.app.fzgid.ZusatzInfoMarke;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfMisc;
import webetk.communication.transferables.TrfTeilesuche;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.fix.Constants;
import webetk.javaclient.dialog.bte.BTEController;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.fzgid.DlgFzgIdController;
import webetk.javaclient.dialog.fzgid.DlgZusatzInfoController;
import webetk.javaclient.dialog.spezifteilesuche.bedingungsauswertung.BedingungsauswertungController;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.SuchergebnisseController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.score.ScoreService;
import webetk.javaclient.workflow.MainWorkflowsteuerung;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.javaclient.workflow.Workflowsteuerung;
import webetk.resources.Resource;

public class WfTeilesucheVL
extends Workflowsteuerung {
    private static Logger log = Logger.getLogger(WfTeilesucheVL.class);
    private static final int STEP_FAHRZEUGIDENTIFIKATION = 0;
    private static final int STEP_ZUSATZINFO = 1;
    private static final int STEP_SUCHE = 2;
    private static final int STEP_ANZEIGE_ERGEBNISSE_1 = 3;
    private static final int STEP_ANZEIGE_ERGEBNISSE_2 = 4;
    private static final int STEP_BEDINGUNGSAUSWERTUNG = 5;
    private static final int STEP_ANZEIGE_BILDTAFEL = 6;
    private static final int STEP_ANZEIGE_TEILELISTE = 7;
    private static final int THIS_BT = 0;
    private static final int NEXT_BT = 1;
    private static final int PREV_BT = 2;
    private CurrentBTE moCurrentBte = null;
    private String msHasNextBT = null;
    private String msHasPrevBT = null;
    private WorkflowStateData moWsd = null;
    private Collection<SearchBTETeile.PartOrBTE> mcBildtafeln_Step1 = new Vector<SearchBTETeile.PartOrBTE>();
    private int mnAnzBildtafeln_Step1 = 0;
    private Collection<SearchBTETeile.PartOrBTE> mcTeilenummern_Step1 = new Vector<SearchBTETeile.PartOrBTE>();
    private int mnAnzTeilenummern_Step1 = 0;
    private Collection<SearchBTETeile.PartOrBTE> mcBildtafeln_Step2 = new Vector<SearchBTETeile.PartOrBTE>();
    private int mnAnzBildtafeln_Step2 = 0;
    private Collection<SearchBTETeile.PartOrBTE> mcBildtafelnSel = new Vector<SearchBTETeile.PartOrBTE>();
    private Collection<SearchBTETeile.PartOrBTE> mcBildtafelnAlle = new Vector<SearchBTETeile.PartOrBTE>();
    private Collection<String> mcSachnummernSel = new Vector<String>();
    private Collection<SearchBTETeile.PartOrBTE> mcBildtafeln_bed_aend = new Vector<SearchBTETeile.PartOrBTE>();
    private TrfHashMap moTeilelistenIDs = null;
    private String msSachnummerSuch = null;
    private ZusatzInfo moZusatzInfo = null;
    private String msExitAction = "";
    private String msAusweisungElemente = "true";
    private String msMouseListenerHashCode = "0";
    private int mnIndexPrevHG = -1;
    private int mnIndexNextHG = -1;
    private boolean mbBedFilter = true;

    @Override
    public AbstractDialogViewController getStartDialog() {
        return new DlgFzgIdController();
    }

    @Override
    protected void finalizeDialog(WorkflowStateData exitData) {
        String sBildtafelSelFirst;
        if (exitData == null) {
            log.error((Object)"No valid data found");
            return;
        }
        this.moZusatzInfo = (ZusatzInfo)exitData.getWert("zusatz_info");
        this.msExitAction = (String)exitData.getWert("exitaction");
        String sBedFilter = (String)exitData.getWert("bed_filter");
        if (sBedFilter != null) {
            boolean bl = this.mbBedFilter = sBedFilter.equals("true");
        }
        if (this.msExitAction != null && (this.msExitAction.equals("zurueck_zu_bt_ergebnisse") || this.msExitAction.equals("zurueck_zu_tnrbt_ergebnisse")) && exitData.getWert("bildtafeln_bed_aend") != null) {
            this.mcBildtafeln_bed_aend = (Collection)exitData.getWert("bildtafeln_bed_aend");
        }
        if (this.msExitAction.equals("anzeige_teileliste")) {
            this.moWsd = (WorkflowStateData)exitData.getWert("wsd");
        }
        if (this.msExitAction.equals("weitersachnummern_step1")) {
            this.mcSachnummernSel = (Collection)exitData.getWert("sachnummern");
            this.mcBildtafelnAlle = null;
            this.mcBildtafelnSel = null;
            this.mcBildtafeln_Step2 = (Collection)exitData.getWert("bildtafeln");
            this.mcBildtafeln_Step2 = this.mcBildtafeln_Step2 == null ? new Vector() : this.mcBildtafeln_Step2;
            this.mnAnzBildtafeln_Step2 = this.mcBildtafeln_Step2.size();
        }
        if (this.msExitAction.equals("weiterbildtafeln_step1")) {
            this.mcBildtafeln_Step2 = new Vector<SearchBTETeile.PartOrBTE>();
            this.mnAnzBildtafeln_Step2 = 0;
            this.mcBildtafelnAlle = (Collection)exitData.getWert("bildtafeln");
            this.mcBildtafelnSel = (Collection)exitData.getWert("bildtafeln_sel");
            sBildtafelSelFirst = this.getFirstSelectedBildtafel();
            if (this.mcBildtafelnSel.size() == 1) {
                this.setBteMenge(this.mcBildtafelnAlle);
            } else {
                this.setBteMenge(this.mcBildtafelnSel);
            }
            this.setCurrentBte(sBildtafelSelFirst);
            this.aktualisiereBTE();
        }
        if (this.msExitAction.equals("weiterbildtafeln_step2")) {
            this.mcBildtafelnAlle = (Collection)exitData.getWert("bildtafeln");
            this.mcBildtafelnSel = (Collection)exitData.getWert("bildtafeln_sel");
            sBildtafelSelFirst = this.getFirstSelectedBildtafel();
            if (this.mcBildtafelnSel.size() == 1) {
                this.setBteMenge(this.mcBildtafelnAlle);
            } else {
                this.setBteMenge(this.mcBildtafelnSel);
            }
            this.setCurrentBte(sBildtafelSelFirst);
            this.aktualisiereBTE();
        }
        if (this.msExitAction.equals("this_bt")) {
            this.moTeilelistenIDs = (TrfHashMap)exitData.getWert("teilelisten");
            this.selectBTE(0);
        }
        if (this.msExitAction.equals("next_bt")) {
            this.moTeilelistenIDs = (TrfHashMap)exitData.getWert("teilelisten");
            this.selectBTE(1);
        }
        if (this.msExitAction.equals("prev_bt")) {
            this.moTeilelistenIDs = (TrfHashMap)exitData.getWert("teilelisten");
            this.selectBTE(2);
        }
        if (this.msExitAction.equals("anzeigen_bt")) {
            this.aktualisiereBTE();
        }
    }

    @Override
    protected AbstractDialogViewController calcNextDialog(int nState, WorkflowStateData oWFStateData) {
        oWFStateData.setWert("bed_filter", this.mbBedFilter ? "true" : "false");
        if (!this.mcBildtafeln_bed_aend.isEmpty() && this.msExitAction != null && (this.msExitAction.equals("zurueck_zu_bt_ergebnisse") || this.msExitAction.equals("zurueck_zu_tnrbt_ergebnisse"))) {
            oWFStateData.setWert("bildtafeln_bed_aend", this.mcBildtafeln_bed_aend);
        }
        if (nState == 0 && GlobalObjects.isScore() && GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() == null) {
            String sScoreFgstnr = GlobalObjects.getInstance().getEtkData().getScoreFgstnr();
            EtkScoreVerbauung[] aScoreAusstattung = GlobalObjects.getInstance().getEtkData().getScoreAusstattungen();
            try {
                ScoreService.doFIByFahrgesellnummer(null, sScoreFgstnr, aScoreAusstattung);
            }
            catch (Exception e) {
                log.error((Object)("Das Fahrzeug mit Fgstnr " + sScoreFgstnr + " konnte nicht identifiziert werden"));
                log.error((Object)e.getMessage());
            }
        }
        if (oWFStateData != null && nState == 0) {
            if (GlobalObjects.getInstance().getEtkData().getSucheInfo() != null && GlobalObjects.getInstance().getFzgIdInfo() != null) {
                nState = 1;
            }
            this.msSachnummerSuch = (String)oWFStateData.getWert("sachnummer");
        }
        if (this.msExitAction.equals("zurueckzubildtafel")) {
            nState = 6;
        } else if (this.msExitAction.equals("weiterbildtafeln_step1") || this.msExitAction.equals("weiterbildtafeln_step2") || this.msExitAction.equals("this_bt") || this.msExitAction.equals("next_bt") || this.msExitAction.equals("prev_bt")) {
            nState = this.evalNextStateBzglBedauswertung();
        } else if (this.msExitAction.equals("anzeigen_bt")) {
            nState = 6;
        } else if (this.msExitAction.equals("zurueckzubildtafel")) {
            nState = 6;
        } else if (this.msExitAction.equals("weitersachnummern_step1")) {
            if (this.mcBildtafeln_Step2.size() == 1) {
                this.setBteMenge(this.mcBildtafeln_Step2);
                this.selectBTE(1);
                nState = this.evalNextStateBzglBedauswertung();
            } else {
                nState = 4;
            }
        } else if (this.msExitAction.equals("zurueck_zu_fi")) {
            nState = 0;
        } else if (this.msExitAction.equals("zurueck_zu_bt_ergebnisse")) {
            nState = this.mnAnzBildtafeln_Step1 > 0 && this.mnAnzBildtafeln_Step2 == 0 ? 3 : 4;
        } else if (this.msExitAction.equals("anzeige_teileliste")) {
            nState = 7;
        }
        if (nState == 0) {
            boolean bZurueckZurFI = MainWorkflowsteuerung.getInstance().zurueckZurFI();
            MainWorkflowsteuerung.getInstance().zurueckZurFI(false);
            if (!this.msExitAction.equals("zurueck_zu_fi") && !bZurueckZurFI && GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() != null) {
                return this.calcNextDialog(2, oWFStateData);
            }
            this.setZustand(1);
            oWFStateData.setWert("isvollstaendigefi", "false");
            oWFStateData.setWert("modus", "FI_Teilesuche");
            log.debug((Object)"Starting spezifische Teilesuche Fahrzeugteile dialog.");
            return this.getStartDialog();
        }
        if (nState == 1) {
            boolean bHatZusatzInfo = false;
            if (this.moZusatzInfo instanceof BedZusatzInfo) {
                BedZusatzInfo oBedZusatzInfo = (BedZusatzInfo)this.moZusatzInfo;
                bHatZusatzInfo = oBedZusatzInfo.hatInfotexte();
            } else if (this.moZusatzInfo instanceof ZusatzInfoMarke) {
                ZusatzInfoMarke oZusatzInfoMarke = (ZusatzInfoMarke)this.moZusatzInfo;
                bHatZusatzInfo = oZusatzInfoMarke.hatZusatzInfos();
            }
            if (this.moZusatzInfo == null || !bHatZusatzInfo) {
                return this.calcNextDialog(2, oWFStateData);
            }
            this.setZustand(2);
            oWFStateData.setWert("zusatz_info", this.moZusatzInfo);
            return new DlgZusatzInfoController();
        }
        if (nState == 2) {
            this.setZustand(3);
            nState = 3;
            oWFStateData.setWert("modus", "ValueLine");
            oWFStateData.setWert("anzeigen_suchkrit", "false");
            oWFStateData.setWert("mouse_listener_hash_code", this.msMouseListenerHashCode);
            oWFStateData.setWert("flag_ausweisung_elemente", this.msAusweisungElemente);
            this.setAusweisungenElemente();
            log.debug((Object)"Starting spezifische Teilesuche Suche dialog f\u00fcr Value Line.");
            if (!this.performSearch()) {
                // empty if block
            }
        }
        if (nState == 3) {
            if (this.mnAnzBildtafeln_Step1 == 1 && this.mnAnzTeilenummern_Step1 == 0) {
                this.setBteMenge(this.mcBildtafeln_Step1);
                this.selectBTE(1);
                return this.calcNextDialog(this.evalNextStateBzglBedauswertung(), oWFStateData);
            }
            this.setZustand(4);
            oWFStateData.setWert("modus", "ValueLine");
            oWFStateData.setWert("bildtafeln", this.mcBildtafeln_Step1);
            if (!this.mcBildtafeln_bed_aend.isEmpty() && this.msExitAction != null && (this.msExitAction.equals("zurueck_zu_bt_ergebnisse") || this.msExitAction.equals("zurueck_zu_tnrbt_ergebnisse"))) {
                oWFStateData.setWert("bildtafeln", this.mcBildtafeln_bed_aend);
            }
            oWFStateData.setWert("teilenummern", this.mcTeilenummern_Step1);
            if (this.mcSachnummernSel != null && this.mcSachnummernSel.size() > 0) {
                oWFStateData.setWert("bildtafeln_sel", null);
                oWFStateData.setWert("sachnummern_sel", this.mcSachnummernSel);
            } else {
                oWFStateData.setWert("bildtafeln_sel", this.mcBildtafelnSel);
                oWFStateData.setWert("sachnummern_sel", null);
            }
            oWFStateData.setWert("index_prev_hg", Integer.toString(this.mnIndexPrevHG));
            oWFStateData.setWert("index_next_hg", Integer.toString(this.mnIndexNextHG));
            log.debug((Object)"Starting spezifische Teilesuche Anzeige Suchergebnisse Step 1 dialog");
            return new SuchergebnisseController();
        }
        if (nState == 4) {
            if (this.mnAnzBildtafeln_Step2 == 1) {
                this.setBteMenge(this.mcBildtafeln_Step2);
                this.selectBTE(1);
                return this.calcNextDialog(this.evalNextStateBzglBedauswertung(), oWFStateData);
            }
            this.setZustand(5);
            oWFStateData.setWert("modus", "ValueLine");
            oWFStateData.setWert("bildtafeln", this.mcBildtafeln_Step2);
            if (!this.mcBildtafeln_bed_aend.isEmpty() && this.msExitAction != null && (this.msExitAction.equals("zurueck_zu_bt_ergebnisse") || this.msExitAction.equals("zurueck_zu_tnrbt_ergebnisse"))) {
                oWFStateData.setWert("bildtafeln", this.mcBildtafeln_bed_aend);
            }
            oWFStateData.setWert("bildtafeln_sel", this.mcBildtafelnSel);
            oWFStateData.setWert("sachnummern_sel", null);
            log.debug((Object)"Starting spezifische Teilesuche Anzeige Suchergebnisse Step 2 dialog");
            return new SuchergebnisseController();
        }
        if (nState == 5) {
            oWFStateData.setWert("currentbte", this.moCurrentBte);
            if (this.moCurrentBte != null && this.moCurrentBte.getBTEType() != null && this.moCurrentBte.getBTEType().equalsIgnoreCase("ASS")) {
                return this.calcNextDialog(6, oWFStateData);
            }
            return new BedingungsauswertungController();
        }
        if (nState == 6) {
            oWFStateData.setWert("modus", "ValueLine");
            oWFStateData.setWert("currentbte", this.moCurrentBte);
            oWFStateData.setWert("teilelisten", this.moTeilelistenIDs);
            oWFStateData.setWert("sachnummersuch", this.msSachnummerSuch);
            oWFStateData.setWert("hasnextbt", this.msHasNextBT);
            oWFStateData.setWert("hasprevbt", this.msHasPrevBT);
            oWFStateData.setWert("zurueck_zu_ergebnisse_tnrbt_visile", "true");
            String sZurueckZuTnrBtErgebnisse = this.mnAnzTeilenummern_Step1 > 0 && this.mnAnzBildtafeln_Step1 + this.mnAnzTeilenummern_Step1 > 1 ? "true" : "false";
            oWFStateData.setWert("zurueck_zu_ergebnisse_tnrbt_sensitiv", sZurueckZuTnrBtErgebnisse);
            oWFStateData.setWert("zurueck_zu_ergebnisse_bt_visible", "true");
            String sZurueckZuBtErgebnisse = this.mnAnzBildtafeln_Step1 > 1 && this.mnAnzTeilenummern_Step1 == 0 || this.mnAnzBildtafeln_Step2 > 1 ? "true" : "false";
            oWFStateData.setWert("zurueck_zu_ergebnisse_bt_sensitiv", sZurueckZuBtErgebnisse);
            oWFStateData.setWert("zurueck_zu_teilesuche_erlauben", "false");
            oWFStateData.setWert("aufruf_aus_workflow", "true");
            oWFStateData.setWert("index_prev_hg", Integer.toString(this.mnIndexPrevHG));
            oWFStateData.setWert("index_next_hg", Integer.toString(this.mnIndexNextHG));
            return new BTEController();
        }
        if (nState == 7) {
            log.debug((Object)"Starting Teileliste dialog.");
            if (this.moWsd == null) {
                log.error((Object)"no valid WorkflowStatInfo available!");
                return null;
            }
            String sTeilelisteID = (String)this.moWsd.getWert("ID");
            oWFStateData.setWert("ID", (String)this.moWsd.getWert("ID"));
            oWFStateData.setWert("EIGENTUEMER", (String)this.moWsd.getWert("EIGENTUEMER"));
            oWFStateData.setWert("FILIALE", (String)this.moWsd.getWert("FILIALE"));
            oWFStateData.setWert("DMS", (String)this.moWsd.getWert("DMS"));
            oWFStateData.setWert("zurueck_zu_bt_erlauben", "true");
            oWFStateData.setWert("aufruf_aus_workflow", "true");
            if (Constants.Bestellliste.isBestellliste(sTeilelisteID)) {
                return new DlgBestelllisteController();
            }
            return new DlgTeilelisteController();
        }
        log.debug((Object)"No further dialog in spezifische Teilesuche workflow.");
        return null;
    }

    private void setBteMenge(Collection<SearchBTETeile.PartOrBTE> cBTEs) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTransferable = new TrfHashMap(null);
        Vector<String> cSelBTENummern = new Vector<String>();
        Vector<String> cSelBTETypen = new Vector<String>();
        for (SearchBTETeile.PartOrBTE oBTE : cBTEs) {
            cSelBTENummern.add(oBTE.getIdNummer());
            cSelBTETypen.add(oBTE.getBtType());
        }
        oTransferable.setValue("bildtafeln_list_of_string", cSelBTENummern);
        oTransferable.setValue("btearten", cSelBTETypen);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.SET_BTE_MENGE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheVL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void selectBTE(int nWhat) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTransferable = new TrfHashMap(null);
        try {
            switch (nWhat) {
                case 0: {
                    GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_THIS_BTE);
                    break;
                }
                case 1: {
                    GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_NEXT_BTE);
                    break;
                }
                case 2: {
                    GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_PREV_BTE);
                }
            }
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheVL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return;
        }
        this.moCurrentBte = (CurrentBTE)oTransferable.getValue("currentbte");
        this.msHasNextBT = (String)oTransferable.getValue("hasnextbt");
        this.msHasPrevBT = (String)oTransferable.getValue("hasprevbt");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setCurrentBte(String sBtNummer) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTransferable = new TrfHashMap(null);
        oTransferable.setValue("btnummer", sBtNummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_SET_CURRENT_BTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheVL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return;
        }
        this.moCurrentBte = (CurrentBTE)oTransferable.getValue("currentbte");
        this.msHasNextBT = (String)oTransferable.getValue("hasnextbt");
        this.msHasPrevBT = (String)oTransferable.getValue("hasprevbt");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void aktualisiereBTE() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTransferable = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_LOAD_BTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheFzg: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return;
        }
        this.moCurrentBte = (CurrentBTE)oTransferable.getValue("currentbte");
        this.msSachnummerSuch = (String)oTransferable.getValue("sachnummersuch");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setAusweisungenElemente() {
        this.msAusweisungElemente = GlobalObjects.getInstance().isIGDOMAktiv() && GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden() && GlobalObjects.getInstance().getSessionInfo().getAktuelleSchnittstelle().equals("igdom") && GlobalObjects.getInstance().getFzgIdInfo() != null && GlobalObjects.getInstance().getFzgIdInfo().getFahrgestellNr() != null ? "true" : "false";
        TrfMisc misc = new TrfMisc(null);
        misc.setValue("flagAusweisungElementeErmitteln", this.msAusweisungElemente);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(misc, Command.SETZE_FLAG_AUSWEISUNG_ELEMENTE);
        }
        catch (CommunicationException e) {
            log.error((Object)"Kommunikationsfehler beim SETZE_FLAG_AUSWEISUNG_ELEMENTE am Server!", (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage());
        }
        if (misc.getError() != null) {
            log.error((Object)"Sonstiger Fehler beim SETZE_FLAG_AUSWEISUNG_ELEMENTE Server!", (Throwable)misc.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), misc.getError().getMessage());
        }
    }

    private boolean performSearch() {
        log.debug((Object)"Starten der Fzg Teilesuche Value Line!");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeilesuche oTransferable = new TrfTeilesuche(null);
        oTransferable.setValue("isfzg", "true");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.LOAD_ERWEITERTE_VALUE_LINE_BTES);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheVL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (oTransferable.getError() != null) {
            if (oTransferable.getError() instanceof NoDataFoundException) {
                log.error((Object)"Suchergebnisse gefunden", (Throwable)oTransferable.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResultValueLine(), Resource.getInstance().getSuchergebnisseFahrzeugteile() + " " + Resource.getInstance().getValueLine(), 0);
                return false;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getSuchergebnisseFahrzeugteile() + " " + Resource.getInstance().getValueLine(), 0);
            return false;
        }
        this.mcBildtafeln_Step1 = (Collection)oTransferable.getValue("bildtafeln");
        this.mcBildtafeln_Step1 = this.mcBildtafeln_Step1 == null ? new Vector() : this.mcBildtafeln_Step1;
        this.mnAnzBildtafeln_Step1 = this.mcBildtafeln_Step1.size();
        this.mcTeilenummern_Step1 = new Vector<SearchBTETeile.PartOrBTE>();
        this.mnAnzTeilenummern_Step1 = 0;
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    private String getFirstSelectedBildtafel() {
        if (this.mcBildtafelnSel == null || this.mcBildtafelnSel.size() == 0) {
            return null;
        }
        Iterator<SearchBTETeile.PartOrBTE> iter = this.mcBildtafelnSel.iterator();
        if (iter.hasNext()) {
            SearchBTETeile.PartOrBTE oSelBte = iter.next();
            return oSelBte.getIdNummer();
        }
        return null;
    }

    private int evalNextStateBzglBedauswertung() {
        boolean bSuchwegVerk = GlobalObjects.getInstance().getSessionInfo().getSuchwegVerkuerzen();
        if (bSuchwegVerk) {
            return 6;
        }
        if (this.moCurrentBte != null && this.moCurrentBte.getBTEType() != null && this.moCurrentBte.getBTEType().equals("FZG")) {
            boolean bAllConditionsEvaluated = true;
            if (!bSuchwegVerk) {
                bAllConditionsEvaluated = this.moCurrentBte.getBedingungen().alleWerteGesetzt();
            }
            if (!bAllConditionsEvaluated) {
                return 5;
            }
        }
        return 6;
    }
}

