/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.tetis.psi.common;

import com.bmw.tetis.psi.common.ConsoleLogger;
import com.bmw.tetis.psi.common.PsiCommunicationException;
import com.bmw.tetis.psi.common.RmiBindAssistant;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class AppletBindAssistant
extends RmiBindAssistant {
    private AppletBindAssistant() {
    }

    public AppletBindAssistant(String string, String string2, int n, int n2, ConsoleLogger consoleLogger) {
        this.hostName = string;
        this.bindName = string2;
        this.startPort = n;
        this.endPort = n2;
        this.logger = consoleLogger;
        this.isPortPoolUsed = true;
    }

    public AppletBindAssistant(String string, String string2, int n, ConsoleLogger consoleLogger) {
        this.hostName = string;
        this.bindName = string2;
        this.bindPort = n;
        this.logger = consoleLogger;
        this.isPortPoolUsed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean createRegistry(int n) {
        boolean bl;
        block14: {
            block13: {
                bl = true;
                if (this.registry != null) break block13;
                this.registry = LocateRegistry.createRegistry(n);
                this.logger.log(0, "create registry on port: " + n);
                bl = true;
            }
            Object var5_3 = null;
            if (this.registry != null) break block14;
            try {
                if (this.bindPort > 0) {
                    this.registry = LocateRegistry.createRegistry(this.bindPort);
                    this.logger.log(0, "create registry on applet standart port: " + this.bindPort);
                    bl = true;
                    break block14;
                }
                this.registry = LocateRegistry.createRegistry(10099);
                this.logger.log(0, "create registry on default port: 10099");
                bl = true;
            }
            catch (RemoteException remoteException) {
                this.logger.log(0, "createRegistry - finally: " + remoteException.getMessage());
                bl = false;
            }
            break block14;
            {
                catch (RemoteException remoteException) {
                    this.logger.log(0, "createRegistry - catch: " + remoteException.getMessage());
                    bl = false;
                    Object var5_4 = null;
                    if (this.registry != null) break block14;
                    try {
                        if (this.bindPort > 0) {
                            this.registry = LocateRegistry.createRegistry(this.bindPort);
                            this.logger.log(0, "create registry on applet standart port: " + this.bindPort);
                            bl = true;
                            break block14;
                        }
                        this.registry = LocateRegistry.createRegistry(10099);
                        this.logger.log(0, "create registry on default port: 10099");
                        bl = true;
                    }
                    catch (RemoteException remoteException2) {
                        this.logger.log(0, "createRegistry - finally: " + remoteException2.getMessage());
                        bl = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.registry == null) {
                    try {
                        if (this.bindPort > 0) {
                            this.registry = LocateRegistry.createRegistry(this.bindPort);
                            this.logger.log(0, "create registry on applet standart port: " + this.bindPort);
                            bl = true;
                        } else {
                            this.registry = LocateRegistry.createRegistry(10099);
                            this.logger.log(0, "create registry on default port: 10099");
                            bl = true;
                        }
                    }
                    catch (RemoteException remoteException) {
                        this.logger.log(0, "createRegistry - finally: " + remoteException.getMessage());
                        bl = false;
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    public void bindObject(Remote remote) throws PsiCommunicationException {
        if (this.isPortPoolUsed()) {
            this.usePoolport(remote);
        } else {
            this.useStandardPort(remote);
        }
    }

    protected void usePoolport(Remote remote) {
        for (int i = this.startPort; i < this.endPort; ++i) {
            String string = "//" + this.hostName + ":" + i + "/" + this.bindName;
            this.logger.log(0, "TRY TO BIND: " + string);
            try {
                this.createRegistry(i);
                Naming.rebind(string, remote);
                this.setBindPort(i);
                this.setPortPoolUsed(true);
                this.logger.log(0, string + " <-- successful bounded. Port choosed from pool. (-:");
                break;
            }
            catch (Exception exception) {
                this.logger.log(0, string + " Bind object exception: " + exception.getMessage());
                continue;
            }
        }
    }

    protected void useStandardPort(Remote remote) {
        String string = "//" + this.hostName + ":" + this.bindPort + "/" + this.bindName;
        try {
            if (this.addToRegistry(this.bindPort)) {
                Naming.rebind(string, remote);
                this.setBindPort(this.bindPort);
                this.setPortPoolUsed(false);
                this.logger.log(0, string + " <-- successful bounded. Used standard port . :-)");
            } else {
                this.logger.log(1, string + " NOT BOUNDED.");
            }
        }
        catch (Exception exception) {
            this.logger.log(0, string + " Bind object exception: " + exception.getMessage());
        }
    }

    protected void showEntrysInRegistry(String[] stringArray, String string) {
        this.logger.log(0, "SEARCH FOR RMI REGISTRY ITEM: " + string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            this.logger.log(0, "RMI REGISTRY ITEM: " + string2);
        }
    }

    protected boolean isRegistryFree(int n) {
        try {
            String string = "//" + this.hostName + ":" + n + "/" + this.bindName;
            Registry registry = LocateRegistry.getRegistry(n);
            System.out.println(" INFO: " + registry);
            String[] stringArray = registry.list();
            if (stringArray != null) {
                this.showEntrysInRegistry(stringArray, string);
                this.logger.log(0, "FOUND RMI INSTANCE ENTRY IN REGISTRY --> RMI REGISTRY IS NOT FREE.");
            }
            return false;
        }
        catch (RemoteException remoteException) {
            this.logger.log(0, "NO RMI INSTANCE ENTRY IN REGISTRY --> RMI REGISTRY IS FREE ");
            return true;
        }
    }

    protected boolean addToRegistry(int n) {
        try {
            boolean bl = this.isRegistryFree(n);
            if (bl) {
                LocateRegistry.createRegistry(n);
            }
            return true;
        }
        catch (RemoteException remoteException) {
            this.logger.log(0, " port is occupied: " + n + ", JVM -->" + remoteException.getMessage());
            return false;
        }
    }
}

