/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.tetis.psi.common;

import com.bmw.tetis.psi.common.ConsoleLogger;
import com.bmw.tetis.psi.common.RmiBindAssistant;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;

public class ETKBindAssistant
extends RmiBindAssistant {
    private ETKBindAssistant() {
    }

    public ETKBindAssistant(Properties properties, ConsoleLogger consoleLogger) {
        this.logger = consoleLogger;
        this.bindName = "psiApplication";
        this.hostName = "localhost";
        this.setProperties(properties);
    }

    private void setProperties(Properties properties) {
        String string = properties.getProperty("com.bmw.tetis.psi.listenPoolPort.start");
        try {
            this.startPort = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = properties.getProperty("com.bmw.tetis.psi.listenPoolPort.end");
        try {
            this.endPort = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = properties.getProperty("com.bmw.tetis.psi.listenPort.client");
        try {
            this.bindPort = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = properties.getProperty("com.bmw.tetis.psi.listenPort.applet");
        try {
            this.partnerBindPort = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.appStartUrl = properties.getProperty("com.bmw.tetis.psi.startUrl");
        this.logger.log(0, "com.bmw.tetis.psi.listenPoolPort.start: " + string);
        this.logger.log(0, "com.bmw.tetis.psi.listenPoolPort.end: " + string2);
        this.logger.log(0, "com.bmw.tetis.psi.listenPort.client: " + string3);
        this.logger.log(0, "com.bmw.tetis.psi.listenPort.applet: " + string4);
        this.logger.log(0, "com.bmw.tetis.psi.startUrl: " + this.appStartUrl);
        if (string != null && string2 != null) {
            this.setPortPoolUsed(true);
            this.logger.log(0, "SET POOL PORT MODUS");
        } else {
            this.logger.log(0, "SET STANDARD PORT MODUS");
            this.setPortPoolUsed(false);
        }
    }

    protected boolean createRegistry(int n) {
        try {
            LocateRegistry.createRegistry(n);
            return true;
        }
        catch (RemoteException remoteException) {
            this.logger.log(0, "port is occupied (ETK CLIENT): " + n + ", JVM -->" + remoteException.getMessage());
            return false;
        }
    }

    public void bindObject(Remote remote) {
        if (this.isPortPoolUsed()) {
            this.usePoolport(remote);
        } else {
            this.useStandardPort(remote);
        }
    }

    protected void usePoolport(Remote remote) {
        for (int i = this.startPort; i < this.endPort; ++i) {
            String string = "//" + this.hostName + ":" + i + "/" + this.bindName;
            try {
                if (!this.createRegistry(i)) continue;
                Naming.rebind(string, remote);
                this.setBindPort(i);
                this.setPortPoolUsed(true);
                this.logger.log(0, string + " <-- successful bounded. Port choosed from pool. (-:");
                break;
            }
            catch (Exception exception) {
                this.logger.log(0, string + " Bind object exception: " + exception.getMessage());
            }
        }
    }

    protected void useStandardPort(Remote remote) {
        String string = "//" + this.hostName + ":" + this.bindPort + "/" + this.bindName;
        try {
            if (this.createRegistry(this.bindPort)) {
                Naming.rebind(string, remote);
                this.setBindPort(this.bindPort);
                this.setPortPoolUsed(false);
                this.logger.log(0, string + " <-- successful bounded. Used standard port . :-)");
            } else {
                this.logger.log(1, string + " NOT BOUNDED.");
            }
        }
        catch (Exception exception) {
            this.logger.log(0, string + " Bind object exception: " + exception.getMessage());
        }
    }
}

