/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.tetis.psi.common;

import com.bmw.tetis.psi.common.IPsiBusyController;
import com.bmw.tetis.psi.common.IPsiLog;
import com.bmw.tetis.psi.common.PsiCommunicationException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;

public class LookupService {
    private static final long SLEEP_TIME = 1000L;
    private String lookupName;
    private long port;
    private String remoteApp = "remoteApp";
    private String execCommand;
    private IPsiLog logger;
    private Remote remote;

    public LookupService(int n, String string, String string2) {
        this.port = n;
        this.execCommand = string;
        this.lookupName = string2;
        this.remote = null;
    }

    public void setPort(int n) {
        this.port = n;
        this.logger.log(0, "LOOKUP SERVICE --> PORT IS NOW WELL KNOWN: " + this.port);
    }

    public void setRemoteApp(String string) {
        this.remoteApp = string;
    }

    public void setLogger(IPsiLog iPsiLog) {
        this.logger = iPsiLog;
    }

    public Remote getRemote(IPsiBusyController iPsiBusyController) throws PsiCommunicationException {
        String string = "//localhost:" + this.port + "/" + this.lookupName;
        try {
            if (this.remote != null) {
                this.logger.log(0, "REMOTE OBJECT READY:" + string);
                this.remote = this.lookup(string);
                return this.remote;
            }
            this.logger.log(0, "REMOTE OBJECT NOT READY - LOOKUP:" + string);
            this.remote = Naming.lookup(string);
            return this.remote;
        }
        catch (Exception exception) {
            this.logger.log(0, string + " seems not to be running. Trying to start ..");
            this.logger.log(0, "Execute Command: " + this.execCommand);
            try {
                if (this.execCommand != null && this.execCommand.indexOf("http") > 0) {
                    Runtime.getRuntime().exec(this.execCommand);
                }
            }
            catch (IOException iOException) {
                throw new PsiCommunicationException(exception);
            }
            Waiter waiter = new Waiter(iPsiBusyController);
            String string2 = iPsiBusyController.getClass().getName();
            if (string2.indexOf("PsiRmiServer") > 0) {
                System.out.println("Busy Controller Class --> case-1: " + iPsiBusyController);
                iPsiBusyController.start();
                waiter.start();
            } else {
                System.out.println("Busy Controller Class --> case-2: " + iPsiBusyController);
                waiter.start();
                iPsiBusyController.start();
            }
            if (waiter.pce != null) {
                this.logger.log(0, "Timeout at waiting for " + string + " wake up.");
                throw new PsiCommunicationException(waiter.pce);
            }
            if (this.remote == null) {
                throw new PsiCommunicationException("Remote Object is null. Trying to bind from JVM.");
            }
            return this.remote;
        }
    }

    public boolean isRemoteAvailable() {
        try {
            Naming.lookup("//localhost:" + this.port + "/" + this.lookupName);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private Remote getRemote() {
        return this.remote;
    }

    private void setRemote(Remote remote) {
        this.remote = remote;
    }

    private Remote lookup(String string) {
        try {
            this.remote = Naming.lookup(string);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
        return this.remote;
    }

    class Waiter
    extends Thread {
        private Exception pce = null;
        private IPsiBusyController busyController;

        public Waiter(IPsiBusyController iPsiBusyController) {
            this.busyController = iPsiBusyController;
        }

        public void run() {
            String string = "";
            while (!this.busyController.isCanceled() && LookupService.this.getRemote() == null) {
                try {
                    this.pce = null;
                    Thread.sleep(1000L);
                    string = "//localhost:" + LookupService.this.port + "/" + LookupService.this.lookupName;
                    Remote remote = Naming.lookup(string);
                    LookupService.this.setRemote(remote);
                    LookupService.this.logger.log(0, " Waiter successful stoped - " + string);
                    break;
                }
                catch (Exception exception) {
                    LookupService.this.logger.log(0, LookupService.this.remoteApp + " not yet available. try to connect on port:" + LookupService.this.port + " , please wait ... " + "[" + string + "]");
                    LookupService.this.logger.log(0, exception.getMessage());
                    this.pce = exception;
                }
            }
            this.busyController.stop();
        }
    }
}

