/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.analyze.BaseFieldProcessor;
import com.bmw.gki.ka.jaxp.keyformat.BcdFieldType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BCDFieldProcessor
extends BaseFieldProcessor {
    public BCDFieldProcessor(BcdFieldType newField) {
        super(newField);
    }

    protected int determineFieldValueType() {
        return 3;
    }

    protected Object getEncodedValue(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte aByte = bytes[i];
            value *= 10;
            value += aByte;
        }
        return new Integer(value);
    }

    protected boolean isFieldValueValid(Object value) {
        if (value != null) {
            Pattern p = Pattern.compile("[0-9]");
            Matcher m = p.matcher(value.toString());
            return m.matches();
        }
        return false;
    }

    protected boolean isEditable() {
        return true;
    }

    public byte[] modifyBytes(String stringValue, byte[] originBytes) {
        byte[] newBytes = null;
        String realIntValueString = "" + new Double(stringValue).intValue();
        int valueStringLength = realIntValueString.length();
        if (valueStringLength > originBytes.length) {
            newBytes = originBytes;
        } else {
            newBytes = new byte[originBytes.length];
            for (int i = 0; i < newBytes.length; ++i) {
                if (newBytes.length - i > valueStringLength) {
                    newBytes[i] = new Integer(0).byteValue();
                    continue;
                }
                char a = realIntValueString.charAt(valueStringLength - (newBytes.length - i));
                newBytes[i] = new Integer("" + a).byteValue();
            }
        }
        return newBytes;
    }
}

