/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.analyze.CompositeProcessor;
import com.bmw.gki.ka.analyze.FileOffsetOutOfBounds;
import com.bmw.gki.logging.GKILogManager;
import org.apache.commons.logging.Log;

public class KeyDataProcessor
extends CompositeProcessor {
    private byte[] bytes;
    private static final Log LOG = GKILogManager.getInstance().getLogger(KeyDataProcessor.class);

    public KeyDataProcessor(byte[] newBytes) {
        this.bytes = newBytes;
    }

    protected int getFileOffset() {
        return 0;
    }

    protected int getRecordByteLength() {
        return 0;
    }

    protected byte[] getBytes(int childOffset, int count) {
        byte[] byteArr = new byte[count];
        if (childOffset + count > this.bytes.length) {
            String message = "try to access byte array out of bounds at " + childOffset + " in length " + count;
            LOG.warn((Object)message);
        }
        try {
            System.arraycopy(this.bytes, childOffset, byteArr, 0, count);
        }
        catch (RuntimeException e) {
            String message = "try to access byte array out of bounds at " + childOffset + " in length " + count;
            throw new FileOffsetOutOfBounds(message, e);
        }
        return byteArr;
    }

    protected void setBytes(int childOffset, byte[] newBytes) {
        if (childOffset + newBytes.length > this.bytes.length) {
            String message = "try to write byte array out of bounds at " + childOffset + " in length " + newBytes.length;
            LOG.warn((Object)message);
        }
        try {
            System.arraycopy(newBytes, 0, this.bytes, childOffset, newBytes.length);
        }
        catch (RuntimeException e) {
            String message = "try to write byte array out of bounds at " + childOffset + " in length " + newBytes.length;
            throw new FileOffsetOutOfBounds(message, e);
        }
    }

    protected String getCurrentRecordId() {
        return "keyData";
    }
}

