/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.BinaryCodec;

public final class ProcessorHelper {
    private ProcessorHelper() {
    }

    private static int transformInt(int byteVal, int bitmask) {
        if (bitmask == 0) {
            return 0;
        }
        int bitmaskcopy = bitmask;
        byteVal &= bitmask;
        while ((bitmaskcopy & 1) != 1) {
            bitmaskcopy >>>= 1;
            byteVal >>>= 1;
        }
        return byteVal;
    }

    public static Integer getEncodedValueSigned(byte[] bytes, String bitmaskAsString, boolean isReverse) {
        if (bytes.length > 4) {
            return null;
        }
        if (isReverse) {
            ProcessorHelper.reverse(bytes);
        }
        int value = 0;
        int leadingBitMask0 = bitmaskAsString.indexOf("1");
        int trailingBitMask0 = bitmaskAsString.length() - bitmaskAsString.lastIndexOf("1") - 1;
        value = ProcessorHelper.toInt(bytes);
        if ((leadingBitMask0 += 32 - bitmaskAsString.length()) > 0) {
            value <<= leadingBitMask0;
        }
        if (leadingBitMask0 + trailingBitMask0 > 0) {
            value >>= leadingBitMask0 + trailingBitMask0;
        }
        return new Integer(value);
    }

    public static Integer getEncodedValue(byte[] bytes, String bitmaskAsString, boolean isReverse) {
        int value;
        if (bytes.length > 4) {
            return null;
        }
        if (isReverse) {
            ProcessorHelper.reverse(bytes);
        }
        if (bitmaskAsString != null) {
            byte[] bitmaskArr = new BinaryCodec().toByteArray(bitmaskAsString);
            ProcessorHelper.reverse(bitmaskArr);
            if (bytes.length != bitmaskArr.length) {
                return null;
            }
            value = ProcessorHelper.toInt(bytes);
            int bitmaskResult = ProcessorHelper.toInt(bitmaskArr);
            value = ProcessorHelper.transformInt(value, bitmaskResult);
        } else {
            value = ProcessorHelper.toInt(bytes);
        }
        return new Integer(value);
    }

    private static void reverse(byte[] bytes) {
        byte buffer = 0;
        int upperBoundery = bytes.length - 1;
        int i = 0;
        while ((double)i < Math.floor(bytes.length / 2)) {
            buffer = bytes[i];
            bytes[i] = bytes[upperBoundery - i];
            bytes[upperBoundery - i] = buffer;
            ++i;
        }
    }

    private static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                result <<= 8;
            }
            result += bytes[i] & 0xFF;
        }
        return result;
    }

    public static String[] extractVariables(String formula) {
        ArrayList<String> buffer = new ArrayList<String>();
        Pattern p = Pattern.compile("([a-zA-Z]+\\s*\\(*)");
        Matcher m = p.matcher(formula);
        while (m.find()) {
            String variable = m.group();
            if (variable.indexOf(40) != -1) continue;
            buffer.add(variable.trim());
        }
        return buffer.toArray(new String[0]);
    }
}

