/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.analyze.BaseFieldProcessor;
import com.bmw.gki.ka.jaxp.keyformat.StrFieldType;
import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.ka.keydata.FieldTo;
import com.bmw.gki.ka.keydataimpl.FieldToImpl;
import com.bmw.gki.ka.util.BitCoderUtil;
import com.bmw.gki.logging.GKILogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFieldProcessor
extends BaseFieldProcessor {
    private static final Log LOG = GKILogManager.getInstance().getLogger(StringFieldProcessor.class);
    private static final String DEFAULT_VALIDATION_PATTERN = "[\\w\\d\\s?:;{}\\-,./]*";
    private StrFieldType strField;

    @Override
    protected void fillValueIntoComponent(FieldToImpl field, Object value, long length, byte[] byteValue) {
        if (value instanceof String) {
            String strValue = (String)value;
            char[] charArr = strValue.toCharArray();
            for (int i = 0; i < charArr.length; ++i) {
                if (charArr[i] >= ' ') continue;
                charArr[i] = 32;
            }
            value = new String(charArr);
        }
        super.fillValueIntoComponent(field, value, length, byteValue);
    }

    public StringFieldProcessor(StrFieldType newField) {
        super(newField);
        this.strField = newField;
    }

    @Override
    protected int determineFieldValueType() {
        return 2;
    }

    @Override
    protected Object getEncodedValue(byte[] bytes) {
        String value = null;
        if (this.strField.getFunctions() != null) {
            String expression = this.strField.getFunctions().getConcatTerm();
            if (expression != null) {
                LOG.debug((Object)("current expression for function concatTerm of string field: " + this.strField.getId() + " is: " + expression));
                String[] arguments = this.getArguments(expression);
                HashMap<String, String> argumentMap = new HashMap<String, String>();
                if (arguments != null && arguments.length > 0) {
                    for (int i = 0; i < arguments.length; ++i) {
                        FieldComponentTo comp = this.getParent().getTo(arguments[i]);
                        if (comp != null && comp instanceof FieldTo) {
                            FieldToImpl field = (FieldToImpl)comp;
                            if (field != null && field.getValue() != null) {
                                value = field.getValue().toString();
                                if (field.getType() == 0) {
                                    for (int j = 0; j < field.getByteValue().length; ++j) {
                                        LOG.debug((Object)(" byte[" + j + "] is: " + field.getByteValue()[j]));
                                    }
                                    char[] charArray = Hex.encodeHex((byte[])field.getByteValue());
                                    value = new String(charArray);
                                }
                            } else {
                                value = "";
                            }
                            LOG.debug((Object)(" id: " + field.getId() + " value: " + value + " length: " + field.getLength()));
                            argumentMap.put(arguments[i], value);
                            continue;
                        }
                        LOG.info((Object)"comp field is not a FieldTo - it will be ignored");
                    }
                    value = this.replaceArguments(expression, argumentMap);
                    try {
                        value = StringFieldProcessor.checkLpadFunction(value);
                    }
                    catch (Throwable t) {
                        LOG.debug((Object)"Exception in checkLpadFunction");
                    }
                    LOG.debug((Object)("Length of String is: " + value.length()));
                }
            }
            LOG.debug((Object)(" return value " + value));
            return value;
        }
        if (this.strField.isCoding6Bit()) {
            byte[] decodedBytes = BitCoderUtil.get6BitDecoded(bytes);
            value = new String(decodedBytes).toUpperCase();
        } else {
            value = new String(bytes);
        }
        return value;
    }

    @Override
    protected boolean isFieldValueValid(Object value) {
        String pattern = this.strField.getValidationPattern();
        if (pattern == null || pattern.trim().length() == 0) {
            pattern = DEFAULT_VALIDATION_PATTERN;
        }
        if (value != null) {
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher((String)value);
            return m.matches();
        }
        return false;
    }

    public static String checkLpadFunction(String value) {
        String lpadFuncString = "lpad(";
        if (value == null || value.length() <= 0) {
            return value;
        }
        if (value.indexOf(lpadFuncString) < 0) {
            return value;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        int length = value.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '(': {
                    int index;
                    if (i - 4 < 0 && !value.subSequence(i - 4, i).equals(lpadFuncString) || (index = value.indexOf(41, i)) == -1 || ++i >= length) continue block5;
                    String argument = value.substring(i, index);
                    if (argument == null || argument.length() == 0) {
                        LOG.debug((Object)"Argument is null or length == 0");
                        i = index;
                        continue block5;
                    }
                    arguments.add(argument);
                    i = index;
                }
            }
        }
        for (String element : arguments) {
            String newValue;
            String[] array = element.split(",");
            if (array == null || array.length != 3) continue;
            String replaceString = array[0];
            if (replaceString.length() <= 0) break;
            int lengthExpression = -1;
            try {
                lengthExpression = Integer.parseInt(array[1]);
            }
            catch (NumberFormatException e) {
                break;
            }
            String expr = array[2];
            if (expr.length() <= 0) break;
            while (expr.length() < lengthExpression) {
                expr = replaceString + expr;
            }
            String match = "lpad\\(" + array[0] + "," + array[1] + "," + array[2] + "\\)";
            value = newValue = value.replaceAll(match, expr);
        }
        return value;
    }

    private String replaceArguments(String expression, HashMap<String, String> keyValues) {
        LOG.debug((Object)("Expression is: " + expression));
        String value = expression;
        Set<String> keys = keyValues.keySet();
        for (String key : keys) {
            LOG.debug((Object)("Key is: " + key));
            if (keyValues.get(key) == null) continue;
            String valueRep = keyValues.get(key).toString();
            String keyRep = "\\{" + key + "\\}";
            value = value.replaceAll(keyRep, valueRep);
        }
        LOG.debug((Object)("Value is: " + value));
        return value;
    }

    private String[] getArguments(String expression) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (expression == null) {
            LOG.debug((Object)"No expression available");
            return null;
        }
        int length = expression.length();
        block3: for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            switch (c) {
                case '{': {
                    int index;
                    if (i + 1 < length && expression.charAt(i + 1) == '{' || (index = expression.indexOf(125, i)) == -1 || ++i >= length) continue block3;
                    String argument = expression.substring(i, index);
                    if (argument == null || argument.length() == 0) {
                        LOG.debug((Object)"Argument is null or length == 0");
                        i = index;
                        continue block3;
                    }
                    arguments.add(argument);
                    i = index;
                }
            }
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public static void main(String[] args) {
        try {
            String value = "PCClass:1 lpad(0,20,majorVersion):6 minVersion:7: patchVersion8";
            System.out.println(value);
            System.out.println("result: " + StringFieldProcessor.checkLpadFunction(value));
            value = "PCClass:1 lpad(0,20,majorVersion): lpad(6,minVersion)";
            System.out.println(value);
            System.out.println("result: " + StringFieldProcessor.checkLpadFunction(value));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    protected boolean isEditable() {
        String expression;
        boolean isEditable = true;
        if (this.strField.getFunctions() != null && (expression = this.strField.getFunctions().getConcatTerm()) != null) {
            LOG.debug((Object)("current expression for function concatTerm of string field: " + this.strField.getId() + " is: " + expression));
            isEditable = false;
        }
        return isEditable;
    }

    @Override
    protected byte[] modifyBytes(String stringValue, byte[] originBytes) {
        byte[] newBytes = null;
        if (this.strField.isCoding6Bit()) {
            stringValue = stringValue.toLowerCase();
            newBytes = BitCoderUtil.set6BitEncoded(stringValue, originBytes);
        } else {
            newBytes = stringValue.getBytes();
        }
        return newBytes;
    }
}

