/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util;

public class BitCoderUtil {
    private static final int BYTE1_BIT_MASK = 255;
    private static final int BYTE2_BIT_MASK = 65280;
    private static final int BYTE3_BIT_MASK = 0xFF0000;

    public static byte[] set6BitEncoded(String stringValue, byte[] originBytes) {
        byte[] resultByte = null;
        if (originBytes.length * 8 >= stringValue.length() * 6) {
            char[] inChars = stringValue.toCharArray();
            int byte3BitMask = 0xFF0000;
            int byte2BitMask = 65280;
            int byte1BitMask = 255;
            int letterCounter = 0;
            int letterStore = 0;
            resultByte = new byte[originBytes.length];
            int resultBytePos = 0;
            int MAXLETTERS = 4;
            char firstLetter = inChars[0];
            int firstLetterInt = Character.digit(firstLetter, 36);
            resultByte[resultBytePos] = (byte)firstLetterInt;
            ++resultBytePos;
            for (int i = 1; i < inChars.length; ++i) {
                char aLetter = inChars[i];
                int aLetterInt = Character.digit(aLetter, 36);
                BitCoderUtil.print(" char pos=" + i + " letter Counter=" + ++letterCounter + " aLetterInt = " + aLetterInt);
                if (letterCounter < MAXLETTERS) {
                    int shiftFacotr = MAXLETTERS - letterCounter;
                    BitCoderUtil.print(" shiftFactor = " + shiftFacotr);
                    int aLetterIntShifted = aLetterInt << shiftFacotr * 6;
                    BitCoderUtil.print(" letterStore |  aLetterIntShifted = " + Integer.toBinaryString(letterStore |= aLetterIntShifted));
                } else {
                    BitCoderUtil.print(" kein shift ");
                    BitCoderUtil.print(" aLetterInt = " + Integer.toBinaryString(aLetterInt));
                    BitCoderUtil.print("letterStore |  aLetterInt= " + Integer.toBinaryString(letterStore |= aLetterInt));
                }
                if (letterCounter != MAXLETTERS) continue;
                int one = (letterStore & byte3BitMask) >> 16;
                resultByte[resultBytePos] = (byte)one;
                BitCoderUtil.print(" resultByte[byteCounter]= " + resultBytePos + " content =" + Integer.toBinaryString(one));
                int two = (letterStore & byte2BitMask) >> 8;
                BitCoderUtil.print(" resultByte[byteCounter]= " + ++resultBytePos + " content =" + Integer.toBinaryString(two));
                resultByte[resultBytePos] = (byte)two;
                int three = letterStore & byte1BitMask;
                BitCoderUtil.print(" resultByte[byteCounter]= " + ++resultBytePos + " content =" + Integer.toBinaryString(three));
                resultByte[resultBytePos] = (byte)three;
                ++resultBytePos;
                letterStore = 0;
                letterCounter = 0;
            }
            if (letterStore != 0) {
                if (resultBytePos < resultByte.length) {
                    int one = letterStore & byte1BitMask;
                    resultByte[resultBytePos] = (byte)one;
                    BitCoderUtil.print(" resultByte[byteCounter]= " + resultBytePos + " content =" + Integer.toBinaryString(one));
                    ++resultBytePos;
                }
                if (resultBytePos >= resultByte.length) {
                    int two = (letterStore & byte2BitMask) >> 8;
                    BitCoderUtil.print(" resultByte[byteCounter]= " + resultBytePos + " content =" + Integer.toBinaryString(two));
                    resultByte[resultBytePos] = (byte)two;
                    ++resultBytePos;
                }
                if (resultBytePos >= resultByte.length) {
                    int three = (letterStore & byte3BitMask) >> 16;
                    BitCoderUtil.print(" resultByte[byteCounter]= " + resultBytePos + " content =" + Integer.toBinaryString(three));
                    resultByte[resultBytePos] = (byte)three;
                    ++resultBytePos;
                }
            }
        } else {
            resultByte = originBytes;
        }
        return resultByte;
    }

    public static byte[] get6BitDecoded(byte[] theBytes) {
        byte[] bytes = (byte[])theBytes.clone();
        int resultLength = (bytes.length - 1) / 3 * 4 + 1;
        byte[] result = new byte[resultLength];
        for (int i = 0; i < result.length; ++i) {
            result[i] = BitCoderUtil.get6BitDecoded(bytes, i);
        }
        return result;
    }

    private static byte get6BitDecoded(byte[] data, int index) {
        byte result = 0;
        int iMod4 = index % 4;
        int iDiv4 = index / 4;
        if (iMod4 == 0) {
            result = (byte)(data[0 + 3 * iDiv4] & 0x3F);
        } else if (iMod4 == 1) {
            result = (byte)((data[1 + 3 * iDiv4] & 0xFC) >>> 2);
        } else if (iMod4 == 2) {
            result = (byte)((data[1 + 3 * iDiv4] & 3) << 4 | (data[2 + 3 * iDiv4] & 0xF0) >>> 4);
        } else if (iMod4 == 3) {
            result = (byte)((data[2 + 3 * iDiv4] & 0xF) << 2 | (data[3 + 3 * iDiv4] & 0xC0) >>> 6);
        }
        return (byte)Character.forDigit(result, 36);
    }

    public static void print(String toPrint) {
        System.out.println(toPrint);
    }
}

