/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util;

import com.bmw.gki.logging.GKILogManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache
implements Serializable {
    private static final long serialVersionUID = 10L;
    private String name;
    private HashMap<Object, Object> cache = new HashMap(89);
    private static final Log LOG = GKILogManager.getInstance().getLogger(Cache.class);

    public Cache(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
        LOG.info((Object)("resetting cache " + this.name));
        this.cache = new HashMap(89);
    }

    public void put(Object key, Object value) {
        LOG.debug((Object)("put to cache for key/value " + key + "/" + value));
        this.cache.put(key, value);
    }

    public Object get(Object key) {
        LOG.debug((Object)("get from cache for key " + key));
        Object retVal = this.cache.get(key);
        return retVal;
    }

    public void remove(Object key) {
        this.cache.remove(key);
    }

    public List<Object> getCollection(String searchKey, Comparator<Object> comparator) {
        List<Object> result = this.getCollection(searchKey);
        Collections.sort(result, comparator);
        return result;
    }

    public List<Object> getCollection(String searchKey) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<Object> it = this.cache.keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            if (!key.startsWith(searchKey)) continue;
            Object value = this.cache.get(key);
            result.add(value);
        }
        return result;
    }
}

