/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util;

import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdValue;
import com.bmw.gki.logging.GKILogManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreProdHolder {
    private static final Log log = GKILogManager.getInstance().getLogger(PreProdHolder.class);
    private static ThreadLocal<PreProdValue> preProdValues = new ThreadLocal<PreProdValue>(){

        @Override
        protected PreProdValue initialValue() {
            return new PreProdValue();
        }
    };

    private PreProdHolder() {
    }

    private static void setPreProdValues(PreProdValue value) {
        preProdValues.set(value);
    }

    private static PreProdValue getPreProdValues() {
        return preProdValues.get();
    }

    public static void reset() {
        log.debug((Object)"***PreProdHolder RESET***");
        PreProdHolder.setPreProdValues(new PreProdValue());
    }

    public static void addLogEntry(PreProdLogEntry entry) {
        PreProdHolder.getPreProdValues().addLogEntry(entry);
    }

    public static void setBinFile(byte[] binFile) {
        log.trace((Object)"PRE:PROD:HOLDER ADD BINFILE");
        PreProdHolder.getPreProdValues().setBinFile(binFile);
    }

    public static void setIsPreProd(boolean isPre) {
        log.info((Object)("PreProdHolder isPre " + isPre));
        PreProdValue.IS_PRE_PROD = isPre;
    }

    public static boolean getIsPreProd() {
        return PreProdValue.IS_PRE_PROD;
    }

    public static List<PreProdLogEntry> getLogEntries() {
        return PreProdHolder.getPreProdValues().getLogEntries();
    }

    public static byte[] getBinFile() {
        return PreProdHolder.getPreProdValues().getBinFile();
    }

    public static List<String> getAllFormattedLogEntries() {
        ArrayList<String> formattetLogList = new ArrayList<String>();
        List<PreProdLogEntry> logEnt = PreProdHolder.getPreProdValues().getLogEntries();
        if (logEnt != null && logEnt.size() > 0) {
            for (int i = 0; i < logEnt.size(); ++i) {
                PreProdLogEntry entry = logEnt.get(i);
                formattetLogList.add(entry.getFormattedLogEntry());
            }
        }
        return formattetLogList;
    }

    public static void setHasMakeArchive(boolean b) {
        PreProdHolder.getPreProdValues().setHasMakeArchiv(b);
    }

    public static boolean getHasMakeArchiv() {
        return PreProdHolder.getPreProdValues().getHasMakeArchiv();
    }
}

