/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util;

import com.bmw.gki.logging.GKILogManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;

public class PreProdLogMessages {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final String BUNDLE_NAME = "PreProductionLogMessages";
    protected final Log logger = GKILogManager.getInstance().getLogger(this.getClass());
    private final HashMap<Locale, ResourceBundle> bundles = new HashMap();
    private static PreProdLogMessages instance;

    private PreProdLogMessages() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("PreProductionLogMessages", DEFAULT_LOCALE);
        this.bundles.put(DEFAULT_LOCALE, resourceBundle);
    }

    public static String getString(String key) {
        Locale locale = DEFAULT_LOCALE;
        return PreProdLogMessages.getInstance().getStringLocalized(key, locale);
    }

    public static String getParameterString(String key, Object[] bindings) {
        Locale locale = DEFAULT_LOCALE;
        String value = PreProdLogMessages.getInstance().getStringLocalized(key, locale);
        return PreProdLogMessages.bind(value, bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PreProdLogMessages getInstance() {
        Class<PreProdLogMessages> clazz = PreProdLogMessages.class;
        synchronized (PreProdLogMessages.class) {
            if (instance == null) {
                instance = new PreProdLogMessages();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private String getStringLocalized(String key, Locale locale) {
        try {
            ResourceBundle resourceBundle = this.bundles.get(locale);
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle("PreProductionLogMessages", locale);
            }
            if (resourceBundle == null) {
                this.logger.error((Object)("Bundle for Locale [" + locale + "] not found"));
                assert (false) : "Bundle for Locale [" + locale + "] not found";
                return '!' + key + '!';
            }
            this.bundles.put(locale, resourceBundle);
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.logger.error((Object)("Key[" + key + "] not found for locale [" + locale + "]"));
            assert (false) : "Key[" + key + "] not found for locale [" + locale + "]";
            return null;
        }
    }

    private static String bind(String message, Object[] bindings) {
        return PreProdLogMessages.internalBind(message, bindings, null, null);
    }

    private static String internalBind(String message, Object[] args, String argZero, String argOne) {
        if (message == null) {
            return "No message available.";
        }
        if (args == null || args.length == 0) {
            args = new Object[]{};
        }
        int length = message.length();
        int bufLen = length + args.length * 5;
        if (argZero != null) {
            bufLen += argZero.length() - 3;
        }
        if (argOne != null) {
            bufLen += argOne.length() - 3;
        }
        StringBuffer buffer = new StringBuffer(bufLen);
        block6: for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            switch (c) {
                case '{': {
                    int index = message.indexOf(125, i);
                    if (index == -1) {
                        buffer.append(c);
                        continue block6;
                    }
                    if (++i >= length) {
                        buffer.append(c);
                        continue block6;
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(message.substring(i, index));
                    }
                    catch (NumberFormatException _ex) {
                        throw new IllegalArgumentException();
                    }
                    if (number == 0 && argZero != null) {
                        buffer.append(argZero);
                    } else if (number == 1 && argOne != null) {
                        buffer.append(argOne);
                    } else {
                        if (number >= args.length || number < 0) {
                            buffer.append("<missing argument>");
                            i = index;
                            continue block6;
                        }
                        buffer.append(args[number]);
                    }
                    i = index;
                    continue block6;
                }
                case '\'': {
                    int nextIndex = i + 1;
                    if (nextIndex >= length) {
                        buffer.append(c);
                        continue block6;
                    }
                    char next = message.charAt(nextIndex);
                    if (next == '\'') {
                        ++i;
                        buffer.append(c);
                        continue block6;
                    }
                    int index2 = message.indexOf(39, nextIndex);
                    if (index2 == -1) {
                        buffer.append(c);
                        continue block6;
                    }
                    buffer.append(message.substring(nextIndex, index2));
                    i = index2;
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

