/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka;

import com.bmw.gki.ka.KeyAnalyzer;
import com.bmw.gki.ka.TechnicalException;
import com.bmw.gki.logging.GKILogManager;
import org.apache.commons.logging.Log;

public class KeyAnalyzerFactory {
    private static final KeyAnalyzerFactory INSTANCE = new KeyAnalyzerFactory();
    private static final Log LOG = GKILogManager.getInstance().getLogger(KeyAnalyzerFactory.class);
    private static String theClassName = null;

    private KeyAnalyzerFactory() {
    }

    public static KeyAnalyzerFactory getInstance() {
        return INSTANCE;
    }

    public static synchronized void init(String className) {
        theClassName = className;
    }

    public KeyAnalyzer getKeyAnalyzer() {
        if (theClassName == null) {
            KeyAnalyzerFactory.init("com.bmw.gki.ka.KeyAnalyzerImpl");
        }
        Object o = null;
        KeyAnalyzer analyzer = null;
        try {
            Class<?> clazz = Class.forName(theClassName);
            o = clazz.newInstance();
            analyzer = o;
        }
        catch (ClassNotFoundException e) {
            LOG.fatal((Object)"class not found: com.bmw.gki.kas.KeyAnalyzerImpl", (Throwable)e);
            throw new TechnicalException("can not create KeyAnalyzerImpl", e);
        }
        catch (InstantiationException e) {
            LOG.fatal((Object)"can not instantiate key analyzer", (Throwable)e);
            throw new TechnicalException("can not create KeyAnalyzerImpl", e);
        }
        catch (IllegalAccessException e) {
            LOG.fatal((Object)"illegal access on KeyAnalyzer", (Throwable)e);
            throw new TechnicalException("can not create KeyAnalyzerImpl", e);
        }
        catch (ClassCastException e) {
            LOG.fatal((Object)"illegal access on KeyAnalyzer", (Throwable)e);
            throw new TechnicalException("can not create KeyAnalyzerImpl", e);
        }
        return analyzer;
    }
}

