/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.exception;

import com.bmw.gki.ka.exception.GKIExceptionIF;
import com.bmw.gki.klib.api.exception.ErrorCategory;
import com.bmw.gki.klib.api.exception.ExceptionHelper;
import com.bmw.gki.klib.api.exception.LocaleHolder;
import com.bmw.gki.logging.GKILogManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class GKIException
extends Exception
implements GKIExceptionIF {
    private static final long serialVersionUID = 1L;
    protected Log logger = GKILogManager.getInstance().getLogger(this.getClass());
    private List<String> params = new ArrayList<String>();

    public GKIException() {
        this((String)null);
    }

    public GKIException(String message) {
        this(message, (Throwable)null);
    }

    public GKIException(String message, Throwable cause) {
        this(message, cause, null);
    }

    public GKIException(String message, String[] parameters) {
        this(message, null, parameters);
    }

    public GKIException(String message, Throwable cause, String[] parameters) {
        super(message, cause);
        this.init(parameters);
    }

    @Override
    public void addParam(String param) {
        this.params.add(param);
    }

    private void init(String[] parameters) {
        this.handleParams(parameters);
        this.logException();
    }

    private void handleParams(String[] parameters) {
        if (parameters != null && parameters.length > 0) {
            this.params.addAll(Arrays.asList(parameters));
        }
    }

    protected void logException() {
        this.getErrorCategory().log(this.formatedLogStr());
        if (this.logger.isDebugEnabled()) {
            String stacktrace = new ExceptionHelper().formattrace(this);
            this.logger.debug((Object)stacktrace);
        }
    }

    private String formatedLogStr() {
        return this.getErrorCategory().getName() + ": " + this.getErrorCode() + ": " + this.getMessage();
    }

    @Override
    public List<String> getParameters() {
        return this.params;
    }

    @Override
    public ErrorCategory getErrorCategory() {
        return FATAL;
    }

    @Override
    public String getErrorCode() {
        return "gki.GKIException";
    }

    @Override
    public String getFormatedMessage() {
        return new ExceptionHelper().getDescription(this);
    }

    @Override
    public String getLocalizedMessage() {
        Locale locale = LocaleHolder.getLocale();
        return new ExceptionHelper().getDescription(this, locale);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[GKIException:");
        buffer.append("cause: ");
        buffer.append(this.getCause());
        buffer.append(" params: ");
        if (this.params != null) {
            buffer.append("-");
            Iterator<String> it = this.params.iterator();
            while (it.hasNext()) {
                buffer.append(it.next());
                buffer.append("-");
            }
        }
        buffer.append("]");
        return buffer.toString();
    }
}

