/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.exception;

import com.bmw.gki.klib.common.LanguageSelection;
import com.bmw.gki.klib.util.ResourceLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages
extends ResourceLoader {
    private final String BUNDLE_NAME = "ExceptionMessages";
    private static Messages instance;

    private Messages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Messages getInstance() {
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            if (instance == null) {
                instance = new Messages();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getString(String key) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        return this.getString(key, locale);
    }

    public String getString(String key, Locale locale) throws MissingResourceException {
        return this.getStringLocalized(key, locale);
    }

    private String getStringLocalized(String key, Locale locale) throws MissingResourceException {
        try {
            ResourceBundle bundle = this.getResourceBundle("ExceptionMessages", locale);
            if (bundle == null) {
                Locale validLocale = LanguageSelection.getInstance().getValidLocale(new Locale(locale.getLanguage()));
                bundle = this.getResourceBundle("ExceptionMessages", validLocale);
            }
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.logger.error((Object)("Key[" + key + "] not found for locale [" + locale + "]"));
            assert (false) : "Key[" + key + "] not found for locale [" + locale + "]";
            throw new MissingResourceException(e.getMessage(), e.getClassName(), key);
        }
    }

    public void readInExceptionMessagesFromKSD(String path, Locale[] supportedLocales) {
        this.loadResourceBundlesFromKSD("ExceptionMessages", path, supportedLocales);
    }

    public static void reset() {
        instance = null;
    }
}

