/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util.resource;

import com.bmw.gki.ka.util.resource.ResourcesChecker;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class ResourceBundleLanguageChecker {
    private static final Locale defaultLocale = Locale.GERMAN;

    public static void main(String[] args) throws Exception {
        File resourceDir = new File("D:\\Projects\\GKI\\workspace\\gki\\resource");
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("gki_translator");
        resources.add("ExceptionMessages");
        for (String resource : resources) {
            ResourceBundleLanguageChecker.checkResourceLocales(resourceDir, resource);
        }
    }

    private static void checkResourceLocales(File resourceDir, String bundleName) throws Exception {
        List<ResourceBundleFile> resourceFiles = ResourceBundleLanguageChecker.getAllResourceFiles(resourceDir, bundleName);
        ResourceBundleFile defaultRbFile = ResourceBundleLanguageChecker.getDefaultResourceFile(resourceDir, bundleName);
        ArrayList<Object> keys = new ArrayList<Object>(ResourceBundleLanguageChecker.getAllResourceKeys(resourceFiles));
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return String.valueOf(o1).toLowerCase().compareTo(String.valueOf(o2).toLowerCase());
            }
        });
        for (ResourceBundleFile rbFile : resourceFiles) {
            ArrayList<String> keysToDelete = new ArrayList<String>();
            ArrayList<String> missingKeys = new ArrayList<String>();
            for (String string : keys) {
                if (string.startsWith("#")) {
                    keysToDelete.add(string);
                    continue;
                }
                String resource = rbFile.getString(string);
                if (resource == null) {
                    missingKeys.add(string);
                    continue;
                }
                if (!"".equals(resource = resource.trim())) continue;
                keysToDelete.add(string);
            }
            ResourceBundleLanguageChecker.handleMissingKeys(missingKeys, rbFile, defaultRbFile);
            ResourceBundleLanguageChecker.handleKeysToDelete(keysToDelete, rbFile);
            rbFile.save();
        }
    }

    private static void handleMissingKeys(List<String> keysToAdd, ResourceBundleFile rbFile, ResourceBundleFile defaultRbFile) {
        for (String key : keysToAdd) {
            rbFile.addMissingKey(key, defaultRbFile != null ? defaultRbFile.getString(key) : null);
            System.out.println(rbFile.getFile().getName() + " - '" + key + "' is missing");
        }
    }

    private static void handleKeysToDelete(List<String> keysToDelete, ResourceBundleFile rbFile) {
        for (String key : keysToDelete) {
            rbFile.removeKey(key);
            System.out.println(rbFile.getFile().getName() + " - '" + key + "' will be deleted");
        }
    }

    private static Set<Object> getAllResourceKeys(List<ResourceBundleFile> resourceBundles) {
        HashSet<Object> resourceKeys = new HashSet<Object>();
        for (ResourceBundleFile rbFile : resourceBundles) {
            resourceKeys.addAll(rbFile.getKeys());
        }
        return resourceKeys;
    }

    private static List<ResourceBundleFile> getAllResourceFiles(File resourceDir, String bundleName) throws Exception {
        File[] files = resourceDir.listFiles(new ResourcesChecker.ResourceFileNameFilter(bundleName));
        ArrayList<ResourceBundleFile> resourceBundles = new ArrayList<ResourceBundleFile>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            resourceBundles.add(new ResourceBundleFile(bundleName, file));
        }
        return resourceBundles;
    }

    private static ResourceBundleFile getDefaultResourceFile(File resourceDir, String bundleName) throws Exception {
        File file = new File(resourceDir, bundleName + "_" + defaultLocale.getLanguage() + ".properties");
        if (file.exists()) {
            return new ResourceBundleFile(bundleName, file);
        }
        return null;
    }

    private static class ResourceBundleFile {
        private ResourceBundle bundle;
        private String bundleName;
        private ResourcesChecker.SortedProperties props;
        private ResourcesChecker.SortedProperties propsMissing;
        private Locale locale;

        public ResourceBundleFile(String bundleName, File file) throws Exception {
            this.bundleName = bundleName;
            this.init(file);
        }

        public void addMissingKey(String key, String value) {
            if (value == null) {
                value = "";
            }
            this.propsMissing.put(key, value);
        }

        public String getString(String key) {
            try {
                return this.bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }

        public Object removeKey(String key) {
            return this.props.remove(key);
        }

        public Collection<Object> getKeys() {
            ArrayList<Object> keys = new ArrayList<Object>();
            Enumeration<String> e = this.bundle.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            return keys;
        }

        private void init(File file) throws Exception {
            this.props = new ResourcesChecker.SortedProperties(file);
            this.props.load();
            this.propsMissing = new ResourcesChecker.SortedProperties(new File(new File(file.getParentFile(), "todo"), file.getName()));
            this.locale = this.getLocaleFromFileName();
            this.bundle = this.getResourceBundle(file);
        }

        private ResourceBundle getResourceBundle(File file) {
            Locale loc = this.locale;
            if (loc == null) {
                loc = Locale.getDefault();
            }
            try {
                URLClassLoader classLoader = new URLClassLoader(new URL[]{file.getParentFile().toURI().toURL()}, null){

                    @Override
                    public URL getResource(String name) {
                        if (!name.matches(".*_[a-z]{2}(_[A-Z]{2})?\\.properties")) {
                            return null;
                        }
                        return super.getResource(name);
                    }
                };
                return ResourceBundle.getBundle(this.bundleName, loc, classLoader);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return ResourceBundle.getBundle(this.bundleName, loc);
            }
        }

        private Locale getLocaleFromFileName() {
            String fileName = this.props.getFile().getName();
            String localeString = fileName.substring(this.bundleName.length(), fileName.length() - ".properties".length());
            if (localeString.startsWith("_")) {
                String language = "";
                String country = "";
                String variant = "";
                StringTokenizer st = new StringTokenizer(localeString, "_");
                if (st.hasMoreTokens()) {
                    language = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    country = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    variant = st.nextToken();
                }
                return new Locale(language, country, variant);
            }
            return null;
        }

        public void save() throws Exception {
            this.props.save();
            this.propsMissing.save();
        }

        public File getFile() {
            return this.props.getFile();
        }
    }
}

