/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.KeyDataBinIF;
import com.bmw.gki.klib.api.SAProviderXMLIF;
import com.bmw.gki.klib.api.SIHandler;
import com.bmw.gki.klib.api.SIProviderXMLIF;
import com.bmw.gki.klib.api.exception.AlternateKeyException;
import com.bmw.gki.klib.api.exception.AnalyserException;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.NoVehicleSSIException;
import com.bmw.gki.klib.api.exception.NotSupportedKeyvariantException;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.api.exception.VINInvalidCharacterException;
import com.bmw.gki.klib.api.exception.WrongVinFormatException;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api.multiform.MultiFormAnalyseResponse;
import com.bmw.gki.klib.api.multiform.MultiFormInterpretResponse;
import com.bmw.gki.klib.api.multiform.MultiFormInterpretSIResponse;
import com.bmw.gki.klib.api.multiform.MultiFormResponse;
import com.bmw.gki.klib.api.multiform.MultiFormRetrieveVINResponse;
import com.bmw.gki.klib.api.multiform.MultiFormUpdateOBResponse;
import com.bmw.gki.klib.api_current.AnalyseKey;
import com.bmw.gki.klib.api_current.GallonType;
import com.bmw.gki.klib.api_current.InterpretKey;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.api_current.KeyDataBinType;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.RetrieveVin;
import com.bmw.gki.klib.api_current.UpdateOrderbase;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.OrderbaseUpdateData;
import com.bmw.gki.klib.data.apitransformation.RequestMapper;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.data.ksd.key.FgnrPraefix;
import com.bmw.gki.klib.data.orderbase.ServicePackageHolder;
import com.bmw.gki.klib.data.xml.AnalyseKeyDataResponseTransformer;
import com.bmw.gki.klib.data.xml.AnalyseKeyDataToTypedTransformer;
import com.bmw.gki.klib.data.xml.InterpretKeyDataResponseToXMLTransformer;
import com.bmw.gki.klib.data.xml.InterpretKeyDataToTypedTransformer;
import com.bmw.gki.klib.data.xml.OptionalEquipmentRequestToXMLTransformer;
import com.bmw.gki.klib.data.xml.OptionalEquipmentResponseTransformer;
import com.bmw.gki.klib.data.xml.RetrieveVinResponseTransformer;
import com.bmw.gki.klib.data.xml.RetrieveVinToTypedTransformer;
import com.bmw.gki.klib.data.xml.SchemaVersionRetriever;
import com.bmw.gki.klib.data.xml.ServicePackageBaseRequestToXMLTransformer;
import com.bmw.gki.klib.data.xml.ServicePackageBaseResponseTransformer;
import com.bmw.gki.klib.data.xml.UpdateOrderbaseRequestDataTransformer;
import com.bmw.gki.klib.data.xml.UpdateOrderbaseResponseToXMLTransformer;
import com.bmw.gki.klib.data.xml.XMLMapper;
import com.bmw.gki.klib.external.KSDDataRetrieverFactory;
import com.bmw.gki.klib.external.KSDDataRetrieverIF;
import com.bmw.gki.klib.external.cache.FgnrPraefixReader;
import com.bmw.gki.klib.external.cache.SSIInformationReader;
import com.bmw.gki.klib.logic.GKILogic;
import com.bmw.gki.klib.logic.KeyAnalyserLogic;
import com.bmw.gki.klib.logic.ServicePackageLogic;
import com.bmw.gki.klib.sa_V01_00_00.TypeError;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.ThreadLocalAttributes;
import com.bmw.gki.logging.GKILogManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class KeyInterpreterXML
extends SIHandler {
    private final Log log = GKILogManager.getInstance().getLogger(KeyInterpreterXML.class);

    protected KeyDataAnalysedType analyseBeforeInterpret(KeyDataBinType type, Locale locale) throws KSDAccessException, AnalyserException, WrongVinFormatException, SystemException {
        this.checkKSD();
        KeyDataBinIF key = this.toKeyDataBinIF(type);
        KeyDataAnalysedType keyData = new KeyAnalyserLogic().analyseKey(key, locale);
        return keyData;
    }

    private boolean isUSGallon(InterpretKey key) {
        GallonType gallonType;
        return key.isSetSetGallon() && "US_Gallon".equals((gallonType = key.getSetGallon()).getTypeDefinition());
    }

    private boolean isUKGallon(InterpretKey key) {
        GallonType gallonType;
        return key.isSetSetGallon() && "UK_Gallon".equals((gallonType = key.getSetGallon()).getTypeDefinition());
    }

    private void checkAlternateKey(KeyDataAnalysedType keyData) throws AlternateKeyException {
        int MAX_TOTAL_DISTANCE = 0xFFFFFF;
        int MAX_TANK_LEVEL = 255;
        int MAX_COOLANT_TEMP = 207;
        int MAX_AIR_TEMP = -6;
        int MAX_SHORT_TIME_DP = 2550;
        if (keyData != null && keyData.getVehicle() != null && keyData.getVehicle().getStateInformation() != null && keyData.getVehicle().getStateInformation().getMiscAttributes() != null && keyData.getCbsBaseData() != null && keyData.getVehicle().getStateInformation().getTotalDistance() >= 1.6777215E7f) {
            double d = keyData.getVehicle().getStateInformation().getMiscAttributes().isSetTankLevel() ? keyData.getVehicle().getStateInformation().getMiscAttributes().getTankLevel() : 0.0;
            if (d >= 255.0) {
                double d2 = keyData.getVehicle().getStateInformation().getMiscAttributes().isSetCoolantTemperature() ? keyData.getVehicle().getStateInformation().getMiscAttributes().getCoolantTemperature() : 0.0;
                if (d2 >= 207.0) {
                    double d3 = keyData.getVehicle().getStateInformation().getMiscAttributes().isSetAirTemperature() ? keyData.getVehicle().getStateInformation().getMiscAttributes().getAirTemperature() : 0.0;
                    if (d3 >= -6.0 && (keyData.getCbsBaseData().isSetShortTimeDrivingPerformance() ? keyData.getCbsBaseData().getShortTimeDrivingPerformance() : 0) >= 2550) {
                        throw new AlternateKeyException("Alternate key - see checked values (total distance, tankLevel, coolantTemp, airTemp, shortTimeDrivingPerf.!");
                    }
                }
            }
        }
    }

    private void checkVINInvalidChar(KeyDataAnalysedType keyData) throws VINInvalidCharacterException {
        if (keyData != null && keyData.getVehicle() != null) {
            this.checkVINInvalidChar(keyData.getVehicle().getVin());
        }
    }

    private void checkVINInvalidChar(String vin) throws VINInvalidCharacterException {
        if (vin != null && vin.indexOf(32) > 0) {
            throw new VINInvalidCharacterException("vin contains invalid character");
        }
    }

    private String getShortVin(String vin) {
        if (vin != null && vin.length() >= 17) {
            return vin.substring(10, vin.length());
        }
        if (vin.length() >= 7) {
            return vin;
        }
        return null;
    }

    private String getVinPrefix(String vin) {
        if (vin != null && vin.length() >= 17) {
            return vin.substring(0, 10);
        }
        return null;
    }

    private KeyDataBinIF toKeyDataBinIF(KeyDataBinType type) {
        RequestMapper mapper = new RequestMapper();
        return mapper.v_current(type);
    }

    private String retrieveVersion(String xml) {
        return new SchemaVersionRetriever().getVersion(xml);
    }

    public String analyseKeyData(String requestXML) throws KSDAccessException, AnalyserException, SystemException {
        MultiFormAnalyseResponse resp = this.analyseMultiForm(requestXML);
        return this.analyseMultiForm(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFormAnalyseResponse analyseMultiForm(String requestXML) throws KSDAccessException, AnalyserException, SystemException {
        ThreadLocalAttributes.setFieldValidCheckInThread(false);
        this.log.info((Object)"---------- Analyzing Key ----------");
        ArrayList<GKIException> exceptions = new ArrayList<GKIException>();
        AnalyseKeyDataToTypedTransformer transformer = new AnalyseKeyDataToTypedTransformer();
        AnalyseKey key = transformer.transformToCurrentTyped(requestXML);
        KeyDataBinType keyData = key.getKeyData();
        assert (keyData != null) : "key data can not be null";
        GKISettings settings = new GKISettings(key.getLanguage(), false);
        KeyDataAnalysedType analysedKey = null;
        try {
            KeyAnalyserLogic.initPreProd(keyData.getContent());
            try {
                analysedKey = this.analyseBeforeInterpret(keyData, settings.getLocale());
                this.checkVINInvalidChar(analysedKey);
                this.checkAlternateKey(analysedKey);
            }
            catch (VINInvalidCharacterException e) {
                exceptions.add(e);
            }
            catch (AlternateKeyException e) {
                exceptions.add(e);
            }
            catch (NotSupportedKeyvariantException e) {
                exceptions.add(e);
            }
            catch (WrongVinFormatException e) {
                exceptions.add(e);
            }
        }
        finally {
            KeyAnalyserLogic.releasePreProd();
        }
        String version = this.retrieveVersion(requestXML);
        AnalyseKeyDataResponseTransformer toXMLTransformer = new AnalyseKeyDataResponseTransformer(version);
        String responseXml = toXMLTransformer.getXML(version, analysedKey, exceptions);
        MultiFormAnalyseResponse response = new MultiFormAnalyseResponse();
        response.setVersion(version);
        response.setXml(responseXml);
        return response;
    }

    public String analyseMultiForm(MultiFormAnalyseResponse multiForm) throws SystemException {
        return this.transformXML(multiForm);
    }

    private String transformXML(MultiFormResponse multiForm) throws XMLBearbeitungsException {
        String srcXml = multiForm.getXml();
        String srcVersion = this.retrieveVersion(srcXml);
        String dstVersion = multiForm.getVersion();
        XMLMapper xmlMapper = new XMLMapper(srcVersion);
        String response = null;
        try {
            response = xmlMapper.mapToXmlVersion(dstVersion, srcVersion, srcXml);
        }
        catch (InstantiationException e) {
            String message = "transformXML - InstantiationException";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            this.log.error((Object)("exception code: " + be.getErrorCode() + " message: " + e.getMessage()));
            throw be;
        }
        catch (ClassNotFoundException e) {
            String message = "transformXML - ClassNotFoundException";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            this.log.error((Object)("exception code: " + be.getErrorCode() + " message: " + e.getMessage()));
            throw be;
        }
        catch (NoSuchMethodException e) {
            String message = "transformXML - NoSuchMethodException";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            this.log.error((Object)("exception code: " + be.getErrorCode() + " message: " + e.getMessage()));
            throw be;
        }
        catch (IllegalAccessException e) {
            String message = "transformXML - IllegalAccessException";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            this.log.error((Object)("exception code: " + be.getErrorCode() + " message: " + e.getMessage()));
            throw be;
        }
        catch (InvocationTargetException e) {
            String message = "transformXML - InvocationTargetException";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            this.log.error((Object)("exception code: " + be.getErrorCode() + " message: " + e.getMessage()));
            throw be;
        }
        return response;
    }

    public String interpretKeyDataWithSI(String requestXML, SIProviderXMLIF si) throws AnalyserException, KSDAccessException, SystemException {
        return this.interpretKeyDataWithSI(requestXML, si, null);
    }

    public String interpretKeyDataWithSI(String requestXML, SIProviderXMLIF si, String country) throws AnalyserException, KSDAccessException, SystemException {
        MultiFormInterpretSIResponse resp = this.interpretKeyDataWithSIMultiForm(requestXML, si, country);
        return this.interpretKeyDataWithSIMultiForm(resp);
    }

    public String interpretKeyDataWithSIMultiForm(MultiFormInterpretSIResponse multiForm) throws SystemException {
        return this.transformXML(multiForm);
    }

    public MultiFormInterpretSIResponse interpretKeyDataWithSIMultiForm(String requestXML, SIProviderXMLIF si) throws AnalyserException, KSDAccessException, SystemException {
        return this.interpretKeyDataWithSIMultiForm(requestXML, si, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFormInterpretSIResponse interpretKeyDataWithSIMultiForm(String requestXML, SIProviderXMLIF si, String country) throws AnalyserException, KSDAccessException, SystemException {
        ThreadLocalAttributes.setFieldValidCheckInThread(true);
        this.log.info((Object)"---------- Interpreting Key with SI ----------");
        InterpretKeyDataToTypedTransformer transformer = new InterpretKeyDataToTypedTransformer();
        InterpretKey key = transformer.transformToCurrentTyped(requestXML);
        KeyDataBinType keyData = key.getKeydata();
        assert (keyData != null) : "key data can not be null";
        GKISettings settings = new GKISettings(key.getLocale(), key.isIsMiles(), key.isSetSetFahrenheit(), this.isUSGallon(key), this.isUKGallon(key));
        ArrayList<TypeErrorAdapter> warnings = new ArrayList<TypeErrorAdapter>();
        AuftragsbasisGrunddatenIF order = null;
        try {
            KeyAnalyserLogic.initPreProd(keyData.getContent());
            KeyDataAnalysedType analysedKey = null;
            try {
                analysedKey = this.analyseBeforeInterpret(keyData, settings.getLocale());
                this.checkVINInvalidChar(analysedKey);
                this.checkAlternateKey(analysedKey);
            }
            catch (NotSupportedKeyvariantException e) {
                warnings.add(new TypeErrorAdapter(e));
            }
            catch (VINInvalidCharacterException e) {
                analysedKey = null;
                warnings.add(new TypeErrorAdapter(e));
            }
            catch (AlternateKeyException e) {
                analysedKey = null;
                warnings.add(new TypeErrorAdapter(e));
            }
            catch (WrongVinFormatException e) {
                warnings.add(new TypeErrorAdapter(e));
            }
            if (analysedKey != null) {
                String vin = analysedKey.getVehicle().getVin();
                Double totalDistance = new Double(analysedKey.getVehicle().getStateInformation().getTotalDistance());
                List<BSIServicePaket> servicePackages = null;
                ServicePackageHolder siHolder = this.getServicePackages(si, vin, totalDistance, settings, warnings);
                if (siHolder != null) {
                    servicePackages = siHolder.getServicePackages();
                }
                GKILogic logic = new GKILogic();
                logic.setUseSI(true);
                logic.setKeyDataBin(key.getKeydata());
                logic.setWarnings(warnings);
                logic.setSiData(servicePackages);
                if (SSIInformationReader.isSSICountry(country)) {
                    logic.setSSICountry(country);
                }
                try {
                    order = logic.createOrderbase(analysedKey, settings);
                }
                catch (GKIException e) {
                    warnings.add(new TypeErrorAdapter(e));
                }
            }
        }
        finally {
            KeyAnalyserLogic.releasePreProd();
        }
        String version = this.retrieveVersion(requestXML);
        InterpretKeyDataResponseToXMLTransformer toXMLTransformer = new InterpretKeyDataResponseToXMLTransformer(version);
        String responseXml = toXMLTransformer.getXML(version, order, key.getKeydata().getReadInDate().toGregorianCalendar().getTimeZone(), warnings, settings);
        MultiFormInterpretSIResponse response = new MultiFormInterpretSIResponse();
        response.setVersion(version);
        response.setXml(responseXml);
        return response;
    }

    public String interpretKeyDataWithSISA(String requestXML, SIProviderXMLIF si, String country, SAProviderXMLIF sa) throws AnalyserException, KSDAccessException, SystemException {
        MultiFormInterpretSIResponse resp = this.interpretKeyDataWithSISAMultiForm(requestXML, si, sa, country);
        return this.interpretKeyDataWithSIMultiForm(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFormInterpretSIResponse interpretKeyDataWithSISAMultiForm(String requestXML, SIProviderXMLIF si, SAProviderXMLIF sa, String country) throws AnalyserException, KSDAccessException, SystemException {
        AuftragsbasisGrunddatenIF order;
        GKISettings settings;
        InterpretKey key;
        ArrayList<TypeErrorAdapter> warnings;
        block36: {
            warnings = new ArrayList<TypeErrorAdapter>();
            if (sa == null) {
                this.log.info((Object)"No SA Provider submitted");
            }
            ThreadLocalAttributes.setFieldValidCheckInThread(true);
            this.log.info((Object)"---------- Interpreting Key with SISA ----------");
            InterpretKeyDataToTypedTransformer transformer = new InterpretKeyDataToTypedTransformer();
            key = transformer.transformToCurrentTyped(requestXML);
            KeyDataBinType keyData = key.getKeydata();
            assert (keyData != null) : "key data can not be null";
            settings = new GKISettings(key.getLocale(), key.isIsMiles(), key.isSetSetFahrenheit(), this.isUSGallon(key), this.isUKGallon(key));
            order = null;
            try {
                KeyAnalyserLogic.initPreProd(keyData.getContent());
                KeyDataAnalysedType analysedKey = null;
                try {
                    analysedKey = this.analyseBeforeInterpret(keyData, settings.getLocale());
                    this.checkVINInvalidChar(analysedKey);
                    this.checkAlternateKey(analysedKey);
                }
                catch (NotSupportedKeyvariantException e) {
                    warnings.add(new TypeErrorAdapter(e));
                }
                catch (VINInvalidCharacterException e) {
                    analysedKey = null;
                    warnings.add(new TypeErrorAdapter(e));
                }
                catch (AlternateKeyException e) {
                    analysedKey = null;
                    warnings.add(new TypeErrorAdapter(e));
                }
                catch (WrongVinFormatException e) {
                    warnings.add(new TypeErrorAdapter(e));
                }
                if (analysedKey == null) break block36;
                String vin = analysedKey.getVehicle().getVin();
                Double totalDistance = new Double(analysedKey.getVehicle().getStateInformation().getTotalDistance());
                List<BSIServicePaket> servicePackages = null;
                ServicePackageBaseResponseTransformer siResponse = null;
                ServicePackageHolder siHolder = this.getServicePackages(si, vin, totalDistance, settings, warnings);
                if (siHolder != null) {
                    servicePackages = siHolder.getServicePackages();
                    siResponse = siHolder.getSIResponse();
                }
                GKILogic logic = new GKILogic();
                logic.setKeyDataBin(key.getKeydata());
                logic.setWarnings(warnings);
                logic.setUseSI(true);
                logic.setSiData(servicePackages);
                if (!SSIInformationReader.isSSICountry(country)) {
                    this.log.info((Object)"No SSI country - call interpretKeyDataWithSIMultiForm()");
                } else {
                    logic.setSSICountry(country);
                    if (siResponse != null) {
                        if (siResponse.isSSInotSupported() || siResponse.getServicePackages().size() == 0) {
                            this.log.info((Object)"SI Provider does not support SSI SA or servicePackageList is empty -- call SA");
                            OptionalEquipmentResponseTransformer saResponseTransformer = null;
                            try {
                                saResponseTransformer = this.transformSAResponse(sa, this.getShortVin(vin), this.getVinPrefix(vin), settings, warnings);
                            }
                            catch (XMLBearbeitungsException xmlExc) {
                                this.log.info((Object)"Error transform sa response: ", (Throwable)xmlExc);
                            }
                            if (saResponseTransformer != null && saResponseTransformer.isSaCodeSet()) {
                                logic.setSAOptionCode(saResponseTransformer.getSsiSaCode());
                                this.log.info((Object)("Use SSI option from SA Provider - Code: " + saResponseTransformer.getSsiSaCode()));
                            } else {
                                this.log.info((Object)"SA Provider: No SSI SA code found for vehicle");
                                warnings.add(new TypeErrorAdapter(new NoVehicleSSIException("No SSI SA found for vehicle " + vin, new String[]{vin})));
                            }
                        } else {
                            String ssiSACode = siResponse.getSAOptionCode();
                            if (siResponse.getSAOptionCode() != null && SSIInformationReader.isSSISA(ssiSACode)) {
                                logic.setSAOptionCode(siResponse.getSAOptionCode());
                                this.log.info((Object)("Use SSI option from SI Provider - Code: " + siResponse.getSAOptionCode()));
                            } else {
                                this.log.info((Object)"SI Provider: No SSI SA code found for vehicle");
                                warnings.add(new TypeErrorAdapter(new NoVehicleSSIException("No SSI SA found for vehicle " + vin, new String[]{vin})));
                            }
                        }
                    } else {
                        OptionalEquipmentResponseTransformer saResponseTransformer;
                        boolean checkSAProvider = true;
                        if (servicePackages != null) {
                            HashSet<String> saSet = new HashSet<String>();
                            for (int i = 0; i < servicePackages.size(); ++i) {
                                BSIServicePaket bsi = servicePackages.get(i);
                                String saOptionCode = bsi.getSAOptionCode();
                                if (!bsi.getSupportSystemSACode()) break;
                                if (saOptionCode == null || !SSIInformationReader.isSSISA(saOptionCode)) continue;
                                saSet.add(saOptionCode);
                            }
                            if (!saSet.isEmpty()) {
                                Iterator itr = saSet.iterator();
                                if (saSet.size() > 1) {
                                    this.log.error((Object)"KSD returned more than one SSI SA option code in service package list. Try to get SSI code from SA Provider.");
                                    while (itr.hasNext()) {
                                        this.log.error((Object)("Found SSI SA option code  " + ((String)itr.next()).toString()));
                                    }
                                } else {
                                    while (itr.hasNext()) {
                                        String code = ((String)itr.next()).toString();
                                        logic.setSAOptionCode(code);
                                        this.log.info((Object)("Use SSI option from KSD - Code: " + code));
                                        checkSAProvider = false;
                                    }
                                }
                            } else {
                                this.log.info((Object)"KSD: No SSI SA option codes found in service package list. Calling SA Provider....");
                            }
                        }
                        if (checkSAProvider && (saResponseTransformer = this.transformSAResponse(sa, this.getShortVin(vin), this.getVinPrefix(vin), settings, warnings)) != null) {
                            if (saResponseTransformer.isSaCodeSet()) {
                                logic.setSAOptionCode(saResponseTransformer.getSsiSaCode());
                                this.log.info((Object)("Use SSI option from SA Provider - Code: " + saResponseTransformer.getSsiSaCode()));
                            } else {
                                warnings.add(new TypeErrorAdapter(new NoVehicleSSIException("No SSI SA found for vehicle " + vin, new String[]{vin})));
                            }
                        }
                    }
                }
                try {
                    order = logic.createOrderbase(analysedKey, settings);
                }
                catch (GKIException e) {
                    warnings.add(new TypeErrorAdapter(e));
                }
            }
            finally {
                KeyAnalyserLogic.releasePreProd();
            }
        }
        String version = this.retrieveVersion(requestXML);
        InterpretKeyDataResponseToXMLTransformer toXMLTransformer = new InterpretKeyDataResponseToXMLTransformer(version);
        String responseXml = toXMLTransformer.getXML(version, order, key.getKeydata().getReadInDate().toGregorianCalendar().getTimeZone(), warnings, settings);
        MultiFormInterpretSIResponse response = new MultiFormInterpretSIResponse();
        response.setVersion(version);
        response.setXml(responseXml);
        return response;
    }

    public boolean isSSI(SAProviderXMLIF sa, String country, String vinShort, String vinPrefix, String language) {
        return SSIInformationReader.isSSICountry(country);
    }

    private OptionalEquipmentResponseTransformer transformSAResponse(SAProviderXMLIF sa, String vinShort, String vinPrefix, GKISettings settings, List<TypeErrorAdapter> warnings) throws XMLBearbeitungsException {
        if (sa == null) {
            return null;
        }
        OptionalEquipmentResponseTransformer toTypedTransformer = null;
        try {
            OptionalEquipmentRequestToXMLTransformer toXMLTransformer = new OptionalEquipmentRequestToXMLTransformer();
            String saCallXml = toXMLTransformer.getXML(vinShort, vinPrefix, settings.getLocale());
            String saResultXml = sa.retrieveOptionalEquipment(saCallXml);
            toTypedTransformer = new OptionalEquipmentResponseTransformer();
            toTypedTransformer.transformToTyped(saResultXml);
            TypeError error = toTypedTransformer.getError();
            if (error != null && !warnings.contains(error)) {
                warnings.add(GKIHelper.toTypeErrorAdapter(error));
            }
        }
        catch (Exception e) {
            this.log.info((Object)"exception occured try to transformSAResponse", (Throwable)e);
            throw new XMLBearbeitungsException("Error OptionalEquipmentResponseTransformer", e.getCause());
        }
        return toTypedTransformer;
    }

    private ServicePackageHolder getServicePackages(SIProviderXMLIF si, String vin, Double totalDistance, GKISettings settings, List<TypeErrorAdapter> warnings) {
        ServicePackageHolder servicePackageHolder = null;
        if (si != null) {
            List<BSIServicePaket> sps = null;
            ServicePackageBaseRequestToXMLTransformer toXMLTransformer = new ServicePackageBaseRequestToXMLTransformer();
            String siCallXml = toXMLTransformer.getXML(vin, settings.getLocale(), totalDistance);
            try {
                String siResultXml = si.retrieveServicePackages(siCallXml);
                ServicePackageBaseResponseTransformer toTypedTransformer = new ServicePackageBaseResponseTransformer();
                toTypedTransformer.transformToTyped(siResultXml);
                com.bmw.gki.klib.si_V01_03_00.TypeError error = toTypedTransformer.getError();
                if (error != null && !warnings.contains(error)) {
                    String brand;
                    boolean ignore = false;
                    if ("bsi.NoSIPackageException".equals(error.getErrorCode()) && "RR".equals(brand = this.getBrand(vin))) {
                        ignore = true;
                    }
                    if (!ignore) {
                        warnings.add(GKIHelper.toTypeErrorAdapter(error));
                    }
                }
                sps = toTypedTransformer.getBsiServicePackageList();
                KSDDataRetrieverIF retriever = KSDDataRetrieverFactory.getKSDDataRetriever(settings);
                ServicePackageLogic.addCalculationBaseToBasicPackages(warnings, sps, retriever);
                servicePackageHolder = new ServicePackageHolder(sps, toTypedTransformer);
            }
            catch (Exception e) {
                this.log.info((Object)"exception occured try to use method without si provider", (Throwable)e);
            }
            return servicePackageHolder;
        }
        try {
            List<BSIServicePaket> sps = ServicePackageLogic.retrieveServicePackage(vin, settings.getLocale(), settings.isMiles(), warnings, totalDistance.floatValue());
            servicePackageHolder = new ServicePackageHolder(sps, null);
        }
        catch (GKIException e) {
            warnings.add(new TypeErrorAdapter(e));
        }
        return servicePackageHolder;
    }

    private String getBrand(String vin) {
        try {
            FgnrPraefix praefix = FgnrPraefixReader.find(vin.substring(0, 3));
            if (praefix != null) {
                return praefix.getMarke();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String interpretKeyData(String requestXML) throws AnalyserException, KSDAccessException, SystemException {
        MultiFormInterpretResponse resp = this.interpretKeyDataMultiForm(requestXML);
        return this.interpretKeyDataMultiForm(resp);
    }

    public String interpretKeyData(String requestXML, String country) throws AnalyserException, KSDAccessException, SystemException {
        MultiFormInterpretResponse resp = this.interpretKeyDataMultiForm(requestXML, country);
        return this.interpretKeyDataMultiForm(resp);
    }

    public String interpretKeyDataMultiForm(MultiFormInterpretResponse multiForm) throws SystemException {
        return this.transformXML(multiForm);
    }

    public MultiFormInterpretResponse interpretKeyDataMultiForm(String requestXML) throws AnalyserException, KSDAccessException, SystemException {
        return this.interpretKeyDataMultiForm(requestXML, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFormInterpretResponse interpretKeyDataMultiForm(String requestXML, String country) throws AnalyserException, KSDAccessException, SystemException {
        ThreadLocalAttributes.setFieldValidCheckInThread(true);
        this.log.info((Object)"---------- Interpreting Key ----------");
        InterpretKeyDataToTypedTransformer transformer = new InterpretKeyDataToTypedTransformer();
        InterpretKey key = transformer.transformToCurrentTyped(requestXML);
        KeyDataBinType keyData = key.getKeydata();
        assert (keyData != null) : "key data can not be null";
        GKISettings settings = new GKISettings(key.getLocale(), key.isIsMiles(), key.isSetSetFahrenheit(), this.isUSGallon(key), this.isUKGallon(key));
        ArrayList<TypeErrorAdapter> warnings = new ArrayList<TypeErrorAdapter>();
        AuftragsbasisGrunddatenIF order = null;
        try {
            KeyAnalyserLogic.initPreProd(keyData.getContent());
            KeyDataAnalysedType analysedKey = null;
            try {
                analysedKey = this.analyseBeforeInterpret(keyData, settings.getLocale());
                this.checkVINInvalidChar(analysedKey);
                this.checkAlternateKey(analysedKey);
            }
            catch (NotSupportedKeyvariantException e) {
                warnings.add(new TypeErrorAdapter(e));
            }
            catch (VINInvalidCharacterException e) {
                analysedKey = null;
                warnings.add(new TypeErrorAdapter(e));
            }
            catch (AlternateKeyException e) {
                analysedKey = null;
                warnings.add(new TypeErrorAdapter(e));
            }
            catch (WrongVinFormatException e) {
                warnings.add(new TypeErrorAdapter(e));
            }
            if (analysedKey != null) {
                GKILogic logic = new GKILogic();
                logic.setUseSI(false);
                logic.setKeyDataBin(key.getKeydata());
                logic.setWarnings(warnings);
                if (SSIInformationReader.isSSICountry(country)) {
                    logic.setSSICountry(country);
                }
                try {
                    order = logic.createOrderbase(analysedKey, settings);
                }
                catch (GKIException e) {
                    warnings.add(new TypeErrorAdapter(e));
                }
            }
        }
        finally {
            KeyAnalyserLogic.releasePreProd();
        }
        String version = this.retrieveVersion(requestXML);
        InterpretKeyDataResponseToXMLTransformer toXMLTransformer = new InterpretKeyDataResponseToXMLTransformer(version);
        String responseXml = toXMLTransformer.getXML(version, order, keyData.getReadInDate().toGregorianCalendar().getTimeZone(), warnings, settings);
        MultiFormInterpretResponse response = new MultiFormInterpretResponse();
        response.setVersion(version);
        response.setXml(responseXml);
        return response;
    }

    public String updateOrderbase(String requestXML) throws KSDAccessException, SystemException {
        MultiFormUpdateOBResponse resp = this.updateOrderbaseMultiForm(requestXML);
        return this.updateOrderBaseMultiForm(resp);
    }

    public String updateOrderBaseMultiForm(MultiFormUpdateOBResponse multiForm) throws SystemException {
        return this.transformXML(multiForm);
    }

    public MultiFormUpdateOBResponse updateOrderbaseMultiForm(String requestXML) throws KSDAccessException, SystemException {
        ThreadLocalAttributes.setFieldValidCheckInThread(true);
        this.checkKSD();
        UpdateOrderbaseRequestDataTransformer transformer = new UpdateOrderbaseRequestDataTransformer();
        UpdateOrderbase updateOrderBase = transformer.transformToCurrentTyped(requestXML);
        OrderbaseUpdateData orderbaseUpdate = transformer.transform(updateOrderBase);
        new GKISettings(transformer.getLocale(), false);
        ArrayList<TypeErrorAdapter> warnings = new ArrayList<TypeErrorAdapter>();
        GKILogic logic = new GKILogic();
        try {
            logic.updateOrderbase(orderbaseUpdate, transformer.getLocale());
        }
        catch (GKIException e) {
            warnings.add(new TypeErrorAdapter(e));
        }
        OrderBaseType orderBaseType = updateOrderBase.getOrderbase();
        String version = this.retrieveVersion(requestXML);
        UpdateOrderbaseResponseToXMLTransformer toXMLTransformer = new UpdateOrderbaseResponseToXMLTransformer(version);
        String responseXml = toXMLTransformer.getXML(orderBaseType, orderbaseUpdate, warnings, version);
        MultiFormUpdateOBResponse response = new MultiFormUpdateOBResponse();
        response.setVersion(version);
        response.setXml(responseXml);
        return response;
    }

    public String retrieveVin(String requestXML) throws KSDAccessException, AnalyserException, SystemException {
        MultiFormRetrieveVINResponse rsp = this.retrieveVinMultiForm(requestXML);
        return this.retrieveVinMultiForm(rsp);
    }

    public String retrieveVinMultiForm(MultiFormRetrieveVINResponse multiForm) throws SystemException {
        return this.transformXML(multiForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFormRetrieveVINResponse retrieveVinMultiForm(String requestXML) throws KSDAccessException, AnalyserException, SystemException {
        ThreadLocalAttributes.setFieldValidCheckInThread(true);
        this.checkKSD();
        this.log.info((Object)"---------- Retrieving VIN ----------");
        RetrieveVinToTypedTransformer transformer = new RetrieveVinToTypedTransformer();
        RetrieveVin key = transformer.transformToCurrentTyped(requestXML);
        KeyDataBinType keyData = key.getKeyData();
        assert (keyData != null) : "key data can not be null";
        new GKISettings(key.getLocale(), false);
        ArrayList<TypeErrorAdapter> warnings = new ArrayList<TypeErrorAdapter>();
        String vin = null;
        try {
            KeyAnalyserLogic.initPreProd(keyData.getContent());
            try {
                KeyDataBinIF keyDataBin = this.toKeyDataBinIF(keyData);
                vin = new KeyAnalyserLogic().retieveVin(keyDataBin);
                this.checkVINInvalidChar(vin);
            }
            catch (VINInvalidCharacterException e) {
                warnings.add(new TypeErrorAdapter(e));
            }
            catch (WrongVinFormatException e) {
                warnings.add(new TypeErrorAdapter(e));
            }
            catch (NotSupportedKeyvariantException e) {
                warnings.add(new TypeErrorAdapter(e));
            }
        }
        finally {
            KeyAnalyserLogic.releasePreProd();
        }
        String version = this.retrieveVersion(requestXML);
        RetrieveVinResponseTransformer toXMLTransformer = new RetrieveVinResponseTransformer(version);
        String responseXml = toXMLTransformer.getXML(version, vin, warnings);
        MultiFormRetrieveVINResponse response = new MultiFormRetrieveVINResponse();
        response.setVersion(version);
        response.setXml(responseXml);
        return response;
    }
}

