/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api;

import com.bmw.gki.klib.api.KeyInterpreterXML;
import com.bmw.gki.klib.api.SIHandler;
import com.bmw.gki.klib.api.SIProviderIF;
import com.bmw.gki.klib.api.SIProviderXMLIF;
import com.bmw.gki.klib.api.exception.AnalyserException;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.multiform.MultiFormAnalyseResponse;
import com.bmw.gki.klib.api.multiform.MultiFormInterpretResponse;
import com.bmw.gki.klib.api.multiform.MultiFormInterpretSIResponse;
import com.bmw.gki.klib.api.multiform.MultiFormRetrieveVINResponse;
import com.bmw.gki.klib.api.multiform.MultiFormUpdateOBResponse;
import com.bmw.gki.klib.api_V00_01_00.AnalyseKeyResponse;
import com.bmw.gki.klib.api_V00_01_00.InterpretKey;
import com.bmw.gki.klib.api_V00_01_00.InterpretKeyResponse;
import com.bmw.gki.klib.api_V00_01_00.KeyDataAnalysedType;
import com.bmw.gki.klib.api_V00_01_00.KeyDataBinType;
import com.bmw.gki.klib.api_V00_01_00.OrderBaseType;
import com.bmw.gki.klib.api_V00_01_00.RetrieveVinResponse;
import com.bmw.gki.klib.api_V00_01_00.TypeSchemaVersionReference;
import com.bmw.gki.klib.api_V00_01_00.UpdateOrderbaseResponse;
import com.bmw.gki.klib.api_V00_01_00.impl.AnalyseKeyImpl;
import com.bmw.gki.klib.api_V00_01_00.impl.InterpretKeyImpl;
import com.bmw.gki.klib.api_V00_01_00.impl.RetrieveVinImpl;
import com.bmw.gki.klib.api_V00_01_00.impl.TypeSchemaVersionReferenceImpl;
import com.bmw.gki.klib.api_V00_01_00.impl.UpdateOrderbaseImpl;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.data.xml.AnalyseKeyDataResponseTransformer;
import com.bmw.gki.klib.data.xml.AnalyseKeyDataToTypedTransformer;
import com.bmw.gki.klib.data.xml.InterpretKeyDataResponseToXMLTransformer;
import com.bmw.gki.klib.data.xml.InterpretKeyDataToTypedTransformer;
import com.bmw.gki.klib.data.xml.RetrieveVinResponseTransformer;
import com.bmw.gki.klib.data.xml.RetrieveVinToTypedTransformer;
import com.bmw.gki.klib.data.xml.ServicePackageBaseResponseTransformer;
import com.bmw.gki.klib.data.xml.UpdateOrderbaseRequestDataTransformer;
import com.bmw.gki.klib.data.xml.UpdateOrderbaseResponseToXMLTransformer;
import com.bmw.gki.klib.si_V01_03_00.ServicePackageType;
import com.bmw.gki.klib.si_V01_03_00.impl.ServicePackageBaseResponseImpl;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class KeyInterpreter_V00_01_00
extends SIHandler {
    private static final String VERSION = "00.01.00";
    private static Log log = GKILogManager.getInstance().getLogger(KeyInterpreter_V00_01_00.class);

    public KeyDataAnalysedType analyseKeyData(KeyDataBinType keydata, Locale locale) throws AnalyserException {
        MultiFormAnalyseResponse resp = this.analyseKeyDataMultiForm(keydata, locale);
        return this.analyseMultiForm(resp);
    }

    public KeyDataAnalysedType analyseMultiForm(MultiFormAnalyseResponse multiForm) throws AnalyserException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().analyseMultiForm(multiForm);
        KeyDataAnalysedType keyAnalysed = null;
        try {
            AnalyseKeyDataResponseTransformer toTypedTransformer = new AnalyseKeyDataResponseTransformer(VERSION);
            AnalyseKeyResponse responseType = (AnalyseKeyResponse)toTypedTransformer.transformToTyped(responseXML);
            keyAnalysed = responseType.getKeyDataAnalysed();
        }
        catch (Exception e) {
            throw new AnalyserException(e);
        }
        return keyAnalysed;
    }

    public MultiFormAnalyseResponse analyseKeyDataMultiForm(KeyDataBinType keydata, Locale locale) throws AnalyserException {
        AnalyseKeyImpl key = new AnalyseKeyImpl();
        key.setKeyData(keydata);
        key.setLanguage(locale.getLanguage());
        key.setSchemaRef(this.getSchemaVersionReferenceType());
        AnalyseKeyDataToTypedTransformer toXMLTransformer = new AnalyseKeyDataToTypedTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(key);
        String responseXML = null;
        try {
            responseXML = new KeyInterpreterXML().analyseKeyData(requestXML);
        }
        catch (AnalyserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalyserException(e);
        }
        MultiFormAnalyseResponse mf = new MultiFormAnalyseResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }

    private TypeSchemaVersionReference getSchemaVersionReferenceType() {
        TypeSchemaVersionReferenceImpl schemaVersionReference = new TypeSchemaVersionReferenceImpl();
        schemaVersionReference.setRefSchema("interpretKeyGKI");
        schemaVersionReference.setVersion(VERSION);
        return schemaVersionReference;
    }

    public OrderBaseType interpretKeyDataWithSI(KeyDataBinType keydata, SIProviderIF si, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException {
        MultiFormInterpretSIResponse resp = this.interpretKeyDataWithSIMultiForm(keydata, si, locale, isMiles, warnings);
        return this.interpretKeyDataWithSIMultiForm(resp);
    }

    public OrderBaseType interpretKeyDataWithSIMultiForm(MultiFormInterpretSIResponse multiForm) throws KSDAccessException, AnalyserException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().interpretKeyDataWithSIMultiForm(multiForm);
        InterpretKeyDataResponseToXMLTransformer toTypedTransformer = new InterpretKeyDataResponseToXMLTransformer(VERSION);
        InterpretKeyResponse responseType = (InterpretKeyResponse)toTypedTransformer.transformToTyped(responseXML);
        return responseType.getOrderbase();
    }

    public MultiFormInterpretSIResponse interpretKeyDataWithSIMultiForm(KeyDataBinType keydata, final SIProviderIF si, final Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException {
        SIProviderXMLIF siXML = null;
        if (si != null) {
            KeyDataAnalysedType analysedType = this.analyseKeyData(keydata, locale);
            final String vin = analysedType.getVehicle().getVin();
            final float totalDistance = analysedType.getVehicle().getStateInformation().getTotalDistance();
            siXML = new SIProviderXMLIF(){

                @Override
                public String retrieveServicePackages(String xml) {
                    try {
                        List servicePackages = si.retrieveServicePackages(locale, vin, totalDistance);
                        ServicePackageBaseResponseImpl slList = new ServicePackageBaseResponseImpl();
                        for (ServicePackageType servicePackage : servicePackages) {
                            slList.getServicePackage().add(servicePackage);
                        }
                        ServicePackageBaseResponseTransformer toXMLTransformer = new ServicePackageBaseResponseTransformer();
                        String retXml = toXMLTransformer.transformServicePackageResponseToXml(slList);
                        return retXml;
                    }
                    catch (Exception e) {
                        log.info((Object)"exception occured try to use method without si provider", (Throwable)e);
                        return null;
                    }
                }
            };
        }
        InterpretKey interpretKey = this.createInterpretKeyType(keydata, locale, isMiles);
        InterpretKeyDataToTypedTransformer toXMLTransformer = new InterpretKeyDataToTypedTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(interpretKey);
        String responseXML = new KeyInterpreterXML().interpretKeyDataWithSI(requestXML, siXML);
        InterpretKeyDataResponseToXMLTransformer toTypedTransformer = new InterpretKeyDataResponseToXMLTransformer(VERSION);
        InterpretKeyResponse responseType = (InterpretKeyResponse)toTypedTransformer.transformToTyped(responseXML);
        warnings.addAll(GKIHelper.toTypeErrorAdapterList(responseType.getError()));
        MultiFormInterpretSIResponse mf = new MultiFormInterpretSIResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }

    private InterpretKey createInterpretKeyType(KeyDataBinType keydata, Locale locale, boolean isMiles) {
        InterpretKeyImpl interpretKey = new InterpretKeyImpl();
        interpretKey.setIsMiles(isMiles);
        interpretKey.setLocale(Utilities.getLocaleToXSDLanguage(locale));
        interpretKey.setKeydata(keydata);
        interpretKey.setSchemaRef(this.getSchemaVersionReferenceType());
        return interpretKey;
    }

    public OrderBaseType interpretKeyDataWithSI(KeyDataBinType keydata, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException {
        return this.interpretKeyDataWithSI(keydata, null, locale, isMiles, warnings);
    }

    public OrderBaseType interpretKeyData(KeyDataBinType keydata, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException {
        MultiFormInterpretResponse resp = this.interpretKeyDataMultiForm(keydata, locale, isMiles, warnings);
        return this.interpretKeyDataMultiForm(resp);
    }

    public OrderBaseType interpretKeyDataMultiForm(MultiFormInterpretResponse multiForm) throws KSDAccessException, AnalyserException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().interpretKeyDataMultiForm(multiForm);
        InterpretKeyDataResponseToXMLTransformer responseTransformer = new InterpretKeyDataResponseToXMLTransformer(VERSION);
        InterpretKeyResponse responseType = (InterpretKeyResponse)responseTransformer.transformToTyped(responseXML);
        return responseType.getOrderbase();
    }

    public MultiFormInterpretResponse interpretKeyDataMultiForm(KeyDataBinType keydata, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException {
        InterpretKey interpretKey = this.createInterpretKeyType(keydata, locale, isMiles);
        InterpretKeyDataToTypedTransformer toXMLTransformer = new InterpretKeyDataToTypedTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(interpretKey);
        String responseXML = new KeyInterpreterXML().interpretKeyData(requestXML);
        InterpretKeyDataResponseToXMLTransformer toTypedTransformer = new InterpretKeyDataResponseToXMLTransformer(VERSION);
        InterpretKeyResponse responseType = (InterpretKeyResponse)toTypedTransformer.transformToTyped(responseXML);
        warnings.addAll(GKIHelper.toTypeErrorAdapterList(responseType.getError()));
        MultiFormInterpretResponse mf = new MultiFormInterpretResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }

    public OrderBaseType updateOrderbase(OrderBaseType orderbase, Locale locale, List<TypeErrorAdapter> warnings) throws KSDAccessException {
        MultiFormUpdateOBResponse resp = this.updateOrderbaseMultiForm(orderbase, locale, warnings);
        return this.updateOBMultiForm(resp);
    }

    public OrderBaseType updateOBMultiForm(MultiFormUpdateOBResponse multiForm) throws KSDAccessException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().updateOrderBaseMultiForm(multiForm);
        UpdateOrderbaseResponseToXMLTransformer responseTransformer = new UpdateOrderbaseResponseToXMLTransformer(VERSION);
        UpdateOrderbaseResponse responseType = (UpdateOrderbaseResponse)responseTransformer.transformToTyped(responseXML);
        return responseType.getOrderbase();
    }

    public MultiFormUpdateOBResponse updateOrderbaseMultiForm(OrderBaseType orderbase, Locale locale, List<TypeErrorAdapter> warnings) throws KSDAccessException {
        UpdateOrderbaseImpl order = new UpdateOrderbaseImpl();
        order.setLocale(Utilities.getLocaleToXSDLanguage(locale));
        order.setOrderbase(orderbase);
        order.setSchemaRef(this.getSchemaVersionReferenceType());
        UpdateOrderbaseRequestDataTransformer toXMLTransformer = new UpdateOrderbaseRequestDataTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(order);
        String responseXML = new KeyInterpreterXML().updateOrderbase(requestXML);
        UpdateOrderbaseResponseToXMLTransformer responseTransformer = new UpdateOrderbaseResponseToXMLTransformer(VERSION);
        UpdateOrderbaseResponse responseType = (UpdateOrderbaseResponse)responseTransformer.transformToTyped(responseXML);
        warnings.addAll(GKIHelper.toTypeErrorAdapterList(responseType.getError()));
        MultiFormUpdateOBResponse mf = new MultiFormUpdateOBResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }

    public String retrieveVin(KeyDataBinType keydata, Locale locale) throws AnalyserException {
        MultiFormRetrieveVINResponse resp = this.retrieveVinMultiForm(keydata, locale);
        return this.retrieveVinMultiForm(resp);
    }

    public String retrieveVinMultiForm(MultiFormRetrieveVINResponse multiForm) {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().retrieveVinMultiForm(multiForm);
        String vin = null;
        if (responseXML != null) {
            RetrieveVinResponseTransformer responseTransformer = new RetrieveVinResponseTransformer(VERSION);
            RetrieveVinResponse responseType = (RetrieveVinResponse)responseTransformer.transformToTyped(responseXML);
            vin = responseType.getVin();
        }
        return vin;
    }

    public MultiFormRetrieveVINResponse retrieveVinMultiForm(KeyDataBinType keydata, Locale locale) throws AnalyserException {
        RetrieveVinImpl vinType = new RetrieveVinImpl();
        vinType.setKeyData(keydata);
        vinType.setLocale(Utilities.getLocaleToXSDLanguage(locale));
        vinType.setSchemaRef(this.getSchemaVersionReferenceType());
        RetrieveVinToTypedTransformer toXMLTransformer = new RetrieveVinToTypedTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(vinType);
        String responseXML = null;
        try {
            responseXML = new KeyInterpreterXML().retrieveVin(requestXML);
        }
        catch (KSDAccessException e) {
            throw new AnalyserException(e);
        }
        catch (AnalyserException e) {
            throw e;
        }
        MultiFormRetrieveVINResponse mf = new MultiFormRetrieveVINResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }
}

