/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api;

import com.bmw.gki.ka.exception.GKIExceptionIF;
import com.bmw.gki.klib.api.KeyInterpreterXML;
import com.bmw.gki.klib.api.SIHandler;
import com.bmw.gki.klib.api.SIProviderIF;
import com.bmw.gki.klib.api.SIProviderXMLIF;
import com.bmw.gki.klib.api.exception.AnalyserException;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.api.multiform.MultiFormAnalyseResponse;
import com.bmw.gki.klib.api.multiform.MultiFormInterpretResponse;
import com.bmw.gki.klib.api.multiform.MultiFormInterpretSIResponse;
import com.bmw.gki.klib.api.multiform.MultiFormRetrieveVINResponse;
import com.bmw.gki.klib.api.multiform.MultiFormUpdateOBResponse;
import com.bmw.gki.klib.api_V05_00_01.AnalyseKeyResponse;
import com.bmw.gki.klib.api_V05_00_01.InterpretKey;
import com.bmw.gki.klib.api_V05_00_01.InterpretKeyResponse;
import com.bmw.gki.klib.api_V05_00_01.KeyDataAnalysedType;
import com.bmw.gki.klib.api_V05_00_01.KeyDataBinType;
import com.bmw.gki.klib.api_V05_00_01.OrderBaseType;
import com.bmw.gki.klib.api_V05_00_01.RetrieveVinResponse;
import com.bmw.gki.klib.api_V05_00_01.TypeError;
import com.bmw.gki.klib.api_V05_00_01.TypeSchemaVersionReference;
import com.bmw.gki.klib.api_V05_00_01.UpdateOrderbaseResponse;
import com.bmw.gki.klib.api_V05_00_01.impl.AnalyseKeyImpl;
import com.bmw.gki.klib.api_V05_00_01.impl.InterpretKeyImpl;
import com.bmw.gki.klib.api_V05_00_01.impl.RetrieveVinImpl;
import com.bmw.gki.klib.api_V05_00_01.impl.TypeSchemaVersionReferenceImpl;
import com.bmw.gki.klib.api_V05_00_01.impl.UpdateOrderbaseImpl;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.data.xml.AnalyseKeyDataResponseTransformer;
import com.bmw.gki.klib.data.xml.AnalyseKeyDataToTypedTransformer;
import com.bmw.gki.klib.data.xml.InterpretKeyDataResponseToXMLTransformer;
import com.bmw.gki.klib.data.xml.InterpretKeyDataToTypedTransformer;
import com.bmw.gki.klib.data.xml.RetrieveVinResponseTransformer;
import com.bmw.gki.klib.data.xml.RetrieveVinToTypedTransformer;
import com.bmw.gki.klib.data.xml.ServicePackageBaseResponseTransformer;
import com.bmw.gki.klib.data.xml.UpdateOrderbaseRequestDataTransformer;
import com.bmw.gki.klib.data.xml.UpdateOrderbaseResponseToXMLTransformer;
import com.bmw.gki.klib.si_V01_03_00.ServicePackageType;
import com.bmw.gki.klib.si_V01_03_00.impl.ServicePackageBaseResponseImpl;
import com.bmw.gki.klib.si_V01_03_00.impl.TypeErrorImpl;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class KeyInterpreter_V05_00_01
extends SIHandler {
    private static final String VERSION = "05.00.01";
    private static Log log = GKILogManager.getInstance().getLogger(KeyInterpreter_V05_00_01.class);

    public KeyDataAnalysedType analyseKeyData(KeyDataBinType keydata, Locale locale) throws AnalyserException, SystemException {
        MultiFormAnalyseResponse resp = this.analyseKeyDataMultiForm(keydata, locale);
        return this.analyseMultiForm(resp);
    }

    public KeyDataAnalysedType analyseMultiForm(MultiFormAnalyseResponse multiForm) throws AnalyserException, SystemException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().analyseMultiForm(multiForm);
        KeyDataAnalysedType keyAnalysed = null;
        try {
            AnalyseKeyDataResponseTransformer toTypedTransformer = new AnalyseKeyDataResponseTransformer(VERSION);
            AnalyseKeyResponse responseType = (AnalyseKeyResponse)toTypedTransformer.transformToTyped(responseXML);
            keyAnalysed = responseType.getKeyDataAnalysed();
        }
        catch (Exception e) {
            throw new AnalyserException(e);
        }
        return keyAnalysed;
    }

    public MultiFormAnalyseResponse analyseKeyDataMultiForm(KeyDataBinType keydata, Locale locale) throws AnalyserException, SystemException {
        AnalyseKeyImpl key = new AnalyseKeyImpl();
        key.setKeyData(keydata);
        key.setLanguage(locale.getLanguage());
        key.setSchemaRef(this.getSchemaVersionReferenceType());
        AnalyseKeyDataToTypedTransformer toXMLTransformer = new AnalyseKeyDataToTypedTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(key);
        String responseXML = null;
        try {
            responseXML = new KeyInterpreterXML().analyseKeyData(requestXML);
        }
        catch (AnalyserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalyserException(e);
        }
        AnalyseKeyDataResponseTransformer toTypedTransformer = new AnalyseKeyDataResponseTransformer(VERSION);
        AnalyseKeyResponse analyseKeyResponse = (AnalyseKeyResponse)toTypedTransformer.transformToTyped(responseXML);
        TypeError error = analyseKeyResponse.getError();
        if (error != null) {
            throw new AnalyserException(error.getErrorDescription());
        }
        MultiFormAnalyseResponse mf = new MultiFormAnalyseResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }

    private TypeSchemaVersionReference getSchemaVersionReferenceType() {
        TypeSchemaVersionReferenceImpl schemaVersionReference = new TypeSchemaVersionReferenceImpl();
        schemaVersionReference.setRefSchema("interpretKeyGKI");
        schemaVersionReference.setVersion(VERSION);
        return schemaVersionReference;
    }

    public OrderBaseType interpretKeyDataWithSI(KeyDataBinType keydata, SIProviderIF si, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException, SystemException {
        MultiFormInterpretSIResponse resp = this.interpretKeyDataWithSIMultiForm(keydata, si, locale, isMiles, warnings);
        return this.interpretKeyDataWithSIMultiForm(resp);
    }

    public OrderBaseType interpretKeyDataWithSI(KeyDataBinType keydata, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException, SystemException {
        return this.interpretKeyDataWithSI(keydata, null, locale, isMiles, warnings);
    }

    public OrderBaseType interpretKeyDataWithSIMultiForm(MultiFormInterpretSIResponse multiForm) throws KSDAccessException, AnalyserException, SystemException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().interpretKeyDataWithSIMultiForm(multiForm);
        InterpretKeyDataResponseToXMLTransformer toTypedTransformer = new InterpretKeyDataResponseToXMLTransformer(VERSION);
        InterpretKeyResponse responseType = (InterpretKeyResponse)toTypedTransformer.transformToTyped(responseXML);
        return responseType.getOrderbase();
    }

    public MultiFormInterpretSIResponse interpretKeyDataWithSIMultiForm(final KeyDataBinType keydata, final SIProviderIF si, final Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException, SystemException {
        SIProviderXMLIF siXML = null;
        if (si != null) {
            siXML = new SIProviderXMLIF(){

                @Override
                public String retrieveServicePackages(String xml) {
                    ServicePackageBaseResponseImpl servicePackageBaseResponse = new ServicePackageBaseResponseImpl();
                    KeyDataAnalysedType analysedType = null;
                    try {
                        analysedType = KeyInterpreter_V05_00_01.this.analyseKeyData(keydata, locale);
                    }
                    catch (AnalyserException e) {
                        // empty catch block
                    }
                    if (analysedType != null) {
                        String vin = analysedType.getVehicle().getVin();
                        float totalDistance = analysedType.getVehicle().getStateInformation().getTotalDistance();
                        try {
                            List servicePackages = si.retrieveServicePackages(locale, vin, totalDistance);
                            for (ServicePackageType servicePackage : servicePackages) {
                                servicePackageBaseResponse.getServicePackage().add(servicePackage);
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof GKIExceptionIF) {
                                GKIExceptionIF ge = (GKIExceptionIF)((Object)e);
                                TypeErrorImpl typeError = new TypeErrorImpl();
                                typeError.setErrorCode(ge.getErrorCode());
                                typeError.setErrorCategory(ge.getErrorCategory().getName());
                                typeError.setErrorDescription(ge.getFormatedMessage());
                                typeError.setErrorDescriptionLocal(ge.getLocalizedMessage());
                                servicePackageBaseResponse.setException(typeError);
                            }
                            log.info((Object)"exception occured try to use method without si provider", (Throwable)e);
                        }
                    }
                    ServicePackageBaseResponseTransformer toXMLTransformer = new ServicePackageBaseResponseTransformer();
                    String retXml = toXMLTransformer.transformServicePackageResponseToXml(servicePackageBaseResponse);
                    return retXml;
                }
            };
        }
        InterpretKey interpretKey = this.createInterpretKeyType(keydata, locale, isMiles);
        InterpretKeyDataToTypedTransformer toXMLTransformer = new InterpretKeyDataToTypedTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(interpretKey);
        String responseXML = new KeyInterpreterXML().interpretKeyDataWithSI(requestXML, siXML);
        InterpretKeyDataResponseToXMLTransformer toTypedTransformerr = new InterpretKeyDataResponseToXMLTransformer(VERSION);
        InterpretKeyResponse responseType = (InterpretKeyResponse)toTypedTransformerr.transformToTyped(responseXML);
        warnings.addAll(GKIHelper.toTypeErrorAdapterList(responseType.getError()));
        MultiFormInterpretSIResponse mf = new MultiFormInterpretSIResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }

    private InterpretKey createInterpretKeyType(KeyDataBinType keydata, Locale locale, boolean isMiles) {
        InterpretKeyImpl interpretKey = new InterpretKeyImpl();
        interpretKey.setIsMiles(isMiles);
        interpretKey.setLocale(Utilities.getLocaleToXSDLanguage(locale));
        interpretKey.setKeydata(keydata);
        interpretKey.setSchemaRef(this.getSchemaVersionReferenceType());
        return interpretKey;
    }

    public OrderBaseType interpretKeyData(KeyDataBinType keydata, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException, SystemException {
        MultiFormInterpretResponse resp = this.interpretKeyDataMultiForm(keydata, locale, isMiles, warnings);
        return this.interpretKeyDataMultiForm(resp);
    }

    public OrderBaseType interpretKeyDataMultiForm(MultiFormInterpretResponse multiForm) throws KSDAccessException, AnalyserException, SystemException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().interpretKeyDataMultiForm(multiForm);
        InterpretKeyDataResponseToXMLTransformer toTypedTransformer = new InterpretKeyDataResponseToXMLTransformer(VERSION);
        InterpretKeyResponse responseType = (InterpretKeyResponse)toTypedTransformer.transformToTyped(responseXML);
        return responseType.getOrderbase();
    }

    public MultiFormInterpretResponse interpretKeyDataMultiForm(KeyDataBinType keydata, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings) throws KSDAccessException, AnalyserException, SystemException {
        InterpretKey interpretKey = this.createInterpretKeyType(keydata, locale, isMiles);
        InterpretKeyDataToTypedTransformer toXMLTransformer = new InterpretKeyDataToTypedTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(interpretKey);
        String responseXML = new KeyInterpreterXML().interpretKeyData(requestXML);
        InterpretKeyDataResponseToXMLTransformer toTypedTransformer = new InterpretKeyDataResponseToXMLTransformer(VERSION);
        InterpretKeyResponse responseType = (InterpretKeyResponse)toTypedTransformer.transformToTyped(responseXML);
        warnings.addAll(GKIHelper.toTypeErrorAdapterList(responseType.getError()));
        MultiFormInterpretResponse mf = new MultiFormInterpretResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }

    public OrderBaseType updateOrderbase(OrderBaseType orderbase, Locale locale, List<TypeErrorAdapter> warnings) throws KSDAccessException, SystemException {
        MultiFormUpdateOBResponse resp = this.updateOrderbaseMultiForm(orderbase, locale, warnings);
        return this.updateOBMultiForm(resp);
    }

    public OrderBaseType updateOBMultiForm(MultiFormUpdateOBResponse multiForm) throws KSDAccessException, SystemException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().updateOrderBaseMultiForm(multiForm);
        UpdateOrderbaseResponseToXMLTransformer toTypedTransformer = new UpdateOrderbaseResponseToXMLTransformer(VERSION);
        UpdateOrderbaseResponse responseType = (UpdateOrderbaseResponse)toTypedTransformer.transformToTyped(responseXML);
        return responseType.getOrderbase();
    }

    public MultiFormUpdateOBResponse updateOrderbaseMultiForm(OrderBaseType orderbase, Locale locale, List<TypeErrorAdapter> warnings) throws KSDAccessException, SystemException {
        UpdateOrderbaseImpl order = new UpdateOrderbaseImpl();
        order.setLocale(Utilities.getLocaleToXSDLanguage(locale));
        order.setOrderbase(orderbase);
        order.setSchemaRef(this.getSchemaVersionReferenceType());
        UpdateOrderbaseRequestDataTransformer toXMLTransformer = new UpdateOrderbaseRequestDataTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(order);
        String responseXML = new KeyInterpreterXML().updateOrderbase(requestXML);
        UpdateOrderbaseResponseToXMLTransformer toTypedTransformer = new UpdateOrderbaseResponseToXMLTransformer(VERSION);
        UpdateOrderbaseResponse responseType = (UpdateOrderbaseResponse)toTypedTransformer.transformToTyped(responseXML);
        warnings.addAll(GKIHelper.toTypeErrorAdapterList(responseType.getError()));
        MultiFormUpdateOBResponse mf = new MultiFormUpdateOBResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }

    public String retrieveVin(KeyDataBinType keydata, Locale locale) throws AnalyserException, SystemException {
        MultiFormRetrieveVINResponse resp = this.retrieveVinMultiForm(keydata, locale);
        return this.retrieveVinMultiForm(resp);
    }

    public String retrieveVinMultiForm(MultiFormRetrieveVINResponse multiForm) throws SystemException {
        multiForm.setVersion(VERSION);
        String responseXML = new KeyInterpreterXML().retrieveVinMultiForm(multiForm);
        String vin = null;
        if (responseXML != null) {
            RetrieveVinResponseTransformer toTypedTransformer = new RetrieveVinResponseTransformer(VERSION);
            RetrieveVinResponse responseType = (RetrieveVinResponse)toTypedTransformer.transformToTyped(responseXML);
            vin = responseType.getVin();
        }
        return vin;
    }

    public MultiFormRetrieveVINResponse retrieveVinMultiForm(KeyDataBinType keydata, Locale locale) throws AnalyserException, SystemException {
        RetrieveVinImpl vinType = new RetrieveVinImpl();
        vinType.setKeyData(keydata);
        vinType.setLocale(Utilities.getLocaleToXSDLanguage(locale));
        vinType.setSchemaRef(this.getSchemaVersionReferenceType());
        RetrieveVinToTypedTransformer toXMLTransformer = new RetrieveVinToTypedTransformer(VERSION);
        String requestXML = toXMLTransformer.getXML(vinType);
        String responseXML = null;
        try {
            responseXML = new KeyInterpreterXML().retrieveVin(requestXML);
        }
        catch (KSDAccessException e) {
            throw new AnalyserException(e);
        }
        catch (AnalyserException e) {
            throw e;
        }
        MultiFormRetrieveVINResponse mf = new MultiFormRetrieveVINResponse();
        mf.setVersion(VERSION);
        mf.setXml(responseXML);
        return mf;
    }
}

