/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api;

import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class SchluesselVariante
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String VOR_E65 = "vorE65";
    public static final String E65 = "E65";
    public static final String E60 = "E60";
    public static final String CBS4 = "CBS4";
    private static final int MAXWERT = 6;
    private int versionskennung;
    private int schluesselVariante;
    private boolean pseudo;
    private int anzeigeId;
    private Vector<FeldTyp> felder;
    private int subvariante;

    public int getVersionskennung() {
        return this.versionskennung;
    }

    public void setversionskennung(int versionskennung) {
        this.versionskennung = versionskennung;
    }

    public SchluesselVariante(int schluesselVariante, int subvariante, String daten, boolean pseudo, int lineNumber, int anzeigeId) throws KSDPropertyFormatException {
        this.schluesselVariante = schluesselVariante;
        this.subvariante = subvariante;
        this.anzeigeId = anzeigeId;
        this.felder = new Vector();
        this.pseudo = pseudo;
        this.ermittelnFelder(daten, lineNumber);
    }

    public int getSchluesselVariante() {
        return this.schluesselVariante;
    }

    public int getAnzeigeId() {
        return this.anzeigeId;
    }

    public Vector<FeldTyp> getFelder() {
        return this.felder;
    }

    public boolean isPseudo() {
        return this.pseudo;
    }

    public boolean usesFeld(int feldTyp) throws KSDPropertyFormatException {
        if (this.isPseudo()) {
            return false;
        }
        for (FeldTyp elem : this.felder) {
            if (elem.getTyp() != feldTyp) continue;
            return elem.isUsed();
        }
        throw new KSDPropertyFormatException("No entries - Pseudo keys", new String[]{"" + feldTyp, "" + this.getSchluesselVariante()});
    }

    public String toString() {
        String message = "ID: " + this.schluesselVariante + " - ";
        Iterator<FeldTyp> i = this.getFelder().iterator();
        while (i.hasNext()) {
            message = message + i.next() + ", ";
        }
        return message;
    }

    private void ermittelnFelder(String daten, int line) throws KSDPropertyFormatException {
        StringTokenizer tokenizer = new StringTokenizer(daten, " \t");
        if (tokenizer.countTokens() % 2 != 0) {
            String message = "Schluesselvarianten Reader count of tokens invalid '(tokenCount % 2 != 0)'";
            KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
            throw pex;
        }
        while (tokenizer.hasMoreTokens()) {
            boolean used = false;
            int type = Integer.parseInt(tokenizer.nextToken().trim());
            if (type < 0 || type > 6) {
                String message = "Schluesselvarianten Reader token count > 6";
                throw new KSDPropertyFormatException(message);
            }
            String verw = tokenizer.nextToken().trim();
            if (verw.equals("1")) {
                used = true;
            }
            if (!verw.equals("0") && !verw.equals("1")) {
                String message = "SchluesselvariantenReader token count not valid";
                throw new KSDPropertyFormatException(message);
            }
            this.felder.addElement(new FeldTyp(type, used));
        }
    }

    protected void setAnzeigeId(int anzeigeId) {
        this.anzeigeId = anzeigeId;
    }

    public int getSubvariante() {
        return this.subvariante;
    }

    public void setSubvariante(int subvariante) {
        this.subvariante = subvariante;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchluesselVariante) {
            return ((SchluesselVariante)obj).getSchluesselVariante() == this.getSchluesselVariante();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getSchluesselVariante();
    }

    public class FeldTyp
    implements Serializable {
        static final long serialVersionUID = 4009831230758657070L;
        int typ;
        boolean verwendung;

        public FeldTyp(int typ, boolean verwendung) {
            this.typ = typ;
            this.verwendung = verwendung;
        }

        public int getTyp() {
            return this.typ;
        }

        public boolean isUsed() {
            return this.verwendung;
        }

        public String toString() {
            return this.typ + ": " + this.verwendung;
        }
    }
}

