/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api;

import com.bmw.gki.klib.api.SchluesselVariante;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.ksd.ExtAttribute;
import com.bmw.gki.klib.external.cache.SchluesselFilterReader;
import com.bmw.gki.klib.external.cache.SchluesselVarianteReader;
import com.bmw.gki.klib.util.Utilities;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class Schluesseldaten
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ExtAttribute> extAttributes;
    private KeyDataAnalysedType keyData;
    public static final int KM_STAND = 1;
    public static final int SIA_STAND = 2;
    public static final int FAHRGESTELLNUMMER = 3;
    public static final int TYPSCHLUESSEL = 4;
    public static final int POLSTERCODE = 5;
    public static final int FARBCODE = 6;
    public static final char HERKUNFT_SERVICE_CALL = 'S';
    public static final char HERKUNFT_KEYREADER = 'K';
    public static final char HERKUNFT_UNBEKANNT = '\u0000';
    private Date einleseDatum = null;
    private char herkunft = '\u0000';
    private SchluesselVariante schluesselVariante;
    protected double kmStand;
    protected String fgnr;
    protected String polsterCode;
    protected String typschluessel;
    protected String farbCode;
    protected Date letzteAktualisierung;
    private boolean uhrzeitLetzteAktualisierungGueltig = true;
    protected String marke;

    protected Schluesseldaten(KeyDataAnalysedType data, SchluesselVariante schluesselVariante) {
        this.keyData = data;
        this.schluesselVariante = schluesselVariante;
    }

    public KeyDataAnalysedType getData() {
        return this.keyData;
    }

    public abstract boolean isLargeKey();

    protected Schluesseldaten(KeyDataAnalysedType data, int baustand) {
        this.keyData = data;
        this.schluesselVariante = SchluesselFilterReader.filter(SchluesselVarianteReader.find(data.getKeyBaseData().getKeyVariant()), baustand);
    }

    public Date getEinleseDatum() {
        return this.einleseDatum;
    }

    public char getHerkunft() {
        return this.herkunft;
    }

    public void setHerkunft(char herkunft) {
        this.herkunft = herkunft;
    }

    public void setEinleseDatum(Date value) {
        this.einleseDatum = value;
    }

    public void setTypschluessel(String s) {
        this.typschluessel = s;
    }

    public SchluesselVariante getSchluesselVariante() {
        return this.schluesselVariante;
    }

    public double getKmStand() {
        return this.kmStand;
    }

    public String getFgnr() {
        return this.fgnr;
    }

    public String getPolsterCode() {
        return this.polsterCode;
    }

    public String getTypschluessel() {
        return this.typschluessel;
    }

    public String getFarbCode() {
        return this.farbCode;
    }

    public Date getLetzteAktualisierung() {
        return this.letzteAktualisierung;
    }

    protected void setUhrzeitLetzteAktualisierungGueltig(boolean gueltig) {
        this.uhrzeitLetzteAktualisierungGueltig = gueltig;
    }

    public boolean isUhrzeitLetzteAktualisierungGueltig() {
        return this.uhrzeitLetzteAktualisierungGueltig;
    }

    public String getLetzteAktualisierungString(Locale locale) {
        if (this.getLetzteAktualisierung() != null) {
            if (this.uhrzeitLetzteAktualisierungGueltig) {
                return Utilities.getDateStringLong(this.getLetzteAktualisierung(), locale);
            }
            return Utilities.getDateString(this.getLetzteAktualisierung(), locale) + " --:--";
        }
        return Utilities.getNotAvailableString();
    }

    public String getMarke() {
        return this.marke;
    }

    public Double getKmMeilenStand(GKISettings settings) {
        if (this.getKmStand() == 0.0) {
            return new Double(0.0);
        }
        double kmMeilen = this.getKmStand();
        if (settings.isMiles() || settings.getDisplayDistance().equals("M")) {
            kmMeilen = Utilities.convertToMiles(kmMeilen);
        }
        return new Double(kmMeilen);
    }

    public boolean isE65upward() {
        return this.isE65() || this.isF01();
    }

    public boolean isE65() {
        int schlusselVariante = this.getSchluesselVariante().getSchluesselVariante();
        return schlusselVariante == 6 || schlusselVariante == 7 || schlusselVariante == 8;
    }

    public boolean isF01() {
        int schlusselVariante = this.getSchluesselVariante().getSchluesselVariante();
        return schlusselVariante == 9;
    }

    public boolean isVorE65() {
        return this.getSchluesselVariante().getVersionskennung() == 4;
    }

    public boolean pruefenAktualitaet() {
        boolean isUpToDate = true;
        Date date = this.getLetzteAktualisierung();
        if (date != null) {
            int sIntervall = Einstellungen.getAktualitaetIntervall();
            long intervall = sIntervall * 60000;
            if (System.currentTimeMillis() - date.getTime() > intervall) {
                isUpToDate = false;
            }
        }
        return isUpToDate;
    }

    public List<ExtAttribute> getExtAttributes() {
        return this.extAttributes;
    }

    public void setExtAttributes(List<ExtAttribute> extAttributes) {
        this.extAttributes = extAttributes;
    }
}

