/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api.exception;

import com.bmw.gki.ka.exception.GKIExceptionIF;
import com.bmw.gki.ka.exception.Messages;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.logging.GKILogManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class ExceptionHelper {
    protected final Log logger = GKILogManager.getInstance().getLogger(this.getClass());

    public String formattrace(Throwable cause) {
        String stacktrace = "";
        if (cause != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            cause.printStackTrace(pw);
            pw.flush();
            writer.flush();
            stacktrace = stacktrace + writer.getBuffer().toString();
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.debug((Object)e);
            }
            pw.close();
        }
        return stacktrace;
    }

    public String getDescription(GKIExceptionIF exception) {
        Locale locale = Locale.getDefault();
        return this.getDescription(exception, locale);
    }

    public String getDescription(GKIExceptionIF exception, Locale locale) {
        String descriptionkey = exception.getErrorCode();
        if (descriptionkey == null || descriptionkey.length() == 0) {
            descriptionkey = new SystemException((String)null).getErrorCode();
        }
        this.logger.debug((Object)("loading string for: " + descriptionkey));
        String description = null;
        try {
            description = Messages.getInstance().getString(descriptionkey, locale);
        }
        catch (Exception e) {
            this.logger.warn((Object)("no message for code " + descriptionkey), (Throwable)e);
        }
        if (description == null || "".equals(description.trim())) {
            return descriptionkey;
        }
        if (exception.getParameters() != null && exception.getParameters().size() > 0) {
            int i = 0;
            for (String value : exception.getParameters()) {
                assert (description.indexOf("{" + i + "}") > 0) : "parameter" + i + " not found! in[" + description + "] with key:" + descriptionkey;
                description = description.replaceAll("\\Q{" + i + "}\\E", value == null ? "!PARAM" + i + "!" : value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\Q$\\E", "\\\\\\$"));
                ++i;
            }
            assert (description.indexOf("{") < 0) : "unresolved parameter(s) found! in[" + description + "] with key:" + descriptionkey;
        }
        this.logger.debug((Object)("********* GET exception key: " + descriptionkey + " returns description " + description + "\n"));
        return description;
    }
}

