/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api.exception;

import com.bmw.gki.ka.exception.GKIExceptionIF;
import com.bmw.gki.klib.api.exception.ErrorCategory;
import com.bmw.gki.klib.api.exception.ExceptionHelper;
import com.bmw.gki.klib.api.exception.LocaleHolder;
import com.bmw.gki.logging.GKILogManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class SystemException
extends RuntimeException
implements GKIExceptionIF {
    private static final long serialVersionUID = 1L;
    protected Log logger = GKILogManager.getInstance().getLogger(this.getClass());
    private List<String> params = new ArrayList<String>();

    public SystemException() {
        this((String)null);
    }

    public SystemException(String message) {
        this(message, (Throwable)null);
    }

    public SystemException(String message, Throwable cause) {
        this(message, cause, null);
    }

    public SystemException(String message, String[] parameters) {
        this(message, null, parameters);
    }

    public SystemException(String message, Throwable cause, String[] parameters) {
        super(message, cause);
        this.init(parameters);
    }

    @Override
    public void addParam(String param) {
        this.params.add(param);
    }

    private void init(String[] parameters) {
        this.handleParams(parameters);
        this.logException();
    }

    private void handleParams(String[] parameters) {
        if (parameters != null && parameters.length > 0) {
            this.params.addAll(Arrays.asList(parameters));
        }
    }

    protected void logException() {
        this.getErrorCategory().log(this.formatedLogStr());
        if (this.logger.isDebugEnabled()) {
            String stacktrace = new ExceptionHelper().formattrace(this);
            this.logger.debug((Object)stacktrace);
        }
    }

    private String formatedLogStr() {
        return this.getErrorCategory().getName() + ": " + this.getErrorCode() + ": " + this.getMessage();
    }

    @Override
    public String getErrorCode() {
        return "gki.SystemException";
    }

    @Override
    public ErrorCategory getErrorCategory() {
        return FATAL;
    }

    @Override
    public List<String> getParameters() {
        return this.params;
    }

    @Override
    public String getFormatedMessage() {
        return new ExceptionHelper().getDescription(this);
    }

    @Override
    public String getLocalizedMessage() {
        Locale locale = LocaleHolder.getLocale();
        return new ExceptionHelper().getDescription(this, locale);
    }
}

