/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.common;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.common.EinstellungenDefaults;
import com.bmw.gki.klib.common.IndividualUserSettings;
import com.bmw.gki.klib.common.SubsidiaryUserSettings;
import com.bmw.gki.klib.data.ServicePartnerID;
import com.bmw.gki.klib.util.OperatingSystem;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class Einstellungen
implements SubsidiaryUserSettings,
IndividualUserSettings,
Serializable,
EinstellungenDefaults {
    private static final long serialVersionUID = 1L;
    private static Log log = GKILogManager.getInstance().getLogger(Einstellungen.class);
    private Integer internetPollIntervall = new Integer(10);
    private Integer proxyPort = new Integer(80);
    private String proxyHost = "";
    private Boolean proxyActive = Boolean.FALSE;
    private String ablageRohDaten = "";
    private String modDatumRohDaten = "";
    private String ablageAuftragsBasis = "";
    private String ablageSchluesselVar = "";
    private String ablageLaenderVar = "";
    private String ablageKeyReferenz = "";
    private String ablageCCMessages = "";
    private String ablageKSDLeittypExe = "";
    private String ablageMSTexte = "";
    private Character initKontrollFlag;
    private Character leitTypQuelle;
    private Boolean epcFlag;
    private Boolean checkFormel1 = Boolean.FALSE;
    private Character bosVariante;
    private String installVariante = "";
    private Character dmsCommVariante;
    private Character tkpCommVariante;
    private String versSAMExec = "";
    private String versSchluesselVar = "";
    private String versLaenderVar = "";
    private String versAWTabelle = "";
    private String versBOSVerbindung = "";
    private String versBOSEmpfehlung = "";
    private String ablageSchluesselVarFilter = "";
    private String ablageSchluesselVarFormat = "";
    private String ablageFgnrPraefixe = "";
    private String versFgnrPraefixe = "";
    private String ablageAuftragsBasisTKP = "";
    private String rpcServer = "";
    private Boolean automatischeSucheTA;
    private Character anzeigeGefundeneTA;
    private Character supportAPI = new Character('F');
    private Boolean onlineUpdate = Boolean.FALSE;
    private String apiPort = "";
    private String apiHost = "localhost";
    private String apiUrl = "soap/servlet/soaprouter";
    private String apiPortTKP = "";
    private String apiHostTKP = "";
    private String apiUrlTKP = "";
    private Boolean keyReader;
    private Boolean ta;
    private Boolean fbm;
    private String ablageTempSchluesseldaten = "";
    private String dcsDirectory = "";
    private String vertriebspartnerNr = "";
    private String betriebsNr = "";
    private String isoLaenderCode = "";
    private Boolean servicecallsMitServerabfrage = Boolean.FALSE;
    private Integer clientseitigesServicecallAbfrageintervall = new Integer(240);
    private Boolean automatischeHintergrundabfrageServicecalls = Boolean.FALSE;
    private Locale guiSprache;
    private String einheitWegstrecke;
    private String einheitTemperatur;
    private String einheitFuellstand;
    private String laenderVariante;
    private Integer aktualitaetIntervall;
    private Boolean autoDruck;
    private Character teilApplikation;
    private String haendlerNr = "";
    private String ksdAusgabedatum;
    private String ablageInterpretierteSchluessel;
    private String ablageSIAServiceblattExe;
    private String ablageCCIdExe;
    private String ablageKSDVersionIni;
    private String ablageCBSIcons;
    private static Einstellungen theSettings;
    private static Vector<String> nullSettings;
    public static String path;
    public static String data;
    public static String order;
    private static final Locale[] supportedLocales;
    private Character bsiDatenQuelle = BSIQUELLE_NO_BSI;
    private String ablageBSIExe = "";
    private String ablageBSIBerechnungsbasis = "";
    private String ablageBSIVerknuepfungen = "";

    protected Einstellungen() {
    }

    public void einstellungenAusgeben() throws GKIException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.einstellungenAusgeben(outstream);
        log.trace((Object)outstream.toString());
    }

    public void einstellungenAusgeben(OutputStream outstream) throws GKIException {
        BufferedWriter out = null;
        String epc = this.epcFlag != false ? "y" : "n";
        String checkF1 = this.checkFormel1 != false ? "y" : "n";
        String sAutomatischeSucheTA = Einstellungen.theSettings.automatischeSucheTA != false ? "y" : "n";
        String sKeyReader = Einstellungen.theSettings.keyReader != false ? "y" : "n";
        String sProxyActive = Einstellungen.theSettings.proxyActive != false ? "y" : "n";
        String sTA = Einstellungen.theSettings.ta != false ? "y" : "n";
        String sFBM = Einstellungen.theSettings.fbm != false ? "y" : "n";
        String sAutodruck = Einstellungen.getAutoDruck() != false ? "y" : "n";
        String sOnlineUpdate = Einstellungen.theSettings.onlineUpdate != false ? "y" : "n";
        String sServicecallsMitServerabfrage = Einstellungen.theSettings.servicecallsMitServerabfrage != false ? "y" : "n";
        String sAutomatischeHintergrundabfrageServicecalls = Einstellungen.theSettings.automatischeHintergrundabfrageServicecalls != false ? "y" : "n";
        try {
            int l;
            out = new BufferedWriter(new OutputStreamWriter(outstream));
            out.write("[SAM]");
            out.newLine();
            out.write("internetPollIntervall=" + Einstellungen.theSettings.internetPollIntervall);
            out.newLine();
            out.write("proxyActive=" + sProxyActive);
            out.newLine();
            out.write("proxyPort=" + Einstellungen.theSettings.proxyPort);
            out.newLine();
            out.write("proxyHost=" + Einstellungen.theSettings.proxyHost);
            out.newLine();
            out.write("versSAMExec=" + Einstellungen.theSettings.versSAMExec);
            out.newLine();
            out.write("ablageRohDaten=" + Einstellungen.theSettings.ablageRohDaten);
            out.newLine();
            out.write("modDatumRohDaten=" + Einstellungen.theSettings.modDatumRohDaten);
            out.newLine();
            out.write("ablageSchluesselVar=" + Einstellungen.theSettings.ablageSchluesselVar);
            out.newLine();
            out.write("ablageLaenderVar=" + Einstellungen.theSettings.ablageLaenderVar);
            out.newLine();
            out.write("ablageFgnrPraefixe=" + Einstellungen.theSettings.ablageFgnrPraefixe);
            out.newLine();
            out.write("ablageKeyReferenz=" + Einstellungen.theSettings.ablageKeyReferenz);
            out.newLine();
            out.write("ablageKSDLeittypExe=" + Einstellungen.theSettings.ablageKSDLeittypExe);
            out.newLine();
            out.write("ablageMSTexte=" + Einstellungen.theSettings.ablageMSTexte);
            out.newLine();
            out.write("ablageTempSchluesseldaten=" + Einstellungen.theSettings.ablageTempSchluesseldaten);
            out.newLine();
            out.write("initKontrollFlag=" + Einstellungen.theSettings.initKontrollFlag);
            out.newLine();
            out.write("leitTypQuelle=" + Einstellungen.theSettings.leitTypQuelle);
            out.newLine();
            out.write("epcFlag=" + epc);
            out.newLine();
            out.write("checkFormel1=" + checkF1);
            out.newLine();
            out.write("bosVariante=" + Einstellungen.theSettings.bosVariante);
            out.newLine();
            out.write("installVariante=" + Einstellungen.theSettings.installVariante);
            out.newLine();
            out.write("dmsCommVariante=" + Einstellungen.theSettings.dmsCommVariante);
            out.newLine();
            out.write("supportAPI=" + Einstellungen.theSettings.supportAPI);
            out.newLine();
            out.write("tkpCommVariante=" + Einstellungen.theSettings.tkpCommVariante);
            out.newLine();
            out.write("rpcServer=" + Einstellungen.theSettings.rpcServer);
            out.newLine();
            out.write("ablageSchluesselVarFilter=" + Einstellungen.theSettings.ablageSchluesselVarFilter);
            out.newLine();
            out.write("ablageSchluesselVarFormat=" + Einstellungen.theSettings.ablageSchluesselVarFormat);
            out.newLine();
            out.write("onlineUpdate=" + sOnlineUpdate);
            out.newLine();
            out.write("apiHost=" + Einstellungen.theSettings.apiHost);
            out.newLine();
            out.write("apiPort=" + Einstellungen.theSettings.apiPort);
            out.newLine();
            out.write("apiUrl=" + Einstellungen.theSettings.apiUrl);
            out.newLine();
            out.write("apiHostTKP=" + Einstellungen.theSettings.apiHostTKP);
            out.newLine();
            out.write("apiPortTKP=" + Einstellungen.theSettings.apiPortTKP);
            out.newLine();
            out.write("apiUrlTKP=" + Einstellungen.theSettings.apiUrlTKP);
            out.newLine();
            out.write("automatischeSucheTA=" + sAutomatischeSucheTA);
            out.newLine();
            out.write("anzeigeGefundeneTA=" + Einstellungen.theSettings.anzeigeGefundeneTA);
            out.newLine();
            out.write("teilApplikation=" + Einstellungen.theSettings.teilApplikation);
            out.newLine();
            out.write("autoDruck=" + sAutodruck);
            out.newLine();
            out.write("haendlerNr=" + Einstellungen.getHaendlerNr());
            out.newLine();
            out.write("guiSprache=" + Einstellungen.getGuiSprache().toString());
            out.newLine();
            out.write("einheitWegstrecke=" + Einstellungen.getEinheitWegstrecke());
            out.newLine();
            out.write("laenderVariante=" + Einstellungen.getLaenderVariante());
            out.newLine();
            int intervall = Einstellungen.getAktualitaetIntervall();
            if (intervall == 0) {
                intervall = 60;
            }
            out.write("aktualitaetIntervall=" + intervall);
            out.newLine();
            String tkpPath = Einstellungen.getAblageAuftragsBasisTKP();
            if (tkpPath == null || tkpPath.trim().length() == 0) {
                tkpPath = "c:\\TKP32\\SAM\\";
            }
            if (tkpPath.charAt((l = tkpPath.length()) - 1) != '\\') {
                tkpPath = tkpPath + "\\";
            }
            Einstellungen.theSettings.ablageAuftragsBasisTKP = tkpPath;
            out.write("ablageAuftragsBasisTKP=" + Einstellungen.getAblageAuftragsBasisTKP());
            out.newLine();
            out.write("dcsDirectory=" + Einstellungen.getDcsDirectory());
            out.newLine();
            out.write("vertriebspartnerNr=" + Einstellungen.getVertriebspartnerNr());
            out.newLine();
            out.write("betriebsNr=" + Einstellungen.getBetriebsNr());
            out.newLine();
            out.write("isoLaenderCode=" + Einstellungen.getIsoLaenderCode());
            out.newLine();
            out.write("keyReader=" + sKeyReader);
            out.newLine();
            out.write("ta=" + sTA);
            out.newLine();
            out.write("fbm=" + sFBM);
            out.newLine();
            out.write("servicecallsMitServerabfrage=" + sServicecallsMitServerabfrage);
            out.newLine();
            out.write("automatischeHintergrundabfrageServicecalls=" + sAutomatischeHintergrundabfrageServicecalls);
            out.newLine();
            out.write("versSchluesselVar=" + Einstellungen.theSettings.versSchluesselVar);
            out.newLine();
            out.write("versFgnrPraefixe=" + Einstellungen.theSettings.versLaenderVar);
            out.newLine();
            out.write("versLaenderVar=" + Einstellungen.theSettings.versFgnrPraefixe);
            out.newLine();
            out.write("versAWTabelle=" + Einstellungen.theSettings.versAWTabelle);
            out.newLine();
            out.write("versBOSVerbindung=" + Einstellungen.theSettings.versBOSVerbindung);
            out.newLine();
            out.write("versBOSEmpfehlung=" + Einstellungen.theSettings.versBOSEmpfehlung);
            out.newLine();
            out.write("clientseitigesServicecallAbfrageintervall=" + Einstellungen.theSettings.clientseitigesServicecallAbfrageintervall);
            out.newLine();
            out.write("bsiDatenQuelle=" + Einstellungen.theSettings.bsiDatenQuelle);
            out.newLine();
            out.write("ablageBSIExe=" + Einstellungen.theSettings.ablageBSIExe);
            out.newLine();
            out.write("ablageBSIBerechnungsbasis=" + Einstellungen.theSettings.ablageBSIBerechnungsbasis);
            out.newLine();
            out.write("ablageBSIVerknuepfungen=" + Einstellungen.theSettings.ablageBSIVerknuepfungen);
            out.newLine();
            out.write("ablageInterpretierteSchluessel=" + Einstellungen.theSettings.ablageInterpretierteSchluessel);
            out.newLine();
            out.write("ablageSIAServiceblattExe=" + Einstellungen.theSettings.ablageSIAServiceblattExe);
            out.newLine();
            out.write("ablageCCIdExe=" + Einstellungen.theSettings.ablageCCIdExe);
            out.newLine();
            out.write("ablageKSDVersionIni=" + Einstellungen.theSettings.ablageKSDVersionIni);
            out.newLine();
            out.write("ablageCBSIcons=" + Einstellungen.theSettings.ablageCBSIcons);
            out.newLine();
            out.write("ksdAusgabedatum=" + Einstellungen.theSettings.ksdAusgabedatum);
            out.newLine();
            out.flush();
            out.close();
        }
        catch (IOException ioex) {
            throw new com.bmw.gki.klib.api.exception.IOException("einstellungen.writeFile.ioException", ioex);
        }
    }

    public static Integer getInternetPollIntervall() {
        return Einstellungen.theSettings.internetPollIntervall;
    }

    public static String getProxyHost() {
        return Einstellungen.theSettings.proxyHost;
    }

    public static Boolean getProxyActive() {
        return Einstellungen.theSettings.proxyActive;
    }

    public static Integer getProxyPort() {
        return Einstellungen.theSettings.proxyPort;
    }

    public static String getAblageAuftragsBasis() {
        return Einstellungen.theSettings.ablageAuftragsBasis;
    }

    public static String getAblageAuftragsBasisTKP() {
        return Einstellungen.theSettings.ablageAuftragsBasisTKP;
    }

    public static String getAblageFgnrPraefixe() {
        return Einstellungen.theSettings.ablageFgnrPraefixe;
    }

    public static String getAblageCCMessages() {
        return Einstellungen.theSettings.ablageCCMessages;
    }

    public static String getAblageKeyReferenz() {
        return Einstellungen.theSettings.ablageKeyReferenz;
    }

    public static String getAblageKSDLeittypExe() {
        return Einstellungen.theSettings.ablageKSDLeittypExe;
    }

    public static String getAblageLaenderVar() {
        return Einstellungen.theSettings.ablageLaenderVar;
    }

    public static String getAblageRohDaten() {
        return Einstellungen.theSettings.ablageRohDaten;
    }

    public static String getAblageSchluesselVar() {
        return Einstellungen.theSettings.ablageSchluesselVar;
    }

    public static String getAblageSchluesselVarFilter() {
        return Einstellungen.theSettings.ablageSchluesselVarFilter;
    }

    public static String getAblageSchluesselVarFormat() {
        return Einstellungen.theSettings.ablageSchluesselVarFormat;
    }

    public static String getAblageTempSchluesseldaten() {
        return Einstellungen.theSettings.ablageTempSchluesseldaten;
    }

    public static String getDcsDirectory() {
        return Einstellungen.theSettings.dcsDirectory;
    }

    public static String getVertriebspartnerNr() {
        return Einstellungen.theSettings.vertriebspartnerNr;
    }

    public static String getBetriebsNr() {
        return Einstellungen.theSettings.betriebsNr;
    }

    public static String getIsoLaenderCode() {
        return Einstellungen.theSettings.isoLaenderCode;
    }

    public static Boolean getServicecallsMitServerabfrage() {
        return Einstellungen.theSettings.servicecallsMitServerabfrage;
    }

    public static Integer getClientseitigesServicecallAbfrageintervall() {
        return Einstellungen.theSettings.clientseitigesServicecallAbfrageintervall;
    }

    public static Boolean getAutomatischeHintergrundabfrageServicecalls() {
        return Einstellungen.theSettings.automatischeHintergrundabfrageServicecalls;
    }

    public static String getAblageMSTexte() {
        return Einstellungen.theSettings.ablageMSTexte;
    }

    public static int getAktualitaetIntervall() {
        return Einstellungen.theSettings.aktualitaetIntervall;
    }

    public static Character getAnzeigeGefundeneTA() {
        return Einstellungen.theSettings.anzeigeGefundeneTA;
    }

    public static boolean isAnzeigeGefundeneTAWindow() {
        return Einstellungen.theSettings.anzeigeGefundeneTA.charValue() == 'W';
    }

    public static String getApiPort() {
        return Einstellungen.theSettings.apiPort;
    }

    public static Boolean getOnlineUpdate() {
        return Einstellungen.theSettings.onlineUpdate;
    }

    public static String getApiHost() {
        return Einstellungen.theSettings.apiHost;
    }

    public static String getApiUrl() {
        return Einstellungen.theSettings.apiUrl;
    }

    public static String getApiPortTKP() {
        return Einstellungen.theSettings.apiPortTKP;
    }

    public static String getApiHostTKP() {
        return Einstellungen.theSettings.apiHostTKP;
    }

    public static String getApiUrlTKP() {
        return Einstellungen.theSettings.apiUrlTKP;
    }

    public static Boolean getAutoDruck() {
        if (Einstellungen.theSettings.autoDruck == null) {
            Einstellungen.theSettings.autoDruck = new Boolean(false);
        }
        return Einstellungen.theSettings.autoDruck;
    }

    public static boolean getAutomatischeSucheTA() {
        return Einstellungen.theSettings.automatischeSucheTA;
    }

    public static char getBosVariante() {
        return Einstellungen.theSettings.bosVariante.charValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Einstellungen getDefaultInstance() {
        if (theSettings != null) return theSettings;
        Class<Einstellungen> clazz = Einstellungen.class;
        synchronized (Einstellungen.class) {
            theSettings = new Einstellungen();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theSettings;
        }
    }

    public static void setDefaultInstance(Einstellungen settings) {
        theSettings = settings;
    }

    public static char getDmsCommVariante() {
        return Einstellungen.theSettings.dmsCommVariante.charValue();
    }

    public static String getEinheitWegstrecke() {
        return Einstellungen.theSettings.einheitWegstrecke;
    }

    public static String getEinheitTemperatur() {
        return Einstellungen.theSettings.einheitTemperatur;
    }

    public static String getEinheitFuellstand() {
        return Einstellungen.theSettings.einheitFuellstand;
    }

    @Override
    public boolean getEpcFlag() {
        return Einstellungen.theSettings.epcFlag;
    }

    public static boolean getCheckFormel1() {
        return Einstellungen.theSettings.checkFormel1;
    }

    public static String getFileName() {
        System.out.println(path + "/" + "sam2settings.txt");
        if (path.length() > 0) {
            return path + "sam2settings.txt";
        }
        return Utilities.getAbsolutFilename("sam2settings.txt");
    }

    public static Locale getGuiSprache() {
        return Einstellungen.theSettings.guiSprache;
    }

    public static String getHaendlerNr() {
        return Einstellungen.theSettings.haendlerNr;
    }

    public static char getInitKontrollFlag() {
        return Einstellungen.theSettings.initKontrollFlag.charValue();
    }

    public static String getInstallVariante() {
        return Einstellungen.theSettings.installVariante;
    }

    public static String getLaenderVariante() {
        return Einstellungen.theSettings.laenderVariante;
    }

    public static char getLeitTypQuelle() {
        return Einstellungen.theSettings.leitTypQuelle.charValue();
    }

    public static String getModDatumRohDaten() {
        return Einstellungen.theSettings.modDatumRohDaten;
    }

    public static boolean getFBM() {
        return Einstellungen.theSettings.fbm;
    }

    public static boolean getKeyReader() {
        return Einstellungen.theSettings.keyReader;
    }

    public static boolean getTA() {
        return Einstellungen.theSettings.ta;
    }

    public static String getOrder() {
        return order;
    }

    @Override
    public String getRpcServer() {
        return this.rpcServer;
    }

    public static String getSbKennung() {
        return System.getProperty("user.name");
    }

    public static char getSupportAPI() {
        return Einstellungen.theSettings.supportAPI.charValue();
    }

    public static char getTeilapplikation() {
        return Einstellungen.theSettings.teilApplikation.charValue();
    }

    public static char getTpsCommVariante() {
        return Einstellungen.theSettings.tkpCommVariante.charValue();
    }

    public static String getVersAWTabelle() {
        return Einstellungen.theSettings.versAWTabelle;
    }

    public static String getVersBOSEmpfehlung() {
        return Einstellungen.theSettings.versBOSEmpfehlung;
    }

    public static String getVersBOSVerbindung() {
        return Einstellungen.theSettings.versBOSVerbindung;
    }

    public static String getVersSchluesselFilter() {
        return String.valueOf(OperatingSystem.getFileVersion(Einstellungen.getAblageSchluesselVarFilter()));
    }

    public static String getVersSchluesselFormat() {
        return String.valueOf(OperatingSystem.getFileVersion(Einstellungen.getAblageSchluesselVarFormat()));
    }

    public static String getVersFgnrPraefixe() {
        return Einstellungen.theSettings.versFgnrPraefixe;
    }

    public static String getVersLaenderVar() {
        return Einstellungen.theSettings.versLaenderVar;
    }

    public static String getVersSAMExec() {
        return Einstellungen.theSettings.versSAMExec;
    }

    public static String getVersSchluesselVar() {
        return Einstellungen.theSettings.versSchluesselVar;
    }

    public static void initialize() throws GKIException {
        if (theSettings == null) {
            theSettings = new Einstellungen();
        }
        nullSettings = new Vector();
        nullSettings.add("laenderVariante");
        nullSettings.add("ablageSchluesselVarFormat");
        nullSettings.add("ablageTempSchluesseldaten");
        nullSettings.add("teilApplikation");
        nullSettings.add("ksdAusgabedatum");
        theSettings.einlesenEinstellungswerte();
        theSettings.validieren();
        theSettings.einstellungenAusgeben();
    }

    public static ServicePartnerID getServicePartnerID() {
        String vertriebspartnernummer = Einstellungen.getVertriebspartnerNr();
        String betriebsnummer = Einstellungen.getBetriebsNr();
        ServicePartnerID servicePartnerID = new ServicePartnerID(vertriebspartnernummer, betriebsnummer);
        return servicePartnerID;
    }

    public static boolean isSupportApiDateibasiert() {
        return Einstellungen.getSupportAPI() == 'F';
    }

    public static boolean isSupportApiPortbasiert() {
        return Einstellungen.getSupportAPI() == 'P';
    }

    public static boolean isAutoDruck() {
        return Einstellungen.getAutoDruck();
    }

    public static boolean isBosLow() {
        return Einstellungen.getBosVariante() == 'L';
    }

    public static boolean isMilesSet() {
        return "M".equals(Einstellungen.getEinheitWegstrecke());
    }

    public static boolean isGallonsSet() {
        return "G".equals(Einstellungen.getEinheitFuellstand());
    }

    public static boolean isFahrenheitSet() {
        return "F".equals(Einstellungen.getEinheitTemperatur());
    }

    public static boolean isTKP() {
        return Einstellungen.getInitKontrollFlag() == 'T';
    }

    public static void main(String[] args) {
        try {
            Einstellungen.initialize();
            System.out.println("+++++++++++++++++++++++++++++++++++++++++");
        }
        catch (GKIException ex) {
            log.trace((Object)ex.getLocalizedMessage());
        }
    }

    private void einlesenEinstellungswerte() throws GKIException {
        BufferedReader reader = null;
        try {
            File file = new File(Einstellungen.getFileName());
            reader = new LineNumberReader(new FileReader(file));
            while (reader.ready()) {
                String line = ((LineNumberReader)reader).readLine();
                if (line == null || line.length() == 0 || line.charAt(0) == '[') continue;
                StringTokenizer tokenizer = new StringTokenizer(line, "=");
                int lineNumber = ((LineNumberReader)reader).getLineNumber();
                if (tokenizer.countTokens() == 1) continue;
                if (tokenizer.countTokens() != 2) {
                    new SystemException("allgemein.zeilenFormatUngueltig" + lineNumber);
                }
                String key = tokenizer.nextToken().trim();
                String value = tokenizer.nextToken().trim();
                this.setSetting(key, value);
            }
        }
        catch (FileNotFoundException ex) {
            throw new com.bmw.gki.klib.api.exception.IOException("einstellungen.fileNotFound :" + Einstellungen.getFileName(), ex);
        }
        catch (GKIException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SystemException("einstellungen.ioException:" + Einstellungen.getFileName(), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        if (Einstellungen.getLeitTypQuelle() == 'A') {
            System.getProperties().put("ksd.property.path", Einstellungen.getAblageKSDLeittypExe());
        }
    }

    public static void setAblageMSTexte(String value) {
        Einstellungen.theSettings.ablageMSTexte = value;
    }

    public static void setAblageRohDaten(String value) {
        Einstellungen.theSettings.ablageRohDaten = value;
    }

    public static void setAblageSchluesselVarFilter(String value) {
        Einstellungen.theSettings.ablageSchluesselVarFilter = value;
    }

    public static void setAktualitaetIntervall(int value) {
        Einstellungen.theSettings.aktualitaetIntervall = new Integer(value);
    }

    public static void setAutoDruck(String value) {
        Einstellungen.theSettings.autoDruck = new Boolean(value);
    }

    public static void setProxyActive(boolean value) {
        Einstellungen.theSettings.proxyActive = new Boolean(value);
    }

    public static void setProxyHost(String value) {
        Einstellungen.theSettings.proxyHost = value;
    }

    public static void setProxyPort(Integer value) {
        Einstellungen.theSettings.proxyPort = value;
    }

    public static void setInternetPollInervall(Integer value) {
        Einstellungen.theSettings.internetPollIntervall = value;
    }

    public static void setAutomatischeHintergrundabfrageServicecalls(String value) {
        Einstellungen.theSettings.automatischeHintergrundabfrageServicecalls = new Boolean(value);
    }

    public static void setClientseitigesServicecallAbfrageintervall(int value) {
        Einstellungen.theSettings.clientseitigesServicecallAbfrageintervall = new Integer(value);
    }

    public static void setData(String d) {
        data = d;
    }

    public static void setEinheitWegstrecke(String value) {
        Einstellungen.theSettings.einheitWegstrecke = value;
    }

    public static void setEinheitTemperatur(String value) {
        Einstellungen.theSettings.einheitTemperatur = value;
    }

    public static void setEinheitFuellstand(String value) {
        Einstellungen.theSettings.einheitFuellstand = value;
    }

    public static void setGuiSprache(Locale value) {
        Einstellungen.theSettings.guiSprache = value;
    }

    public static void setHaendlerNr(String value) {
        Einstellungen.theSettings.haendlerNr = value;
    }

    public static void setLaenderVariante(String value) {
        Einstellungen.theSettings.laenderVariante = value;
    }

    public static void setModDatumRohDaten(String value) {
        Einstellungen.theSettings.modDatumRohDaten = value;
    }

    public static void setOrder(String o) {
        order = o;
    }

    public static void setPath(String p) {
        path = p;
    }

    public static void setRpcServer(String value) {
        Einstellungen.theSettings.rpcServer = value;
    }

    private void setSetting(String key, String value) throws GKIException {
        if (value == null || value.length() == 0) {
            return;
        }
        Field[] fields = this.getClass().getDeclaredFields();
        boolean found = false;
        for (int i = 0; i < fields.length; ++i) {
            block11: {
                if (!fields[i].getName().equals(key)) continue;
                fields[i].setAccessible(true);
                try {
                    if (fields[i].getType() == String.class) {
                        fields[i].set(this, value);
                        break block11;
                    }
                    if (fields[i].getType() == Character.class) {
                        fields[i].set(this, new Character(value.charAt(0)));
                        break block11;
                    }
                    if (fields[i].getType() == Boolean.class) {
                        fields[i].set(this, new Boolean(value.charAt(0) == '1' || value.charAt(0) == 'y' || value.charAt(0) == 'Y'));
                        break block11;
                    }
                    if (fields[i].getType() == Locale.class) {
                        fields[i].set(this, Utilities.getLocaleForSprache(value.trim()));
                        break block11;
                    }
                    if (fields[i].getType() == Integer.class) {
                        fields[i].set(this, new Integer(value.trim()));
                        break block11;
                    }
                    if (fields[i].getType() == Long.class) {
                        fields[i].set(this, new Long(value.trim()));
                        break block11;
                    }
                    throw new SystemException("Datentyp wird von den Einstellungen nicht unterstuetzt");
                }
                catch (IllegalAccessException iae) {
                    throw new SystemException("illegal.Access", iae);
                }
            }
            fields[i].setAccessible(false);
            found = true;
            break;
        }
        if (!found) {
            log.info((Object)("Entry '" + key + "'=" + value + " ignored "));
        }
    }

    public static void setTeilapplikation(char value) {
        Einstellungen.theSettings.teilApplikation = new Character(value);
    }

    public static void setVersAWTabelle(String value) {
        Einstellungen.theSettings.versAWTabelle = value;
    }

    public static void setVersBOSEmpfehlung(String value) {
        Einstellungen.theSettings.versBOSEmpfehlung = value;
    }

    public static void setVersBOSVerbindung(String value) {
        Einstellungen.theSettings.versBOSVerbindung = value;
    }

    public static void setVersFgnrPraefixe(String value) {
        Einstellungen.theSettings.versFgnrPraefixe = value;
    }

    public static void setVersLaenderVar(String value) {
        Einstellungen.theSettings.versLaenderVar = value;
    }

    public static void setVersSAMExec(String value) {
        Einstellungen.theSettings.versSAMExec = value;
    }

    public static void setVersSchluesselVar(String value) {
        Einstellungen.theSettings.versSchluesselVar = value;
    }

    public static void setBSIDatenQuelle(Character value) {
        Einstellungen.theSettings.bsiDatenQuelle = value;
    }

    public static void setDmsCommVariante(char value) {
        Einstellungen.theSettings.dmsCommVariante = new Character(value);
    }

    public static void setSupportAPI(char value) {
        Einstellungen.theSettings.supportAPI = new Character(value);
    }

    public static void setCheckFormel1(boolean value) {
        Einstellungen.theSettings.checkFormel1 = new Boolean(value);
    }

    private void validieren() throws GKIException {
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String key;
            if (Modifier.isStatic(fields[i].getModifiers()) || nullSettings.contains(key = fields[i].getName())) continue;
            try {
                if (fields[i].get(this) == null) {
                    throw new SystemException("einstellungen.nichtGesetzt:" + key);
                }
            }
            catch (IllegalAccessException iae) {
                throw new SystemException("Feld in Einstellungen nicht vorhanden oder Zugriff nicht moeglich.");
            }
            if (!this.getEpcFlag() || Einstellungen.getInitKontrollFlag() == 'A') continue;
            throw new SystemException("einstellungen.epcUndInitKontrolle");
        }
    }

    private void aktualisierenEinstellungswerte() throws GKIException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(Einstellungen.getFileName());
            this.einstellungenAusgeben(out);
            out.flush();
        }
        catch (IOException e) {
            throw new com.bmw.gki.klib.api.exception.IOException("einstellungen.writeFile.ioException", e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void schreibenEinstellungswerte() throws GKIException {
        theSettings.aktualisierenEinstellungswerte();
    }

    public static final Locale[] getSupportedLocales() {
        return supportedLocales;
    }

    public static boolean isSupportedLocale(Locale locale) {
        for (int i = 0; i < supportedLocales.length; ++i) {
            if (!supportedLocales[i].getLanguage().equals(locale.getLanguage())) continue;
            return true;
        }
        return false;
    }

    public static String getTKPInitiatorDatei() {
        return Einstellungen.getAblageAuftragsBasisTKP() + "tkpinit.txt";
    }

    public static String getTKPParameterDatei() {
        return Einstellungen.getAblageAuftragsBasisTKP() + "samcmd.txt";
    }

    public static boolean isDCSvorhanden() {
        return Einstellungen.getDcsDirectory() != null && Einstellungen.getDcsDirectory().trim().length() != 0;
    }

    @Override
    public String getRegionCode() {
        return this.laenderVariante;
    }

    @Override
    public String getSubsidiaryID() {
        return null;
    }

    @Override
    public boolean getAutomaticSelectRecommendedService() {
        return false;
    }

    @Override
    public int getCheckIntervalKeyContents() {
        return this.aktualitaetIntervall;
    }

    @Override
    public Locale getLanguage() {
        return this.guiSprache;
    }

    @Override
    public String getDisplayDistance() {
        return this.einheitWegstrecke;
    }

    public String getDisplayTemperature() {
        return this.einheitTemperatur;
    }

    public String getDisplayFuel() {
        return this.einheitFuellstand;
    }

    @Override
    public String getDealerWarrantyNumber() {
        return this.haendlerNr;
    }

    @Override
    public char getLeadModelSource() {
        return this.leitTypQuelle.charValue();
    }

    @Override
    public char getCBSVariant() {
        return this.bosVariante.charValue();
    }

    @Override
    public char getBsiQuelle() {
        return this.bsiDatenQuelle.charValue();
    }

    public static char getBSIDatenQuelle() {
        return Einstellungen.theSettings.bsiDatenQuelle.charValue();
    }

    public static String getAblageBSIBerechnungsbasis() {
        return Einstellungen.theSettings.ablageBSIBerechnungsbasis;
    }

    public static String getAblageBSIExe() {
        return Einstellungen.theSettings.ablageBSIExe;
    }

    public static String getAblageBSIVerknuepfungen() {
        return Einstellungen.theSettings.ablageBSIVerknuepfungen;
    }

    public static String getKsdAusgabedatum() {
        return Einstellungen.theSettings.ksdAusgabedatum;
    }

    public static void setKsdAusgabedatum(String ksdAusgabedatum) {
        Einstellungen.theSettings.ksdAusgabedatum = ksdAusgabedatum;
    }

    public static String getAblageKSDVersionIni() {
        return Einstellungen.theSettings.ablageKSDVersionIni;
    }

    public static String getAblageCBSIcons() {
        return Einstellungen.theSettings.ablageCBSIcons;
    }

    public static void setAblageKSDVersionIni(String ablageKSDVersionIni) {
        Einstellungen.theSettings.ablageKSDVersionIni = ablageKSDVersionIni;
    }

    public static String getAblageCCIdExe() {
        return Einstellungen.theSettings.ablageCCIdExe;
    }

    public static void setAblageCCIdExe(String ablageCCIdExe) {
        Einstellungen.theSettings.ablageCCIdExe = ablageCCIdExe;
    }

    static {
        path = "";
        data = null;
        order = null;
        supportedLocales = new Locale[]{Locale.GERMANY, Locale.US, Locale.UK, Locale.FRANCE, new Locale("es", "ES"), Locale.ITALY, new Locale("sv", "SE"), new Locale("nl", "NL"), new Locale("ja", "JP"), new Locale("ru", "RU"), new Locale("th", "TH"), new Locale("ko", "KR"), new Locale("zh", "CN"), new Locale("zh", "TW"), new Locale("tr", "TR"), new Locale("in", "ID"), new Locale("el", "GR"), new Locale("pt", "PT")};
    }
}

