/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.common;

import com.bmw.gki.klib.common.Einstellungen;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class LanguageSelection {
    private static LanguageSelection instance = new LanguageSelection();
    private Locale[] locales = Einstellungen.getSupportedLocales();
    private Map<String, Locale> localeMap = new HashMap<String, Locale>();

    public static LanguageSelection getInstance() {
        return instance;
    }

    private LanguageSelection() {
        for (int i = 0; i < this.locales.length; ++i) {
            this.localeMap.put(this.locales[i].toString(), this.locales[i]);
            Locale language = new Locale(this.locales[i].getLanguage());
            if (this.localeMap.get(language) != null) continue;
            this.localeMap.put(language.toString(), this.locales[i]);
        }
    }

    public Locale getValidLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return this.getValidLocale(locale.toString());
    }

    public static void main(String[] args) {
        Locale[] tests = new Locale[]{new Locale("es"), new Locale("es", "ES"), new Locale("es", "DE"), new Locale("qw", "DE"), new Locale("qw"), Locale.US, Locale.UK, new Locale("en"), new Locale("de", "XX")};
        for (int i = 0; i < tests.length; ++i) {
            Locale result = LanguageSelection.getInstance().getValidLocale(tests[i]);
            System.out.printf("%s -> %s", tests[i], result);
            System.out.println();
        }
    }

    public Locale getValidLocale(String language) {
        Locale validLocale = this.localeMap.get(language);
        String countryCode = null;
        if (validLocale == null) {
            StringTokenizer tok = new StringTokenizer(language, "-_ ");
            String languageCode = tok.nextToken();
            validLocale = this.localeMap.get(languageCode);
            if (tok.hasMoreTokens()) {
                countryCode = tok.nextToken();
            }
        }
        if (validLocale == null) {
            validLocale = Locale.UK;
        } else if (countryCode != null) {
            validLocale = new Locale(validLocale.getLanguage(), countryCode);
        }
        return validLocale;
    }

    public Locale[] getAllLanguages() {
        return this.locales;
    }
}

