/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.config;

import com.bmw.gki.klib.config.GKICacheObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GKICache {
    public static final String CACHE_BOSVALUE = "CACHE_BOSVALUECACHE";
    public static final String GKI_BOSVALUECACHE_ACTIVATED = "GKI_BOSVALUECACHE_ACTIVATED";
    public static final String GKI_BOSVALUECACHE_FILE = "GKI_BOSVALUECACHE_FILE";
    public static final String GKI_BOSVALUECACHE_DIRECTORY = "GKI_BOSVALUECACHE_DIRECTORY";
    public static final String GKI_BOSVALUECACHE_VALUEOBJECT1 = "GKI_BOSVALUECACHE_VALUEOBJECT1";
    public static final String GKI_BOSVALUECACHE_ACTIVE_FILEPATH = "GKI_BOSVALUECACHE_ACTIVE_FILEPATH";
    public static final String TEMP_DIRECTORY = "TEMP_DIRECTORY";
    private String systemTempDirectory = null;
    private Map<String, GKICacheObject> cacheConfig = new HashMap<String, GKICacheObject>();

    public void addCacheObject(String keyObject, GKICacheObject cObject) {
        cObject.setTempDirectory(this.systemTempDirectory);
        this.cacheConfig.put(keyObject, cObject);
    }

    public GKICacheObject getCacheObject(String keyObject) {
        return this.cacheConfig.get(keyObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueToCacheObject(String keyObject, String value) {
        GKICacheObject gco = this.cacheConfig.get(keyObject);
        if (gco != null) {
            gco.setValueObject(value);
            Map<String, GKICacheObject> map = this.cacheConfig;
            synchronized (map) {
                this.cacheConfig.remove(keyObject);
                this.cacheConfig.put(keyObject, gco);
            }
        }
    }

    public List<GKICacheObject> getActiveCacheObjects() {
        Collection<GKICacheObject> activeCaches = this.cacheConfig.values();
        ArrayList<GKICacheObject> listGco = new ArrayList<GKICacheObject>();
        for (GKICacheObject gco : activeCaches) {
            if (!gco.isCached()) continue;
            listGco.add(gco);
        }
        return listGco;
    }

    public void setSystemTempDirectory(String pathToTemp) {
        this.systemTempDirectory = pathToTemp;
    }

    public String getSystemTempDirectory() {
        return this.systemTempDirectory;
    }
}

