/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.apiparams;

import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.ka.keydata.FieldRecordTo;
import com.bmw.gki.klib.api.exception.WriteOperationNotSupportedException;
import com.bmw.gki.klib.api_current.KeyBaseType;
import com.bmw.gki.klib.data.apiparams.GKICalendar;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class KeyBase
implements KeyBaseType {
    private FieldRecordTo fieldRecord;
    private TimeZone gkiTimeZone = TimeZone.getTimeZone("GMT");

    public KeyBase(FieldComponentTo fieldRecord, TimeZone newGkiTimeZone) {
        this.fieldRecord = (FieldRecordTo)fieldRecord;
        if (newGkiTimeZone != null) {
            this.gkiTimeZone = newGkiTimeZone;
        }
    }

    @Override
    public Integer getDataConsistence3() {
        return KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "dataConsistence3");
    }

    @Override
    public void setDataConsistence3(Integer value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public XMLGregorianCalendar getWriteDate() {
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            System.out.println("createKeyDataBinType:Exception(" + e + ")");
        }
        GKICalendar calendar = null;
        int year = KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "lastRefreshYear");
        int month = KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "lastRefreshMonth");
        int day = KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "lastRefreshDay");
        if (month > 0 && month < 13 && day >= 1 && day <= 31) {
            calendar = new GKICalendar(this.gkiTimeZone);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            int hour = KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "lastRefreshHour");
            if (hour == 253) {
                calendar.setErrorHourFlagValue(hour);
            }
            if (hour <= 24 && hour >= 0) {
                calendar.set(11, hour);
            } else {
                calendar.set(11, 0);
            }
            int min = KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "lastRefreshMin");
            if (min <= 60 && min >= 0) {
                calendar.set(12, min);
            } else {
                calendar.set(12, 0);
            }
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        if (calendar == null) {
            return null;
        }
        return df.newXMLGregorianCalendar(calendar);
    }

    @Override
    public void setWriteDate(XMLGregorianCalendar value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public Short getKeyProfil() {
        return (short)KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "keyProfile");
    }

    @Override
    public void setKeyProfil(Short value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public int getKeyVariant() {
        return KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "keyvariant");
    }

    @Override
    public void setKeyVariant(int value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public int getKeySubVariant() {
        return KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "keySubvariant");
    }

    @Override
    public void setKeySubVariant(int value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public Integer getDataConsistence4() {
        return KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "dataConsistence4");
    }

    @Override
    public void setDataConsistence4(Integer value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public Short getKeyNumber() {
        return (short)KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "keyNumber");
    }

    @Override
    public void setKeyNumber(Short value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetDataConsistence3() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "dataConsistence3");
    }

    public void unsetDataConsistence3() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetKeyProfil() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "keyProfile");
    }

    public void unsetKeyProfil() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetKeyVariant() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "keyvariant");
    }

    public void unsetKeyVariant() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetKeySubVariant() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "keySubvariant");
    }

    public void unsetKeySubVariant() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetDataConsistence4() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "dataConsistence4");
    }

    public void unsetDataConsistence4() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetKeyNumber() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "keyNumber");
    }

    public void unsetKeyNumber() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public Integer getWriteMode() {
        return KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "writeMode");
    }

    @Override
    public void setWriteMode(Integer value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetWriteMode() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "writeMode");
    }

    public void unsetWriteMode() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetWriteDate() {
        return this.getWriteDate() != null;
    }

    public void unsetWriteDate() {
        throw new WriteOperationNotSupportedException();
    }
}

