/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.apiparams;

import com.bmw.gki.ka.TechnicalException;
import com.bmw.gki.ka.keydata.FieldArrayTo;
import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.ka.keydata.FieldRecordTo;
import com.bmw.gki.ka.keydata.FieldTo;
import com.bmw.gki.ka.keydata.KeyDataTo;
import com.bmw.gki.ka.util.ExtendedAttributesHandler;
import com.bmw.gki.klib.api.KeyDataBinIF;
import com.bmw.gki.klib.api.exception.WriteOperationNotSupportedException;
import com.bmw.gki.klib.api_current.DfzKeyType;
import com.bmw.gki.klib.api_current.DtcBaseType;
import com.bmw.gki.klib.api_current.EcuIdentDataType;
import com.bmw.gki.klib.api_current.KeyBaseType;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.api_current.VehicleKeyType;
import com.bmw.gki.klib.api_current.impl.DfzKeyTypeImpl;
import com.bmw.gki.klib.api_current.impl.DtcBaseTypeImpl;
import com.bmw.gki.klib.api_current.impl.EcuIdentDataTypeImpl;
import com.bmw.gki.klib.api_current.impl.ExtendedAttributeBaseTypeImpl;
import com.bmw.gki.klib.api_current.impl.KeyBaseTypeImpl;
import com.bmw.gki.klib.api_current.impl.KeyDataAnalysedTypeImpl;
import com.bmw.gki.klib.api_current.impl.VehicleKeyTypeImpl;
import com.bmw.gki.klib.data.apiparams.CBSData;
import com.bmw.gki.klib.data.apiparams.DTCData;
import com.bmw.gki.klib.data.apiparams.KeyBase;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import com.bmw.gki.klib.data.apiparams.SIABaseData;
import com.bmw.gki.klib.data.apiparams.VehicleKey;
import com.bmw.gki.logging.GKILogManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;

public class KeyDataAnalysed
implements KeyDataAnalysedType {
    static Log log = GKILogManager.getInstance().getLogger(KeyDataAnalysed.class);
    private KeyDataTo analysedField;
    private FieldRecordTo fieldRecord;
    private TimeZone gkiTimeZone = TimeZone.getTimeZone("GMT");
    private KeyDataBinIF keybinData;

    public KeyDataAnalysed(KeyDataTo analysedFields, KeyDataBinIF bin) {
        this.analysedField = analysedFields;
        this.keybinData = bin;
        this.fieldRecord = analysedFields.getFieldRecord();
        this.gkiTimeZone = this.keybinData != null && this.keybinData.getReadInDate() != null ? this.keybinData.getReadInDate().toGregorianCalendar().getTimeZone() : TimeZone.getDefault();
    }

    public Date getReadInDate() {
        if (this.keybinData != null && this.keybinData.getReadInDate() != null) {
            return this.keybinData.getReadInDate().toGregorianCalendar().getTime();
        }
        return null;
    }

    public String getOrigin() {
        return this.keybinData.getOrigin().value();
    }

    public KeyDataBinIF getKeybinData() {
        return this.keybinData;
    }

    public void setKeybinData(KeyDataBinIF keybinData) {
        this.keybinData = keybinData;
    }

    public String getVin() {
        return this.analysedField.getVin();
    }

    public void setVin(String vin) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public KeyDataAnalysedType.CcData getCcData() {
        KeyDataAnalysedType.CcData ccData = new KeyDataAnalysedType.CcData(){

            @Override
            public List<KeyDataAnalysedType.CcData.Cc> getCc() {
                ArrayList<KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl> ccElements = null;
                FieldArrayTo ccArray = (FieldArrayTo)KeyDataAnalysed.this.fieldRecord.getFieldComponent("ccData");
                if (ccArray != null) {
                    ccElements = new ArrayList<KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl>();
                    for (int i = 0; i < ccArray.getSize(); ++i) {
                        FieldRecordTo comp = ccArray.getFieldRecord(i);
                        if (comp == null || !comp.isValid()) continue;
                        CCElement ccElement = new CCElement(comp);
                        KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl ccImpl = new KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl();
                        ccImpl.setValue(ccElement.getValue());
                        if (ccElement.isSetTotalDistance() && ccElement.getTotalDistance() != 0L) {
                            ccImpl.setTotalDistance(ccElement.getTotalDistance());
                        }
                        ccElements.add(ccImpl);
                    }
                }
                return ccElements;
            }

            @Override
            public boolean isSetCc() {
                return KeyDataHelper.getIsSetFromFieldRecordTo(KeyDataAnalysed.this.fieldRecord, "ccData");
            }

            @Override
            public void unsetCc() {
            }

            @Override
            public BigInteger getCountActiveCCM() {
                long ccACcm = KeyDataHelper.getIntFromFieldRecordTo(KeyDataAnalysed.this.fieldRecord, "countActiveCCM");
                return new BigInteger(new Long(ccACcm).toString());
            }

            @Override
            public void setCountActiveCCM(BigInteger value) {
                throw new WriteOperationNotSupportedException();
            }

            @Override
            public boolean isSetCountActiveCCM() {
                return KeyDataHelper.getIsSetFromFieldRecordTo(KeyDataAnalysed.this.fieldRecord, "countActiveCCM");
            }
        };
        KeyDataAnalysedTypeImpl.CcDataImpl newCCType = null;
        List<KeyDataAnalysedType.CcData.Cc> ccElements = ccData.getCc();
        if (ccElements != null && !ccElements.isEmpty()) {
            newCCType = new KeyDataAnalysedTypeImpl.CcDataImpl();
            if (this.getCountActiveCCM() != null && this.isSetCountActiveCCM()) {
                newCCType.setCountActiveCCM(this.getCountActiveCCM());
            }
            Iterator<KeyDataAnalysedType.CcData.Cc> iter = ccElements.iterator();
            while (iter.hasNext()) {
                newCCType.getCc().add(iter.next());
            }
        }
        return newCCType;
    }

    @Override
    public void setCcData(KeyDataAnalysedType.CcData value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public KeyBaseType getKeyBaseData() {
        KeyBase keyBase = new KeyBase(KeyDataHelper.isFieldComponentValid(this.fieldRecord), this.gkiTimeZone);
        return (KeyBaseType)KeyDataHelper.copyValues(new KeyBaseTypeImpl(), keyBase);
    }

    @Override
    public void setKeyBaseData(KeyBaseType value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public VehicleKeyType getVehicle() {
        return (VehicleKeyType)KeyDataHelper.copyValues(new VehicleKeyTypeImpl(), new VehicleKey(this.fieldRecord, this.gkiTimeZone));
    }

    @Override
    public void setVehicle(VehicleKeyType value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public String getNaviDVDVersion() {
        if (KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "naviVersion")) {
            return new Double(KeyDataHelper.getDoubleFromFieldRecordTo(this.fieldRecord, "naviVersion")).toString();
        }
        return null;
    }

    @Override
    public void setNaviDVDVersion(String value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public KeyDataAnalysedType.SiaData getSiaData() {
        SIABaseData sourceSiaBase = new SIABaseData(this.fieldRecord);
        if (sourceSiaBase.isSetSia()) {
            return (KeyDataAnalysedType.SiaData)KeyDataHelper.copyValues(new KeyDataAnalysedTypeImpl.SiaDataImpl(), sourceSiaBase);
        }
        return null;
    }

    @Override
    public void setSiaData(KeyDataAnalysedType.SiaData value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public KeyDataAnalysedType.CbsBaseData getCbsBaseData() {
        if (this.fieldRecord != null) {
            CBSData srcCbsData = new CBSData(this.fieldRecord);
            if (srcCbsData.isSetCbsCount()) {
                KeyDataAnalysedTypeImpl.CbsBaseDataImpl destCbsData = new KeyDataAnalysedTypeImpl.CbsBaseDataImpl();
                destCbsData.getConditionBasedService().addAll(srcCbsData.getConditionBasedService());
                return (KeyDataAnalysedType.CbsBaseData)KeyDataHelper.copyValues(destCbsData, srcCbsData);
            }
            return null;
        }
        return null;
    }

    @Override
    public void setCbsBaseData(KeyDataAnalysedType.CbsBaseData value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public DtcBaseType getDtcData() {
        if (this.fieldRecord != null) {
            DTCData srcDtc = new DTCData(this.fieldRecord);
            DtcBaseTypeImpl destDtc = new DtcBaseTypeImpl();
            KeyDataHelper.copyValues(destDtc, srcDtc);
            List<DtcBaseType.Dtc> dtcList = srcDtc.getDtc();
            if (dtcList != null && !dtcList.isEmpty()) {
                Iterator<DtcBaseType.Dtc> iter = dtcList.iterator();
                while (iter.hasNext()) {
                    destDtc.getDtc().add(iter.next());
                }
            } else {
                List<DtcBaseType.EcuErrors> EcuErrorsList = srcDtc.getEcuErrors();
                if (EcuErrorsList != null && !EcuErrorsList.isEmpty()) {
                    Iterator<DtcBaseType.EcuErrors> iter = EcuErrorsList.iterator();
                    while (iter.hasNext()) {
                        destDtc.getEcuErrors().add(iter.next());
                    }
                } else {
                    return null;
                }
            }
            return destDtc;
        }
        return null;
    }

    @Override
    public void setDtcData(DtcBaseType value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public EcuIdentDataType getEcuIdentData() {
        List<EcuIdentDataType.EcuIdent> ecuIden;
        EcuIdentDataTypeImpl targetEcuIdent = null;
        EcuIdentDataType sourceEcuIdent = new EcuIdentDataType(){

            @Override
            public List<EcuIdentDataType.EcuIdent> getEcuIdent() {
                ArrayList<EcuIdentDataType.EcuIdent> ecuElements = new ArrayList<EcuIdentDataType.EcuIdent>();
                FieldArrayTo ccArray = (FieldArrayTo)KeyDataAnalysed.this.fieldRecord.getFieldComponent("diagnose");
                if (ccArray != null && ccArray.getSize() > 0) {
                    for (int i = 0; i < ccArray.getSize(); ++i) {
                        final FieldRecordTo comp = ccArray.getFieldRecord(i);
                        if (comp == null || !comp.isValid()) continue;
                        EcuIdentDataType.EcuIdent ecuIdent = (EcuIdentDataType.EcuIdent)KeyDataHelper.copyValues(new EcuIdentDataTypeImpl.EcuIdentImpl(), new EcuIdentDataType.EcuIdent(){

                            @Override
                            public int getEcuAddress() {
                                return KeyDataHelper.getIntFromFieldRecordTo((FieldRecordTo)comp, "stg_address");
                            }

                            @Override
                            public void setEcuAddress(int value) {
                                throw new WriteOperationNotSupportedException();
                            }

                            @Override
                            public int getEcuVariantIndex() {
                                return KeyDataHelper.getIntFromFieldRecordTo((FieldRecordTo)comp, "stg_variante_index");
                            }

                            @Override
                            public void setEcuVariantIndex(int value) {
                                throw new WriteOperationNotSupportedException();
                            }

                            @Override
                            public int getEcuDiagnosticIndex() {
                                return KeyDataHelper.getIntFromFieldRecordTo((FieldRecordTo)comp, "stg_index");
                            }

                            @Override
                            public void setEcuDiagnosticIndex(int value) {
                                throw new WriteOperationNotSupportedException();
                            }

                            @Override
                            public boolean isSetEcuAddress() {
                                return KeyDataHelper.getIsSetFromFieldRecordTo((FieldRecordTo)comp, "stg_address");
                            }

                            @Override
                            public boolean isSetEcuVariantIndex() {
                                return KeyDataHelper.getIsSetFromFieldRecordTo((FieldRecordTo)comp, "stg_variante_index");
                            }

                            @Override
                            public boolean isSetEcuDiagnosticIndex() {
                                return KeyDataHelper.getIsSetFromFieldRecordTo((FieldRecordTo)comp, "stg_index");
                            }
                        });
                        ecuElements.add(ecuIdent);
                    }
                }
                return ecuElements;
            }

            @Override
            public boolean isSetEcuIdent() {
                return false;
            }

            @Override
            public void unsetEcuIdent() {
                throw new WriteOperationNotSupportedException();
            }
        };
        if (sourceEcuIdent != null && (ecuIden = sourceEcuIdent.getEcuIdent()) != null && ecuIden.size() > 0) {
            targetEcuIdent = new EcuIdentDataTypeImpl();
            for (EcuIdentDataType.EcuIdent ecuIdentType : sourceEcuIdent.getEcuIdent()) {
                if (ecuIdentType.getEcuAddress() == 0 && ecuIdentType.getEcuDiagnosticIndex() == 0 && ecuIdentType.getEcuVariantIndex() == 0) continue;
                targetEcuIdent.getEcuIdent().add(ecuIdentType);
            }
            if (targetEcuIdent.getEcuIdent() != null && targetEcuIdent.getEcuIdent().size() == 0) {
                targetEcuIdent = null;
            }
        }
        return targetEcuIdent;
    }

    @Override
    public void setEcuIdentData(EcuIdentDataType value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetCcData() {
        return this.getCcData() != null;
    }

    public void unsetCcData() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetKeyBaseData() {
        return this.getKeyBaseData() != null;
    }

    public void unsetKeyBaseData() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetEcuIdentData() {
        return this.getEcuIdentData() != null;
    }

    public void unsetEcuIdentData() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetVehicle() {
        return this.getVehicle() != null;
    }

    public void unsetVehicle() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetDtcData() {
        return this.getDtcData() != null;
    }

    public void unsetDtcData() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetNaviDVDVersion() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "naviVersion");
    }

    public void unsetNaviDVDVersion() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetSiaData() {
        return this.getSiaData() != null;
    }

    public void unsetSiaData() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetCbsBaseData() {
        return this.getCbsBaseData() != null;
    }

    public void unsetCbsBaseData() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public KeyDataAnalysedType.ExtendedAttributes getExtendedAttributes() {
        if (!ExtendedAttributesHandler.getInstance().existExtendedAttributesNameFile()) {
            return null;
        }
        KeyDataAnalysedTypeImpl.ExtendedAttributesImpl newExtType = null;
        List<?> field = this.fieldRecord.getFieldComponents();
        for (Object element : field) {
            String id = ((FieldComponentTo)element).getId();
            if (!ExtendedAttributesHandler.getInstance().isExtendedAttribute(id)) continue;
            if (element instanceof FieldTo) {
                FieldTo actField = (FieldTo)element;
                Object value = actField.getValue();
                log.debug((Object)("Extended Attribute element id:" + actField.getId()));
                log.debug((Object)("Extended Attribute element value:" + value));
                log.debug((Object)("Instance of value is:" + value.getClass()));
                if (value == null) continue;
                if (newExtType == null) {
                    newExtType = new KeyDataAnalysedTypeImpl.ExtendedAttributesImpl();
                }
                ExtendedAttributeBaseTypeImpl att = new ExtendedAttributeBaseTypeImpl();
                att.setName(actField.getId());
                att.setValue(value.toString());
                newExtType.getExtendedAttribute().add(att);
                continue;
            }
            log.debug((Object)("ELEMENT: " + id + "is not a FieldTo"));
        }
        return newExtType;
    }

    public List<KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl> getCc() {
        ArrayList<KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl> ccElements = null;
        FieldArrayTo ccArray = (FieldArrayTo)this.fieldRecord.getFieldComponent("ccData");
        if (ccArray != null) {
            ccElements = new ArrayList<KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl>();
            for (int i = 0; i < ccArray.getSize(); ++i) {
                long distance;
                FieldRecordTo comp = ccArray.getFieldRecord(i);
                if (comp == null || !comp.isValid()) continue;
                CCElement ccElement = new CCElement(comp);
                KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl ccImpl = new KeyDataAnalysedTypeImpl.CcDataImpl.CcImpl();
                ccImpl.setValue(ccElement.getValue());
                if (ccElement.isSetTotalDistance() && (distance = ccElement.getTotalDistance()) > 0L) {
                    ccImpl.setTotalDistance(ccElement.getTotalDistance());
                }
                ccElements.add(ccImpl);
            }
        }
        return ccElements;
    }

    public boolean isSetCc() {
        return false;
    }

    public void unsetCc() {
    }

    public BigInteger getCountActiveCCM() {
        long ccACcm = KeyDataHelper.getIntFromFieldRecordTo(this.fieldRecord, "countActiveCCM");
        if (ccACcm >= 0L) {
            return new BigInteger(new Long(ccACcm).toString());
        }
        return null;
    }

    public void setCountActiveCCM(BigInteger value) {
        throw new WriteOperationNotSupportedException();
    }

    public boolean isSetCountActiveCCM() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "countActiveCCM");
    }

    public void unsetCountActiveCCM() {
    }

    @Override
    public void setExtendedAttributes(KeyDataAnalysedType.ExtendedAttributes value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetExtendedAttributes() {
        Set<Object> extAtt = ExtendedAttributesHandler.getInstance().getExtendedAttributesNames();
        for (String string : extAtt) {
            if (!KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, string)) continue;
            return true;
        }
        return false;
    }

    public void unsetExtendedAttributes() {
    }

    @Override
    public DfzKeyType getDfzKey() {
        DfzKeyTypeImpl newKeyType = new DfzKeyTypeImpl();
        String value = KeyDataHelper.getStringFromFieldRecordTo(this.fieldRecord, "dfzKey");
        if (value == null) {
            return null;
        }
        log.debug((Object)("DFZKey value is: " + value));
        if (value != null && value.length() == 64) {
            newKeyType.setValue(value);
            String dfzKeyHex = value.substring(0, 32);
            log.debug((Object)("DFZKey is: " + dfzKeyHex));
            byte[] dfzKey = null;
            try {
                dfzKey = Hex.decodeHex((char[])dfzKeyHex.toCharArray());
            }
            catch (DecoderException e) {
                String message = "cannot decode from hex to byte array";
                log.warn((Object)message, (Throwable)e);
                throw new TechnicalException(message, e);
            }
            newKeyType.setDfzKey(dfzKey);
        }
        String wupHex = value.substring(32, 40);
        log.debug((Object)("DFZKey WUP is: " + wupHex));
        if (wupHex != null) {
            byte[] wup = null;
            try {
                wup = Hex.decodeHex((char[])wupHex.toCharArray());
            }
            catch (DecoderException e) {
                String message = "cannot decode from hex to byte array";
                log.warn((Object)message, (Throwable)e);
                throw new TechnicalException(message, e);
            }
            newKeyType.setWUP(wup);
        }
        String version = value.substring(40, 42);
        log.debug((Object)("DFZKey frequency is: " + version));
        BigInteger vers = new BigInteger(version, 16);
        newKeyType.setVersion(vers.intValue());
        String lfKeyHex = value.substring(48, 56);
        log.debug((Object)("LFKey is: " + lfKeyHex));
        if (lfKeyHex != null) {
            byte[] lfKey;
            try {
                lfKey = Hex.decodeHex((char[])lfKeyHex.toCharArray());
            }
            catch (DecoderException e) {
                String message = "cannot decode from hex to byte array";
                log.warn((Object)message, (Throwable)e);
                throw new TechnicalException(message, e);
            }
            newKeyType.setLfKey(lfKey);
        }
        String frequency = value.substring(42, 44);
        log.debug((Object)("DFZKey frequency is: " + frequency));
        BigInteger freq = new BigInteger(frequency, 16);
        newKeyType.setFrequency(freq.intValue());
        return newKeyType;
    }

    @Override
    public boolean isSetDfzKey() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "dfzKey");
    }

    @Override
    public void setDfzKey(DfzKeyType value) {
        throw new WriteOperationNotSupportedException();
    }

    public void unsetDfzKey() {
    }

    public KeyDataTo getAnalysedField() {
        return this.analysedField;
    }

    private class CCElement
    implements KeyDataAnalysedType.CcData.Cc {
        private FieldRecordTo ccRecord;

        public CCElement(FieldComponentTo ccRecord) {
            this.ccRecord = (FieldRecordTo)ccRecord;
        }

        @Override
        public String getValue() {
            return String.valueOf(KeyDataHelper.getIntFromFieldRecordTo(this.ccRecord, "cc"));
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public boolean isSetValue() {
            return KeyDataHelper.getIsSetFromFieldRecordTo(this.ccRecord, "cc");
        }

        @Override
        public long getTotalDistance() {
            double distance = KeyDataHelper.getDoubleFromFieldRecordTo(this.ccRecord, "totalDistance");
            return (long)distance;
        }

        @Override
        public boolean isSetTotalDistance() {
            return KeyDataHelper.getIsSetFromFieldRecordTo(this.ccRecord, "totalDistance");
        }

        @Override
        public void setTotalDistance(long value) {
            throw new WriteOperationNotSupportedException();
        }

        @Override
        public void unsetTotalDistance() {
        }
    }
}

