/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.apiparams;

import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.ka.keydata.FieldRecordTo;
import com.bmw.gki.ka.keydata.FieldTo;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.util.ThreadLocalAttributes;
import com.bmw.gki.logging.GKILogManager;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;

public final class KeyDataHelper {
    public static final String TIME_ZONE_STRING = "GMT";
    private static final Log log = GKILogManager.getInstance().getLogger(KeyDataHelper.class);
    private static Log LOG = GKILogManager.getInstance().getLogger(KeyDataHelper.class);

    private KeyDataHelper() {
    }

    public static Calendar retrieveCalendar(Date date, TimeZone timezone) {
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(date);
        GregorianCalendar cal = new GregorianCalendar(timezone);
        cal.set(1, tempCal.get(1));
        cal.set(2, tempCal.get(2));
        cal.set(5, tempCal.get(5));
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static XMLGregorianCalendar retrieveXMLGregorianCalendar(Date date, TimeZone timezone) {
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            log.error((Object)("retrieveXMLGregorianCalendar:Exception(" + e + ")"));
        }
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(date);
        GregorianCalendar cal = new GregorianCalendar(timezone);
        cal.set(1, tempCal.get(1));
        cal.set(2, tempCal.get(2));
        cal.set(5, tempCal.get(5));
        cal.set(13, 0);
        cal.set(14, 0);
        return df.newXMLGregorianCalendar(cal);
    }

    public static Calendar retrieveCalendarDateTime(Date date, TimeZone timezone) {
        GregorianCalendar tempCal = new GregorianCalendar(timezone);
        tempCal.setTime(date);
        GregorianCalendar cal = new GregorianCalendar(timezone);
        cal.set(1, tempCal.get(1));
        cal.set(2, tempCal.get(2));
        cal.set(5, tempCal.get(5));
        cal.set(11, tempCal.get(11));
        cal.set(12, tempCal.get(12));
        cal.set(13, tempCal.get(13));
        cal.set(14, 0);
        return cal;
    }

    public static XMLGregorianCalendar retrieveXMLGregorianCalendarTime(Date date, TimeZone timezone) {
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            log.error((Object)("retrieveXMLGregorianCalendar:Exception(" + e + ")"));
        }
        GregorianCalendar tempCal = new GregorianCalendar(timezone);
        tempCal.setTime(date);
        GregorianCalendar cal = new GregorianCalendar(timezone);
        cal.set(1, tempCal.get(1));
        cal.set(2, tempCal.get(2));
        cal.set(5, tempCal.get(5));
        cal.set(11, tempCal.get(11));
        cal.set(12, tempCal.get(12));
        cal.set(13, tempCal.get(13));
        cal.set(14, 0);
        return df.newXMLGregorianCalendar(cal);
    }

    public static FieldComponentTo isFieldComponentValid(FieldComponentTo fieldComponent) {
        if (fieldComponent != null && fieldComponent.isValid()) {
            return fieldComponent;
        }
        if (fieldComponent != null) {
            LOG.debug((Object)("field component" + fieldComponent.getId() + " is invalid"));
        }
        return null;
    }

    public static int getIntFromFieldRecordTo(FieldRecordTo fieldRecord, String id) {
        FieldTo field;
        if (fieldRecord != null && (field = (FieldTo)KeyDataHelper.isFieldComponentValid(fieldRecord.getFieldComponent(id))) != null && field.getValue() != null) {
            Object val = field.getValue();
            String strVal = null;
            if (val instanceof Double) {
                Double dbVal = (Double)val;
                strVal = new Integer(dbVal.intValue()).toString();
            } else {
                strVal = val.toString();
            }
            return Integer.parseInt(strVal);
        }
        return 0;
    }

    public static boolean getIsSetFromFieldRecordTo(FieldRecordTo fieldRecord, String id) {
        if (fieldRecord != null) {
            FieldTo field = null;
            field = ThreadLocalAttributes.isFieldValidCheckInThread() ? (FieldTo)KeyDataHelper.isFieldComponentValid(fieldRecord.getFieldComponent(id)) : (FieldTo)fieldRecord.getFieldComponent(id);
            if (field != null && field.getValue() != null) {
                return true;
            }
        }
        return false;
    }

    public static float getFloatFromFieldRecordTo(FieldRecordTo fieldRecord, String id) {
        FieldTo field;
        if (fieldRecord != null && (field = (FieldTo)KeyDataHelper.isFieldComponentValid(fieldRecord.getFieldComponent(id))) != null && field.getValue() != null) {
            Double dbVal = (Double)field.getValue();
            return dbVal.floatValue();
        }
        return 0.0f;
    }

    public static double getDoubleFromFieldRecordTo(FieldRecordTo fieldRecord, String id) {
        FieldTo field;
        if (fieldRecord != null && (field = (FieldTo)KeyDataHelper.isFieldComponentValid(fieldRecord.getFieldComponent(id))) != null && field.getValue() != null) {
            Double dbVal = (Double)field.getValue();
            return dbVal;
        }
        return 0.0;
    }

    public static String getStringFromFieldRecordTo(FieldRecordTo fieldRecord, String id) {
        FieldTo field;
        if (fieldRecord != null && (field = (FieldTo)KeyDataHelper.isFieldComponentValid(fieldRecord.getFieldComponent(id))) != null && field.getValue() != null) {
            return field.getValue().toString();
        }
        return null;
    }

    public static Boolean getBooleanFromFieldRecordTo(FieldRecordTo fieldRecord, String id) {
        int val;
        FieldTo field = (FieldTo)KeyDataHelper.isFieldComponentValid(fieldRecord.getFieldComponent(id));
        Boolean bool = new Boolean(false);
        if (field != null && field.getValue() != null && (val = new Double(field.getValue().toString()).intValue()) == 1) {
            bool = new Boolean(true);
            return bool;
        }
        return bool;
    }

    public static Object copyValues(Object destObject, Object srcObject) {
        try {
            KeyDataHelper.copyProperties(destObject, srcObject);
        }
        catch (IllegalAccessException e) {
            LOG.fatal((Object)e);
            throw new XMLBearbeitungsException("not possible to copy properties into " + destObject.toString(), e);
        }
        catch (InvocationTargetException e) {
            LOG.fatal((Object)e);
            throw new XMLBearbeitungsException("not possible to copy properties into " + destObject.toString(), e);
        }
        return destObject;
    }

    private static void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!BeanUtilsBean.getInstance().getPropertyUtils().isWriteable(dest, name)) continue;
                Object value = ((DynaBean)orig).get(name);
                KeyDataHelper.copyPropertyWithCondition(orig, dest, name, value);
            }
        } else if (orig instanceof Map) {
            for (String name : ((Map)orig).keySet()) {
                if (!BeanUtilsBean.getInstance().getPropertyUtils().isWriteable(dest, name)) continue;
                Object value = ((Map)orig).get(name);
                KeyDataHelper.copyPropertyWithCondition(orig, dest, name, value);
            }
        } else {
            PropertyDescriptor[] origDescriptors = BeanUtilsBean.getInstance().getPropertyUtils().getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !BeanUtilsBean.getInstance().getPropertyUtils().isReadable(orig, name) || !BeanUtilsBean.getInstance().getPropertyUtils().isWriteable(dest, name)) continue;
                try {
                    Object value = BeanUtilsBean.getInstance().getPropertyUtils().getSimpleProperty(orig, name);
                    KeyDataHelper.copyPropertyWithCondition(orig, dest, name, value);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void copyPropertyWithCondition(Object src, Object dest, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        String methodName = Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length());
        Method method = MethodUtils.getAccessibleMethod(src.getClass(), (String)("get" + methodName), (Class[])new Class[0]);
        if (method != null) {
            if (method.getReturnType().isPrimitive() || method.getReturnType() == String.class || method.getReturnType() == Double.class || method.getReturnType() == Integer.class || method.getReturnType() == Long.class || method.getReturnType() == Float.class) {
                String isSetMethodName = "isSet" + methodName;
                try {
                    Boolean isSet = Boolean.TRUE;
                    isSet = (Boolean)MethodUtils.invokeExactMethod((Object)src, (String)isSetMethodName, null);
                    if (isSet.booleanValue()) {
                        BeanUtilsBean.getInstance().copyProperty(dest, name, value);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("property from class " + src.getClass().getName() + " and property " + name + " isSet == false"));
                    }
                }
                catch (NoSuchMethodException e) {
                    log.fatal((Object)("no such method " + isSetMethodName), (Throwable)e);
                }
            } else {
                BeanUtilsBean.getInstance().copyProperty(dest, name, value);
            }
        }
    }
}

