/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.apitransformation;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.ka.exception.GKIExceptionIF;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.Schluesseldaten;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.DfzKeyType;
import com.bmw.gki.klib.api_current.DtcBaseType;
import com.bmw.gki.klib.api_current.EcuIdentDataType;
import com.bmw.gki.klib.api_current.ExtendedAttributeType;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.ServicePackageEvalType;
import com.bmw.gki.klib.api_current.impl.DescriptionTypeImpl;
import com.bmw.gki.klib.api_current.impl.ExtendedAttributeTypeImpl;
import com.bmw.gki.klib.api_current.impl.FlatRateUnitTypeImpl;
import com.bmw.gki.klib.api_current.impl.ILevelTypeImpl;
import com.bmw.gki.klib.api_current.impl.NaviDVDTypeImpl;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.data.ksd.ExtAttribute;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.data.ksd.cc.CCMessage;
import com.bmw.gki.klib.data.ksd.engineoil.EngineOil;
import com.bmw.gki.klib.data.ksd.ilevel.ILevelData;
import com.bmw.gki.klib.data.ksd.navi.NaviDVDData;
import com.bmw.gki.klib.data.orderbase.ExtendedKeyData;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.data.xsd.CcList;
import com.bmw.gki.klib.data.xsd.ServiceInformation;
import com.bmw.gki.klib.data.xsd.Vehicle;
import com.bmw.gki.klib.data.xsd.VehicleKey;
import com.bmw.gki.logging.GKILogManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;

public class ResponseMapper {
    private static Log log = GKILogManager.getInstance().getLogger(ResponseMapper.class);

    public OrderBaseType current(AuftragsbasisGrunddatenIF data, TimeZone timeZone, GKISettings usersettings, List<TypeErrorAdapter> warnings) {
        if (data != null) {
            try {
                OrderBaseTypeImpl orderBase = new OrderBaseTypeImpl();
                Schluesseldaten keyData = data.getSchluesseldaten();
                if (keyData != null) {
                    this.setDfzKey(orderBase, keyData);
                    this.setExtendedAttributes(orderBase, keyData);
                    this.setEcuIdentData(orderBase, keyData);
                    if (keyData.isE65upward()) {
                        ExtendedKeyData extendedKeyData;
                        SchluesseldatenE65 keyDataE65 = (SchluesseldatenE65)keyData;
                        if (keyData.isLargeKey() && (extendedKeyData = keyDataE65.getExtendedKeyData()) != null) {
                            this.setTopUpInformationEngineOil(orderBase, extendedKeyData, usersettings.getLocale());
                            this.setNaviDVDData(orderBase, extendedKeyData);
                            this.setILevelData(orderBase, extendedKeyData);
                        }
                        this.setCCMessages(orderBase, keyDataE65);
                    }
                }
                this.setServicePackages(orderBase, data, timeZone, usersettings);
                this.setVehicle(orderBase, timeZone, data, usersettings);
                this.setVehicleKey(orderBase, data, timeZone, usersettings, warnings);
                this.setServiceInformation(orderBase, data, timeZone, usersettings);
                return orderBase;
            }
            catch (GKIException e) {
                String message = "ResponseMapper - create XML failure (GKIException)";
                XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
                log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
                throw be;
            }
            catch (SystemException e) {
                String message = "ResponseMapper - create XML failure (SystemException)";
                XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
                log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
                throw be;
            }
            catch (Exception e) {
                String message = "ResponseMapper - create XML failure (Exception)";
                XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
                log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
                throw be;
            }
        }
        log.debug((Object)"passed AuftragsbasisGrunddaten is null");
        return null;
    }

    private void setCCMessages(OrderBaseType orderBase, SchluesseldatenE65 keyDataE65) throws GKIException {
        List<CCMessage> ccIds = keyDataE65.getCheckControlIds();
        if (ccIds != null && !ccIds.isEmpty()) {
            BigInteger ccActiveCount = null;
            if (keyDataE65.getData().getCcData() != null && keyDataE65.getData().getCcData().isSetCountActiveCCM()) {
                ccActiveCount = keyDataE65.getData().getCcData().getCountActiveCCM();
            }
            orderBase.setCcList(CcList.createCCListType(ResponseMapper.getCCMessages(keyDataE65), ccActiveCount));
        }
        List<DtcBaseType.Dtc> dtcCodes = keyDataE65.getDtcCodes();
        List<DtcBaseType.EcuErrors> ecuErrors = keyDataE65.getEcuErrors();
        if (!dtcCodes.isEmpty() || !ecuErrors.isEmpty()) {
            Iterator<Object> iter;
            OrderBaseTypeImpl.DtcDataImpl dtcType = new OrderBaseTypeImpl.DtcDataImpl();
            if (keyDataE65.getCountEcuResponding() > -1) {
                dtcType.setCountEcuResponding(keyDataE65.getCountEcuResponding());
            }
            if (keyDataE65.getCountEcuWithErrors() > -1) {
                dtcType.setCountEcuWithErrors(keyDataE65.getCountEcuWithErrors());
            }
            if (!dtcCodes.isEmpty()) {
                dtcType.setDtcCount(keyDataE65.getDtcCount());
                iter = dtcCodes.iterator();
                while (iter.hasNext()) {
                    dtcType.getDtc().add((DtcBaseType.Dtc)iter.next());
                }
            }
            if (!ecuErrors.isEmpty()) {
                DtcBaseType.EcuErrors ecuError;
                iter = ecuErrors.iterator();
                while (iter.hasNext() && (ecuError = (DtcBaseType.EcuErrors)iter.next()).getEcuAddress() != 255) {
                    dtcType.getEcuErrors().add(ecuError);
                }
            }
            List<DtcBaseType.Dtc> dtcs = dtcType.getDtc();
            List<DtcBaseType.EcuErrors> ecus = dtcType.getEcuErrors();
            if (dtcs != null && !dtcs.isEmpty() || ecus != null && !ecus.isEmpty()) {
                orderBase.setDtcData(dtcType);
            }
        }
    }

    private void setServiceInformation(OrderBaseType orderBase, AuftragsbasisGrunddatenIF data, TimeZone timeZone, GKISettings usersettings) {
        orderBase.setServiceInformation(ServiceInformation.createServiceInformationType(data, timeZone, usersettings));
    }

    private void setVehicleKey(OrderBaseType orderBase, AuftragsbasisGrunddatenIF data, TimeZone timeZone, GKISettings usersettings, List<TypeErrorAdapter> warnings) throws GKIException {
        if (data.getSchluesseldaten().getSchluesselVariante().getSchluesselVariante() >= 0) {
            orderBase.setVehicleKey(VehicleKey.createXMLNode(new OrderBaseTypeImpl.VehicleKeyImpl(), data, timeZone, warnings, usersettings.getLocale()));
        }
    }

    private void setVehicle(OrderBaseType orderBase, TimeZone timeZone, AuftragsbasisGrunddatenIF data, GKISettings usersettings) throws GKIException {
        orderBase.setVehicle(Vehicle.createVehicleType(data, timeZone, usersettings));
    }

    private void setServicePackages(OrderBaseType orderBase, AuftragsbasisGrunddatenIF data, TimeZone timezone, GKISettings usersettings) throws GKIException {
        List<BSIServicePaket> servicePackages = data.getServicePackages();
        if (servicePackages != null && servicePackages.size() > 0) {
            OrderBaseTypeImpl.ServicePackageListImpl serviceList = new OrderBaseTypeImpl.ServicePackageListImpl();
            for (BSIServicePaket element : servicePackages) {
                serviceList.getServicePackage().add((ServicePackageEvalType)element.createServicePackageType(usersettings, timezone));
            }
            orderBase.setServicePackageList(serviceList);
        }
    }

    private void setILevelData(OrderBaseType orderBase, ExtendedKeyData extendedKeyData) {
        ILevelData iLevel = extendedKeyData.getILevelData();
        if (iLevel != null) {
            ILevelTypeImpl iLev = new ILevelTypeImpl();
            iLev.setILevelBackup(iLevel.getILevelBackup());
            iLev.setILevelHO(iLevel.getILevelHO());
            iLev.setILevelPlant(iLevel.getIlevelPlant());
            iLev.setNewILevelAvailable(iLevel.isNewiLevelHOAvailable());
            orderBase.setILevel(iLev);
        }
    }

    private void setNaviDVDData(OrderBaseType orderBase, ExtendedKeyData extendedKeyData) {
        NaviDVDData navi = extendedKeyData.getNaviData();
        if (navi != null) {
            NaviDVDTypeImpl naviType = new NaviDVDTypeImpl();
            naviType.setCurrentNaviDVDName(navi.getDescription());
            naviType.setUpdateNeccessary(navi.isSoftwareUpdateNecessary());
            naviType.setAlteredFunctionality(navi.isNewFeatures());
            NaviDVDData currentDvd = navi;
            NaviDVDData successorDVD = null;
            while (true) {
                if (currentDvd.getPartData() != null) {
                    successorDVD = currentDvd.getPartData().getSuccessorDVD();
                }
                if (successorDVD == null) {
                    if (naviType.getCurrentNaviDVDName().equals(currentDvd.getDescription())) break;
                    naviType.setNewNaviDVDName(currentDvd.getDescription());
                    break;
                }
                naviType.setPartNumberOfNewNaviDVD(successorDVD.getPartNumber());
                currentDvd = successorDVD;
            }
            orderBase.setNaviDVD(naviType);
        }
    }

    private void setTopUpInformationEngineOil(OrderBaseType orderBase, ExtendedKeyData extendedKeyData, Locale locale) {
        EngineOil engineOil = extendedKeyData.getTopUpInformationEngineOil();
        if (engineOil != null) {
            OrderBaseTypeImpl.TopUpInformationEngineOilImpl oilType = new OrderBaseTypeImpl.TopUpInformationEngineOilImpl();
            oilType.setCbsIdentifier(String.valueOf(engineOil.getId()));
            oilType.setCode(new Integer(engineOil.getCode()));
            DescriptionTypeImpl descrType = new DescriptionTypeImpl();
            StringBuffer language = new StringBuffer(locale.getLanguage());
            if (locale.getCountry() != null) {
                language.append("-").append(locale.getCountry());
            }
            descrType.setLanguage(language.toString());
            descrType.setValue(engineOil.getDescription());
            oilType.setDescription(descrType);
            if (engineOil.getFlatRateNumber() != null) {
                FlatRateUnitTypeImpl flatType = new FlatRateUnitTypeImpl();
                flatType.setIsLocal(false);
                flatType.setNumber(engineOil.getFlatRateNumber());
                oilType.setFlatRateNumber(flatType);
            }
            orderBase.setTopUpInformationEngineOil(oilType);
        }
    }

    private void setEcuIdentData(OrderBaseType orderBase, Schluesseldaten keyData) {
        EcuIdentDataType ecuIdentData = keyData.getData().getEcuIdentData();
        if (ecuIdentData != null && ecuIdentData.isSetEcuIdent()) {
            orderBase.setEcuIdentData(ecuIdentData);
        }
    }

    private void setDfzKey(OrderBaseType orderBase, Schluesseldaten keyData) {
        DfzKeyType key = keyData.getData().getDfzKey();
        if (key != null) {
            log.debug((Object)("set DFZKey: " + key.getValue()));
            orderBase.setDfzKey(key);
        }
    }

    private void setExtendedAttributes(OrderBaseType orderBase, Schluesseldaten keyData) {
        List<ExtAttribute> extendedAttributes = keyData.getExtAttributes();
        if (extendedAttributes != null && !extendedAttributes.isEmpty()) {
            OrderBaseTypeImpl.ExtendedAttributesImpl extNewAttr = new OrderBaseTypeImpl.ExtendedAttributesImpl();
            List<ExtendedAttributeType> extAttNewList = extNewAttr.getExtendedAttribute();
            for (ExtAttribute extendedAttribute : extendedAttributes) {
                String name = extendedAttribute.getName();
                String value = extendedAttribute.getValue();
                String displayName = extendedAttribute.getDisplayName();
                String displayValue = extendedAttribute.getDisplayValue();
                ExtendedAttributeTypeImpl newExtendedAttribute = new ExtendedAttributeTypeImpl();
                newExtendedAttribute.setName(name);
                newExtendedAttribute.setValue(value);
                if (displayName != null && displayName.length() > 0) {
                    newExtendedAttribute.setDisplayName(displayName);
                }
                if (displayValue != null && displayValue.length() > 0) {
                    newExtendedAttribute.setDisplayValue(displayValue);
                }
                extAttNewList.add(newExtendedAttribute);
            }
            orderBase.setExtendedAttributes(extNewAttr);
        }
    }

    public List<TypeErrorAdapter> v_currentExceptions(List<GKIException> exceptions) {
        ArrayList<TypeErrorAdapter> errors = new ArrayList<TypeErrorAdapter>();
        for (GKIExceptionIF gKIExceptionIF : exceptions) {
            errors.add(new TypeErrorAdapter(gKIExceptionIF));
        }
        return errors;
    }

    private static List<CCMessage> getCCMessages(SchluesseldatenE65 sd) {
        ArrayList<CCMessage> ccMessages = new ArrayList<CCMessage>();
        List<CCMessage> set = sd.getCheckControlIds();
        Map<?, ?> map = sd.getCheckControlMessageTexts();
        for (CCMessage ccSd : set) {
            CCMessage message;
            if (map != null) {
                message = (CCMessage)map.get(ccSd.getId());
                if (message == null) {
                    message = new CCMessage(ccSd.getId(), "", "", ccSd.getTotalDistance());
                }
                message.setTotalDistance(ccSd.getTotalDistance());
            } else {
                message = new CCMessage(ccSd.getId(), "", "", ccSd.getTotalDistance());
            }
            ccMessages.add(message);
        }
        return ccMessages;
    }
}

