/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.apitransformation;

import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.external.SIContractDataIF;
import com.bmw.gki.klib.si_V01_03_00.ServicePackageType;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;

public class SIDataMapper {
    private static Log log = GKILogManager.getInstance().getLogger(SIDataMapper.class);
    private static final SimpleDateFormat dateFormatterDE = new SimpleDateFormat("dd.MM.yyyy");
    private static final SimpleDateFormat dateFormatterISO = new SimpleDateFormat("yyyy-MM-dd");

    public static BSIServicePaket createBSIServicePackage(SIContractDataIF ksdData, String language) {
        log.debug((Object)"create bsiServicePaket");
        String contract = ksdData.getContractType();
        String contractVolume = ksdData.getVertragsArt();
        Integer distance = new Integer((int)ksdData.getDistanceKM());
        Integer duration = new Integer(ksdData.getDuration());
        Date startDate = ksdData.getStartDate();
        Date endDate = ksdData.getEndDate();
        String description = ksdData.getSiDescription();
        String origin = ksdData.getHerkunftKZ();
        BSIServicePaket bsiServicePackage = new BSIServicePaket(contract, duration, distance, startDate, endDate, description, origin, contractVolume);
        bsiServicePackage.setCashUpStartDate(ksdData.getCashUpStartDate());
        bsiServicePackage.setStartKm(ksdData.getStartKm());
        bsiServicePackage.setEndKm(ksdData.getEndKm());
        bsiServicePackage.setSupportSystemSACode(false);
        bsiServicePackage.setSAOptionCode(null);
        return bsiServicePackage;
    }

    public static BSIServicePaket createBSIServicePackage(SIContractDataIF ksdData, String language, boolean isSSISACode) {
        log.debug((Object)"create bsiServicePaket");
        String contract = ksdData.getContractType();
        String contractVolume = ksdData.getVertragsArt();
        Integer distance = new Integer((int)ksdData.getDistanceKM());
        Integer duration = new Integer(ksdData.getDuration());
        Date startDate = ksdData.getStartDate();
        Date endDate = ksdData.getEndDate();
        String description = ksdData.getSiDescription();
        String origin = ksdData.getHerkunftKZ();
        BSIServicePaket bsiServicePackage = new BSIServicePaket(contract, duration, distance, startDate, endDate, description, origin, contractVolume);
        bsiServicePackage.setCashUpStartDate(ksdData.getCashUpStartDate());
        bsiServicePackage.setStartKm(ksdData.getStartKm());
        bsiServicePackage.setEndKm(ksdData.getEndKm());
        if (isSSISACode) {
            String ssICode = ksdData.getSAOptionCode();
            if (ssICode != null && ssICode.trim().length() >= 3) {
                bsiServicePackage.setSAOptionCode(ssICode);
            }
            bsiServicePackage.setSupportSystemSACode(isSSISACode);
        }
        return bsiServicePackage;
    }

    public static BSIServicePaket createBSIServicePackage(ServicePackageType obj) {
        log.debug((Object)"create bsiServicePaket");
        String contract = obj.getContract();
        String contractVolume = obj.getContractVolume();
        Integer distance = new Integer((int)obj.getDistance().getValue());
        Integer duration = new Integer(obj.getDuration().getValue().intValue());
        Date startDate = SIDataMapper.parseDate(obj.getStartDate());
        Date endDate = SIDataMapper.parseDate(obj.getEndDate());
        String description = obj.getDescription() != null ? obj.getDescription().getValue() : null;
        String origin = obj.getOrigin();
        BSIServicePaket bsiServicePackage = new BSIServicePaket(contract, duration, distance, startDate, endDate, description, origin, contractVolume);
        bsiServicePackage.setCashUpStartDate(obj.getCashUpStartDate().toGregorianCalendar().getTime());
        if ("miles".equals(obj.getStartKm().getUnits())) {
            bsiServicePackage.setStartKm(new Double(Utilities.convertToKm(obj.getStartKm().getValue())).intValue());
        } else {
            bsiServicePackage.setStartKm(obj.getStartKm().getValue());
        }
        if ("miles".equals(obj.getEndKm().getUnits())) {
            bsiServicePackage.setEndKm(new Double(Utilities.convertToKm(obj.getEndKm().getValue())).intValue());
        } else {
            bsiServicePackage.setEndKm(obj.getEndKm().getValue());
        }
        return bsiServicePackage;
    }

    private static Date parseDate(String dateString) {
        Date result = null;
        try {
            result = dateFormatterDE.parse(dateString);
        }
        catch (ParseException e) {
            try {
                result = dateFormatterISO.parse(dateString);
            }
            catch (ParseException e2) {
                throw new SystemException("dateformat.invalid", e, new String[]{dateString});
            }
        }
        return result;
    }
}

