/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.ksd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.data.ksd.cbs.BOSValue;
import java.io.Serializable;

public class FgnrKreisInfo
implements Serializable {
    public static final String BEAN_NAME = "fgnrkreisinfo";
    static final long serialVersionUID = 9204538897026085768L;
    public static final int AUTOMATICALLY = 0;
    public static final int MANUALLY = 1;
    private int baustand = 0;
    private String typschluessel = null;
    private String leittyp = null;
    private String modelBezeichnung = "";
    private int leittypEingabeArt = 0;
    private int typschluesselEingabeArt = 0;
    private String engineeringSeries;

    public FgnrKreisInfo() {
    }

    public FgnrKreisInfo(String leittyp, int leittypEingabeArt, int baustand) {
        this();
        this.leittyp = leittyp;
        this.baustand = baustand;
        this.leittypEingabeArt = leittypEingabeArt;
    }

    public FgnrKreisInfo(String leittyp, int leittypEingabeArt, int baustand, String modelBezeichnung) {
        this(leittyp, leittypEingabeArt, baustand);
        this.modelBezeichnung = modelBezeichnung;
    }

    public FgnrKreisInfo(String leittyp, int leittypEingabeArt, int baustand, String modelBezeichnung, String typschluessel, String engineeringSeries) {
        this(leittyp, leittypEingabeArt, baustand, modelBezeichnung);
        this.typschluessel = typschluessel;
        if (engineeringSeries != null) {
            this.engineeringSeries = engineeringSeries.trim();
        }
    }

    public int getBaustand() {
        return this.baustand;
    }

    public String getTypschluessel() {
        return this.typschluessel;
    }

    public String getLeittyp() {
        return this.leittyp;
    }

    public String getModelBezeichnung() {
        return this.modelBezeichnung;
    }

    public void setBaustand(int value) {
        this.baustand = value;
    }

    public void setLeittyp(String value) {
        this.leittyp = value;
    }

    public int getLeittypEingabeArt() {
        return this.leittypEingabeArt;
    }

    public int getTypschluesselEingabeArt() {
        return this.typschluesselEingabeArt;
    }

    public void setLeittypEingabeArt(int leittypEingabeArt) {
        this.leittypEingabeArt = leittypEingabeArt;
    }

    public void validierenLeittypBaustand() throws GKIException {
        try {
            BOSValue.testAndGetBaustand(String.valueOf(this.baustand), "manuelle Eingabe", 1);
        }
        catch (Exception e) {
            throw new GKIException("schluesselAnnahme.baustand.ungueltig", e);
        }
        BOSValue.testAndGetTypschluessel(String.valueOf(this.leittyp));
    }

    public String getEngineeringSeries() {
        return this.engineeringSeries;
    }

    public void setEngineeringSeries(String engineeringSeries) {
        this.engineeringSeries = engineeringSeries;
    }

    public void setModelBezeichnung(String modelBezeichnung) {
        this.modelBezeichnung = modelBezeichnung;
    }

    public void setTypschluessel(String typschluessel) {
        this.typschluessel = typschluessel;
    }

    public void setTypschluesselEingabeArt(int typschluesselEingabeArt) {
        this.typschluesselEingabeArt = typschluesselEingabeArt;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FgnrKreisInfo:");
        buffer.append(" baustand: ");
        buffer.append(this.baustand);
        buffer.append(" typschluessel: ");
        buffer.append(this.typschluessel);
        buffer.append(" leittyp: ");
        buffer.append(this.leittyp);
        buffer.append(" modelBezeichnung: ");
        buffer.append(this.modelBezeichnung);
        buffer.append(" leittypEingabeArt: ");
        buffer.append(this.leittypEingabeArt);
        buffer.append(" typschluesselEingabeArt: ");
        buffer.append(this.typschluesselEingabeArt);
        buffer.append(" engineeringSeries: ");
        buffer.append(this.engineeringSeries);
        buffer.append("]");
        return buffer.toString();
    }
}

