/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.ksd.cbs;

import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;

public class BOSValue {
    public static int testAndGetInt(String value, int minLength, int maxLength, String path, int lineNr) throws KSDPropertyFormatException {
        try {
            value = value.trim();
            if (value.length() < minLength || value.length() > maxLength) {
                throw new KSDPropertyFormatException("Value <" + value + ">, invalid length (" + minLength + ", " + maxLength + "), path: " + path + ", line: " + lineNr);
            }
            for (int i = 0; i < value.length(); ++i) {
                char zeichen = value.charAt(i);
                if (Character.isDigit(zeichen)) continue;
                throw new KSDPropertyFormatException("Value <" + value + "> has to consist out of numbers, path: " + path + ", line: " + lineNr);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new KSDPropertyFormatException("Value <" + value + ">, path: " + path + ", line: " + lineNr);
        }
    }

    public static String testAndGetString(String value, int minLength, int maxLength, String path, int lineNr) throws KSDPropertyFormatException {
        if ((value = value.trim()).length() < minLength || value.length() > maxLength) {
            throw new KSDPropertyFormatException("Value <" + value + ">, invalid length (" + minLength + ", " + maxLength + "), path: " + path + ", line: " + lineNr);
        }
        return value;
    }

    public static int testAndGetBaustand(String value, String path, int lineNr) throws KSDPropertyFormatException {
        try {
            value = value.trim();
            if (value.length() != 6) {
                throw new KSDPropertyFormatException("Baujahr <" + value + "> must have 6 digits, path: " + path + ", line: " + lineNr);
            }
            for (int i = 0; i < value.length(); ++i) {
                char zeichen = value.charAt(i);
                if (Character.isDigit(zeichen)) continue;
                throw new KSDPropertyFormatException("Baujahr <" + value + "> must have 6 digits, path: " + path + ", line: " + lineNr);
            }
            if (value.equals("000000") || value.equals("999999")) {
                return Integer.parseInt(value);
            }
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(4, 6));
            if (year < 1900 || year > 2150) {
                throw new KSDPropertyFormatException("Baujahr <" + value + ">, year must be between 1900 and 2150, path: " + path + ", line: " + lineNr);
            }
            if (month < 1 || month > 12) {
                throw new KSDPropertyFormatException("Baujahr <" + value + ">, invalid month " + ", path: " + path + ", line: " + lineNr);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new KSDPropertyFormatException("Value <" + value + ">, path: " + path + ", line: " + lineNr);
        }
    }

    public static char testAndGetChar(String value, String validChars, String path, int lineNr) throws KSDPropertyFormatException {
        if ((value = value.trim()).length() != 1) {
            throw new KSDPropertyFormatException("Value <" + value + ">, invalid length (1), path: " + path + ", line: " + lineNr);
        }
        if (validChars.indexOf(value) == -1) {
            throw new KSDPropertyFormatException("Value <" + value + "> not in set <" + validChars + ">, path: " + path + ", line: " + lineNr);
        }
        return value.charAt(0);
    }

    public static String testAndGetTypschluessel(String value) throws KSDPropertyFormatException {
        if ((value = value.trim()).length() != 4) {
            throw new KSDPropertyFormatException("schluesselAnnahme.leittyp.ungueltig");
        }
        if (!(Character.isLetter(value.charAt(0)) && Character.isLetter(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)))) {
            throw new KSDPropertyFormatException("schluesselAnnahme.leittyp.ungueltig");
        }
        return value;
    }
}

