/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.ksd.cbs;

import com.bmw.gki.logging.GKILogManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class SSIFormula
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ENGINE_DIESEL = "D";
    private static final String ENGINE_ASTERISK = "*";
    private final Log log = GKILogManager.getInstance().getLogger(SSIFormula.class);
    private String saOption;
    private String engineType;
    private String cbsId;
    private String linkedId;
    private String period;
    private String formula;
    private int psc_counter = 0;
    private int asc_counter = 0;
    private String countries;
    private List<String> countryList = new ArrayList<String>();
    public static final String ASC = "ASC";
    public static final String PSC = "PSC";

    public SSIFormula(String saOption, String engineType, String cbsId, String linkedId, String period, String formula, String countries) {
        this.saOption = saOption;
        this.engineType = engineType;
        this.cbsId = cbsId;
        this.linkedId = linkedId;
        this.period = period;
        this.formula = formula;
        this.countries = countries;
        this.parseFormula();
        this.parseCountries();
    }

    public String getCountries() {
        return this.countries;
    }

    public String getSaOption() {
        return this.saOption;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public String getCbsId() {
        return this.cbsId;
    }

    public String getLinkedId() {
        return this.linkedId;
    }

    public String getPeriod() {
        return this.period;
    }

    public String getFormula() {
        return this.formula;
    }

    public static boolean checkEngineType(String engineType) {
        return engineType.equals(ENGINE_DIESEL) || engineType.equals(ENGINE_DIESEL) || engineType.equals(ENGINE_ASTERISK);
    }

    public static boolean checkPeriod(String period) {
        return period.equals(ASC) || period.equals(PSC);
    }

    public int getPSC() {
        return this.psc_counter;
    }

    public int getASC() {
        return this.asc_counter;
    }

    private void parseFormula() {
        int idx = 0;
        while (idx < this.formula.length()) {
            char character = this.formula.charAt(idx);
            if (character == '+' || character == '-') {
                String next_formula = null;
                boolean skip = false;
                for (int idx_next = idx + 1; idx_next < this.formula.length(); ++idx_next) {
                    char character_next = this.formula.charAt(idx_next);
                    if (character_next != '+' && character_next != '-') continue;
                    if (idx_next > idx + 1) {
                        next_formula = this.formula.substring(idx + 1, idx_next);
                        idx = idx_next;
                        break;
                    }
                    skip = true;
                    idx = idx_next;
                    break;
                }
                if (next_formula == null && !skip) {
                    next_formula = this.formula.substring(idx + 1);
                    idx = this.formula.length() + 1;
                }
                if (next_formula == null) continue;
                if (next_formula.equals("P")) {
                    if (character == '+') {
                        ++this.psc_counter;
                        continue;
                    }
                    --this.psc_counter;
                    continue;
                }
                if (next_formula.indexOf("P") > 0 && next_formula.length() > 1) {
                    int pIndex = next_formula.indexOf("P");
                    String subStr = next_formula.substring(0, pIndex);
                    try {
                        Integer multVal = new Integer(subStr);
                        if (character == '+') {
                            this.psc_counter += multVal.intValue();
                        }
                        if (character != '-') continue;
                        this.psc_counter -= multVal.intValue();
                    }
                    catch (NumberFormatException e) {
                        this.log.error((Object)("Invalid formula: " + this.formula + " - " + e.getMessage()));
                    }
                    continue;
                }
                try {
                    Integer value = new Integer(next_formula);
                    if (character == '+') {
                        this.asc_counter += value.intValue();
                        continue;
                    }
                    this.asc_counter -= value.intValue();
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)("Invalid formula: " + this.formula + " - " + e.getMessage()));
                }
                continue;
            }
            ++idx;
        }
    }

    private void parseCountries() {
        StringTokenizer st = new StringTokenizer(this.countries, ",");
        while (st.hasMoreTokens()) {
            this.countryList.add(st.nextToken());
        }
        this.countryList = Collections.unmodifiableList(this.countryList);
    }

    public boolean isValidCountry(String country) {
        return ENGINE_ASTERISK.equals(this.countries) || this.countryList.contains(country);
    }

    public static void main(String[] args) {
        SSIFormula formel = new SSIFormula("708KK", ENGINE_ASTERISK, "00001", "00018", PSC, "+100P-10P", ENGINE_ASTERISK);
        System.out.println("PSC: " + formel.getPSC());
        System.out.println("ASC: " + formel.getASC());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SSIFormula:");
        buffer.append(" saOption: ");
        buffer.append(this.saOption);
        buffer.append(" engineType: ");
        buffer.append(this.engineType);
        buffer.append(" cbsId: ");
        buffer.append(this.cbsId);
        buffer.append(" linkedId: ");
        buffer.append(this.linkedId);
        buffer.append(" period: ");
        buffer.append(this.period);
        buffer.append(" formula: ");
        buffer.append(this.formula);
        buffer.append(" psc_counter: ");
        buffer.append(this.psc_counter);
        buffer.append(" asc_counter: ");
        buffer.append(this.asc_counter);
        buffer.append(" countries: ");
        buffer.append(this.countries);
        buffer.append("]");
        return buffer.toString();
    }
}

