/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.orderbase;

import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.BSIBerechnungsbasis;
import com.bmw.gki.klib.api.Schluesseldaten;
import com.bmw.gki.klib.api.exception.ToManyActiveBasicSIPackagesException;
import com.bmw.gki.klib.data.ksd.FgnrKreisInfo;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.data.orderbase.BOSAWPosition;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class AuftragsbasisGrunddaten
implements Serializable,
AuftragsbasisGrunddatenIF {
    private static final long serialVersionUID = 1L;
    private Schluesseldaten schluesseldaten;
    private FgnrKreisInfo lnkFgnrKreisInfo;
    private BSIServicePaket lnkBSIServicePaket;
    private List<BSIServicePaket> servicePackages;
    private boolean flagCBSDataAvailable;
    private boolean flagForeignVehicle;
    private boolean flagFlatRatesAvailable;
    private Collection<BOSAWPosition> bosAwPositions;

    @Override
    public boolean isAktivesServicePaket() {
        if (this.getBSIServicePaket() != null) {
            return this.getBSIServicePaket().isAktiv();
        }
        return false;
    }

    public void setBSIServicePaket(BSIServicePaket bsiServicePaket) {
        this.lnkBSIServicePaket = bsiServicePaket;
    }

    @Override
    public void setServicePackages(List<BSIServicePaket> servicePackage) throws ToManyActiveBasicSIPackagesException {
        String[] contractVolumePriority = new String[]{"B", "S", "F", "A", "C"};
        for (int i = 0; i < contractVolumePriority.length && this.getBSIServicePaket() == null; ++i) {
            this.checkBsiServicePaket(contractVolumePriority[i], servicePackage);
        }
        this.servicePackages = servicePackage;
    }

    private void checkBsiServicePaket(String contractVolumeType, List<BSIServicePaket> servicePackage) throws ToManyActiveBasicSIPackagesException {
        for (BSIServicePaket element : servicePackage) {
            if (!element.isAktiv() || !element.getContractVolume().equals(contractVolumeType) || this.getBSIServicePaket() != null) continue;
            this.setBSIServicePaket(element);
        }
    }

    @Override
    public boolean isUebergabedurchsicht() {
        if (this.getSchluesseldaten().isE65upward()) {
            return ((SchluesseldatenE65)this.getSchluesseldaten()).getBOSDaten().isUebergabedurchsicht();
        }
        return false;
    }

    @Override
    public boolean nichtVerrechenbar() {
        if (this.isAktivesServicePaket()) {
            for (int i = 0; i < this.bosAwPositions.size(); ++i) {
                BOSAWPosition pos = new ArrayList<BOSAWPosition>(this.bosAwPositions).get(i);
                if (!pos.isAusserhalbServicePaketUmfang()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public BSIBerechnungsbasis getBSIBerechnungsbasis() {
        return this.lnkBSIServicePaket == null ? null : this.lnkBSIServicePaket.getBerechnungsbasis();
    }

    @Override
    public Object[] getBOSAWPositionLowestRestwegValue(int typ, boolean isMiles) {
        BOSAWPosition bosp = null;
        Object einheit = null;
        Date keyUpdateDate = null;
        Schluesseldaten sd = this.getSchluesseldaten();
        int shortTimeDrivingPerformance = 0;
        Vector<BOSAWPosition> values = this.getBOSAWPositionValuesTyp(typ, isMiles);
        if (values == null || values.size() == 0) {
            return new Object[]{null, null, null};
        }
        Integer value = new Integer(Integer.MAX_VALUE);
        if (sd != null) {
            keyUpdateDate = sd.getLetzteAktualisierung() != null ? sd.getLetzteAktualisierung() : sd.getEinleseDatum();
        }
        BOSAWPosition bosaw = null;
        for (int i = 0; i < values.size(); ++i) {
            long forecastDistance;
            bosaw = values.elementAt(i);
            if (!bosaw.getSelectionFlag().booleanValue()) {
                shortTimeDrivingPerformance = ((SchluesseldatenE65)this.getSchluesseldaten()).getBOSDaten().getShortTimeDrivingPerformance();
                if (bosaw.getRestlauf(isMiles, keyUpdateDate, shortTimeDrivingPerformance, 2).getEarlistRemainingValue() >= value) continue;
                value = bosaw.getRestlauf(isMiles, keyUpdateDate, shortTimeDrivingPerformance, 2).getEarlistRemainingValue();
                bosp = bosaw;
                continue;
            }
            if (bosaw.isUebergabedurchsicht()) continue;
            if (typ == 2) {
                int forecasttime;
                if (bosaw.getBOSPosition().getForecastRemainingTime() == null || (forecasttime = bosaw.getBOSPosition().getForecastRemainingTime().intValue() * 30) >= value) continue;
                value = new Integer(forecasttime);
                bosp = bosaw;
                continue;
            }
            if (bosaw.getBOSPosition().getForecastRemainingDistance() == null || (forecastDistance = (long)(bosaw.getBOSPosition().getForecastRemainingDistance().intValue() * 1000)) <= 0L || forecastDistance >= (long)value.intValue()) continue;
            value = new Integer((int)forecastDistance);
            bosp = bosaw;
        }
        if (typ == 2 && bosp != null) {
            return new Object[]{bosp, bosp.getCBSDatum(this.getSchluesseldaten(), keyUpdateDate, shortTimeDrivingPerformance), einheit};
        }
        return new Object[]{bosp, bosp == null ? null : value, einheit};
    }

    @Override
    public Vector<BOSAWPosition> getBOSAWPositionValuesTyp(int typ, boolean isMiles) {
        Vector<BOSAWPosition> awPositions = new Vector<BOSAWPosition>();
        Date keyUpdateDate = null;
        Schluesseldaten sd = this.getSchluesseldaten();
        if (sd != null) {
            keyUpdateDate = sd.getLetzteAktualisierung() != null ? sd.getLetzteAktualisierung() : sd.getEinleseDatum();
        }
        if (this.getBosAwPositions() != null) {
            for (BOSAWPosition pos : this.getBosAwPositions()) {
                if (pos.getServiceZaehler() == 0 && pos.hasZuVerknuepfendeBosPosition()) continue;
                if (pos.isCombinedCBS()) {
                    int shortTimeDrivingPerformance = ((SchluesseldatenE65)this.getSchluesseldaten()).getBOSDaten().getShortTimeDrivingPerformance();
                    int zielterminEinheit = pos.determineEarliestDueTypeForCombinedCBS(keyUpdateDate, shortTimeDrivingPerformance);
                    if (zielterminEinheit != typ) continue;
                    awPositions.add(pos);
                    continue;
                }
                if (pos.isDueDate()) {
                    if (typ != 2) continue;
                    awPositions.add(pos);
                    continue;
                }
                if (pos.getEinheitRestlaufleistung() != typ) continue;
                awPositions.add(pos);
            }
        }
        return awPositions;
    }

    @Override
    public boolean isFlagCBSDataAvailable() {
        return this.flagCBSDataAvailable;
    }

    @Override
    public void setFlagCBSDataAvailable(boolean flagCBSDataAvailable) {
        this.flagCBSDataAvailable = flagCBSDataAvailable;
    }

    @Override
    public boolean isFlagForeignVehicle() {
        return this.flagForeignVehicle;
    }

    @Override
    public void setFlagForeignVehicle(boolean flagForeignVehicle) {
        this.flagCBSDataAvailable = flagForeignVehicle;
    }

    @Override
    public boolean isFlagFlatRatesAvailable() {
        return this.flagFlatRatesAvailable;
    }

    @Override
    public void setFlagFlatRatesAvailable(boolean flagFlatRatesAvailable) {
        this.flagCBSDataAvailable = flagFlatRatesAvailable;
    }

    @Override
    public void setSchluesseldaten(Schluesseldaten schluesseldaten) {
        this.schluesseldaten = schluesseldaten;
    }

    public AuftragsbasisGrunddaten(Schluesseldaten key, FgnrKreisInfo fgnr) {
        this.schluesseldaten = key;
        this.lnkFgnrKreisInfo = fgnr;
    }

    @Override
    public BSIServicePaket getBSIServicePaket() {
        return this.lnkBSIServicePaket;
    }

    @Override
    public FgnrKreisInfo getFgnrKreisInfo() {
        return this.lnkFgnrKreisInfo;
    }

    @Override
    public Schluesseldaten getSchluesseldaten() {
        return this.schluesseldaten;
    }

    @Override
    public List<BSIServicePaket> getServicePackages() {
        return this.servicePackages;
    }

    @Override
    public Collection<BOSAWPosition> getBosAwPositions() {
        return this.bosAwPositions;
    }

    @Override
    public void setBosAwPositions(Collection<BOSAWPosition> bosAwPositions) {
        this.bosAwPositions = bosAwPositions;
    }

    public void setLnkFgnrKreisInfo(FgnrKreisInfo lnkFgnrKreisInfo) {
        this.lnkFgnrKreisInfo = lnkFgnrKreisInfo;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AuftragsbasisGrunddaten:");
        buffer.append(" schluesseldaten: ");
        buffer.append(this.schluesseldaten);
        buffer.append(" lnkFgnrKreisInfo: ");
        buffer.append(this.lnkFgnrKreisInfo);
        buffer.append(" lnkBSIServicePaket: ");
        buffer.append(this.lnkBSIServicePaket);
        buffer.append(" servicePackages: ");
        buffer.append(this.servicePackages);
        buffer.append(" flagCBSDataAvailable: ");
        buffer.append(this.flagCBSDataAvailable);
        buffer.append(" flagForeignVehicle: ");
        buffer.append(this.flagForeignVehicle);
        buffer.append(" flagFlatRatesAvailable: ");
        buffer.append(this.flagFlatRatesAvailable);
        buffer.append(" bosAwPositions: ");
        buffer.append(this.bosAwPositions);
        buffer.append("]");
        return buffer.toString();
    }
}

