/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.orderbase;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.BosNotFoundException;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.orderbase.BOSPosition;
import com.bmw.gki.logging.GKILogManager;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class BOSHeaderDaten
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = GKILogManager.getInstance().getLogger(BOSHeaderDaten.class);
    private KeyDataAnalysedType.CbsBaseData cbsData;
    private boolean isMiles = false;
    private int integrationsstand;
    private boolean istGbOderUsCodiert;
    private List<BOSPosition> bosPositionen = new ArrayList<BOSPosition>();
    private boolean isUebergabedurchsicht;

    public BOSHeaderDaten(KeyDataAnalysedType data, boolean istGbOderUsCodiert, boolean istIntegrationsStand) {
        this.istGbOderUsCodiert = istGbOderUsCodiert;
        this.integrationsstand = istIntegrationsStand ? 1 : 0;
        this.cbsData = data.getCbsBaseData();
    }

    public int getFahrleistungLangzeitWert() {
        return this.cbsData != null && this.cbsData.isSetLongTimeDrivingPerformance() ? this.cbsData.getLongTimeDrivingPerformance() : 0;
    }

    public boolean isUebergabedurchsicht() {
        return this.isUebergabedurchsicht;
    }

    public void entferneBosPositionenBeiUebergabedurchsicht() {
        assert (this.bosPositionen != null) : "bosPositionen == null!";
        assert (this.getBosCount() == this.bosPositionen.size()) : "bosCount <> bosPositionen.size()";
        BOSPosition pos = null;
        for (int i = this.bosPositionen.size() - 1; i >= 0; --i) {
            pos = this.bosPositionen.get(i);
            if (!pos.isUebergabeDurchsicht()) continue;
            this.isUebergabedurchsicht = true;
            break;
        }
        log.debug((Object)("bosHeaderDaten isUebergabedurchsicht " + this.isUebergabedurchsicht));
        if (this.isUebergabedurchsicht) {
            log.info((Object)"BosHeaderDaten: entferne BosPositionen bei Uebergabedurchsicht!");
            this.bosPositionen = new Vector<BOSPosition>();
            this.bosPositionen.add(pos);
        }
    }

    private int getBosCount() {
        return this.cbsData != null && this.cbsData.isSetCbsCount() ? this.cbsData.getCbsCount() : 0;
    }

    public void erzeugeBosPositionenCBS4(KeyDataAnalysedType data) throws GKIException {
        BosNotFoundException bosNotFoundException = null;
        KeyDataAnalysedType.CbsBaseData cbsBaseData = data.getCbsBaseData();
        try {
            this.erzeugeBosPositionen(data, (cbsBaseData.isSetDisplayUnit() ? cbsBaseData.getDisplayUnit() : 0) == 1);
        }
        catch (BosNotFoundException e) {
            bosNotFoundException = e;
        }
        KeyDataAnalysedType.CbsBaseData.LegalInspectionDates legalInspectionDates = cbsBaseData.getLegalInspectionDates();
        if (legalInspectionDates != null) {
            int dueDateMonthHU = legalInspectionDates.getMonthHU();
            int dueDateYearHU = legalInspectionDates.getYearHU();
            int cbsStateHU = legalInspectionDates.getColorHU();
            if (dueDateMonthHU != 0 && dueDateMonthHU != 15 && dueDateYearHU != 0 && dueDateYearHU != 63) {
                this.bosPositionen.add(new BOSPosition(32, dueDateYearHU, dueDateMonthHU, cbsStateHU));
            }
            int dueDateMonthAU = legalInspectionDates.getMonthAU();
            int dueDateYearAU = legalInspectionDates.getYearAU();
            int cbsStateAU = legalInspectionDates.getColorAU();
            if (dueDateMonthAU != 0 && dueDateMonthAU != 15 && dueDateYearAU != 0 && dueDateYearAU != 63) {
                this.bosPositionen.add(new BOSPosition(33, dueDateYearAU, dueDateMonthAU, cbsStateAU));
            }
        }
        if (bosNotFoundException != null) {
            throw bosNotFoundException;
        }
    }

    public void erzeugeBosPositionen(KeyDataAnalysedType data, boolean isMilesSet) throws GKIException {
        KeyDataAnalysedType.CbsBaseData cbsBaseData;
        this.isMiles = false;
        if (this.getCbsVariant() < 2) {
            if (this.isIntegrationsStand685()) {
                if (this.getDisplayUnit() == 1) {
                    this.isMiles = true;
                }
            } else if (this.istGbOderUsCodiert) {
                this.isMiles = true;
            }
        }
        if ((cbsBaseData = data.getCbsBaseData()) != null) {
            BosNotFoundException bosNotFoundException = null;
            List<KeyDataAnalysedType.CbsBaseData.ConditionBasedService> services = cbsBaseData.getConditionBasedService();
            for (KeyDataAnalysedType.CbsBaseData.ConditionBasedService serviceData : services) {
                if (!serviceData.isSetCbsId()) {
                    bosNotFoundException = new BosNotFoundException("CBS id not set");
                    break;
                }
                try {
                    this.bosPositionen.add(new BOSPosition(serviceData, this.isMiles));
                }
                catch (BosNotFoundException e) {
                    bosNotFoundException = e;
                }
            }
            if (bosNotFoundException != null) {
                throw bosNotFoundException;
            }
        }
    }

    public int getDisplayUnit() {
        return this.cbsData != null && this.cbsData.isSetDisplayUnit() ? this.cbsData.getDisplayUnit() : 0;
    }

    public int getLaenderCoding() {
        return this.cbsData != null && this.cbsData.isSetDisplayUnit() ? this.cbsData.getDisplayUnit() : 0;
    }

    public boolean isIntegrationsStand685() {
        return this.integrationsstand > 0;
    }

    public int getShortTimeDrivingPerformance() {
        return this.cbsData != null && this.cbsData.isSetShortTimeDrivingPerformance() ? this.cbsData.getShortTimeDrivingPerformance() : 0;
    }

    public Collection<BOSPosition> getBosPositionen() {
        return this.bosPositionen;
    }

    public BOSPosition getBosPosition(BOSNummer nummer) {
        for (BOSPosition position : this.bosPositionen) {
            if (!position.getBosNr().equals(nummer)) continue;
            return position;
        }
        return null;
    }

    public BigDecimal getCodeCBSHUAU() {
        return new BigDecimal(this.cbsData != null && this.cbsData.isSetCodeCBSYellowHUAU() ? this.cbsData.getCodeCBSYellowHUAU() : 0);
    }

    public BigDecimal getCodeCBSYellow() {
        return new BigDecimal(this.cbsData != null && this.cbsData.isSetCodeCBSYellow() ? this.cbsData.getCodeCBSYellow() : 0);
    }

    public int getStatusTeleservice() {
        if (this.cbsData != null && this.cbsData.getStatusTeleservice() != null) {
            return this.cbsData.getStatusTeleservice();
        }
        return 0;
    }

    public int getCbsCount() {
        if (this.cbsData != null && this.cbsData.getCbsCount() != null) {
            return this.cbsData.getCbsCount();
        }
        return 0;
    }

    public int getCbsVariant() {
        if (this.cbsData != null && this.cbsData.getCbsVariant() != null) {
            return this.cbsData.getCbsVariant();
        }
        return 0;
    }

    public int getYellowServiceDistance() {
        if (this.cbsData != null && this.cbsData.getYellowServiceDistance() != null) {
            return this.cbsData.getYellowServiceDistance();
        }
        return 0;
    }

    public int getYellowServiceTime() {
        if (this.cbsData != null && this.cbsData.getYellowServiceTime() != null) {
            return this.cbsData.getYellowServiceTime();
        }
        return 0;
    }

    public boolean isMilesWrittenKey() {
        return this.isMiles;
    }
}

