/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.orderbase;

import com.bmw.gki.klib.api.exception.SIADataException;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.logging.GKILogManager;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;

public class LEDStand
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = GKILogManager.getInstance().getLogger(LEDStand.class);
    private boolean[] grueneLampen;
    private boolean gelbeLampe;
    private boolean roteLampe;

    public LEDStand(KeyDataAnalysedType led) throws SIADataException {
        KeyDataAnalysedType.SiaData.Led theLed = led.getSiaData().getLed();
        List<Boolean> gruene = theLed.getLedGreen();
        int size = gruene.size();
        if (size > 5) {
            SIADataException exception = new SIADataException("more lights than expected (" + size + ")");
            log.info((Object)("exception code: " + exception.getErrorCode() + " message: " + exception.getFormatedMessage()));
        }
        this.grueneLampen = new boolean[5];
        int i = 0;
        for (Boolean lampe : gruene) {
            this.grueneLampen[i] = lampe;
            ++i;
        }
        this.roteLampe = theLed.isLedRed();
        this.gelbeLampe = theLed.isLedYellow();
    }

    public LEDStand() {
        this.grueneLampen = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            this.grueneLampen[i] = false;
        }
        this.roteLampe = false;
        this.gelbeLampe = false;
    }

    public boolean[] getGrueneLampen() {
        return this.grueneLampen;
    }

    public boolean getGelbeLampe() {
        return this.gelbeLampe;
    }

    public boolean getRoteLampe() {
        return this.roteLampe;
    }

    public boolean isYellow() {
        return this.gelbeLampe;
    }

    public boolean isRed() {
        return this.roteLampe;
    }

    public int countGreen() {
        int count = 0;
        for (int i = 0; i < 5; ++i) {
            if (!this.grueneLampen[i]) continue;
            ++count;
        }
        return count;
    }
}

