/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.orderbase;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.Fahreigenschaft;
import com.bmw.gki.klib.api.SchluesselVariante;
import com.bmw.gki.klib.api.Schluesseldaten;
import com.bmw.gki.klib.api.exception.BosNotFoundException;
import com.bmw.gki.klib.api.exception.RegistrationDateException;
import com.bmw.gki.klib.api.exception.WrongVinFormatException;
import com.bmw.gki.klib.api_current.DtcBaseType;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.api_current.StateInformationKeyType;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.GKICalendar;
import com.bmw.gki.klib.data.apiparams.KeyDataAnalysed;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.ksd.cc.CCMessage;
import com.bmw.gki.klib.data.ksd.engineoil.EngineOil;
import com.bmw.gki.klib.data.ksd.ilevel.ILevelKeyData;
import com.bmw.gki.klib.data.ksd.key.FgnrPraefix;
import com.bmw.gki.klib.data.orderbase.BOSHeaderDaten;
import com.bmw.gki.klib.data.orderbase.BOSPosition;
import com.bmw.gki.klib.data.orderbase.ExtendedKeyData;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.FgnrPraefixReader;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class SchluesseldatenE65
extends Schluesseldaten
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Log log = GKILogManager.getInstance().getLogger(SchluesseldatenE65.class);
    private List<DtcBaseType.Dtc> dtcCodes;
    private List<DtcBaseType.EcuErrors> ecuErrors;
    private int dtcCount;
    private int dtcMax;
    private int countEcuResponding = -1;
    private int countEcuWithErrors = -1;
    private boolean largeKey = false;
    private boolean isMilesSet = false;
    private int versionsKennung;
    private int datenKonsistenz;
    private Date erstZulassung;
    private Double aussentemperatur;
    private double batteriespannung;
    private double tankinhalt;
    private double kuehlmitteltemperatur;
    private BOSHeaderDaten bosDaten;
    private int laenderkodierungKombi;
    private List<CCMessage> checkControlIds;
    private Map<?, ?> checkControlMessageTexts;
    private static final int US_CODED = 2;
    private static final int GB_CODED = 4;
    private static final int AUS_CODED = 6;
    protected static final int CHECKCONTROL_END_OFFSET = 191;
    private ExtendedKeyData extendedKeyData;

    public SchluesseldatenE65(KeyDataAnalysedType data, GKISettings settings, SchluesselVariante schluesselVariante) throws GKIException {
        super(data, schluesselVariante);
        this.initialisieren(data, settings);
    }

    protected void analysiereDTC(KeyDataAnalysedType data, GKISettings settings) {
        this.dtcCodes = new ArrayList<DtcBaseType.Dtc>();
        this.ecuErrors = new ArrayList<DtcBaseType.EcuErrors>();
        DtcBaseType dtcData = data.getDtcData();
        if (dtcData != null) {
            this.dtcCount = dtcData.isSetDtcCount() ? dtcData.getDtcCount() : 0;
            if (dtcData.isSetCountEcuWithErrors() && dtcData.getCountEcuWithErrors() > 0 && dtcData.getCountEcuWithErrors() != 255) {
                this.countEcuWithErrors = dtcData.getCountEcuWithErrors();
            }
            if (dtcData.isSetCountEcuResponding() && dtcData.getCountEcuResponding() > 0 && dtcData.getCountEcuResponding() != 255) {
                this.countEcuResponding = dtcData.getCountEcuResponding();
            }
            if (dtcData.getDtc() != null && dtcData.getDtc().size() > 0) {
                DtcBaseType.Dtc dtcEntry;
                List<DtcBaseType.Dtc> dtcList = dtcData.getDtc();
                Iterator<Object> iter = dtcList.iterator();
                while (iter.hasNext() && !(dtcEntry = (DtcBaseType.Dtc)iter.next()).getValue().equals(new Integer(65535).toString())) {
                    this.getDtcCodes().add(dtcEntry);
                }
            }
            if (dtcData.getEcuErrors() != null && dtcData.getEcuErrors().size() > 0) {
                List<DtcBaseType.EcuErrors> ecuErrors = dtcData.getEcuErrors();
                for (DtcBaseType.EcuErrors ecuError : ecuErrors) {
                    if (ecuError.getEcuAddress() <= 0 && ecuError.getErrorCount() <= 0) continue;
                    this.getEcuErrors().add(ecuError);
                }
            }
        }
    }

    public List<DtcBaseType.EcuErrors> getEcuErrors() {
        return this.ecuErrors;
    }

    public List<DtcBaseType.Dtc> getDtcCodes() {
        return this.dtcCodes;
    }

    public int getDtcCount() {
        return this.dtcCount;
    }

    public int getDtcMax() {
        return this.dtcMax;
    }

    public int getCountEcuResponding() {
        return this.countEcuResponding;
    }

    public int getCountEcuWithErrors() {
        return this.countEcuWithErrors;
    }

    protected void initialisieren(KeyDataAnalysedType data, GKISettings settings) throws GKIException {
        this.isMilesSet = settings.isMiles();
        if (this.getSchluesselVariante().usesFeld(4)) {
            this.typschluessel = data.getVehicle().getVin();
        }
        if (this.getSchluesselVariante().usesFeld(5)) {
            this.polsterCode = data.getVehicle().getUpholstery();
            if (!this.checkAlphaNumeric(this.polsterCode)) {
                this.polsterCode = "****";
            }
        }
        if (this.getSchluesselVariante().usesFeld(6)) {
            this.farbCode = data.getVehicle().getColourCode();
            if (this.farbCode == null || !this.checkAlphaNumeric(this.farbCode)) {
                this.farbCode = "****";
            }
        }
        this.versionsKennung = data.getKeyBaseData().getKeyVariant();
        this.datenKonsistenz = data.getKeyBaseData().getDataConsistence3();
        this.laenderkodierungKombi = data.getVehicle().isSetTypeCountry() ? data.getVehicle().getTypeCountry() : 0;
        this.tankinhalt = data.getVehicle().getStateInformation().getMiscAttributes().isSetTankLevel() ? data.getVehicle().getStateInformation().getMiscAttributes().getTankLevel() : 0.0;
        double d = this.kuehlmitteltemperatur = data.getVehicle().getStateInformation().getMiscAttributes().isSetCoolantTemperature() ? data.getVehicle().getStateInformation().getMiscAttributes().getCoolantTemperature() : 0.0;
        if (data.getVehicle().getStateInformation().getMiscAttributes().isSetAirTemperature()) {
            this.aussentemperatur = new Double(data.getVehicle().getStateInformation().getMiscAttributes().getAirTemperature());
        }
        this.batteriespannung = data.getVehicle().getStateInformation().getMiscAttributes().isSetBatteryVoltage() ? data.getVehicle().getStateInformation().getMiscAttributes().getBatteryVoltage() : 0.0;
        this.setErstzulassung(data);
        this.setUpdateDate(data);
        if (this.getSchluesselVariante().usesFeld(1) || Einstellungen.getDefaultInstance().getEpcFlag()) {
            this.kmStand = data.getVehicle().getStateInformation().getTotalDistance();
        }
        if (this.getSchluesselVariante().usesFeld(3) || Einstellungen.getDefaultInstance().getEpcFlag()) {
            this.fgnr = data.getVehicle().getVin();
        }
        if (this.fgnr != null) {
            try {
                FgnrPraefix praefix = FgnrPraefixReader.find(this.fgnr.substring(0, 3));
                if (praefix != null) {
                    this.marke = praefix.getMarke();
                }
            }
            catch (GKIException e) {
                String message = "VIN Praefix not found";
                WrongVinFormatException wve = new WrongVinFormatException(message, e);
                this.log.info((Object)("error code: " + wve.getErrorCode() + " " + message));
                throw wve;
            }
        }
        this.bosDaten = new BOSHeaderDaten(data, this.pruefeUsOderGbCodiert(), this.pruefeIntegrationsStand685(data));
        this.interpretCheckControl();
        if (this.isLargeKey(data)) {
            this.largeKey = true;
            this.initialisierenExtendedKeyData(data, settings);
        }
        this.analysiereDTC(data, settings);
    }

    protected boolean isLargeKey(KeyDataAnalysedType data) {
        KeyDataAnalysed keyDataAnalysed;
        int length;
        return data instanceof KeyDataAnalysed && (length = (keyDataAnalysed = (KeyDataAnalysed)data).getKeybinData().getContent().length) >= 512;
    }

    protected boolean isOriginTeleservice(KeyDataAnalysedType data) {
        KeyDataAnalysed keyDataAnalysed;
        String origin;
        return data instanceof KeyDataAnalysed && !(origin = (keyDataAnalysed = (KeyDataAnalysed)data).getKeybinData().getOrigin().value()).equalsIgnoreCase("K");
    }

    protected void initialisierenExtendedKeyData(KeyDataAnalysedType data, GKISettings settings) {
        this.log.debug((Object)"initialisierenExtendedKeyData E65");
        this.extendedKeyData = new ExtendedKeyData();
        StateInformationKeyType.MiscAttributes misc = data.getVehicle().getStateInformation().getMiscAttributes();
        if (misc != null) {
            EngineOil engineOil = new EngineOil();
            engineOil.setCode("" + Math.round(misc.isSetTopUpEngineOil() ? misc.getTopUpEngineOil() : 0.0));
            this.extendedKeyData.setTopUpInformationEngineOil(engineOil);
            StateInformationKeyType.MiscAttributes.ILevel ilevelKA = misc.getILevel();
            if (ilevelKA != null) {
                String iLevelPlant;
                String iLevelHo;
                String iLevelBackup;
                String iLevelPlantCode;
                String iLevelHoCode;
                boolean set = false;
                ILevelKeyData iLevelKeyData = new ILevelKeyData();
                String iLevelBackupCode = ilevelKA.getILevelBackupCode();
                if (iLevelBackupCode != null && !iLevelBackupCode.equals("0")) {
                    iLevelKeyData.setIlevelBackupCode(Integer.valueOf(iLevelBackupCode));
                    set = true;
                }
                if ((iLevelHoCode = ilevelKA.getILevelHoCode()) != null && !iLevelHoCode.equals("0")) {
                    iLevelKeyData.setIlevelHOCode(Integer.valueOf(iLevelHoCode));
                    set = true;
                }
                if ((iLevelPlantCode = ilevelKA.getILevelPlantCode()) != null && !iLevelPlantCode.equals("0")) {
                    iLevelKeyData.setIlevelPlantCode(Integer.valueOf(iLevelPlantCode));
                    set = true;
                }
                if ((iLevelBackup = ilevelKA.getILevelBackup()) != null) {
                    iLevelKeyData.setIlevelBackup(iLevelBackup);
                    set = true;
                }
                if ((iLevelHo = ilevelKA.getILevelHO()) != null) {
                    iLevelKeyData.setIlevelHO(iLevelHo);
                    set = true;
                }
                if ((iLevelPlant = ilevelKA.getILevelPlant()) != null) {
                    iLevelKeyData.setIlevelPlant(iLevelPlant);
                    set = true;
                }
                if (set) {
                    this.extendedKeyData.setIlevelKeyData(iLevelKeyData);
                }
            }
        }
        this.extendedKeyData.setKeyNumber(data.getKeyBaseData().getKeyNumber().shortValue());
        this.extendedKeyData.setKeyProfil(data.getKeyBaseData().getKeyProfil().shortValue());
        if (data.getNaviDVDVersion() != null) {
            this.extendedKeyData.setNaviDVDCode(new Integer(new Double(data.getNaviDVDVersion()).intValue()));
        }
    }

    public void erzeugeBosDaten() throws GKIException {
        BosNotFoundException bosNotFoundException = null;
        BOSHeaderDaten bosData = this.getBOSDaten();
        try {
            bosData.erzeugeBosPositionen(this.getData(), this.isMilesSet);
        }
        catch (BosNotFoundException e) {
            bosNotFoundException = e;
        }
        bosData.entferneBosPositionenBeiUebergabedurchsicht();
        if (!bosData.isUebergabedurchsicht() && bosNotFoundException != null) {
            throw bosNotFoundException;
        }
    }

    int getLaenderkodierung() {
        return this.laenderkodierungKombi;
    }

    public boolean pruefeUsOderGbCodiert() {
        return this.laenderkodierungKombi == 2 || this.laenderkodierungKombi == 4 || this.laenderkodierungKombi == 6;
    }

    public boolean pruefeIntegrationsStand685(KeyDataAnalysedType data) {
        int icu685 = new Double(data.getCbsBaseData().isSetIcu685Version() ? data.getCbsBaseData().getIcu685Version() : 0.0).intValue();
        return icu685 != 0;
    }

    protected void setErstzulassung(KeyDataAnalysedType data) {
        XMLGregorianCalendar cal = data.getVehicle().getFirstRegistrationDate();
        if (cal != null) {
            this.erstZulassung = data.getVehicle().getFirstRegistrationDate().toGregorianCalendar().getTime();
        }
    }

    protected void setUpdateDate(KeyDataAnalysedType data) {
        GKICalendar gkiCal;
        if (data.getKeyBaseData().getWriteDate() == null) {
            return;
        }
        GregorianCalendar cal = data.getKeyBaseData().getWriteDate().toGregorianCalendar();
        if (cal instanceof GKICalendar && (gkiCal = (GKICalendar)cal).getErrorHourFlagValue() != null && gkiCal.getErrorHourFlagValue() == 253) {
            this.setUhrzeitLetzteAktualisierungGueltig(false);
        }
        this.letzteAktualisierung = cal.getTime();
    }

    public Date getErstzulassung() {
        return this.erstZulassung;
    }

    public Double getAussentemperatur(boolean isFahrenheit) {
        if (this.aussentemperatur == null) {
            return null;
        }
        if (isFahrenheit) {
            return new Double(Utilities.convertToFahrenheit(this.aussentemperatur));
        }
        return this.aussentemperatur;
    }

    public double getBatteriespannung() {
        return this.batteriespannung;
    }

    public double getTankinhalt(boolean isUSGallons, boolean isUKGallons) {
        if (isUSGallons) {
            return Utilities.convertToUSGallons(this.tankinhalt);
        }
        if (isUKGallons) {
            return Utilities.convertToUKGallons(this.tankinhalt);
        }
        return this.tankinhalt;
    }

    public double getKuehlmitteltemperatur(boolean isFahrenheit) {
        if (isFahrenheit) {
            return Utilities.convertToFahrenheit(this.kuehlmitteltemperatur);
        }
        return this.kuehlmitteltemperatur;
    }

    @Override
    public Date getLetzteAktualisierung() {
        return this.letzteAktualisierung;
    }

    public BOSHeaderDaten getBOSDaten() {
        return this.bosDaten;
    }

    protected void setAussentemperatur(Double aussentemperatur) {
        this.aussentemperatur = aussentemperatur;
    }

    protected void setBatteriespannung(double batteriespannung) {
        this.batteriespannung = batteriespannung;
    }

    protected void setTankinhalt(float tankinhalt) {
        this.tankinhalt = tankinhalt;
    }

    protected void setKuehlmitteltemperatur(int kuehlmitteltemperatur) {
        this.kuehlmitteltemperatur = kuehlmitteltemperatur;
    }

    protected void setVersionsKennung(int versionsKennung) {
        this.versionsKennung = versionsKennung;
    }

    protected void setLaenderkodierungKombi(int laenderkodierungKombi) {
        this.laenderkodierungKombi = laenderkodierungKombi;
    }

    protected void setBOSDaten(BOSHeaderDaten bosDaten) {
        this.bosDaten = bosDaten;
    }

    public static String getFgnr(KeyDataAnalysedType data) {
        return data.getVehicle().getVin();
    }

    public Collection<BOSPosition> getBOSPositionen() {
        return this.bosDaten.getBosPositionen();
    }

    public Integer getNextFahrzeugcheck(GKISettings usersettings) {
        try {
            BOSNummer bosNummerFahrzeugcheck = BOSNummerReader.find(17);
            BOSPosition pos = null;
            pos = this.bosDaten.getBosPosition(bosNummerFahrzeugcheck);
            if (pos.getEinheitRestlaufleistung() == 1) {
                int value = pos.getRestweg();
                if (usersettings.isMiles()) {
                    value = (int)Utilities.roundDistance(pos.getEinheitAbstand(), Utilities.convertToMiles(value));
                }
                return new Integer(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Date getNextHUDate() {
        try {
            BOSNummer bosNummerHU = BOSNummerReader.find(32);
            return this.ermittelnDatum(bosNummerHU);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getNextAUDate() {
        try {
            BOSNummer bosNummerAU = BOSNummerReader.find(33);
            return this.ermittelnDatum(bosNummerAU);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getNextBremsfluessigkeitsDate() {
        try {
            BOSNummer bosNummerBremsfl = BOSNummerReader.find(3);
            return this.ermittelnDatum(bosNummerBremsfl);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Date ermittelnDatum(BOSNummer bosNummer) {
        Date retval = null;
        Date last = this.getLetzteAktualisierung();
        BOSPosition pos = null;
        pos = this.bosDaten.getBosPosition(bosNummer);
        if (pos != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            if (pos.getDueDateMonth() > 0 && pos.getDueDateYear() > 0) {
                calendar.set(pos.getDueDateYear(), pos.getDueDateMonth() - 1, 1);
            } else {
                calendar.setTime(last);
                int delta = pos.getRestweg();
                calendar.add(5, delta);
            }
            retval = calendar.getTime();
        }
        return retval;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("SchluesselVariante: \t" + this.getSchluesselVariante().getSchluesselVariante() + "\n");
        strbuf.append("Versionskennung: \t" + this.versionsKennung + "\n");
        strbuf.append("Datenkonsistenz: \t" + this.datenKonsistenz + " " + (this.datenKonsistenz == 254 ? "OK" : "ERR") + "\n");
        strbuf.append("Fahrgestellnummer: \t" + this.fgnr + "\n");
        strbuf.append("Typschl\u00fcssel: \t\t" + this.typschluessel + "\n");
        strbuf.append("FarbCode: \t\t" + this.farbCode + "\n");
        strbuf.append("PolsterCode: \t\t" + this.polsterCode + "\n");
        strbuf.append("Erstzulassung: \t\t" + Utilities.getDateString(this.erstZulassung) + "\n");
        strbuf.append("km-Stand: \t\t" + this.kmStand + "\n");
        strbuf.append("Tankinhalt: \t\t" + this.tankinhalt + "\n");
        strbuf.append("Batteriespannung: \t" + this.batteriespannung + "\n");
        strbuf.append("K\u00fchlmitteltemperatur: \t" + this.kuehlmitteltemperatur + "\n");
        strbuf.append("Aussentemperatur: \t" + this.aussentemperatur + "\n");
        strbuf.append("Hauptuntersuchung: \t" + Utilities.getDateString(this.getNextHUDate()) + "\n");
        strbuf.append("Abgasuntersuchung: \t" + Utilities.getDateString(this.getNextAUDate()) + "\n");
        strbuf.append("Aktualisierung: \t" + Utilities.getTimeString(this.letzteAktualisierung) + "\n");
        strbuf.append("\n" + this.bosDaten);
        return strbuf.toString();
    }

    protected boolean checkAlphaNumeric(String value) {
        boolean retVal = false;
        if (value != null) {
            for (int i = value.length() - 1; i >= 0; --i) {
                char c = value.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                return false;
            }
            retVal = true;
        }
        return retVal;
    }

    public void pruefeErstzulassungsdatum() throws RegistrationDateException {
        if (this.erstZulassung == null || this.erstZulassung.getTime() == 0L) {
            String message = "registration date not valid";
            throw new RegistrationDateException(message);
        }
    }

    public double ermittleLaufleistung(GKISettings settings) {
        double wochen = this.getLetzteAktualisierung().getTime() - this.getErstzulassung().getTime();
        return (double)this.getKmMeilenStand(settings).intValue() / (wochen /= 6.048E8);
    }

    public Fahreigenschaft ermittleFahreigenschaften(int min, int max, GKISettings settings) {
        int fahrertyp = 0;
        try {
            double laufleistung = this.ermittleLaufleistung(settings);
            fahrertyp = (double)min > laufleistung ? 1 : ((double)max < laufleistung ? 2 : 0);
        }
        catch (NullPointerException e) {
            fahrertyp = 0;
        }
        return new Fahreigenschaft(fahrertyp);
    }

    public int ermittelnLagerzeitraum() throws RegistrationDateException {
        this.pruefeErstzulassungsdatum();
        long value = new Date().getTime() - this.getErstzulassung().getTime();
        return (int)(value /= 86400000L);
    }

    public Map<?, ?> getCheckControlMessageTexts() {
        return this.checkControlMessageTexts;
    }

    public void setCheckControlMessageTexts(Map<?, ?> checkControlMessageTexts) {
        this.checkControlMessageTexts = checkControlMessageTexts;
    }

    public void interpretCheckControl() {
        this.checkControlIds = new Vector<CCMessage>();
        List<KeyDataAnalysedType.CcData.Cc> ccs = this.getData().getCcData().getCc();
        for (KeyDataAnalysedType.CcData.Cc cc : ccs) {
            this.log.debug((Object)("CC is: " + cc.toString()));
            int ids = Integer.parseInt(cc.getValue());
            if (ids <= 0 || ids >= 65535) continue;
            CCMessage ccM = new CCMessage();
            ccM.setCCId(StringUtils.leftPad((String)new Integer(ids).toString(), (int)5, (String)"0"));
            if (cc.isSetTotalDistance()) {
                ccM.setTotalDistance(cc.getTotalDistance());
            }
            if (this.checkControlIds.contains(ccM)) {
                Iterator<CCMessage> it = this.checkControlIds.iterator();
                while (it.hasNext()) {
                    CCMessage o1 = it.next();
                    if (!o1.equals(ccM) || o1.getTotalDistance() >= ccM.getTotalDistance()) continue;
                    it.remove();
                    break;
                }
            }
            this.checkControlIds.add(ccM);
            this.log.debug((Object)("ADD to Schl\u00fcsselvariante E65 cc id: " + ccM.getId() + " distance: " + ccM.getTotalDistance()));
        }
    }

    protected void setCheckControlIds(List<CCMessage> checkControlIds) {
        this.checkControlIds = checkControlIds;
    }

    public List<CCMessage> getCheckControlIds() {
        return this.checkControlIds;
    }

    @Override
    public boolean isLargeKey() {
        return this.largeKey;
    }

    public ExtendedKeyData getExtendedKeyData() {
        return this.extendedKeyData;
    }

    public void setExtendedKeyData(ExtendedKeyData extendedKeyData) {
        this.extendedKeyData = extendedKeyData;
    }
}

