/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.orderbase;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.SchluesselVariante;
import com.bmw.gki.klib.api.Schluesseldaten;
import com.bmw.gki.klib.api.exception.SIADataException;
import com.bmw.gki.klib.api.exception.WrongVinFormatException;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.data.ksd.key.FgnrPraefix;
import com.bmw.gki.klib.data.orderbase.LEDStand;
import com.bmw.gki.klib.external.cache.FgnrPraefixReader;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.Serializable;
import org.apache.commons.logging.Log;

public class SchluesseldatenVorE65
extends Schluesseldaten
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = GKILogManager.getInstance().getLogger(SchluesseldatenVorE65.class);
    private int siaStand = 0;
    private boolean zeitinspektion;
    private boolean inspektion;
    private boolean oelservice;
    private Integer restweg;
    private int tageBisService = 0;
    private LEDStand ledStatus;

    public SchluesseldatenVorE65(KeyDataAnalysedType schluesselDatenRoh, SchluesselVariante schluesselVariante) throws GKIException {
        super(schluesselDatenRoh, schluesselVariante);
        FgnrPraefix praefix;
        this.setData(schluesselDatenRoh);
        this.fgnr = schluesselDatenRoh.getVehicle().getVin();
        try {
            praefix = FgnrPraefixReader.find(this.fgnr.substring(0, 3));
        }
        catch (GKIException e) {
            WrongVinFormatException wve = new WrongVinFormatException("VIN Praefix not found", e);
            log.info((Object)("error code: " + wve.getErrorCode() + " message: " + wve.getMessage()));
            throw wve;
        }
        if (praefix != null) {
            this.marke = praefix.getMarke();
        }
    }

    public void setData(KeyDataAnalysedType data) throws GKIException {
        if (this.getSchluesselVariante().usesFeld(5)) {
            this.polsterCode = data.getVehicle().getUpholstery();
        }
        if (this.getSchluesselVariante().usesFeld(6)) {
            this.farbCode = data.getVehicle().getColourCode();
        }
        this.kmStand = Math.round(data.getVehicle().getStateInformation().getTotalDistance());
        if (this.getSchluesselVariante().usesFeld(3)) {
            this.fgnr = data.getVehicle().getVin();
        }
        if (this.getSchluesselVariante().usesFeld(4)) {
            this.typschluessel = this.fgnr.substring(3, 7);
        }
        this.setSIAData(data);
    }

    private void setSIAData(KeyDataAnalysedType data) throws GKIException {
        int siaVersion = (int)Math.round(data.getSiaData().getSia().getSiaVersion());
        switch (siaVersion) {
            case 0: {
                this.siaStand = 3;
                break;
            }
            case 1: {
                this.siaStand = 4;
                break;
            }
            default: {
                SIADataException sde = new SIADataException("Unknown sia version");
                log.info((Object)("exception code: " + sde.getErrorCode() + " message: " + sde.getMessage()));
                throw sde;
            }
        }
        if (this.getSchluesselVariante().usesFeld(2)) {
            long siDue = Math.round(data.getSiaData().getSia().getSiaDue());
            this.zeitinspektion = (siDue & 4L) != 0L;
            this.inspektion = (siDue & 2L) != 0L;
            this.oelservice = (siDue & 1L) != 0L;
            switch (this.siaStand) {
                case 3: {
                    this.ledStatus = new LEDStand(data);
                    break;
                }
                case 4: {
                    int rwRoh = (int)Math.round(data.getSiaData().getSiaRemainingDistance());
                    this.restweg = this.isInspektionSet() || this.isOelserviceSet() ? new Integer(0 - rwRoh) : new Integer(rwRoh);
                }
            }
        } else {
            switch (this.siaStand) {
                case 3: {
                    this.ledStatus = new LEDStand();
                    break;
                }
            }
        }
        int daysSinceLastService = 0;
        daysSinceLastService = data.getSiaData().getSia().getSiTimeInspectionCounter();
        int serviceInterval = 0;
        serviceInterval = data.getSiaData().getSia().getCodedTimeIntervall();
        this.tageBisService = serviceInterval - daysSinceLastService;
    }

    public int getTageBisService() {
        return this.tageBisService;
    }

    public LEDStand getRefLEDStand() {
        return this.ledStatus;
    }

    public Integer getRestweg(boolean isMilesSet) {
        if (this.restweg == null) {
            return null;
        }
        if (isMilesSet) {
            return new Integer((int)Math.round(Utilities.convertToMiles(this.restweg.intValue())));
        }
        return this.restweg;
    }

    public int getSiaStand() {
        return this.siaStand;
    }

    public int getCountGreen() {
        return this.ledStatus.countGreen();
    }

    public boolean isYellowSet() {
        return this.ledStatus.isYellow();
    }

    public boolean isRedSet() {
        return this.ledStatus.isRed();
    }

    public boolean isZeitinspektionSet() {
        return this.zeitinspektion;
    }

    public boolean isInspektionSet() {
        return this.inspektion;
    }

    public boolean isOelserviceSet() {
        return this.oelservice;
    }

    @Override
    public boolean isLargeKey() {
        return false;
    }
}

