/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xml;

import com.bmw.gki.klib.api.GKISettingsRessource;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.sa_V01_00_00.OptionalEquipmentRequest;
import com.bmw.gki.klib.sa_V01_00_00.TypeChassisNumber;
import com.bmw.gki.klib.sa_V01_00_00.TypeError;
import com.bmw.gki.klib.sa_V01_00_00.impl.TypeSchemaVersionReferenceImpl;
import com.bmw.gki.logging.GKILogManager;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class OptionalEquipmentRequestTransformer {
    private static final Log LOG = GKILogManager.getInstance().getLogger(OptionalEquipmentRequestTransformer.class);
    private static final String ROOT_PACKAGE_NAME = "com.bmw.gki.klib.sa_";
    private TypeError error;
    private TypeChassisNumber chassisNumber = null;
    private String language = null;

    public TypeError getError() {
        return this.error;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getVinShort() {
        if (this.chassisNumber != null && this.chassisNumber.isSetVinShort()) {
            return this.chassisNumber.getVinShort();
        }
        return null;
    }

    public String getVinLongPrefix() {
        if (this.chassisNumber != null && this.chassisNumber.isSetVinLongPrefix()) {
            return this.chassisNumber.getVinLongPrefix();
        }
        return null;
    }

    public void transformToTyped(String xml) throws XMLBearbeitungsException {
        OptionalEquipmentRequest request = (OptionalEquipmentRequest)this.parseObject(xml);
        if (request != null) {
            this.chassisNumber = request.getVehicleIdentification();
            this.language = request.getLanguage();
        }
    }

    protected Object parseObject(String srcXml) throws XMLBearbeitungsException {
        Object dstObj = null;
        String version = GKISettingsRessource.getString("saVersion");
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getJaxbPackageName(version));
            Unmarshaller u = jc.createUnmarshaller();
            dstObj = u.unmarshal((Source)new StreamSource(new StringReader(srcXml)));
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex);
            String shortClassName = ClassUtils.getShortClassName(this.getClass());
            String errorText = "Error:Exception:" + ex + " - " + shortClassName + ".parseObject(" + srcXml + ")";
            throw new XMLBearbeitungsException(errorText, ex);
        }
        return dstObj;
    }

    public String transformOptionalEquipmentResponseToXml(OptionalEquipmentRequest optionalEquipmentRequest) throws XMLBearbeitungsException {
        String version = GKISettingsRessource.getString("saVersion");
        if (optionalEquipmentRequest.getSchemaRef() == null) {
            TypeSchemaVersionReferenceImpl ref = new TypeSchemaVersionReferenceImpl();
            ref.setVersion(version);
            ref.setRefSchema(GKISettingsRessource.getString("saRefSchema"));
            optionalEquipmentRequest.setSchemaRef(ref);
        }
        String xmlSource = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getJaxbPackageName(version));
            Marshaller mSource = jc.createMarshaller();
            mSource.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter stringWriter = new StringWriter();
            mSource.marshal((Object)optionalEquipmentRequest, (Writer)stringWriter);
            xmlSource = stringWriter.toString();
        }
        catch (Exception ex) {
            LOG.fatal((Object)"unknown error occured ", (Throwable)ex);
            String shortClassName = ClassUtils.getShortClassName(this.getClass());
            String srcObjClassName = null;
            srcObjClassName = optionalEquipmentRequest.getClass().getName();
            String errorText = "Error:Exception:" + ex + " - " + shortClassName + ".formatObjectToString(" + version + "," + srcObjClassName + ")";
            throw new XMLBearbeitungsException(errorText, ex);
        }
        return xmlSource;
    }

    private String getJaxbPackageName(String version) {
        String packageName = ROOT_PACKAGE_NAME + this.versionToPackageName(version);
        return packageName;
    }

    private String versionToPackageName(String xmlVersion) {
        String packageName = ROOT_PACKAGE_NAME;
        String version = "V" + StringUtils.replace((String)xmlVersion, (String)".", (String)"_");
        packageName = packageName + version;
        return version;
    }
}

